<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Jam extends CI_Controller {

	public function __construct()
	{
		parent::__construct();
		$this->load->model('jam_model','jam');
		$this->load->helper('url');
		if ($this->session->userdata('username')=='') {
            redirect('login');
        }
	}

	public function index()
	{
		$this->template->display('admin/jam');
	}
	public function balikin($str){
		$search = array ("'xpsijix'");
		$replace = array ("'");
		$str = preg_replace($search,$replace,$str);
		return $str;
	}
	public function ajax_list()
	{
		$list = $this->jam->get_datatables();
		$data = array();
		$no = $_POST['start'];
		foreach ($list as $jam) {
			$no++;
			$row = array();
			$row[] = $no;
			$row[] = '<a class="btn btn-white btn-primary btn-sm" href="javascript:void(0)" title="Edit jam" onclick="edit_jam('."'".$jam->id."'".')"><i class="glyphicon glyphicon-pencil"></i></a>
				  <a class="btn btn-white btn-danger btn-sm" href="javascript:void(0)" title="Hapus" onclick="delete_log('."'".$jam->id."'".')"><i class="glyphicon glyphicon-trash"></i></a>';
			$row[] = $jam->kode;
			$row[] = $jam->nama;
			$row[] = $jam->awal_masuk;
			$row[] = $jam->jam_masuk;
			$row[] = $jam->akhir_masuk;
			$row[] = $jam->jam_pulang;
			$row[] = $jam->akhir_pulang;
			$data[] = $row;
		}

			$output = array(
						"draw" => $_POST['draw'],
						"recordsTotal" => $this->jam->count_all(),
						"recordsFiltered" => $this->jam->count_filtered(),
						"data" => $data,
				);

		echo json_encode($output);
	}


	public function ajax_edit($id)
	{
		$data = $this->jam->get_by_id($id);
		echo json_encode($data);
	}
	public function ajax_add()
	{
		$this->_validate();
		$data = array(
				'kode' => $this->input->post('kode'),
				'nama' => $this->input->post('nama'),
				'awal_masuk' => $this->input->post('awal_masuk'),
				'jam_masuk' => $this->input->post('jam_masuk'),
				'akhir_masuk' => $this->input->post('akhir_masuk'),
				'jam_pulang' => $this->input->post('jam_pulang'),
				'akhir_pulang' => $this->input->post('akhir_pulang'),
			);

		$insert = $this->jam->save($data);

		echo json_encode(array("status" => TRUE));
	}
	public function ajax_update()
	{
		$this->_validate();
		$data = array(
			'kode' => $this->input->post('kode'),
			'nama' => $this->input->post('nama'),
			'awal_masuk' => $this->input->post('awal_masuk'),
			'jam_masuk' => $this->input->post('jam_masuk'),
			'akhir_masuk' => $this->input->post('akhir_masuk'),
			'jam_pulang' => $this->input->post('jam_pulang'),
			'akhir_pulang' => $this->input->post('akhir_pulang'),
			);

		$this->jam->update(array('id' => $this->input->post('id')), $data);
		echo json_encode(array("status" => TRUE));
	}
	public function ajax_delete($id)
	{
		$jam = $this->jam->get_by_id($id);
		$this->jam->delete_by_id($id);
		echo json_encode(array("status" => TRUE));
	}
	private function _validate()
	{
		$data = array();
		$data['error_string'] = array();
		$data['inputerror'] = array();
		$data['status'] = TRUE;

		if($this->input->post('kode') == '')
		{
			$data['inputerror'][] = 'kode';
			$data['error_string'][] = 'Kode wajib di isi';
			$data['status'] = FALSE;
		}
		if($this->input->post('nama') == '')
		{
			$data['inputerror'][] = 'nama';
			$data['error_string'][] = 'Nama wajib di isi';
			$data['status'] = FALSE;
		}
		if($data['status'] === FALSE)
		{
			echo json_encode($data);
			exit();
		}
	}

}
