<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Libur extends CI_Controller {

	public function __construct()
	{
		parent::__construct();
		$this->load->model('libur_model','libur');
		$this->load->helper('url');
		if ($this->session->userdata('username')=='') {
            redirect('login');
        }
	}

	public function index()
	{
		$this->template->display('admin/libur');
	}
	public function balikin($str){
		$search = array ("'xpsijix'");
		$replace = array ("'");
		$str = preg_replace($search,$replace,$str);
		return $str;
	}
	public function ajax_list()
	{
		$list = $this->libur->get_datatables();
		$data = array();
		$no = $_POST['start'];
		foreach ($list as $libur) {
			$no++;
			$row = array();
			$row[] = $no;
			$row[] = '<a class="btn btn-white btn-primary btn-sm" href="javascript:void(0)" title="Edit libur" onclick="edit_libur('."'".$libur->id."'".')"><i class="glyphicon glyphicon-pencil"></i></a>
				  <a class="btn btn-white btn-danger btn-sm" href="javascript:void(0)" title="Hapus" onclick="delete_log('."'".$libur->id."'".')"><i class="glyphicon glyphicon-trash"></i></a>';
			$row[] = $libur->tgl;
			$row[] = $libur->ket;
			$data[] = $row;
		}

			$output = array(
						"draw" => $_POST['draw'],
						"recordsTotal" => $this->libur->count_all(),
						"recordsFiltered" => $this->libur->count_filtered(),
						"data" => $data,
				);

		echo json_encode($output);
	}


	public function ajax_edit($id)
	{
		$data = $this->libur->get_by_id($id);
		echo json_encode($data);
	}
	public function ajax_add()
	{
		$this->_validate();
		$data = array(
				'tgl' => $this->input->post('tgl'),
				'ket' => $this->input->post('ket'),
			);

		$insert = $this->libur->save($data);

		echo json_encode(array("status" => TRUE));
	}
	public function ajax_update()
	{
		$this->_validate();
		$data = array(
			'tgl' => $this->input->post('tgl'),
			'ket' => $this->input->post('ket'),
			);

		$this->libur->update(array('id' => $this->input->post('id')), $data);
		echo json_encode(array("status" => TRUE));
	}
	public function ajax_delete($id)
	{
		$libur = $this->libur->get_by_id($id);
		$this->libur->delete_by_id($id);
		echo json_encode(array("status" => TRUE));
	}
	private function _validate()
	{
		$data = array();
		$data['error_string'] = array();
		$data['inputerror'] = array();
		$data['status'] = TRUE;

		if($this->input->post('tgl') == '')
		{
			$data['inputerror'][] = 'tgl';
			$data['error_string'][] = 'Tanggal wajib di isi';
			$data['status'] = FALSE;
		}
		if($this->input->post('ket') == '')
		{
			$data['inputerror'][] = 'ket';
			$data['error_string'][] = 'Keterangan wajib di isi';
			$data['status'] = FALSE;
		}
		if($data['status'] === FALSE)
		{
			echo json_encode($data);
			exit();
		}
	}

}
