<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Ruang extends CI_Controller {

	public function __construct()
	{
		parent::__construct();
		$this->load->model('ruang_model','ruang');
		$this->load->helper('url');
		if ($this->session->userdata('username')=='') {
            redirect('login');
        } 
	}

	public function index()
	{
		$this->template->display('admin/ruang');
	}
	public function balikin($str){
		$search = array ("'xpsijix'");
		$replace = array ("'");
		$str = preg_replace($search,$replace,$str);
		return $str;
	}
	public function ajax_list()
	{
		$list = $this->ruang->get_datatables();
		$data = array();
		$no = $_POST['start'];
		foreach ($list as $ruang) {
			$no++;
			$row = array();
			$row[] = $no;
			$row[] = '<a class="btn btn-white btn-primary btn-sm" href="javascript:void(0)" title="Edit ruang" onclick="edit_ruang('."'".$ruang->id."'".')"><i class="glyphicon glyphicon-pencil"></i></a>
				  <a class="btn btn-white btn-danger btn-sm" href="javascript:void(0)" title="Hapus" onclick="delete_log('."'".$ruang->id."'".')"><i class="glyphicon glyphicon-trash"></i></a>';
			$row[] = $ruang->kode;
			$row[] = $ruang->nama_ruang;
			$row[] = $ruang->jenis_ruang;
			$row[] = $ruang->kerusakan;
			$row[] = $ruang->keterangan;
			$data[] = $row;
		}

			$output = array(
						"draw" => $_POST['draw'],
						"recordsTotal" => $this->ruang->count_all(),
						"recordsFiltered" => $this->ruang->count_filtered(),
						"data" => $data,
				);
		
		echo json_encode($output);
	}
	
	
	public function ajax_edit($id)
	{
		$data = $this->ruang->get_by_id($id);
		echo json_encode($data);
	}
	public function ajax_add()
	{
		$this->_validate();
		$data = array(
				'kode' => $this->input->post('kode'),
				'nama_ruang' => $this->input->post('nama'),
				'jenis_ruang' => $this->input->post('jenis'),
				'kerusakan' => $this->input->post('rusak'),
				'keterangan' => $this->input->post('keterangan'),
			);

		$insert = $this->ruang->save($data);

		echo json_encode(array("status" => TRUE));
	}
	public function ajax_update()
	{
		$this->_validate();
		$data = array(
				'kode' => $this->input->post('kode'),
				'nama_ruang' => $this->input->post('nama'),
				'jenis_ruang' => $this->input->post('jenis'),
				'kerusakan' => $this->input->post('rusak'),
				'keterangan' => $this->input->post('keterangan'),
			);

		$this->ruang->update(array('id' => $this->input->post('id')), $data);
		echo json_encode(array("status" => TRUE));
	}
	public function ajax_delete($id)
	{
		$ruang = $this->ruang->get_by_id($id);
		$this->ruang->delete_by_id($id);
		echo json_encode(array("status" => TRUE));
	}
	private function _validate()
	{
		$data = array();
		$data['error_string'] = array();
		$data['inputerror'] = array();
		$data['status'] = TRUE;

		if($this->input->post('kode') == '')
		{
			$data['inputerror'][] = 'kode';
			$data['error_string'][] = 'Kode wajib di isi';
			$data['status'] = FALSE;
		}
		if($this->input->post('nama') == '')
		{
			$data['inputerror'][] = 'nama';
			$data['error_string'][] = 'Nama wajib di isi';
			$data['status'] = FALSE;
		}
		if($data['status'] === FALSE)
		{
			echo json_encode($data);
			exit();
		}
	}

}
