<section class="content-header">
      <h1>
          Pengajuan ijin Absen
      </h1>
      <ol class="breadcrumb">
          <li><a href="#"><i class="fa fa-dashboard"></i> Home</a></li>
          <li class="active">Pengajuan Ijin Absen</li>
      </ol>
  </section>
<section class="content">
  <div class="row">
      <div class="col-md-12">
          <div class="box box-primary">
      <div class='box-header with-border'>
        <!--<button class="btn btn-success" onclick="add_absen()"><i class="glyphicon glyphicon-plus"></i> Tambah Ijin</button>-->
        <button class="btn btn-default" onclick="reload_table()"><i class="glyphicon glyphicon-refresh"></i> Reload</button>

      </div>
        <!-- /.box-header -->
        <div class="box-body table-responsive">
        <table id="table" class="table table-bordered table-striped">
          <thead>
            <tr>
              <th>No</th>
              <th>Tanggal</th>
              <th>Nama Individu</th>
              <th>Status</th>
              <th>Keterangan</th>
              <th>File</th>
              <th>Status</th>
            </tr>
          </thead>
          <tbody>
          </tbody>

          <tfoot>
          <tr>
            <th>No</th>
            <th>Tanggal</th>
            <th>Nama Individu</th>
            <th>Status</th>
            <th>Keterangan</th>
            <th>File</th>
            <th>Status</th>
          </tr>
          </tfoot>
        </table>
      </div><!-- /.box-body -->
          </div><!-- /.box -->
      </div>
  </div>

    <script type="text/javascript">

    var save_method; //for save method string
    var table;
    var base_url = '<?php echo base_url();?>';

    $(document).ready(function() {
      $("#kd_jenis").change(function(){ // Ketika user mengganti atau memilih data pelajaran
        $("#kikd").hide(); // Sembunyikan dulu combobox kikd nya

        $.ajax({
          type: "POST",
          url: "<?php echo base_url("ijin/listsiswa"); ?>", // Isi dengan url/path file php yang dituju
          data: {kd_jenis : $("#kd_jenis").val()}, // data yang akan dikirim ke file yang dituju
          dataType: "json",
          beforeSend: function(e) {
            if(e && e.overrideMimeType) {
              e.overrideMimeType("application/json;charset=UTF-8");
            }
          },
          success: function(response){ // Ketika proses pengiriman berhasil
            $("#kikd").html(response.list_kelas).show();
          },
          error: function (xhr, ajaxOptions, thrownError) { // Ketika ada error
            alert(xhr.status + "\n" + xhr.responseText + "\n" + thrownError); // Munculkan alert error
          }
        });
      });
      //datepicker
      $('.datepicker').datepicker({
        autoclose: true,
        format: "yyyy-mm-dd",
        todayHighlight: true,
        orientation: "top auto",
        todayBtn: true,
        todayHighlight: true,
      });

      //set input/textarea/select event when change value, remove class error and remove text help block
      $("input").change(function(){
        $(this).parent().parent().removeClass('has-error');
        $(this).next().empty();
      });
      $("textarea").change(function(){
        $(this).parent().parent().removeClass('has-error');
        $(this).next().empty();
      });
      $("select").change(function(){
        $(this).parent().parent().removeClass('has-error');
        $(this).next().empty();
      });
       //check all
      $("#check-all").click(function () {
        $(".data-check").prop('checked', $(this).prop('checked'));
      });
    });

    $(function () {
      table = $('#table').DataTable({

        "processing": true, //Feature control the processing indicator.
        "serverSide": true, //Feature control DataTables' server-side processing mode.
        "order": [], //Initial no order.

        // Load data for the table's content from an Ajax source
        "ajax": {
          "url": "<?php echo site_url('tempijin/ajax_list')?>",
          "type": "POST"
        },

        //Set column definition initialisation properties.
        "columnDefs": [
          {
            "targets": [ 0 ], //first column
            "orderable": false, //set not orderable
          },
          {
            "targets": [ -1 ], //last column
            "orderable": false, //set not orderable
          },

        ],

      });
    });


    

    function reload_table()
    {
      table.ajax.reload(null,false); //reload datatable ajax
    }

    
    function delete_tempijin(id)
    {
      if(confirm('Are you sure delete this data?'))
      {
        // ajax delete data to database
        $.ajax({
          url : "<?php echo site_url('tempijin/ajax_delete')?>/"+id,
          type: "POST",
          dataType: "JSON",
          success: function(data)
          {
            $.toast({
				heading: 'Success',
				text: "Temp Ijin Terhapus.",
				showHideTransition: 'slide',
				icon: 'success',

				position: 'bottom-right',
				bgColor: '#7EC857'
			});
            reload_table();
          },
          error: function (jqXHR, textStatus, errorThrown)
          {
            alert('Error deleting data');
          }
        });

      }
    }
    function acc_tempijin(id,status)
			{
				if(confirm('Apakah yakin men ACC Ijin?'))
				{
					// ajax delete data to database
					$.ajax({

						type: 'POST',
						data: {idnya:id,statusnya:status},
						url : "<?php echo site_url('tempijin/acc_tempijin')?>",
						dataType: "JSON",
						success: function(data)
							{
								if(data.status)
								{
									$.toast({
										heading: 'Success',
										text: "User sudah spesial.",
										showHideTransition: 'slide',
										icon: 'success',

										position: 'bottom-right',
										bgColor: '#7EC857'
									});
									reload_table();
								}
								else
								{
									alert('Failed.');
								}

							},
							error: function (jqXHR, textStatus, errorThrown)
							{
								alert('Error spesial data');
							}
					});

				}
			}
    </script>
</section>
