/******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId]) {
/******/ 			return installedModules[moduleId].exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			i: moduleId,
/******/ 			l: false,
/******/ 			exports: {}
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.l = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// define getter function for harmony exports
/******/ 	__webpack_require__.d = function(exports, name, getter) {
/******/ 		if(!__webpack_require__.o(exports, name)) {
/******/ 			Object.defineProperty(exports, name, { enumerable: true, get: getter });
/******/ 		}
/******/ 	};
/******/
/******/ 	// define __esModule on exports
/******/ 	__webpack_require__.r = function(exports) {
/******/ 		if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 			Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 		}
/******/ 		Object.defineProperty(exports, '__esModule', { value: true });
/******/ 	};
/******/
/******/ 	// create a fake namespace object
/******/ 	// mode & 1: value is a module id, require it
/******/ 	// mode & 2: merge all properties of value into the ns
/******/ 	// mode & 4: return value when already ns object
/******/ 	// mode & 8|1: behave like require
/******/ 	__webpack_require__.t = function(value, mode) {
/******/ 		if(mode & 1) value = __webpack_require__(value);
/******/ 		if(mode & 8) return value;
/******/ 		if((mode & 4) && typeof value === 'object' && value && value.__esModule) return value;
/******/ 		var ns = Object.create(null);
/******/ 		__webpack_require__.r(ns);
/******/ 		Object.defineProperty(ns, 'default', { enumerable: true, value: value });
/******/ 		if(mode & 2 && typeof value != 'string') for(var key in value) __webpack_require__.d(ns, key, function(key) { return value[key]; }.bind(null, key));
/******/ 		return ns;
/******/ 	};
/******/
/******/ 	// getDefaultExport function for compatibility with non-harmony modules
/******/ 	__webpack_require__.n = function(module) {
/******/ 		var getter = module && module.__esModule ?
/******/ 			function getDefault() { return module['default']; } :
/******/ 			function getModuleExports() { return module; };
/******/ 		__webpack_require__.d(getter, 'a', getter);
/******/ 		return getter;
/******/ 	};
/******/
/******/ 	// Object.prototype.hasOwnProperty.call
/******/ 	__webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "";
/******/
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(__webpack_require__.s = "./global.js");
/******/ })
/************************************************************************/
/******/ ({

/***/ "./core/src/accessibility.js":
/*!***********************************!*\
  !*** ./core/src/accessibility.js ***!
  \***********************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return Accessibility; });\n/* harmony import */ var _cache__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./cache */ \"./core/src/cache.js\");\n/* harmony import */ var _core_src__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./core.src */ \"./core/src/core.src.js\");\n/* harmony import */ var _serviceprovider__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./serviceprovider */ \"./core/src/serviceprovider.js\");\n/* harmony import */ var _mathml_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./mathml.js */ \"./core/src/mathml.js\");\nfunction _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError(\"Cannot call a class as a function\"); } }\n\nfunction _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if (\"value\" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }\n\nfunction _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }\n\n\n\n\n\n/**\r\n * Class representing MathType accessible class. This class converts MathML into accessible text.\r\n */\n\nvar Accessibility =\n/*#__PURE__*/\nfunction () {\n  function Accessibility() {\n    _classCallCheck(this, Accessibility);\n  }\n\n  _createClass(Accessibility, null, [{\n    key: \"mathMLToAccessible\",\n\n    /**\r\n     * Gets the accessible text of a given MathML calling mathml2accessible service.\r\n     * @param {string} mathML - MathML to be converted to accessible text.\r\n     * @param {string} language - language of the accessible text.\r\n     * @param {Object[]} data - object containing parameters to send to textService service.\r\n     * @return {string} Accessibility from mathml string on language string.\r\n     */\n    value: function mathMLToAccessible(mathML, language, data) {\n      // Check MathML class. If the class is chemistry,\n      // we add chemistry to data to force accessibility service\n      // to load chemistry grammar.\n      if (_mathml_js__WEBPACK_IMPORTED_MODULE_3__[\"default\"].containClass(mathML, 'wrs_chemistry')) {\n        data['mode'] = 'chemistry';\n      }\n\n      var accessibleText;\n\n      if (Accessibility.cache.get(mathML)) {\n        accessibleText = Accessibility.cache.get[mathML];\n      } else {\n        data['service'] = 'mathml2accessible';\n        data['lang'] = language;\n        var accessibleJsonResponse = JSON.parse(_serviceprovider__WEBPACK_IMPORTED_MODULE_2__[\"default\"].getService('service', data));\n\n        if (accessibleJsonResponse.status != 'error') {\n          accessibleText = accessibleJsonResponse.result.text;\n          Accessibility.cache.populate(mathML, accessibleText);\n        } else {\n          accessibleText = _core_src__WEBPACK_IMPORTED_MODULE_1__[\"default\"].getStringManager().getString('error_convert_accessibility');\n        }\n      }\n\n      return accessibleText;\n    }\n  }]);\n\n  return Accessibility;\n}();\n/**\r\n * Static property. This property contains an instance of TextCache class to manage the JavaScript accessible cache.\r\n * Each entry of the cache object contains the MathML and it's correspondent accessibility text.\r\n * @type {TextCache}\r\n */\n\n\n\nAccessibility.cache = new _cache__WEBPACK_IMPORTED_MODULE_0__[\"default\"]();\n\n//# sourceURL=webpack:///./core/src/accessibility.js?");

/***/ }),

/***/ "./core/src/backwardslib.js":
/*!**********************************!*\
  !*** ./core/src/backwardslib.js ***!
  \**********************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _core_src__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./core.src */ \"./core/src/core.src.js\");\n/* harmony import */ var _parser__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./parser */ \"./core/src/parser.js\");\n/* harmony import */ var _listeners__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./listeners */ \"./core/src/listeners.js\");\n\n\n\nvar backwardsLib;\n/* harmony default export */ __webpack_exports__[\"default\"] = (backwardsLib); // Backward compatibility library for public methods previous to version 7.6.0\n\n/**\r\n * Add a new callback to a MathType listener.\r\n * @param {Object} jsonListener - an Object containing listener name and a callback.\r\n * @tutorial tutorial\r\n * @deprecated Since version 7.6.0. Use Listeners.newListener instead.\r\n */\n\nfunction wrs_addPluginListener(jsonListener) {\n  // TODO: Add documentation URL + doc example.\n  console.warn('Deprecated method');\n  var eventName;\n  eventName = Object.keys(jsonListener)[0];\n  var callback;\n  callback = jsonListener[eventName];\n  var pluginListener = _listeners__WEBPACK_IMPORTED_MODULE_2__[\"default\"].newListener(eventName, callback);\n  _core_src__WEBPACK_IMPORTED_MODULE_0__[\"default\"].addGlobalListener(pluginListener);\n} // Expose the method globally.\n\n\nwindow.wrs_addPluginListener = wrs_addPluginListener;\n/**\r\n * Parses initial HTML code. If the HTML contains data generated by WIRIS, this data would be converted as following:\r\n * <pre>\r\n * MathML code: Image containing the corresponding MathML formulas.\r\n * MathML code with LaTeX annotation : LaTeX.\r\n * </pre>\r\n * @param {string} code - HTML code with data generated by MathType.\r\n * @param {string} language - language for the formula.\r\n * @return {string} HTML code with the WIRIS data converted into LaTeX and images.\r\n * @deprecated Since version 7.6.0. Use Parser.initParse instead.\r\n */\n\nfunction wrs_initParse(code, language) {\n  console.warn('Deprecated method. Use Parser.endParse instead.');\n  return _parser__WEBPACK_IMPORTED_MODULE_1__[\"default\"].initParse(code, language);\n} // Expose the method globally.\n\n\nwindow.wrs_initParse = wrs_initParse;\n/**\r\n * Parses end HTML code. The end HTML code is HTML code with embedded images or LaTeX formulas created with MathType. <br>\r\n * By default this method converts the formula images and LaTeX strings in MathML. <br>\r\n * If image mode is enabled the images will not be converted into MathML. For further information see {@link http://www.wiris.com/plugins/docs/full-mathml-mode}.\r\n * @param {string} code - string to be parsed.\r\n * @param {Object} wirisProperties - extra attributes for the formula.\r\n * @param {string} language - language for the formula.\r\n * @return {string}\r\n * @deprecated Since version 7.6.0. Use Parser.initParse instead.\r\n */\n\nfunction wrs_endParse(code, wirisProperties, language) {\n  console.warn('Deprecated method. Use Parser.endParse instead.');\n  return _parser__WEBPACK_IMPORTED_MODULE_1__[\"default\"].endParse(code, wirisProperties, language);\n} // Expose the method globally.\n\n\nwindow.wrs_endParse = wrs_endParse;\n\n//# sourceURL=webpack:///./core/src/backwardslib.js?");

/***/ }),

/***/ "./core/src/cache.js":
/*!***************************!*\
  !*** ./core/src/cache.js ***!
  \***************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return TextCache; });\nfunction _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError(\"Cannot call a class as a function\"); } }\n\nfunction _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if (\"value\" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }\n\nfunction _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }\n\n/**\r\n * Class representing a client cache class. This class contains pairs of\r\n * strings (key/value) which can be retrieved in any moment. Usually used\r\n * to store AJAX responses for text services like mathml2latex.\r\n */\nvar TextCache =\n/*#__PURE__*/\nfunction () {\n  function TextCache() {\n    _classCallCheck(this, TextCache);\n\n    /**\r\n     * Cache array object. Contains all cache entries.\r\n     * @type {Object[]}\r\n     */\n    this.cache = [];\n  }\n  /**\r\n   * This method populates a key/value pair into the cache property.\r\n   * @param {string} key - The cache key, usually the service string parameter.\r\n   * @param {string} value - The cache value, usually the service response.\r\n   */\n\n\n  _createClass(TextCache, [{\n    key: \"populate\",\n    value: function populate(key, value) {\n      this.cache[key] = value;\n    }\n    /**\r\n     * This method retrieves a cache value. Usually called before call a text service.\r\n     * @param {string} key - The cache key, usually the service string parameter.\r\n     * @return {string} value - The cache value, if exists. False otherwise.\r\n     */\n\n  }, {\n    key: \"get\",\n    value: function get(key) {\n      if (this.cache.hasOwnProperty(key)) {\n        return this.cache[key];\n      } else {\n        return false;\n      }\n    }\n  }]);\n\n  return TextCache;\n}();\n\n\n\n//# sourceURL=webpack:///./core/src/cache.js?");

/***/ }),

/***/ "./core/src/configuration.js":
/*!***********************************!*\
  !*** ./core/src/configuration.js ***!
  \***********************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return Configuration; });\nfunction _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError(\"Cannot call a class as a function\"); } }\n\nfunction _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if (\"value\" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }\n\nfunction _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }\n\n/**\r\n * This class represents the JavaScript configuration properties.\r\n * Usually used to retrieve configuration properties generated in the backend\r\n * into the frontend.\r\n */\nvar Configuration =\n/*#__PURE__*/\nfunction () {\n  function Configuration() {\n    _classCallCheck(this, Configuration);\n  }\n\n  _createClass(Configuration, null, [{\n    key: \"addConfiguration\",\n\n    /**\r\n     * Appends a properties object to Configuration.properties.\r\n     * @param {Object} properties - properties to append to current properties..\r\n     */\n    value: function addConfiguration(properties) {\n      Object.assign(Configuration.properties, properties);\n    }\n    /**\r\n     * Returns the value of one property key.\r\n     * @param {string} key - property key\r\n     * @returns {string} property value\r\n     */\n\n  }, {\n    key: \"get\",\n    value: function get(key) {\n      //TODO: '_wrs_conf' should be removed from the backend service.\n      if (!Configuration.properties.hasOwnProperty('_wrs_conf_' + key)) {\n        return false;\n      }\n\n      return Configuration.properties['_wrs_conf_' + key];\n    }\n    /**\r\n     * Sets a new property.\r\n     * @param {string} key - property key.\r\n     * @param {object} value - property value.\r\n     */\n\n  }, {\n    key: \"set\",\n    value: function set(key, value) {\n      Configuration.properties[key] = value;\n    }\n    /**\r\n     * Updates a property object with new values.\r\n     * @param {string} key - key of the property to be updated.\r\n     * @param {Object} propertyValue - values to update the property.\r\n     */\n\n  }, {\n    key: \"update\",\n    value: function update(key, propertyValue) {\n      if (!Configuration.get(key)) {\n        Configuration.set(key, propertyValue);\n      } else {\n        var updateProperty = Object.assign(Configuration.get(key), propertyValue);\n        Configuration.set(key, updateProperty);\n      }\n    }\n  }]);\n\n  return Configuration;\n}();\n/**\r\n * Static properties object. Stores all configuration properties.\r\n * @type {Object}\r\n */\n\n\n\nConfiguration.properties = {};\n\n//# sourceURL=webpack:///./core/src/configuration.js?");

/***/ }),

/***/ "./core/src/constants.js":
/*!*******************************!*\
  !*** ./core/src/constants.js ***!
  \*******************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return Constants; });\nfunction _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError(\"Cannot call a class as a function\"); } }\n\nfunction _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if (\"value\" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }\n\nfunction _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }\n\n/**\r\n * This class represents all the constants needed in a MathType integration among different classes.+\r\n * If a constant should be used between different classes should be defined here using attribute accessors.\r\n */\nvar Constants =\n/*#__PURE__*/\nfunction () {\n  function Constants() {\n    _classCallCheck(this, Constants);\n  }\n\n  _createClass(Constants, null, [{\n    key: \"safeXmlCharactersEntities\",\n\n    /**\r\n     * Safe XML entities.\r\n     */\n    get: function get() {\n      return {\n        'tagOpener': '&laquo;',\n        'tagCloser': '&raquo;',\n        'doubleQuote': '&uml;',\n        'realDoubleQuote': '&quot;'\n      };\n    }\n    /**\r\n     * Blackboard invalid safe characters.\r\n     */\n\n  }, {\n    key: \"safeBadBlackboardCharacters\",\n    get: function get() {\n      return {\n        'ltElement': '«mo»<«/mo»',\n        'gtElement': '«mo»>«/mo»',\n        'ampElement': '«mo»&«/mo»'\n      };\n    }\n    /**\r\n     * Blackboard valid safe characters.\r\n     */\n\n  }, {\n    key: \"safeGoodBlackboardCharacters\",\n    get: function get() {\n      return {\n        'ltElement': '«mo»§lt;«/mo»',\n        'gtElement': '«mo»§gt;«/mo»',\n        'ampElement': '«mo»§amp;«/mo»'\n      };\n    }\n  }]);\n\n  return Constants;\n}();\n/**\r\n * Standard XML special characters.\r\n * @static\r\n */\n\n\n\nConstants.xmlCharacters = {\n  'tagOpener': '<',\n  // Hex: \\x3C.\n  'tagCloser': '>',\n  // Hex: \\x3E.\n  'doubleQuote': '\"',\n  // Hex: \\x22.\n  'ampersand': '&',\n  // Hex: \\x26.\n  'quote': '\\'' // Hex: \\x27.\n\n  /**\r\n   * Safe XML special characters. This characters are used instead the standard\r\n   * the standard to parse the  MathML if safeXML save mode is enable. Each XML\r\n   * special character have a UTF-8 representation.\r\n   * @static\r\n   */\n\n};\nConstants.safeXmlCharacters = {\n  'tagOpener': '«',\n  // Hex: \\xAB.\n  'tagCloser': '»',\n  // Hex: \\xBB.\n  'doubleQuote': '¨',\n  // Hex: \\xA8.\n  'ampersand': '§',\n  // Hex: \\xA7.\n  'quote': '`',\n  // Hex: \\x60.\n  'realDoubleQuote': '¨'\n};\n\n//# sourceURL=webpack:///./core/src/constants.js?");

/***/ }),

/***/ "./core/src/contentmanager.js":
/*!************************************!*\
  !*** ./core/src/contentmanager.js ***!
  \************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return ContentManager; });\n/* harmony import */ var _configuration_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./configuration.js */ \"./core/src/configuration.js\");\n/* harmony import */ var _editorlistener_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./editorlistener.js */ \"./core/src/editorlistener.js\");\n/* harmony import */ var _listeners_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./listeners.js */ \"./core/src/listeners.js\");\n/* harmony import */ var _mathml_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./mathml.js */ \"./core/src/mathml.js\");\n/* harmony import */ var _util_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./util.js */ \"./core/src/util.js\");\nfunction _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError(\"Cannot call a class as a function\"); } }\n\nfunction _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if (\"value\" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }\n\nfunction _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }\n\n\n\n\n\n\n/**\r\n * This class represents the content of a ModalDialog class managing the following:\r\n * - Insertion in the ModalDialog.\r\n * - Actions to be done once the modal object has been submitted (submitAction() method).\r\n * - Updates itself when ModalDialog is updated, for example when ModalDialog\r\n *   is re-opened (update(modalObject) method).\r\n * - Communicates ModalDialog if some changes have be done (hasChanges() method).\r\n */\n\nvar ContentManager =\n/*#__PURE__*/\nfunction () {\n  /**\r\n   * Class constructor\r\n   * @param {Object} contentManagerAttributes - Object containing all attributes needed to\r\n   * create a new instance of ContentManager class.\r\n   * @param {Object} contentManagerAttributes.editorAttributes - Object containing MathType editor parameters.\r\n   */\n  function ContentManager(contentManagerAttributes) {\n    _classCallCheck(this, ContentManager);\n\n    /**\r\n     * An object containing MathType editor parameters. See\r\n     * http://docs.wiris.com/en/mathtype/mathtype_web/sdk-api/parameters for further information.\r\n     * @type {Object}\r\n     */\n    this.contentManagerAttributes = {};\n\n    if ('editorAttributes' in contentManagerAttributes) {\n      this.editorAttributes = contentManagerAttributes.editorAttributes;\n    } else {\n      throw new Error('ContentManager constructor error: editorAttributes property missed.');\n    }\n    /**\r\n     * CustomEditors instance. Contains the custom editors.\r\n     * @type {CustomEditors}\r\n     */\n\n\n    this.customEditors = null;\n\n    if ('customEditors' in contentManagerAttributes) {\n      this.customEditors = contentManagerAttributes.customEditors;\n    }\n    /**\r\n    * Environment properties. This object contains data about the integration platform.\r\n    * @type {Object}\r\n    * @property {string} editor - Editor name. Usually the HTML editor.\r\n    * @property {string} mode - Save mode. Xml by default\r\n    * @property {string} version - Plugin version.\r\n    */\n\n\n    this.environment = {};\n\n    if ('environment' in contentManagerAttributes) {\n      this.environment = contentManagerAttributes.environment;\n    } else {\n      throw new Error('ContentManager constructor error: environment property missed');\n    }\n    /**\r\n      * ContentManager language.\r\n      * @type {string}\r\n      */\n\n\n    this.language = '';\n\n    if ('language' in contentManagerAttributes) {\n      this.language = contentManagerAttributes.language;\n    } else {\n      throw new Error('ContentManager constructor error: language property missed');\n    }\n    /**\r\n    * Editor listener. Needed to get control about editor changes.\r\n    * @type {EditorListener}\r\n    */\n\n\n    this.editorListener = new _editorlistener_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"]();\n    /**\r\n     * MathType editor instance.\r\n     * @type {JsEditor}\r\n     */\n\n    this.editor = null;\n    /**\r\n     * Navigator user agent.\r\n     * @type {string}\r\n     */\n\n    this.ua = navigator.userAgent.toLowerCase();\n    /**\r\n     * Mobile device properties object\r\n     * @type {Object}\r\n     * @property {boolean} isAndroid - True if the device is android. False otherwise.\r\n     * @property {boolean} isIOS - True if the device is iOS. False otherwise.\r\n     */\n\n    this.deviceProperties = {};\n    this.deviceProperties.isAndroid = this.ua.indexOf(\"android\") > -1;\n    this.deviceProperties.isIOS = this.ua.indexOf(\"ipad\") > -1 || this.ua.indexOf(\"iphone\") > -1;\n    /**\r\n     * Custom editor toolbar.\r\n     * @type {string} toolbar\r\n     */\n\n    this.toolbar = null;\n    /**\r\n     * Instance of the ModalDialog class associated to the ContentManager instance.\r\n     * @type {ModalDialog}\r\n     */\n\n    this.modalDialogInstance = null;\n    /**\r\n     * ContentManager listeners.\r\n     * @type {Listeners}\r\n     */\n\n    this.listeners = new _listeners_js__WEBPACK_IMPORTED_MODULE_2__[\"default\"]();\n    /**\r\n     * MathML associated to the ContentManager instance.\r\n     * @type {string}\r\n     */\n\n    this.mathML = null;\n    /**\r\n     * Indicates if the edited element is a new element or not.\r\n     * @type {boolean}\r\n     */\n\n    this.isNewElement = true;\n    /**\r\n     * IntegrationModel instance. Needed to call wrapper methods.\r\n     * @type {IntegrationModel}\r\n     */\n\n    this.integrationModel = null;\n    /**\r\n     * Indicates if the editor is loaded.\r\n     * @type {boolean}\r\n     */\n\n    this.isEditorLoaded = false;\n  }\n  /**\r\n   * Add a new listener to ContentManager class.\r\n   * @param {Object} listener - listener to be added.\r\n   */\n\n\n  _createClass(ContentManager, [{\n    key: \"addListener\",\n    value: function addListener(listener) {\n      this.listeners.add(listener);\n    }\n    /**\r\n     * Sets an instance of an IntegrationModel\r\n     * @param {IntegrationModel} integrationModel\r\n     */\n\n  }, {\n    key: \"setIntegrationModel\",\n    value: function setIntegrationModel(integrationModel) {\n      this.integrationModel = integrationModel;\n    }\n    /**\r\n     * Sets a modal dialog instance.\r\n     * @param {ModalDialog} - a ModalDialog instance\r\n     */\n\n  }, {\n    key: \"setModalDialogInstance\",\n    value: function setModalDialogInstance(modalDialogInstance) {\n      this.modalDialogInstance = modalDialogInstance;\n    }\n    /**\r\n     * Mandatory method. Inserts editor into modal object content container.\r\n     */\n\n  }, {\n    key: \"insert\",\n    value: function insert() {\n      // Before insert the editor we update the modal object title to avoid weird render display.\n      this.updateTitle(this.modalDialogInstance);\n      this.insertEditor(this.modalDialogInstance);\n    }\n    /**\r\n     * Method to insert MathType into modal object. This method\r\n     * waits until editor JavaScript is loaded to insert the editor into\r\n     * contentContainer modal object element.\r\n     */\n\n  }, {\n    key: \"insertEditor\",\n    value: function insertEditor() {\n      // To know if editor JavaScript is loaded we need to wait until com.wiris.jsEditor namespace is ready.\n      if ('com' in window && 'wiris' in window.com && 'jsEditor' in window.com.wiris) {\n        this.editor = com.wiris.jsEditor.JsEditor.newInstance(this.editorAttributes);\n        this.editor.insertInto(this.modalDialogInstance.contentContainer);\n        this.editor.focus();\n\n        if (this.modalDialogInstance.rtl) {\n          this.editor.action('rtl');\n        } // Setting div in rtl in case of it's activated.\n\n\n        if (this.editor.getEditorModel().isRTL()) {\n          this.editor.element.style.direction = 'rtl';\n        } // Editor listener: this object manages the changes logic of editor.\n\n\n        this.editor.getEditorModel().addEditorListener(this.editorListener); // iOS events.\n\n        if (this.modalDialogInstance.deviceProperties['isIOS']) {\n          setTimeout(function () {\n            this.modalDialogInstance.hideKeyboard();\n          }, 400);\n          var formulaDisplayDiv = document.getElementsByClassName('wrs_formulaDisplay')[0];\n          _util_js__WEBPACK_IMPORTED_MODULE_4__[\"default\"].addEvent(formulaDisplayDiv, 'focus', this.modalDialogInstance.handleOpenedIosSoftkeyboard);\n          _util_js__WEBPACK_IMPORTED_MODULE_4__[\"default\"].addEvent(formulaDisplayDiv, 'blur', this.modalDialogInstance.handleClosedIosSoftkeyboard);\n        } // Fire onLoad event. Necessary to set the MathML into the editor\n        // after is loaded.\n\n\n        this.listeners.fire('onLoad', {});\n        this.isEditorLoaded = true;\n      } else {\n        setTimeout(ContentManager.prototype.insertEditor.bind(this, this.modalDialogInstance), 100);\n      }\n    }\n    /**\r\n     * Loads MathType script.\r\n     */\n\n  }, {\n    key: \"init\",\n    value: function init() {\n      var queryParams = window.location.search.substring(1).split(\"&\");\n\n      for (var i = 0; i < queryParams.length; i++) {\n        var pos = queryParams[i].indexOf(\"v=\");\n\n        if (pos >= 0) {\n          version = queryParams[i].substring(2);\n        }\n      }\n\n      var script = document.createElement('script');\n      script.type = 'text/javascript';\n      var editorUrl = _configuration_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"].get('editorUrl'); // We create an object url for parse url string and work more efficiently.\n\n      var urlObject = document.createElement('a');\n      urlObject.href = editorUrl; // Change to https if necessary.\n\n      if (window.location.href.indexOf(\"https://\") == 0) {\n        // It check if browser is https and configuration is http. If this is so, we will replace protocol.\n        if (urlObject.protocol == 'http:') {\n          urlObject.protocol = 'https:';\n        }\n      } // Check protocol and remove port if it's standard.\n\n\n      if (urlObject.port == '80' || urlObject.port == '443') {\n        editorUrl = urlObject.protocol + '//' + urlObject.hostname + '/' + urlObject.pathname;\n      } else {\n        editorUrl = urlObject.protocol + '//' + urlObject.hostname + ':' + urlObject.port + '/' + urlObject.pathname;\n      } // Editor stats. Use environment property to set it.\n\n\n      var stats = {};\n\n      if ('editor' in this.environment) {\n        stats.editor = this.environment.editor;\n      } else {\n        stats.editor = 'unknown';\n      }\n\n      if ('mode' in this.environment) {\n        stats.mode = this.environment.mode;\n      } else {\n        stats.mode = _configuration_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"].get('saveMode');\n      }\n\n      if ('version' in this.environment) {\n        stats.version = this.environment.version;\n      } else {\n        stats.version = _configuration_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"].get('version');\n      } // Load editor URL. We add stats as GET params.\n\n\n      script.src = editorUrl + \"?lang=\" + this.language + '&stats-editor=' + stats.editor + '&stats-mode=' + stats.mode + '&stats-version=' + stats.version;\n      document.getElementsByTagName('head')[0].appendChild(script);\n    }\n    /**\r\n    * Set the editor initial content: an existing formula or a blank MathML\r\n    */\n\n  }, {\n    key: \"setInitialContent\",\n    value: function setInitialContent() {\n      if (!this.isNewElement) {\n        this.setMathML(this.mathML);\n      }\n    }\n    /**\r\n     * Set a MathML into editor.\r\n     * @param {string} mathml - MathML string.\r\n     * @param {bool} focusDisabled - if true editor don't get focus after the MathML is set. false by default.\r\n     */\n\n  }, {\n    key: \"setMathML\",\n    value: function setMathML(mathml, focusDisabled) {\n      // By default focus is enabled\n      if (typeof focusDisabled === 'undefined') {\n        focusDisabled = false;\n      } // Using setMathML method is not a change produced by the user but for the API\n      // so we set to false the contentChange property of editorListener.\n\n\n      this.editor.setMathMLWithCallback(mathml, function () {\n        this.editorListener.setWaitingForChanges(true);\n      }.bind(this)); // We need to wait a little until the callback finish.\n\n      setTimeout(function () {\n        this.editorListener.setIsContentChanged(false);\n      }.bind(this), 500); // In some scenarios - like closing modal object - editor mustn't be focused.\n\n      if (!focusDisabled) {\n        this.onFocus();\n      }\n    }\n    /**\r\n     * Set focus on editor.\r\n     */\n\n  }, {\n    key: \"onFocus\",\n    value: function onFocus() {\n      if (typeof this.editor !== 'undefined' && this.editor != null) {\n        this.editor.focus();\n      }\n    }\n    /**\r\n     * Mandatory method: modal object calls this method to execute a callback action\r\n     * on submit.\r\n     * This method updates the edition area (inserting a new formula or update an older one),\r\n     * and focus the edition area too.\r\n     */\n\n  }, {\n    key: \"submitAction\",\n    value: function submitAction() {\n      if (!this.editor.isFormulaEmpty()) {\n        var mathML = this.editor.getMathMLWithSemantics(); // Add class for custom editors.\n\n        if (this.customEditors.getActiveEditor() != null) {\n          mathML = _mathml_js__WEBPACK_IMPORTED_MODULE_3__[\"default\"].addCustomEditorClassAttribute(mathML, this.customEditors.getActiveEditor().toolbar);\n        } else {\n          // We need - if exists - the editor name from MathML\n          // class attribute.\n          for (var key in this.customEditors.editors) {\n            mathML = _mathml_js__WEBPACK_IMPORTED_MODULE_3__[\"default\"].removeCustomEditorClassAttribute(mathML, key);\n          }\n        }\n\n        var mathmlEntitiesEncoded = _mathml_js__WEBPACK_IMPORTED_MODULE_3__[\"default\"].mathMLEntities(mathML);\n        this.integrationModel.updateFormula(mathmlEntitiesEncoded);\n      } else {\n        this.integrationModel.updateFormula(null);\n      }\n\n      this.customEditors.disable();\n      this.integrationModel.notifyWindowClosed(); // Set disabled focus to prevent lost focus.\n\n      this.setEmptyMathML();\n      this.customEditors.disable();\n    }\n    /**\r\n     * Set an empty MathML into the editor in order to clean the edit area.\r\n     */\n\n  }, {\n    key: \"setEmptyMathML\",\n    value: function setEmptyMathML() {\n      // As second argument we pass\n      if (this.deviceProperties.isAndroid || this.deviceProperties.isIOS) {\n        // We need to set a empty annotation in order to maintain editor in Hand mode.\n        // Adding dir rtl in case of it's activated.\n        if (this.editor.getEditorModel().isRTL()) {\n          this.setMathML('<math dir=\"rtl\"><semantics><annotation encoding=\"application/json\">[]</annotation></semantics></math>', true);\n        } else {\n          this.setMathML('<math><semantics><annotation encoding=\"application/json\">[]</annotation></semantics></math>', true);\n        }\n      } else {\n        if (this.editor.getEditorModel().isRTL()) {\n          this.setMathML('<math dir=\"rtl\"/>', true);\n        } else {\n          this.setMathML('<math/>', true);\n        }\n      }\n    }\n    /**\r\n     * Mandatory method: modal object calls this method when is updated, for example re-editing a formula when the\r\n     * editor is open with another formula. This method updates the editor content (with an empty MathML or an existing formula),\r\n     * updates - if needed - the editor toolbar (math --> chem or chem --> math) and recover the focus.\r\n     */\n\n  }, {\n    key: \"onOpen\",\n    value: function onOpen() {\n      if (this.isNewElement) {\n        this.setEmptyMathML();\n      } else {\n        this.setMathML(this.mathML);\n      }\n\n      this.updateToolbar();\n      this.onFocus();\n    }\n    /**\r\n     * Sets the correct toolbar depending if exist other custom toolbars at the same time (e.g: Chemistry)\r\n     */\n\n  }, {\n    key: \"updateToolbar\",\n    value: function updateToolbar() {\n      this.updateTitle(this.modalDialogInstance);\n      var customEditor;\n\n      if (customEditor = this.customEditors.getActiveEditor()) {\n        var toolbar = customEditor.toolbar ? customEditor.toolbar : _wrs_int_wirisProperties['toolbar'];\n\n        if (this.toolbar == null || this.toolbar != toolbar) {\n          this.setToolbar(toolbar);\n        }\n      } else {\n        var toolbar = this.getToolbar();\n\n        if (this.toolbar == null || this.toolbar != toolbar) {\n          this.setToolbar(toolbar);\n          this.customEditors.disable();\n        }\n      }\n    }\n    /**\r\n     * Updates the modalObject title: if a custom editor (with a custom toolbar) is enabled\r\n     * picks the custom editor title. Otherwise default title.\r\n     */\n\n  }, {\n    key: \"updateTitle\",\n    value: function updateTitle() {\n      var customEditor;\n\n      if (customEditor = this.customEditors.getActiveEditor()) {\n        this.modalDialogInstance.setTitle(customEditor.title);\n      } else {\n        this.modalDialogInstance.setTitle('MathType');\n      }\n    }\n    /**\r\n     * Returns toolbar depending on the configuration local or server side.\r\n     */\n\n  }, {\n    key: \"getToolbar\",\n    value: function getToolbar() {\n      var toolbar;\n\n      if ('toolbar' in this.editorAttributes) {\n        toolbar = this.editorAttributes.toolbar;\n      } else {\n        toolbar = \"general\";\n      } // TODO: Change global integration variable for integration custom toolbar\n\n\n      if (toolbar == 'general') {\n        toolbar = typeof _wrs_int_wirisProperties == 'undefined' || typeof _wrs_int_wirisProperties['toolbar'] == 'undefined' ? 'general' : _wrs_int_wirisProperties['toolbar'];\n      }\n\n      return toolbar;\n    }\n    /**\r\n     * Set a toolbar into editor.\r\n     * @param {string} toolbar - toolbar name.\r\n     */\n\n  }, {\n    key: \"setToolbar\",\n    value: function setToolbar(toolbar) {\n      this.toolbar = toolbar;\n      this.editor.setParams({\n        'toolbar': this.toolbar\n      });\n    }\n    /**\r\n     * Returns true if the content of the editor has been changed. The logic of the changes\r\n     * is delegated to editorListener object.\r\n     */\n\n  }, {\n    key: \"hasChanges\",\n    value: function hasChanges() {\n      return !this.editor.isFormulaEmpty() && this.editorListener.getIsContentChanged();\n    }\n  }]);\n\n  return ContentManager;\n}();\n\n\n\n//# sourceURL=webpack:///./core/src/contentmanager.js?");

/***/ }),

/***/ "./core/src/core.src.js":
/*!******************************!*\
  !*** ./core/src/core.src.js ***!
  \******************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return Core; });\n/* harmony import */ var _util_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./util.js */ \"./core/src/util.js\");\n/* harmony import */ var _stringmanager_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./stringmanager.js */ \"./core/src/stringmanager.js\");\n/* harmony import */ var _contentmanager_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./contentmanager.js */ \"./core/src/contentmanager.js\");\n/* harmony import */ var _modal_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./modal.js */ \"./core/src/modal.js\");\n/* harmony import */ var _serviceprovider_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./serviceprovider.js */ \"./core/src/serviceprovider.js\");\n/* harmony import */ var _parser_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./parser.js */ \"./core/src/parser.js\");\n/* harmony import */ var _latex_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./latex.js */ \"./core/src/latex.js\");\n/* harmony import */ var _mathml_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./mathml.js */ \"./core/src/mathml.js\");\n/* harmony import */ var _customeditors_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./customeditors.js */ \"./core/src/customeditors.js\");\n/* harmony import */ var _configuration_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./configuration.js */ \"./core/src/configuration.js\");\n/* harmony import */ var _jsvariables_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./jsvariables.js */ \"./core/src/jsvariables.js\");\n/* harmony import */ var _event_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./event.js */ \"./core/src/event.js\");\n/* harmony import */ var _listeners_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./listeners.js */ \"./core/src/listeners.js\");\n/* harmony import */ var _integrationmodel_js__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ./integrationmodel.js */ \"./core/src/integrationmodel.js\");\n/* harmony import */ var _image_js__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ./image.js */ \"./core/src/image.js\");\nfunction _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError(\"Cannot call a class as a function\"); } }\n\nfunction _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if (\"value\" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }\n\nfunction _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n/**\n * Class representing MathType integration Core. This class is the integration entry point. Manages integration\n * initialization (services, languages), events, and the insertion of the formulas in the edit area.\n */\n\nvar Core =\n/*#__PURE__*/\nfunction () {\n  /**\n   * Core class constructor. Admits a string containing the configurationjs service\n   * which loads all JavaScript configuration generated in the backend. This file is needed\n   * to instantiate the serviceProvider class (all services lives in the same path).\n   */\n  function Core() {\n    _classCallCheck(this, Core);\n\n    /**\n     * Language. Needed for accessibility and locales. 'en' by default.\n     * @type {string}\n     */\n    this.language = 'en';\n    /**\n     * Edit mode. Admit 'images' and 'latex' values.\n     * @type {string}\n     */\n\n    this.editMode = 'images';\n    /**\n     * Modal dialog instance.\n     * @type {ModalDialog}\n     */\n\n    this.modalDialog = null;\n    /**\n     * Core custom editors. By default only chemistry editor.\n     * @type {CustomEditors}\n     */\n\n    this.customEditors = new _customeditors_js__WEBPACK_IMPORTED_MODULE_8__[\"default\"]();\n    var chemEditorParams = {\n      name: 'Chemistry',\n      toolbar: 'chemistry',\n      icon: 'chem.png',\n      confVariable: 'chemEnabled',\n      title: 'ChemType',\n      tooltip: 'Insert a chemistry formula - ChemType' // TODO: Localize tooltip.\n\n    };\n    this.customEditors.addEditor('chemistry', chemEditorParams);\n    /**\n     * Environment properties. This object contains data about the integration platform.\n     * @type {Object}\n     * @property {string} editor - Editor name. Usually the HTML editor.\n     * @property {string} mode - Save mode. Xml by default\n     * @property {string} version - Plugin version.\n     */\n\n    this.environment = {};\n    /**\n     * Edit properties.\n     * @type {Object}\n     * @property {boolean} isNewElement - Indicates if the edit formula is a new one or not.\n     * @property {Img} temporalImage - Image of the formula edited. Null if the formula is a new one.\n     * @property {Range} latexRange - LaTeX formula range.\n     * @property {Range} range - Image range.\n     * @property {string} editMode - Edition mode. Images by default.\n     */\n\n    this.editionProperties = {\n      isNewElement: true,\n      temporalImage: null,\n      latexRange: null,\n      range: null\n      /**\n       * Integration model instance.\n       * @type {IntegrationModel}\n       */\n\n    };\n    this.integrationModel = null;\n    /**\n     * ContentManager instance.\n     * @type {ContentManager}\n     */\n\n    this.contentManager = null;\n    /**\n     * Information about the current browser.\n     * @type {string}\n     */\n\n    this.browser = function get_browser() {\n      var ua = navigator.userAgent;\n\n      if (ua.search(\"Edge/\") >= 0) {\n        return \"EDGE\";\n      } else if (ua.search(\"Chrome/\") >= 0) {\n        return \"CHROME\";\n      } else if (ua.search(\"Trident/\") >= 0) {\n        return \"IE\";\n      } else if (ua.search(\"Firefox/\") >= 0) {\n        return \"FIREFOX\";\n      } else if (ua.search(\"Safari/\") >= 0) {\n        return \"SAFARI\";\n      }\n    }();\n    /**\n     * Plugin listeners.\n     * @type {Object[]}\n     */\n\n\n    this.listeners = new _listeners_js__WEBPACK_IMPORTED_MODULE_12__[\"default\"]();\n  }\n  /**\n   * Initializes the core.\n   * @param {string} integrationPath - integration root folder path.\n   */\n\n\n  _createClass(Core, [{\n    key: \"init\",\n    value: function init(integrationPath) {\n      this.load(integrationPath);\n    }\n    /**\n     * Sets the instance of the integration model object.\n     * @param {IntegrationModel} integrationModel - integrationModel instance.\n     */\n\n  }, {\n    key: \"setIntegrationModel\",\n    value: function setIntegrationModel(integrationModel) {\n      this.integrationModel = integrationModel;\n    }\n    /**\n     * This method set an object containing environment properties. The structure for the an\n     * environment object is the following:\n     * @param {Object} environmentObject - And object containing environment properties.\n     * @param {string} environmentObject.editor - Integration editor (usually HTML editor).\n     * @param {string} environmentObject.mode - Save mode.\n     * @param {string} environmentObject.version - Integration version.\n     */\n\n  }, {\n    key: \"setEnvironment\",\n    value: function setEnvironment(environmentObject) {\n      if ('editor' in environmentObject) {\n        this.environment.editor = environmentObject.editor;\n      }\n\n      if ('mode' in environmentObject) {\n        this.environment.mode = environmentObject.mode;\n      }\n\n      if ('version' in environmentObject) {\n        this.environment.version = environmentObject.version;\n      }\n    }\n    /**\n     * Get modal dialog\n     * @returns {ModalDialog} Modal Window core instance.\n     */\n\n  }, {\n    key: \"getModalDialog\",\n    value: function getModalDialog() {\n      return this.modalDialog;\n    }\n    /**\n     * This method inits the Core class doing the following:\n     * - Calls (async) to configurationjs service, converting the response JSON into javascript variables.\n     * - Updates Configuration class with the previous configuration properties.\n     * - Updates the ServiceProvider class using configurationjs service path as reference.\n     * - Load lang strings and CSS.\n     * - Once the previous is ready fires 'onLoad' event.\n     */\n\n  }, {\n    key: \"load\",\n    value: function load(integrationPath) {\n      var httpRequest = typeof XMLHttpRequest != 'undefined' ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');\n      this.integrationPath = integrationPath.indexOf(\"/\") == 0 || integrationPath.indexOf(\"http\") == 0 ? integrationPath : _util_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"].concatenateUrl(this.integrationModel.getPath(), integrationPath);\n      httpRequest.open('GET', this.integrationPath, false); // Async request.\n\n      httpRequest.onload = function (e) {\n        var _this = this;\n\n        if (httpRequest.readyState === 4) {\n          // Loading configuration variables.\n          var jsonConfiguration = JSON.parse(httpRequest.responseText);\n          var variables = Object.keys(jsonConfiguration);\n          _configuration_js__WEBPACK_IMPORTED_MODULE_9__[\"default\"].addConfiguration(jsonConfiguration); // Adding JavaScript (not backend) configuration variables.\n\n          _configuration_js__WEBPACK_IMPORTED_MODULE_9__[\"default\"].addConfiguration(_jsvariables_js__WEBPACK_IMPORTED_MODULE_10__[\"default\"]); // Load service paths.\n\n          this.loadServicePaths(); // Load lang file.\n\n          this.loadLangFile();\n          this.loadCSS(); // Fire 'onLoad' event. All integration must listen this event in order to know if the plugin has been properly loaded.\n          // We need to wait until stringManager has been loaded.\n\n          if (Core.stringManager === null) {\n            var stringManagerListener = _listeners_js__WEBPACK_IMPORTED_MODULE_12__[\"default\"].newListener('onLoad', function () {\n              _this.listeners.fire('onLoad', {});\n            });\n            Core.stringManager.addListener(stringManagerListener);\n          } else {\n            this.listeners.fire('onLoad', {});\n          }\n        }\n      }.bind(this);\n\n      httpRequest.send(null);\n    }\n    /**\n     * Instantiate a new ServiceProvider path (static) and calculate all the backend services\n     * paths using Core integrationPath as base path.\n     */\n\n  }, {\n    key: \"loadServicePaths\",\n    value: function loadServicePaths() {\n      // Services path (tech dependant).\n      var createImagePath = this.integrationPath.replace('configurationjs', 'createimage');\n      var showImagePath = this.integrationPath.replace('configurationjs', 'showimage');\n      var createImagePath = this.integrationPath.replace('configurationjs', 'createimage');\n      var getMathMLPath = this.integrationPath.replace('configurationjs', 'getmathml');\n      var servicePath = this.integrationPath.replace('configurationjs', 'service'); // Some backend integrations (like Java o Ruby) have an absolute backend path,\n      // for example: /app/service. For them we calculate the absolute URL path, i.e\n      // protocol://domain:port/app/service\n\n      if (this.integrationPath.indexOf(\"/\") == 0) {\n        var serverPath = this.getServerPath();\n        showImagePath = serverPath + showImagePath;\n        createImagePath = serverPath + createImagePath;\n        getMathMLPath = serverPath + getMathMLPath;\n        servicePath = serverPath + servicePath;\n      }\n\n      _serviceprovider_js__WEBPACK_IMPORTED_MODULE_4__[\"default\"].setServicePath('showimage', showImagePath);\n      _serviceprovider_js__WEBPACK_IMPORTED_MODULE_4__[\"default\"].setServicePath('createimage', createImagePath);\n      _serviceprovider_js__WEBPACK_IMPORTED_MODULE_4__[\"default\"].setServicePath('service', servicePath);\n      _serviceprovider_js__WEBPACK_IMPORTED_MODULE_4__[\"default\"].setServicePath('getmathml', getMathMLPath);\n    }\n    /**\n     * Returns the client side server path on integration script lives.\n     * @return {string} client side server path.\n     */\n\n  }, {\n    key: \"getServerPath\",\n    value: function getServerPath() {\n      var url = this.integrationModel.getPath();\n      var hostNameIndex = url.indexOf(\"/\", url.indexOf(\"/\") + 2);\n      return url.substr(0, hostNameIndex);\n    }\n    /**\n     * Loads language file using integration script path as base path. Then\n     * load the string into the core StringManager instance.\n     */\n\n  }, {\n    key: \"loadLangFile\",\n    value: function loadLangFile() {\n      // Translated languages.\n      var languages = 'ar,ca,cs,da,de,en,es,et,eu,fi,fr,gl,he,hr,hu,it,ja,ko,nl,no,pl,pt,pt_br,ru,sv,tr,zh,el';\n      var langArray = languages.split(',');\n      var lang = this.language;\n\n      if (langArray.indexOf(lang) == -1) {\n        lang = lang.substr(0, 2);\n      }\n\n      if (langArray.indexOf(lang) == -1) {\n        lang = 'en';\n      }\n\n      var script = document.createElement('script');\n      script.type = 'text/javascript';\n      script.src = this.integrationModel.getPath() + '/' + this.integrationModel.langFolderName + '/' + lang + '/strings.js'; // When strings are loaded, it loads into stringManager\n\n      script.onload = function () {\n        Core.getStringManager().loadStrings(wrs_strings);\n      };\n\n      document.getElementsByTagName('head')[0].appendChild(script);\n    }\n    /**\n     * Appends CSS file to header.\n     */\n\n  }, {\n    key: \"loadCSS\",\n    value: function loadCSS() {\n      var fileRef = document.createElement(\"link\");\n      fileRef.setAttribute(\"rel\", \"stylesheet\");\n      fileRef.setAttribute(\"type\", \"text/css\");\n      fileRef.setAttribute(\"href\", _util_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"].concatenateUrl(this.integrationModel.getPath(), '/core/styles.css'));\n      document.getElementsByTagName(\"head\")[0].appendChild(fileRef);\n    }\n    /**\n     * Adds a listener to Listeners core property.\n     * @param {Object} listener - listener to be added.\n     */\n\n  }, {\n    key: \"addListener\",\n    value: function addListener(listener) {\n      this.listeners.add(listener);\n    }\n    /**\n     * Adds a listener to global core listeners.\n     * @param {Object} listener - listener to be added.\n     * @static\n     */\n\n  }, {\n    key: \"updateFormula\",\n\n    /**\n     * Transform a MathML into a image formula. Then the image formula is inserted in the specified target, creating\n     * a new image (new formula) or updating an existing one.\n     * @param {Object} focusElement - element to be focused\n     * @param {Object} windowTarget - window where the editable content is\n     * @param {string} mathml - Mathml code\n     * @param {Object[]} wirisProperties - extra attributes for the formula (like background color or font size).\n     */\n    value: function updateFormula(focusElement, windowTarget, mathml, wirisProperties) {\n      /**\n       * This event is fired after update the formula.\n       * @type {Object}\n       * @property {string} mathml - MathML to be transformed.\n       * @property {string} editMode - edit mode.\n       * @property {Object} wirisProperties - extra attributes for the formula.\n       * @property {string} language - formula language.\n       */\n      var beforeUpdateEvent = new _event_js__WEBPACK_IMPORTED_MODULE_11__[\"default\"]();\n      beforeUpdateEvent.mathml = mathml; // Cloning wirisProperties object\n      // We don't want wirisProperties object modified.\n\n      beforeUpdateEvent.wirisProperties = {};\n\n      for (var attr in wirisProperties) {\n        beforeUpdateEvent.wirisProperties[attr] = wirisProperties[attr];\n      } // Read only.\n\n\n      beforeUpdateEvent.language = this.language;\n      beforeUpdateEvent.editMode = this.editMode;\n\n      if (this.listeners.fire('onBeforeFormulaInsertion', beforeUpdateEvent)) {\n        return;\n      }\n\n      if (Core.globalListeners.fire('onBeforeFormulaInsertion', beforeUpdateEvent)) {\n        return;\n      }\n\n      mathml = beforeUpdateEvent.mathml;\n      wirisProperties = beforeUpdateEvent.wirisProperties;\n      /**\n       * This event is fired after update the formula.\n       * @type {Object}\n       * @param {string} editMode - edit mode.\n       * @param {Object} windowTarget - target window.\n       * @param {Object} focusElement - target element to be focused after update.\n       * @param {string} latex - LaTeX generated by the formula (editMode=latex).\n       * @param {Object} node - node generated after update the formula (text if LaTeX img otherwise).\n       */\n\n      var afterUpdateEvent = new _event_js__WEBPACK_IMPORTED_MODULE_11__[\"default\"]();\n      afterUpdateEvent.editMode = this.editMode;\n      afterUpdateEvent.windowTarget = windowTarget;\n      afterUpdateEvent.focusElement = focusElement;\n\n      if (!mathml) {\n        this.insertElementOnSelection(null, focusElement, windowTarget);\n      } else if (this.editMode == 'latex') {\n        afterUpdateEvent.latex = _latex_js__WEBPACK_IMPORTED_MODULE_6__[\"default\"].getLatexFromMathML(mathml); // this.integrationModel.getNonLatexNode is an integration wrapper to have special behaviours for nonLatex.\n        // Not all the integrations have special behaviours for nonLatex.\n\n        if (!!this.integrationModel.fillNonLatexNode && !afterUpdateEvent.latex) {\n          this.integrationModel.fillNonLatexNode(afterUpdateEvent, windowTarget, mathml);\n        } else {\n          afterUpdateEvent.node = windowTarget.document.createTextNode('$$' + afterUpdateEvent.latex + '$$');\n        }\n\n        this.insertElementOnSelection(afterUpdateEvent.node, focusElement, windowTarget);\n      } else if (this.editMode == 'iframes') {\n        var iframe = wrs_mathmlToIframeObject(windowTarget, mathml);\n        this.insertElementOnSelection(iframe, focusElement, windowTarget);\n      } else {\n        afterUpdateEvent.node = _parser_js__WEBPACK_IMPORTED_MODULE_5__[\"default\"].mathmlToImgObject(windowTarget.document, mathml, wirisProperties, this.language);\n        this.insertElementOnSelection(afterUpdateEvent.node, focusElement, windowTarget);\n      }\n\n      if (this.listeners.fire('onAfterFormulaInsertion', afterUpdateEvent)) {\n        return;\n      }\n\n      if (Core.globalListeners.fire('onAfterFormulaInsertion', afterUpdateEvent)) {\n        return;\n      }\n    }\n    /**\n     * Sets the caret after 'node' and focus node owner document.\n     * @param {Object} node - node that it will be behind the caret after the execution.\n     */\n\n  }, {\n    key: \"placeCaretAfterNode\",\n    value: function placeCaretAfterNode(node) {\n      this.integrationModel.getSelection();\n      var nodeDocument = node.ownerDocument;\n\n      if (typeof nodeDocument.getSelection !== 'undefined' && !!node.parentElement) {\n        var range = nodeDocument.createRange();\n        range.setStartAfter(node);\n        range.collapse(true);\n        var selection = nodeDocument.getSelection();\n        selection.removeAllRanges();\n        selection.addRange(range);\n        nodeDocument.body.focus();\n      }\n    }\n    /**\n     * Replaces a selection with an element.\n     * @param {Object} element - element to replace the selection.\n     * @param {Object} focusElement - element to be focused after the replace.\n     * @param {Object} windowTarget - target window.\n     */\n\n  }, {\n    key: \"insertElementOnSelection\",\n    value: function insertElementOnSelection(element, focusElement, windowTarget) {\n      if (this.editionProperties.isNewElement) {\n        if (element) {\n          if (focusElement.type == 'textarea') {\n            _util_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"].updateTextArea(focusElement, element.textContent);\n          } else if (document.selection && document.getSelection == 0) {\n            var range = windowTarget.document.selection.createRange();\n            windowTarget.document.execCommand('InsertImage', false, element.src);\n\n            if (!('parentElement' in range)) {\n              windowTarget.document.execCommand('delete', false);\n              range = windowTarget.document.selection.createRange();\n              windowTarget.document.execCommand('InsertImage', false, element.src);\n            }\n\n            if ('parentElement' in range) {\n              var temporalObject = range.parentElement();\n\n              if (temporalObject.nodeName.toUpperCase() == 'IMG') {\n                temporalObject.parentNode.replaceChild(element, temporalObject);\n              } else {\n                // IE9 fix: parentNode() does not return the IMG node, returns the parent DIV node. In IE < 9, pasteHTML does not work well.\n                range.pasteHTML(_util_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"].createObjectCode(element));\n              }\n            }\n          } else {\n            var editorSelection = this.integrationModel.getSelection();\n\n            var _range; // In IE is needed keep the range due to after focus the modal window it can't be retrieved the last selection.\n\n\n            if (this.editionProperties.range) {\n              _range = this.editionProperties.range;\n              this.editionProperties.range = null;\n            } else {\n              _range = editorSelection.getRangeAt(0);\n            } // Delete if something was surrounded.\n\n\n            _range.deleteContents();\n\n            var node = _range.startContainer;\n            var position = _range.startOffset;\n\n            if (node.nodeType == 3) {\n              // TEXT_NODE.\n              node = node.splitText(position);\n              node.parentNode.insertBefore(element, node);\n            } else if (node.nodeType == 1) {\n              // ELEMENT_NODE.\n              node.insertBefore(element, node.childNodes[position]);\n            }\n\n            this.placeCaretAfterNode(element);\n          }\n        } else if (focusElement.type == 'textarea') {\n          focusElement.focus();\n        } else {\n          var _editorSelection = this.integrationModel.getSelection();\n\n          _editorSelection.removeAllRanges();\n\n          if (this.editionProperties.range) {\n            var _range2 = this.editionProperties.range;\n            this.editionProperties.range = null;\n\n            _editorSelection.addRange(_range2);\n          }\n        }\n      } else if (this.editionProperties.latexRange) {\n        if (document.selection && document.getSelection == 0) {\n          this.editionProperties.isNewElement = true;\n          this.editionProperties.latexRange.select();\n          this.insertElementOnSelection(element, focusElement, windowTarget);\n        } else {\n          this.editionProperties.latexRange.deleteContents();\n          this.editionProperties.latexRange.insertNode(element);\n          this.placeCaretAfterNode(element);\n        }\n      } else if (focusElement.type == \"textarea\") {\n        var item; // Wrapper for some integrations that can have special behaviours to show latex.\n\n        if (typeof this.integrationModel.getSelectedItem !== 'undefined') {\n          item = this.integrationModel.getSelectedItem(focusElement, false);\n        } else {\n          item = _util_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"].getSelectedItemOnTextarea(focusElement);\n        }\n\n        _util_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"].updateExistingTextOnTextarea(focusElement, element.textContent, item.startPosition, item.endPosition);\n      } else {\n        if (element && element.nodeName.toLowerCase() === 'img') {\n          // Editor empty, formula has been erased on edit.\n          // Clone is needed to maintain event references to temporalImage.\n          _image_js__WEBPACK_IMPORTED_MODULE_14__[\"default\"].clone(element, this.editionProperties.temporalImage);\n        } else {\n          this.editionProperties.temporalImage.remove();\n        }\n\n        this.placeCaretAfterNode(this.editionProperties.temporalImage);\n      }\n    }\n    /**\n     * Opens a new modal dialog.\n     * @param {object} target - target element.\n     * @param {boolean} isIframe - specifies if the target is an iframe.\n     */\n\n  }, {\n    key: \"openModalDialog\",\n    value: function openModalDialog(target, isIframe) {\n      // Textarea elements don't have normal document ranges. It only accepts latex edit.\n      this.editMode = 'images'; // In IE is needed keep the range due to after focus the modal window it can't be retrieved the last selection.\n\n      try {\n        if (isIframe) {\n          // Is needed focus the target first.\n          target.contentWindow.focus();\n          var selection = target.contentWindow.getSelection();\n          this.editionProperties.range = selection.getRangeAt(0);\n        } else {\n          // Is needed focus the target first.\n          target.focus();\n\n          var _selection = getSelection();\n\n          this.editionProperties.range = _selection.getRangeAt(0);\n        }\n      } catch (e) {\n        this.editionProperties.range = null;\n      }\n\n      if (isIframe === undefined) {\n        isIframe = true;\n      }\n\n      this.editionProperties.latexRange = null;\n\n      if (target) {\n        var selectedItem;\n\n        if (typeof this.integrationModel.getSelectedItem !== 'undefined') {\n          selectedItem = this.integrationModel.getSelectedItem(target, isIframe);\n        } else {\n          selectedItem = _util_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"].getSelectedItem(target, isIframe);\n        } // Check LaTeX if and only if the node is a text node (nodeType==3).\n\n\n        if (selectedItem) {\n          // Case when image was selected and button pressed.\n          if (!selectedItem.caretPosition && _util_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"].containsClass(selectedItem.node, _configuration_js__WEBPACK_IMPORTED_MODULE_9__[\"default\"].get('imageClassName'))) {\n            this.editionProperties.temporalImage = selectedItem.node;\n            this.editionProperties.isNewElement = false;\n          } else if (selectedItem.node.nodeType === 3) {\n            // If it's a text node means that editor is working with LaTeX.\n            if (!!this.integrationModel.getMathmlFromTextNode) {\n              // If integration has this function it isn't set range due to we don't\n              // know if it will be put into a textarea as a text or image.\n              var mathml = this.integrationModel.getMathmlFromTextNode(selectedItem.node, selectedItem.caretPosition);\n\n              if (mathml) {\n                this.editMode = 'latex';\n                this.editionProperties.isNewElement = false;\n                this.editionProperties.temporalImage = document.createElement('img');\n                this.editionProperties.temporalImage.setAttribute(_configuration_js__WEBPACK_IMPORTED_MODULE_9__[\"default\"].get('imageMathmlAttribute'), _mathml_js__WEBPACK_IMPORTED_MODULE_7__[\"default\"].safeXmlEncode(mathml));\n              }\n            } else {\n              var latexResult = _latex_js__WEBPACK_IMPORTED_MODULE_6__[\"default\"].getLatexFromTextNode(selectedItem.node, selectedItem.caretPosition);\n\n              if (latexResult) {\n                var _mathml = _latex_js__WEBPACK_IMPORTED_MODULE_6__[\"default\"].getMathMLFromLatex(latexResult.latex);\n\n                this.editMode = 'latex';\n                this.editionProperties.isNewElement = false;\n                this.editionProperties.temporalImage = document.createElement('img');\n                this.editionProperties.temporalImage.setAttribute(_configuration_js__WEBPACK_IMPORTED_MODULE_9__[\"default\"].get('imageMathmlAttribute'), _mathml_js__WEBPACK_IMPORTED_MODULE_7__[\"default\"].safeXmlEncode(_mathml));\n                var windowTarget = isIframe ? target.contentWindow : window;\n\n                if (target.tagName.toLowerCase() !== 'textarea') {\n                  if (document.selection) {\n                    var leftOffset = 0;\n                    var previousNode = latexResult.startNode.previousSibling;\n\n                    while (previousNode) {\n                      leftOffset += _util_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"].getNodeLength(previousNode);\n                      previousNode = previousNode.previousSibling;\n                    }\n\n                    this.editionProperties.latexRange = windowTarget.document.selection.createRange();\n                    this.editionProperties.latexRange.moveToElementText(latexResult.startNode.parentNode);\n                    this.editionProperties.latexRange.move('character', leftOffset + latexResult.startPosition);\n                    this.editionProperties.latexRange.moveEnd('character', latexResult.latex.length + 4); // Plus 4 for the '$$' characters.\n                  } else {\n                    this.editionProperties.latexRange = windowTarget.document.createRange();\n                    this.editionProperties.latexRange.setStart(latexResult.startNode, latexResult.startPosition);\n                    this.editionProperties.latexRange.setEnd(latexResult.endNode, latexResult.endPosition);\n                  }\n                }\n              }\n            }\n          }\n        } else if (target.tagName.toLowerCase() === 'textarea') {\n          // By default editMode is 'images', but when target is a textarea it needs to be 'latex'.\n          this.editMode = 'latex';\n        }\n      } // Setting an object with the editor parameters.\n      // Editor parameters can be customized in several ways:\n      // 1 - editorAttributes: Contains the default editor attributes, usually the metrics in a comma separated string. Always exists.\n      // 2 - editorParameters: Object containing custom editor parameters. These parameters are defined in the backend. So they affects\n      //     all integration instances.\n      // The backend send the default editor attributes in a coma separated with the following structure:\n      // key1=value1,key2=value2...\n\n\n      var defaultEditorAttributesArray = _configuration_js__WEBPACK_IMPORTED_MODULE_9__[\"default\"].get('editorAttributes').split(\", \");\n      var defaultEditorAttributes = {};\n\n      for (var i = 0, len = defaultEditorAttributesArray.length; i < len; i++) {\n        var tempAttribute = defaultEditorAttributesArray[i].split('=');\n        var key = tempAttribute[0];\n        var value = tempAttribute[1];\n        defaultEditorAttributes[key] = value;\n      } // Custom editor parameters.\n\n\n      var editorAttributes = {};\n      Object.assign(editorAttributes, defaultEditorAttributes, _configuration_js__WEBPACK_IMPORTED_MODULE_9__[\"default\"].get('editorParameters'));\n      editorAttributes.language = this.language;\n      editorAttributes.rtl = this.integrationModel.rtl;\n      var contentManagerAttributes = {};\n      contentManagerAttributes.editorAttributes = editorAttributes;\n      contentManagerAttributes.language = this.language;\n      contentManagerAttributes.customEditors = this.customEditors;\n      contentManagerAttributes.environment = this.environment;\n\n      if (this.modalDialog == null) {\n        this.modalDialog = new _modal_js__WEBPACK_IMPORTED_MODULE_3__[\"default\"](editorAttributes);\n        this.contentManager = new _contentmanager_js__WEBPACK_IMPORTED_MODULE_2__[\"default\"](contentManagerAttributes); // When an instance of ContentManager is created we need to wait until the ContentManager is ready\n        // by listening 'onLoad' event.\n\n        var listener = _listeners_js__WEBPACK_IMPORTED_MODULE_12__[\"default\"].newListener('onLoad', function () {\n          this.contentManager.isNewElement = this.editionProperties.isNewElement;\n\n          if (this.editionProperties.temporalImage != null) {\n            var mathML = _mathml_js__WEBPACK_IMPORTED_MODULE_7__[\"default\"].safeXmlDecode(this.editionProperties.temporalImage.getAttribute(_configuration_js__WEBPACK_IMPORTED_MODULE_9__[\"default\"].get('imageMathmlAttribute')));\n            this.contentManager.mathML = mathML;\n          }\n        }.bind(this));\n        this.contentManager.addListener(listener);\n        this.contentManager.init();\n        this.modalDialog.setContentManager(this.contentManager);\n        this.contentManager.setModalDialogInstance(this.modalDialog);\n      } else {\n        this.contentManager.isNewElement = this.editionProperties.isNewElement;\n\n        if (this.editionProperties.temporalImage != null) {\n          var mathML = _mathml_js__WEBPACK_IMPORTED_MODULE_7__[\"default\"].safeXmlDecode(this.editionProperties.temporalImage.getAttribute(_configuration_js__WEBPACK_IMPORTED_MODULE_9__[\"default\"].get('imageMathmlAttribute')));\n          this.contentManager.mathML = mathML;\n        }\n      }\n\n      this.contentManager.setIntegrationModel(this.integrationModel);\n      this.modalDialog.open();\n    }\n    /**\n     * Returns the instance of the ServiceProvider class.\n     * @returns {ServiceProvider} ServiceProvider instance.\n     * @static\n     */\n\n  }, {\n    key: \"getCustomEditors\",\n\n    /**\n     * Return an object with all instance custom editors.\n     * @return {CustomEditors}\n     */\n    value: function getCustomEditors() {\n      return this.customEditors;\n    }\n  }], [{\n    key: \"addGlobalListener\",\n    value: function addGlobalListener(listener) {\n      Core.globalListeners.add(listener);\n    }\n  }, {\n    key: \"getServiceProvider\",\n    value: function getServiceProvider() {\n      return Core.serviceProvider;\n    }\n    /**\n     * Returns the instance of the StringManager class.\n     * @returns {StringManager} StringManager instance\n     */\n\n  }, {\n    key: \"getStringManager\",\n    value: function getStringManager() {\n      return Core.stringManager;\n    }\n  }]);\n\n  return Core;\n}();\n/**\n * Plugin static listeners.\n * @type {Object[]}\n * @static\n */\n\n\n\nCore.globalListeners = new _listeners_js__WEBPACK_IMPORTED_MODULE_12__[\"default\"]();\n/**\n * Class to manage plugin locales.\n * @type {StringManager}\n * @static\n */\n\nCore.stringManager = new _stringmanager_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"]();\n\n//# sourceURL=webpack:///./core/src/core.src.js?");

/***/ }),

/***/ "./core/src/customeditors.js":
/*!***********************************!*\
  !*** ./core/src/customeditors.js ***!
  \***********************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return CustomEditors; });\nfunction _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError(\"Cannot call a class as a function\"); } }\n\nfunction _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if (\"value\" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }\n\nfunction _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }\n\n/**\r\n * This class represents MathType custom editors. A custom editor is athType editor with a different\r\n * toolbar. This class is necessary to associate a custom editor to:\r\n * - It's own formulas\r\n * - A custom toolbar\r\n * - An icon to open it from a HTML editor.\r\n * - A tooltip for the icon.\r\n * - A global variable to enable or disable it globally.\r\n */\nvar CustomEditors =\n/*#__PURE__*/\nfunction () {\n  function CustomEditors() {\n    _classCallCheck(this, CustomEditors);\n\n    /**\r\n     * Array containing all custom editors.\r\n     * @type {Object[]}\r\n     */\n    this.editors = [];\n    /**\r\n     * Default editor name.\r\n     * @type {string}\r\n     */\n\n    this.activeEditor = 'default';\n  }\n  /**\r\n   * Adds a custom editor to editors property.\r\n   * @param {string} editorName - editorName.\r\n   * @param {Object} editorParams - custom editor params.\r\n   * @param {string} editorParams.name - custom editor name.\r\n   * @param {string} editorParams.toolbar - custom editor toolbar.\r\n   * @param {string} editorParams.icon - custom editor icon.\r\n   * @param {string} editorParams.confVariable - configuration key to retrieve if the custom editor is enabled.\r\n   * @param {string} editorParams.title - custom editor title.\r\n   * @param {string} editorParams.tooltip - custom editor tooltip associated with it's own icon.\r\n   */\n\n\n  _createClass(CustomEditors, [{\n    key: \"addEditor\",\n    value: function addEditor(editorName, editorParams) {\n      var customEditor = {};\n      customEditor.name = editorParams.name;\n      customEditor.toolbar = editorParams.toolbar;\n      customEditor.icon = editorParams.icon;\n      customEditor.confVariable = editorParams.confVariable;\n      customEditor.title = editorParams.title;\n      customEditor.tooltip = editorParams.tooltip;\n      this.editors[editorName] = customEditor;\n    }\n    /**\r\n     * Adds a customEditor to editors property.\r\n     * @param {string} key - editor key.\r\n     * @param {CustomEditor} customEditor - a custom editor class.\r\n     */\n\n  }, {\n    key: \"add\",\n    value: function add(key, customEditor) {\n      this.customEditors[key] = customEditor;\n    }\n    /**\r\n     * Set as active a customEditor.\r\n     * @param {string} customEditor - customEditor key.\r\n     */\n\n  }, {\n    key: \"enable\",\n    value: function enable(customEditor) {\n      this.activeEditor = customEditor;\n    }\n    /**\r\n     * Disables a custom editor.\r\n     */\n\n  }, {\n    key: \"disable\",\n    value: function disable() {\n      this.activeEditor = 'default';\n    }\n    /**\r\n     * Returns the active editor key.\r\n     * @return {object} - If a custom editor is enabled, returns the custom editor object. Null otherwise.\r\n     */\n\n  }, {\n    key: \"getActiveEditor\",\n    value: function getActiveEditor() {\n      if (this.activeEditor != 'default') {\n        return this.editors[this.activeEditor];\n      } else {\n        return null;\n      }\n    }\n  }]);\n\n  return CustomEditors;\n}();\n\n\n\n//# sourceURL=webpack:///./core/src/customeditors.js?");

/***/ }),

/***/ "./core/src/editorlistener.js":
/*!************************************!*\
  !*** ./core/src/editorlistener.js ***!
  \************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return EditorListener; });\nfunction _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError(\"Cannot call a class as a function\"); } }\n\nfunction _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if (\"value\" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }\n\nfunction _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }\n\n/**\r\n * EditorListener class. This class implement EditorListener interface\r\n * and contains the logic to determine if editor has been changed or not.\r\n */\nvar EditorListener =\n/*#__PURE__*/\nfunction () {\n  function EditorListener() {\n    _classCallCheck(this, EditorListener);\n\n    /**\r\n     * Indicates if the content of the editor has changed.\r\n     * @type {boolean}\r\n     */\n    this.isContentChanged = false;\n    /**\r\n     * Indicates if the listener should be waiting for changes in the editor.\r\n     * @type {boolean}\r\n     */\n\n    this.waitingForChanges = false;\n  }\n  /**\r\n   * EditorListener method set if content is changed\r\n   * @param {boolean} value - true if the content has changed. false otherwise.\r\n   */\n\n\n  _createClass(EditorListener, [{\n    key: \"setIsContentChanged\",\n    value: function setIsContentChanged(value) {\n      this.isContentChanged = value;\n    }\n  }, {\n    key: \"getIsContentChanged\",\n\n    /**\r\n     * Returns true if the content of the editor has been changed. false otherwise.\r\n     * @return {boolean}\r\n     */\n    value: function getIsContentChanged() {\n      return this.isContentChanged;\n    }\n  }, {\n    key: \"setWaitingForChanges\",\n\n    /**\r\n     * Indicates if the EditorListener should wait for any changes.\r\n     * @param {boolean} value - true if the editor should wait for changes. false otherwise.\r\n     */\n    value: function setWaitingForChanges(value) {\n      this.waitingForChanges = value;\n    }\n  }, {\n    key: \"caretPositionChanged\",\n\n    /**\r\n     * EditorListener method to overwrite.\r\n     */\n    value: function caretPositionChanged(editor) {}\n  }, {\n    key: \"clipboardChanged\",\n\n    /**\r\n     * EditorListener method to overwrite\r\n     */\n    value: function clipboardChanged(editor) {}\n  }, {\n    key: \"contentChanged\",\n\n    /**\r\n     * This method contains all the logic to indicate if the content of the editor\r\n     * has changed.\r\n     * @param {JsEditor} editor - editor object.\r\n     */\n    value: function contentChanged(editor) {\n      if (this.waitingForChanges === true && this.isContentChanged === false) {\n        this.isContentChanged = true;\n      }\n    }\n    /**\r\n     * EditorListener method to overwrite\r\n     */\n\n  }, {\n    key: \"styleChanged\",\n    value: function styleChanged(editor) {}\n  }, {\n    key: \"transformationReceived\",\n\n    /**\r\n     * EditorListener method to overwrite\r\n     */\n    value: function transformationReceived(editor) {}\n  }]);\n\n  return EditorListener;\n}();\n\n\n\n//# sourceURL=webpack:///./core/src/editorlistener.js?");

/***/ }),

/***/ "./core/src/event.js":
/*!***************************!*\
  !*** ./core/src/event.js ***!
  \***************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return Event; });\nfunction _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError(\"Cannot call a class as a function\"); } }\n\nfunction _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if (\"value\" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }\n\nfunction _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }\n\n/**\r\n * This class represents a custom event.\r\n */\nvar Event =\n/*#__PURE__*/\nfunction () {\n  /**\r\n   * Class constructor.\r\n   */\n  function Event() {\n    _classCallCheck(this, Event);\n\n    this.cancelled = false;\n    this.defaultPrevented = false;\n  }\n  /**\r\n   * Cancel the event.\r\n   */\n\n\n  _createClass(Event, [{\n    key: \"cancel\",\n    value: function cancel() {\n      this.cancelled = true;\n    }\n    /**\r\n     * Prevents the default action\r\n     */\n\n  }, {\n    key: \"preventDefault\",\n    value: function preventDefault() {\n      this.defaultPrevented = true;\n    }\n  }]);\n\n  return Event;\n}();\n\n\n\n//# sourceURL=webpack:///./core/src/event.js?");

/***/ }),

/***/ "./core/src/image.js":
/*!***************************!*\
  !*** ./core/src/image.js ***!
  \***************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return Image; });\n/* harmony import */ var _configuration_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./configuration.js */ \"./core/src/configuration.js\");\n/* harmony import */ var _util_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./util.js */ \"./core/src/util.js\");\nfunction _typeof(obj) { if (typeof Symbol === \"function\" && typeof Symbol.iterator === \"symbol\") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === \"function\" && obj.constructor === Symbol && obj !== Symbol.prototype ? \"symbol\" : typeof obj; }; } return _typeof(obj); }\n\nfunction _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError(\"Cannot call a class as a function\"); } }\n\nfunction _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if (\"value\" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }\n\nfunction _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }\n\n\n\n/**\r\n * This class contains all the logic related to image manipulation.\r\n */\n\nvar Image =\n/*#__PURE__*/\nfunction () {\n  function Image() {\n    _classCallCheck(this, Image);\n  }\n\n  _createClass(Image, null, [{\n    key: \"clone\",\n\n    /**\r\n     * Clone Wirisformula attributes from 'originImg' to 'destImg'.\r\n     * @param {HTMLImageElement} originImg - formula to copy to 'destImg'. Is a Wirisformula.\r\n     * @param {HTMLImageElement} destImg - formula where 'destImg' copies. Is a Wirisformula.\r\n     */\n    value: function clone(originImg, destImg) {\n      var customEditorAttributeName = 'data-custom-editor';\n\n      if (!originImg.hasAttribute(customEditorAttributeName)) {\n        destImg.removeAttribute(customEditorAttributeName);\n      }\n\n      var mathmlAttributeName = _configuration_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"].get('imageMathmlAttribute');\n      var imgAttributes = [mathmlAttributeName, customEditorAttributeName, 'alt', 'height', 'width', 'style', 'src', 'role'];\n\n      for (var _i = 0; _i < imgAttributes.length; _i++) {\n        var iterator = imgAttributes[_i];\n        var originAttribute = originImg.getAttribute(iterator);\n\n        if (originAttribute) {\n          destImg.setAttribute(iterator, originAttribute);\n        }\n      }\n    }\n    /**\r\n    * Calculates the metrics of an img dom object given the response URI.\r\n    * @param {Object} img - DOM image object.\r\n    * @param {string} uri - URI generated by the image service: can be a data URI scheme or a URL.\r\n    * @param {boolean} jsonResponse - indicates if the response of the image service is a JSON object.\r\n    */\n\n  }, {\n    key: \"setImgSize\",\n    value: function setImgSize(img, uri, jsonResponse) {\n      if (jsonResponse) {\n        // Cleaning data:image/png;base64.\n        if (_configuration_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"].get('imageFormat') == 'svg') {\n          // SVG format.\n          // If SVG is encoded in base64 we need to convert the base64 bytes into a SVG string.\n          if (_configuration_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"].get('saveMode') != 'base64') {\n            var ar = Image.getMetricsFromSvgString(uri);\n          } else {\n            var base64String = img.src.substr(img.src.indexOf('base64,') + 7, img.src.length);\n            var svgString = '';\n            var bytes = _util_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"].b64ToByteArray(base64String, base64String.length);\n\n            for (var i = 0; i < bytes.length; i++) {\n              svgString += String.fromCharCode(bytes[i]);\n            }\n\n            var ar = Image.getMetricsFromSvgString(svgString);\n          } // PNG format: we store all metrics information in the first 88 bytes.\n\n        } else {\n          var base64String = img.src.substr(img.src.indexOf('base64,') + 7, img.src.length);\n          var bytes = _util_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"].b64ToByteArray(base64String, 88);\n          var ar = Image.getMetricsFromBytes(bytes);\n        } // Backwards compatibility: we store the metrics into createimage response.\n\n      } else {\n        var ar = _util_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"].urlToAssArray(uri);\n      }\n\n      var width = ar['cw'];\n\n      if (!width) {\n        return;\n      }\n\n      var height = ar['ch'];\n      var baseline = ar['cb'];\n      var dpi = ar['dpi'];\n\n      if (dpi) {\n        width = width * 96 / dpi;\n        height = height * 96 / dpi;\n        baseline = baseline * 96 / dpi;\n      }\n\n      img.width = width;\n      img.height = height;\n      img.style.verticalAlign = \"-\" + (height - baseline) + \"px\";\n    }\n    /**\r\n     * Re-calculates the metrics of a image which has been resized.\r\n     * @param {Object} img  - DOM image object.\r\n     */\n\n  }, {\n    key: \"fixAfterResize\",\n    value: function fixAfterResize(img) {\n      img.removeAttribute('style');\n      img.removeAttribute('width');\n      img.removeAttribute('height'); // In order to avoid resize with max-width css property.\n\n      img.style.maxWidth = 'none';\n\n      if (img.src.indexOf(\"data:image\") != -1) {\n        if (_configuration_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"].get('imageFormat') == 'svg') {\n          // ...data:image/svg+xml;charset=utf8, = 32.\n          var svg = decodeURIComponent(img.src.substring(32, img.src.length));\n          Image.setImgSize(img, svg, true);\n        } else {\n          // ...data:image/png;base64, == 22.\n          var base64 = img.src.substring(22, img.src.length);\n          Image.setImgSize(img, base64, true);\n        }\n      } else {\n        Image.setImgSize(img, img.src);\n      }\n    }\n    /**\r\n     * Returns the metrics (height, width and baseline) contained in SVG image generated\r\n     * by the MathType image service. This image contains as an extra attribute the image baseline (wrs:baseline).\r\n     * @param {string} svgString - a string containing an svg image.\r\n     * @return {Object[]} - Array object containing the image metrics.\r\n     */\n\n  }, {\n    key: \"getMetricsFromSvgString\",\n    value: function getMetricsFromSvgString(svgString) {\n      var first = svgString.indexOf('height=\"');\n      var last = svgString.indexOf('\"', first + 8, svgString.length);\n      var height = svgString.substring(first + 8, last);\n      first = svgString.indexOf('width=\"');\n      last = svgString.indexOf('\"', first + 7, svgString.length);\n      var width = svgString.substring(first + 7, last);\n      first = svgString.indexOf('wrs:baseline=\"');\n      last = svgString.indexOf('\"', first + 14, svgString.length);\n      var baseline = svgString.substring(first + 14, last);\n\n      if (_typeof(width != 'undefined')) {\n        var arr = new Array();\n        arr['cw'] = width;\n        arr['ch'] = height;\n\n        if (typeof baseline != 'undefined') {\n          arr['cb'] = baseline;\n        }\n\n        return arr;\n      }\n    }\n    /**\r\n     * Get metrics (width, height, baseline and dpi) from a png byte array.\r\n     * @param  {Object[]} bytes - png byte array.\r\n     * @return {Object[]} a array containing the png metrics.\r\n     * @static\r\n     */\n\n  }, {\n    key: \"getMetricsFromBytes\",\n    value: function getMetricsFromBytes(bytes) {\n      _util_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"].readBytes(bytes, 0, 8);\n      var alloc = 10;\n      var i = 0;\n\n      while (bytes.length >= 4) {\n        var len = _util_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"].readInt32(bytes);\n        var typ = _util_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"].readInt32(bytes);\n\n        if (typ == 0x49484452) {\n          var width = _util_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"].readInt32(bytes);\n          var height = _util_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"].readInt32(bytes); // Read 5 bytes.\n\n          _util_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"].readInt32(bytes);\n          _util_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"].readByte(bytes);\n        } else if (typ == 0x62615345) {\n          // Baseline: 'baSE'.\n          var baseline = _util_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"].readInt32(bytes);\n        } else if (typ == 0x70485973) {\n          // Dpis: 'pHYs'.\n          var dpi = _util_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"].readInt32(bytes);\n          dpi = Math.round(dpi / 39.37);\n          _util_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"].readInt32(bytes);\n          _util_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"].readByte(bytes);\n        }\n\n        _util_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"].readInt32(bytes);\n      }\n\n      if (typeof width != 'undefined') {\n        var arr = new Array();\n        arr['cw'] = width;\n        arr['ch'] = height;\n        arr['dpi'] = dpi;\n\n        if (baseline) {\n          arr['cb'] = baseline;\n        }\n\n        return arr;\n      }\n    }\n  }]);\n\n  return Image;\n}();\n\n\n\n//# sourceURL=webpack:///./core/src/image.js?");

/***/ }),

/***/ "./core/src/integrationmodel.js":
/*!**************************************!*\
  !*** ./core/src/integrationmodel.js ***!
  \**************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return IntegrationModel; });\n/* harmony import */ var _core_src_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./core.src.js */ \"./core/src/core.src.js\");\n/* harmony import */ var _image_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./image.js */ \"./core/src/image.js\");\n/* harmony import */ var _listeners_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./listeners.js */ \"./core/src/listeners.js\");\n/* harmony import */ var _util_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./util.js */ \"./core/src/util.js\");\n/* harmony import */ var _configuration__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./configuration */ \"./core/src/configuration.js\");\nfunction _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError(\"Cannot call a class as a function\"); } }\n\nfunction _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if (\"value\" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }\n\nfunction _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }\n\n\n\n\n\n\n/**\r\n * @typedef {Object} integrationModelProperties\r\n * @property {string} configurationService - configuration service path.\r\n * @property {HTMLElement} integrationModelProperties.target - HTML target.\r\n * @property {string} integrationModelProperties.scriptName integrationModelProperties.scriptName - integration script name.\r\n * @property {Object} integrationModelProperties.environment - integration environment properties.\r\n * @property {Object} [integrationModelProperties.callbackMethodArguments] - object containing callback method arguments.\r\n * @property {string} [integrationModelProperties.version] - integration version number.\r\n * @property {string} [integrationModelProperties.langFolderName] - integration lang folder name. 'lang' by default.\r\n * @property {Object} [integrationModelProperties.editorObject] - object containing the integration editor instance.\r\n * @property {boolean} [integrationModelProperties.rtl] - true if the editor is in RTL mode. false otherwise.\r\n */\n\n/**\r\n * This class represents an integration model, allowing the integration script to\r\n * communicate with Core class. Each integration must extend this class.\r\n */\n\nvar IntegrationModel =\n/*#__PURE__*/\nfunction () {\n  /**\r\n   * IntegrationModel constructor.\r\n   * @param {integrationModelProperties} integrationModelProperties\r\n   */\n  function IntegrationModel(integrationModelProperties) {\n    _classCallCheck(this, IntegrationModel);\n\n    /**\r\n     * Language. Needed for accessibility and locales. English by default.\r\n     */\n    this.language = 'en';\n    /**\r\n     * Configuration service path. The integration service is needed by Core class to\r\n     * load all the backend configuration into the frontend and also to create the paths\r\n     * of all services (all services lives in the same route). Mandatory property.\r\n     */\n\n    this.configurationService = '';\n\n    if ('configurationService' in integrationModelProperties) {\n      this.configurationService = integrationModelProperties.configurationService;\n    } else {\n      throw new Error('IntegrationModel constructor error: configurationService property missed.');\n    }\n    /**\r\n     * Plugin version. Needed to stats and caching.\r\n     * @type {string}\r\n     */\n\n\n    this.version = 'version' in integrationModelProperties ? integrationModelProperties.version : '';\n    /**\r\n     * DOM target in which the plugin works. Needed to associate events, insert formulas, etc.\r\n     * Mandatory property.\r\n     */\n\n    this.target = null;\n\n    if ('target' in integrationModelProperties) {\n      this.target = integrationModelProperties.target;\n    } else {\n      throw new Error('IntegrationModel constructor error: target property missed.');\n    }\n    /**\r\n     * Integration script name. Needed to know the plugin path.\r\n     */\n\n\n    if ('scriptName' in integrationModelProperties) {\n      this.scriptName = integrationModelProperties.scriptName;\n    } else {\n      throw new Error('IntegrationModel constructor error: scriptName property missed.');\n    }\n    /**\r\n     * Object containing the arguments needed by the callback function.\r\n     */\n\n\n    this.callbackMethodArguments = {};\n\n    if ('callbackMethodArguments' in integrationModelProperties) {\n      this.callbackMethodArguments = integrationModelProperties.callbackMethodArguments;\n    }\n    /**\r\n     * Contains information about the integration environment: like the name of the editor, the version, etc.\r\n     */\n\n\n    this.environment = {};\n\n    if ('environment' in integrationModelProperties) {\n      this.environment = integrationModelProperties.environment;\n    }\n    /**\r\n     * Language folder path. 'lang' by default. the lang folder path could change for some HTML editors.\r\n     */\n\n\n    this.langFolderName = 'lang';\n\n    if ('langFolderName' in integrationModelProperties) {\n      this.langFolderName = integrationModelProperties.langFolderName;\n    }\n    /**\r\n     * Indicates if the DOM target is - or not - and iframe.\r\n     */\n\n\n    this.isIframe = false;\n\n    if (this.target != null) {\n      this.isIframe = this.target.tagName.toUpperCase() === 'IFRAME';\n    }\n    /**\r\n     * Instance of the integration editor object. Usually the entry point to access the API\r\n     * of a HTML editor.\r\n     */\n\n\n    this.editorObject = null;\n\n    if ('editorObject' in integrationModelProperties) {\n      this.editorObject = integrationModelProperties.editorObject;\n    }\n    /**\r\n     * Specifies if the direction of the text is RTL. false by default.\r\n     */\n\n\n    this.rtl = false;\n\n    if ('rtl' in integrationModelProperties) {\n      this.rtl = integrationModelProperties.rtl;\n    }\n    /**\r\n     * Indicates if an image is selected. Needed to resize the image to the original size in case\r\n     * the image is resized.\r\n     * @type {boolean}\r\n     */\n\n\n    this.temporalImageResizing = false;\n    /**\r\n     * The Core class instance associated to the integration model.\r\n     * @type {Core}\r\n     */\n\n    this.core = null;\n    /**\r\n     * Integration model listeners.\r\n     * @type {Listeners}\r\n     */\n\n    this.listeners = new _listeners_js__WEBPACK_IMPORTED_MODULE_2__[\"default\"]();\n  }\n  /**\r\n   * Init function. Usually called from the integration side once the core.js file is loaded.\r\n   */\n\n\n  _createClass(IntegrationModel, [{\n    key: \"init\",\n    value: function init() {\n      this.language = this.getLanguage(); // We need to wait until Core class is loaded ('onLoad' event) before\n      // call the callback method.\n\n      var listener = _listeners_js__WEBPACK_IMPORTED_MODULE_2__[\"default\"].newListener('onLoad', function () {\n        this.callbackFunction(this.callbackMethodArguments);\n      }.bind(this));\n      this.setCore(new _core_src_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"]());\n      this.core.addListener(listener);\n      this.core.language = this.language; // Initializing Core class.\n\n      this.core.init(this.configurationService);\n      this.core.setEnvironment(this.environment);\n    }\n    /**\r\n     * Returns the absolute path of the integration script.\r\n     * @return {string} - Absolute path for the integration script.\r\n     */\n\n  }, {\n    key: \"getPath\",\n    value: function getPath() {\n      var col = document.getElementsByTagName(\"script\");\n      var path = '';\n\n      for (var i = 0; i < col.length; i++) {\n        var j = col[i].src.lastIndexOf(this.scriptName);\n\n        if (j >= 0) {\n          path = col[i].src.substr(0, j - 1);\n        }\n      }\n\n      return path;\n    }\n    /**\r\n     * Sets the language property.\r\n     * @param {string} language - language code.\r\n     */\n\n  }, {\n    key: \"setLanguage\",\n    value: function setLanguage(language) {\n      this.language = language;\n    }\n    /**\r\n     * Sets a Core instance.\r\n     * @param {Core} core - instance of Core class.\r\n     */\n\n  }, {\n    key: \"setCore\",\n    value: function setCore(core) {\n      this.core = core;\n      core.setIntegrationModel(this);\n    }\n    /**\r\n     * Returns the Core instance.\r\n     * @returns {Core} instance of Core class.\r\n     */\n\n  }, {\n    key: \"getCore\",\n    value: function getCore() {\n      return this.core;\n    }\n    /**\r\n     * Sets the object target and updates the iframe property.\r\n     * @param {HTMLElement} target - target object.\r\n     */\n\n  }, {\n    key: \"setTarget\",\n    value: function setTarget(target) {\n      this.target = target;\n      this.isIframe = this.target.tagName.toUpperCase() === 'IFRAME';\n    }\n    /**\r\n     * Sets the editor object.\r\n     * @param {Object} editorObject - The editor object.\r\n     */\n\n  }, {\n    key: \"setEditorObject\",\n    value: function setEditorObject(editorObject) {\n      this.editorObject = editorObject;\n    }\n    /**\r\n     * Opens formula editor to editing a new formula. Can be overwritten in order to make some\r\n     * actions from integration part before the formula is edited.\r\n     */\n\n  }, {\n    key: \"openNewFormulaEditor\",\n    value: function openNewFormulaEditor() {\n      this.core.editionProperties.isNewElement = true;\n      this.core.openModalDialog(this.target, this.isIframe);\n    }\n    /**\r\n     * Opens formula editor to editing an existing formula. Can be overwritten in order to make some\r\n     * actions from integration part before the formula is edited.\r\n     */\n\n  }, {\n    key: \"openExistingFormulaEditor\",\n    value: function openExistingFormulaEditor() {\n      this.core.editionProperties.isNewElement = false;\n      this.core.openModalDialog(this.target, this.isIframe);\n    }\n    /**\r\n     * Wrapper to Core.updateFormula method.\r\n     * Transform a MathML into a image formula. Then the image formula is inserted in the specified target, creating\r\n     * a new image (new formula) or updating an existing one.\r\n     * @param {string} mathml - MathML to generate the formula.\r\n     * @param {string} editMode - Edit Mode (LaTeX or images).\r\n     */\n\n  }, {\n    key: \"updateFormula\",\n    value: function updateFormula(mathml) {\n      if (this.isIframe) {\n        this.core.updateFormula(this.target.contentWindow, this.target.contentWindow, mathml, null);\n      } else {\n        this.core.updateFormula(this.target, window, mathml, null);\n      }\n    }\n    /**\r\n     * Returns the target selection.\r\n     * @returns {Selection} target selection.\r\n     */\n\n  }, {\n    key: \"getSelection\",\n    value: function getSelection() {\n      if (this.isIframe) {\n        this.target.contentWindow.focus();\n        return this.target.contentWindow.getSelection();\n      } else {\n        this.target.focus();\n        return window.getSelection();\n      }\n    }\n    /**\r\n     * Add events to formulas in the DOM target. The events added are the following:\r\n     * - doubleClickHandler: handles double click event on formulas by opening an editor\r\n     * to edit them.\r\n     * - mouseDownHandler: handles mouse down event on formulas by saving the size of the formula\r\n     * in case the the formula is resized.\r\n     * - mouseUpHandler: handles mouse up event on formulas by restoring the saved formula size\r\n     * in case the formula is resized.\r\n     */\n\n  }, {\n    key: \"addEvents\",\n    value: function addEvents() {\n      var eventTarget = this.isIframe ? this.target.contentWindow.document : this.target;\n      _util_js__WEBPACK_IMPORTED_MODULE_3__[\"default\"].addElementEvents(eventTarget, function (element, event) {\n        this.doubleClickHandler(element, event);\n      }.bind(this), function (element, event) {\n        this.mousedownHandler(element, event);\n      }.bind(this), function (element, event) {\n        this.mouseupHandler(element, event);\n      }.bind(this));\n    }\n    /**\r\n     * Handles a double click on the target element. Opens an editor\r\n     * to re-edit the double-clicked formula.\r\n     * @param {HTMLElement} element - DOM object target.\r\n     */\n\n  }, {\n    key: \"doubleClickHandler\",\n    value: function doubleClickHandler(element) {\n      if (element.nodeName.toLowerCase() == 'img') {\n        this.core.getCustomEditors().disable();\n\n        if (element.hasAttribute('data-custom-editor')) {\n          var customEditor = element.getAttribute('data-custom-editor');\n          this.core.getCustomEditors().enable(customEditor);\n        }\n\n        if (_util_js__WEBPACK_IMPORTED_MODULE_3__[\"default\"].containsClass(element, _configuration__WEBPACK_IMPORTED_MODULE_4__[\"default\"].get('imageClassName'))) {\n          this.core.editionProperties.temporalImage = element;\n          this.core.editionProperties.isNewElement = true;\n          this.openExistingFormulaEditor();\n        }\n      }\n    }\n    /**\r\n     * Handles a mouse up event on the target element. Restores the image size to avoid\r\n     * resizing formulas.\r\n     */\n\n  }, {\n    key: \"mouseupHandler\",\n    value: function mouseupHandler() {\n      if (this.temporalImageResizing) {\n        setTimeout(function () {\n          _image_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"].fixAfterResize(this.temporalImageResizing);\n        }.bind(this), 10);\n      }\n    }\n    /**\r\n     * Handles a mouse down event on the target element. Saves the formula size to avoid\r\n     * resizing formulas.\r\n     * @param {HTMLElement} element - target element.\r\n     */\n\n  }, {\n    key: \"mousedownHandler\",\n    value: function mousedownHandler(element) {\n      if (element.nodeName.toLowerCase() == 'img') {\n        if (_util_js__WEBPACK_IMPORTED_MODULE_3__[\"default\"].containsClass(element, _configuration__WEBPACK_IMPORTED_MODULE_4__[\"default\"].get('imageClassName'))) {\n          this.temporalImageResizing = element;\n        }\n      }\n    }\n    /**\r\n     * Returns the integration language. By default the browser agent. This method\r\n     * should be overwritten to obtain the integration language, for example using the\r\n     * plugin API of an HTML editor.\r\n     * @returns {string} integration language.\r\n     */\n\n  }, {\n    key: \"getLanguage\",\n    value: function getLanguage() {\n      return this.getBrowserLanguage();\n    }\n    /**\r\n     * Returns the browser language.\r\n     * @returns {string} the browser language.\r\n     */\n\n  }, {\n    key: \"getBrowserLanguage\",\n    value: function getBrowserLanguage() {\n      var language = 'en';\n\n      if (navigator.userLanguage) {\n        language = navigator.userLanguage.substring(0, 2);\n      } else if (navigator.language) {\n        language = navigator.language.substring(0, 2);\n      } else {\n        language = 'en';\n      }\n\n      return language;\n    }\n    /**\r\n     * Callback function. This function will be called once the Core is loaded. IntegrationModel class\r\n     * will fire this method once the 'onLoad' Core event is fired. This function should content all the logic to init\r\n     * the integration.\r\n     */\n\n  }, {\n    key: \"callbackFunction\",\n    value: function callbackFunction() {\n      // It's needed to wait until the integration target is ready. The event is fired\n      // from the integration side.\n      var listener = _listeners_js__WEBPACK_IMPORTED_MODULE_2__[\"default\"].newListener('onTargetReady', function () {\n        this.addEvents(this.target);\n      }.bind(this));\n      this.listeners.add(listener);\n    }\n    /**\r\n     * Function called when the content submits an action.\r\n     */\n\n  }, {\n    key: \"notifyWindowClosed\",\n    value: function notifyWindowClosed() {} // Nothing.\n\n    /**\r\n     * Wrapper.\r\n     * Extracts mathml of a determined text node. This function is used as a wrapper inside core.js\r\n     * in order to get mathml from a text node that can contain normal LaTeX or other chosen text.\r\n     * @param {string} textNode - text node to extract the MathML.\r\n     * @param {int} caretPosition - caret position inside the text node.\r\n     * @returns {string} MathML inside the text node.\r\n     */\n\n  }, {\n    key: \"getMathmlFromTextNode\",\n    value: function getMathmlFromTextNode(textNode, caretPosition) {} // Nothing.\n\n    /**\r\n     * Wrapper\r\n     * It fills wrs event object of nonLatex with the desired data.\r\n     * @param {Object} event - event object.\r\n     * @param {Object} window dom window object.\r\n     * @param {string} mathml valid mathml.\r\n     */\n\n  }, {\n    key: \"fillNonLatexNode\",\n    value: function fillNonLatexNode(event, window, mathml) {} // Nothing,\n\n    /**\r\n      Wrapper.\r\n     * Returns selected item from the target.\r\n     * @param {HTMLElement} target - target element\r\n     * @param {boolean} iframe\r\n     */\n\n  }, {\n    key: \"getSelectedItem\",\n    value: function getSelectedItem(target, isIframe) {// Nothing.\n    }\n  }]);\n\n  return IntegrationModel;\n}(); // To know if the integration that extends this class implements\n// wrapper methods, they are set as undefined.\n\n\n\nIntegrationModel.prototype.getMathmlFromTextNode = undefined;\nIntegrationModel.prototype.fillNonLatexNode = undefined;\nIntegrationModel.prototype.getSelectedItem = undefined;\n\n//# sourceURL=webpack:///./core/src/integrationmodel.js?");

/***/ }),

/***/ "./core/src/jsvariables.js":
/*!*********************************!*\
  !*** ./core/src/jsvariables.js ***!
  \*********************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/**\r\n * Represents the configuration properties generated from the frontend (JavaScript variables).\r\n * @type {Object}\r\n * @property {string} _wrs_conf_imageClassName - Default MathType formula image class.\r\n * @property {string} _wrs_conf_imageClassName - Default MathType CAS image class.\r\n */\nvar jsProperties = {\n  _wrs_conf_imageClassName: 'Wirisformula',\n  _wrs_conf_CASClassName: 'Wiriscas'\n};\n/* harmony default export */ __webpack_exports__[\"default\"] = (jsProperties);\n\n//# sourceURL=webpack:///./core/src/jsvariables.js?");

/***/ }),

/***/ "./core/src/latex.js":
/*!***************************!*\
  !*** ./core/src/latex.js ***!
  \***************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return Latex; });\n/* harmony import */ var _cache_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./cache.js */ \"./core/src/cache.js\");\n/* harmony import */ var _mathml_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./mathml.js */ \"./core/src/mathml.js\");\n/* harmony import */ var _serviceprovider_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./serviceprovider.js */ \"./core/src/serviceprovider.js\");\n/* harmony import */ var _constants_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./constants.js */ \"./core/src/constants.js\");\n/* harmony import */ var _util_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./util.js */ \"./core/src/util.js\");\nfunction _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError(\"Cannot call a class as a function\"); } }\n\nfunction _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if (\"value\" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }\n\nfunction _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }\n\n\n\n\n\n\n/**\r\n * This class represents a LaTeX parser. Manages the services which allows to convert\r\n * LaTeX into MathML and MathML into LaTeX.\r\n */\n\nvar Latex =\n/*#__PURE__*/\nfunction () {\n  function Latex() {\n    _classCallCheck(this, Latex);\n  }\n\n  _createClass(Latex, null, [{\n    key: \"getLatexFromMathML\",\n\n    /**\r\n     * Converts MathML to LaTeX by calling mathml2latex service. For text services\r\n     * we call a text service with the param mathml2latex.\r\n     * @param {string} mathml - MathML String\r\n     * @return {string} LaTeX string generated by the MathML argument.\r\n     */\n    value: function getLatexFromMathML(mathml) {\n      var mathmlWithoutSemantics = _mathml_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"].removeSemantics(mathml);\n      /**\r\n       * @type {TextCache}\r\n       */\n\n      var cache = Latex.cache;\n      var data = {\n        'service': 'mathml2latex',\n        'mml': mathmlWithoutSemantics\n      };\n      var jsonResponse = JSON.parse(_serviceprovider_js__WEBPACK_IMPORTED_MODULE_2__[\"default\"].getService('service', data)); //TODO: Error handling.\n\n      var latex = '';\n\n      if (jsonResponse.status == \"ok\") {\n        latex = jsonResponse.result.text;\n        var latexHtmlEntitiesEncoded = _util_js__WEBPACK_IMPORTED_MODULE_4__[\"default\"].htmlEntities(latex); // Inserting LaTeX semantics.\n\n        var mathmlWithSemantics = _mathml_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"].addAnnotation(mathml, latexHtmlEntitiesEncoded, 'LaTeX');\n        cache.populate(latex, mathmlWithSemantics);\n      }\n\n      return latex;\n    }\n    /**\r\n     * Converts LaTeX to MathML by calling latex2mathml service. For text services\r\n     * we call a text service with the param latex2mathml.\r\n     * @param {string} latex - string containing a LaTeX formula.\r\n     * @param {boolean} includeLatexOnSemantics - if true LaTeX would me included into MathML semantics.\r\n     * @return {string} MathML string generated by the LaTeX argument.\r\n     */\n\n  }, {\n    key: \"getMathMLFromLatex\",\n    value: function getMathMLFromLatex(latex, includeLatexOnSemantics) {\n      /**\r\n       * @type {TextCache}\r\n       */\n      var latexCache = Latex.cache;\n\n      if (Latex.cache.get(latex)) {\n        return Latex.cache.get(latex);\n      }\n\n      var data = {\n        'service': 'latex2mathml',\n        'latex': latex\n      };\n\n      if (includeLatexOnSemantics) {\n        data['saveLatex'] = '';\n      }\n\n      var jsonResponse = JSON.parse(_serviceprovider_js__WEBPACK_IMPORTED_MODULE_2__[\"default\"].getService('service', data));\n      var output;\n\n      if (jsonResponse.status == \"ok\") {\n        var mathml = jsonResponse.result.text;\n        mathml = mathml.split(\"\\r\").join('').split(\"\\n\").join(' '); // Populate LatexCache.\n\n        if (mathml.indexOf('semantics') == -1 && mathml.indexOf('annotation') == -1) {\n          mathml = _mathml_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"].addAnnotation(mathml, latex, 'LaTeX');\n          output = mathml;\n        } else {\n          output = mathml;\n        }\n\n        if (!latexCache.get(latex)) {\n          latexCache.populate(latex, mathml);\n        }\n      } else {\n        output = \"$$\" + latex + \"$$\";\n      }\n\n      return output;\n    }\n    /**\r\n     * Converts all occurrences of MathML code to LaTeX. The MathML code should containing <annotation encoding=\"LaTeX\"/> to be converted.\r\n     * @param {string} content - a string containing MathML valid code.\r\n     * @param {Object} characters - an object containing special characters.\r\n     * @return {string} a string containing all MathML annotated occurrences replaced by the corresponding LaTeX code.\r\n     */\n\n  }, {\n    key: \"parseMathmlToLatex\",\n    value: function parseMathmlToLatex(content, characters) {\n      var output = '';\n      var mathTagBegin = characters.tagOpener + 'math';\n      var mathTagEnd = characters.tagOpener + '/math' + characters.tagCloser;\n      var openTarget = characters.tagOpener + 'annotation encoding=' + characters.doubleQuote + 'LaTeX' + characters.doubleQuote + characters.tagCloser;\n      var closeTarget = characters.tagOpener + '/annotation' + characters.tagCloser;\n      var start = content.indexOf(mathTagBegin);\n      var end = 0;\n      var mathml, startAnnotation, closeAnnotation;\n\n      while (start != -1) {\n        output += content.substring(end, start);\n        end = content.indexOf(mathTagEnd, start);\n\n        if (end == -1) {\n          end = content.length - 1;\n        } else {\n          end += mathTagEnd.length;\n        }\n\n        mathml = content.substring(start, end);\n        startAnnotation = mathml.indexOf(openTarget);\n\n        if (startAnnotation != -1) {\n          startAnnotation += openTarget.length;\n          closeAnnotation = mathml.indexOf(closeTarget);\n          var latex = mathml.substring(startAnnotation, closeAnnotation);\n\n          if (characters == _constants_js__WEBPACK_IMPORTED_MODULE_3__[\"default\"].safeXmlCharacters) {\n            latex = _mathml_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"].safeXmlDecode(latex);\n          }\n\n          output += '$$' + latex + '$$'; // Populate latex into cache.\n\n          Latex.cache.populate(latex, mathml);\n        } else {\n          output += mathml;\n        }\n\n        start = content.indexOf(mathTagBegin, end);\n      }\n\n      output += content.substring(end, content.length);\n      return output;\n    }\n    /**\r\n     * Extracts the latex of a determined position in a text.\r\n     * @param {Node} textNode - textNode to extract the LaTeX\r\n     * @param {number} caretPosition - starting position to find LaTeX.\r\n     * @param {Object} latexTags - optional parameter representing tags between latex is inserted. It has the 'open' attribute for the open tag and the 'close' attribute for the close tag.\r\n     * \"$$\" by default.\r\n     * @return {Object} An object with 3 keys: 'latex', 'start' and 'end'. Null if latex is not found.\r\n     * @static\r\n     */\n\n  }, {\n    key: \"getLatexFromTextNode\",\n    value: function getLatexFromTextNode(textNode, caretPosition, latexTags) {\n      // TODO: Set LaTeX Tags as Core variable. Fix the call to this function (third argument).\n      // Tags used for LaTeX formulas.\n      var defaultLatexTags = {\n        'open': '$$',\n        'close': '$$'\n      }; // latexTags is an optional parameter. If is not set, use default latexTags.\n\n      if (typeof latexTags == 'undefined' || latexTags == null) {\n        latexTags = defaultLatexTags;\n      } // Looking for the first textNode.\n\n\n      var startNode = textNode;\n\n      while (startNode.previousSibling && startNode.previousSibling.nodeType == 3) {\n        // TEXT_NODE.\n        startNode = startNode.previousSibling;\n      } // Finding latex.\n\n      /**\r\n       * Returns the next latex position and node from a specific node and position.\r\n       * @param {Node} currentNode - node where searching latex.\r\n       * @param {number} currentPosition - current position inside the currentNode.\r\n       * @param {Object} latexTagsToUse - tags used at latex beginning and latex final. \"$$\" by default.\r\n       * @param {boolean} tag - tag containing the current search.\r\n       * @returns {object} object containing the current node and the position.\r\n       */\n\n\n      function getNextLatexPosition(currentNode, currentPosition, tag) {\n        var position = currentNode.nodeValue.indexOf(tag, currentPosition);\n\n        while (position == -1) {\n          currentNode = currentNode.nextSibling;\n\n          if (!currentNode) {\n            // TEXT_NODE.\n            return null; // Not found.\n          }\n\n          position = currentNode.nodeValue ? currentNode.nodeValue.indexOf(latexTags.close) : -1;\n        }\n\n        return {\n          'node': currentNode,\n          'position': position\n        };\n      }\n      /**\r\n       * Determines if a node is previous, or not, to a second one.\r\n       * @param {Node} node - start node.\r\n       * @param {number} position - start node position.\r\n       * @param {Node} endNode - end node.\r\n       * @param {number} endPosition - end node position.\r\n       * @returns {boolean} true if the starting node is previous thant the en node. false otherwise.\r\n       */\n\n\n      function isPrevious(node, position, endNode, endPosition) {\n        if (node == endNode) {\n          return position <= endPosition;\n        }\n\n        while (node && node != endNode) {\n          node = node.nextSibling;\n        }\n\n        return node == endNode;\n      }\n\n      var start;\n      var end = {\n        'node': startNode,\n        'position': 0\n      }; // Is supposed that open and close tags has the same length.\n\n      var tagLength = latexTags.open.length;\n\n      do {\n        var start = getNextLatexPosition(end.node, end.position, latexTags.open);\n\n        if (start == null || isPrevious(textNode, caretPosition, start.node, start.position)) {\n          return null;\n        }\n\n        var end = getNextLatexPosition(start.node, start.position + tagLength, latexTags.close);\n\n        if (end == null) {\n          return null;\n        }\n\n        end.position += tagLength;\n      } while (isPrevious(end.node, end.position, textNode, caretPosition)); // Isolating latex.\n\n\n      var latex;\n\n      if (start.node == end.node) {\n        latex = start.node.nodeValue.substring(start.position + tagLength, end.position - tagLength);\n      } else {\n        latex = start.node.nodeValue.substring(start.position + tagLength, start.node.nodeValue.length);\n        var currentNode = start.node;\n\n        do {\n          currentNode = currentNode.nextSibling;\n\n          if (currentNode == end.node) {\n            latex += end.node.nodeValue.substring(0, end.position - tagLength);\n          } else {\n            latex += currentNode.nodeValue ? currentNode.nodeValue : '';\n          }\n        } while (currentNode != end.node);\n      }\n\n      return {\n        'latex': latex,\n        'startNode': start.node,\n        'startPosition': start.position,\n        'endNode': end.node,\n        'endPosition': end.position\n      };\n    }\n  }]);\n\n  return Latex;\n}();\n/**\r\n * Text cache. Stores all processed LaTeX strings and it's correspondent MathML string.\r\n * @type {Cache}\r\n * @static\r\n */\n\n\n\nLatex.cache = new _cache_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"]();\n\n//# sourceURL=webpack:///./core/src/latex.js?");

/***/ }),

/***/ "./core/src/listeners.js":
/*!*******************************!*\
  !*** ./core/src/listeners.js ***!
  \*******************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return Listeners; });\nfunction _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError(\"Cannot call a class as a function\"); } }\n\nfunction _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if (\"value\" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }\n\nfunction _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }\n\n/**\r\n * This class represents a class to manage custom listeners.\r\n */\nvar Listeners =\n/*#__PURE__*/\nfunction () {\n  function Listeners() {\n    _classCallCheck(this, Listeners);\n\n    /**\r\n     * Array containing all custom listeners.\r\n     * @type {Object[]}\r\n     */\n    this.listeners = [];\n  }\n  /**\r\n   * Add a listener to Listener class.\r\n   * @param {Object} listener - A listener object.\r\n   */\n\n\n  _createClass(Listeners, [{\n    key: \"add\",\n    value: function add(listener) {\n      this.listeners.push(listener);\n    }\n    /**\r\n     * Fires MathType event listeners\r\n     * @param {String} eventName - event name\r\n     * @param {Event} event - event object.\r\n     * @return {boolean} false if event has been prevented. true otherwise.\r\n     */\n\n  }, {\n    key: \"fire\",\n    value: function fire(eventName, event) {\n      for (var i = 0; i < this.listeners.length && !event.cancelled; ++i) {\n        if (this.listeners[i].eventName === eventName) {\n          // Calling listener.\n          this.listeners[i].callback(event);\n        }\n      }\n\n      return event.defaultPrevented;\n    }\n    /**\r\n     * Creates a new listener object.\r\n     * @param {string} eventName - Event name.\r\n     * @param {Object} callback - Callback function.\r\n     * @returns {object} the listener object.\r\n     */\n\n  }], [{\n    key: \"newListener\",\n    value: function newListener(eventName, callback) {\n      var listener = {};\n      listener.eventName = eventName;\n      listener.callback = callback;\n      return listener;\n    }\n  }]);\n\n  return Listeners;\n}();\n\n\n\n//# sourceURL=webpack:///./core/src/listeners.js?");

/***/ }),

/***/ "./core/src/mathml.js":
/*!****************************!*\
  !*** ./core/src/mathml.js ***!
  \****************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return MathML; });\n/* harmony import */ var _constants_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./constants.js */ \"./core/src/constants.js\");\n/* harmony import */ var _util_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./util.js */ \"./core/src/util.js\");\nfunction _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError(\"Cannot call a class as a function\"); } }\n\nfunction _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if (\"value\" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }\n\nfunction _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }\n\n\n\n/**\r\n * This class represents a class to manage MathML objects.\r\n */\n\nvar MathML =\n/*#__PURE__*/\nfunction () {\n  function MathML() {\n    _classCallCheck(this, MathML);\n  }\n\n  _createClass(MathML, null, [{\n    key: \"isMathmlInAttribute\",\n\n    /**\r\n     * Checks if the mathml at position i is inside an HTML attribute or not.\r\n     * @param {string} content - a string containing MathML code.\r\n     * @param {number} i -  search index.\r\n     * @return {boolean} true if is inside an HTML attribute. false otherwise.\r\n     */\n    value: function isMathmlInAttribute(content, i) {\n      // Regex = '^[\\'\"][\\\\s]*=[\\\\s]*[\\\\w-]+([\\\\s]*(\"[^\"]*\"|\\'[^\\']*\\')[\\\\s]*=[\\\\s]*[\\\\w-]+[\\\\s]*)*[\\\\s]+gmi<';\n      var math_att = '[\\'\"][\\\\s]*=[\\\\s]*[\\\\w-]+'; // \"=att OR '=att\n\n      var att_content = '\"[^\"]*\"|\\'[^\\']*\\''; // \"blabla\" OR 'blabla'\n\n      var att = '[\\\\s]*(' + att_content + ')[\\\\s]*=[\\\\s]*[\\\\w-]+[\\\\s]*'; // \"blabla\"=att OR 'blabla'=att\n\n      var atts = '(' + att + ')*'; // \"blabla\"=att1 \"blabla\"=att2\n\n      var regex = '^' + math_att + atts + '[\\\\s]+gmi<'; // \"=att \"blabla\"=att1 \"blabla\"=att2 gmi< .\n\n      var expression = new RegExp(regex);\n      var actual_content = content.substring(0, i);\n      var reversed = actual_content.split('').reverse().join('');\n      var exists = expression.test(reversed);\n      return exists;\n    }\n    /**\r\n     * Decodes an encoded MathML with standard XML tags.\r\n     * We use these entities because IE doesn't support html entities on its attributes sometimes. Yes, sometimes.\r\n     * @param {string} input - string to be decoded.\r\n     * @return {string} decoded string.\r\n     */\n\n  }, {\n    key: \"safeXmlDecode\",\n    value: function safeXmlDecode(input) {\n      // Decoding entities.\n      input = input.split(_constants_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"].safeXmlCharactersEntities.tagOpener).join(_constants_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"].safeXmlCharacters.tagOpener);\n      input = input.split(_constants_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"].safeXmlCharactersEntities.tagCloser).join(_constants_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"].safeXmlCharacters.tagCloser);\n      input = input.split(_constants_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"].safeXmlCharactersEntities.doubleQuote).join(_constants_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"].safeXmlCharacters.doubleQuote); // Added to fix problem due to import from 1.9.x.\n\n      input = input.split(_constants_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"].safeXmlCharactersEntities.realDoubleQuote).join(_constants_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"].safeXmlCharacters.realDoubleQuote); // Blackboard.\n\n      if ('_wrs_blackboard' in window && window._wrs_blackboard) {\n        input = input.split(_constants_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"].safeBadBlackboardCharacters.ltElement).join(_constants_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"].safeGoodBlackboardCharacters.ltElement);\n        input = input.split(_constants_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"].safeBadBlackboardCharacters.gtElement).join(_constants_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"].safeGoodBlackboardCharacters.gtElement);\n        input = input.split(_constants_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"].safeBadBlackboardCharacters.ampElement).join(_constants_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"].safeGoodBlackboardCharacters.ampElement);\n      } // Decoding characters.\n\n\n      input = input.split(_constants_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"].safeXmlCharacters.tagOpener).join(_constants_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"].xmlCharacters.tagOpener);\n      input = input.split(_constants_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"].safeXmlCharacters.tagCloser).join(_constants_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"].xmlCharacters.tagCloser);\n      input = input.split(_constants_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"].safeXmlCharacters.doubleQuote).join(_constants_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"].xmlCharacters.doubleQuote);\n      input = input.split(_constants_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"].safeXmlCharacters.ampersand).join(_constants_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"].xmlCharacters.ampersand);\n      input = input.split(_constants_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"].safeXmlCharacters.quote).join(_constants_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"].xmlCharacters.quote); // We are replacing $ by & when its part of an entity for retrocompatibility. Now, the standard is replace § by &.\n\n      var returnValue = '';\n      var currentEntity = null;\n\n      for (var i = 0; i < input.length; ++i) {\n        var character = input.charAt(i);\n\n        if (currentEntity == null) {\n          if (character == '$') {\n            currentEntity = '';\n          } else {\n            returnValue += character;\n          }\n        } else {\n          if (character == ';') {\n            returnValue += '&' + currentEntity + ';';\n            currentEntity = null;\n          } else if (character.match(/([a-zA-Z0-9#._-] | '-')/)) {\n            // Character is part of an entity.\n            currentEntity += character;\n          } else {\n            returnValue += '$' + currentEntity; // Is not an entity.\n\n            currentEntity = null;\n            --i; // Parse again the current character.\n          }\n        }\n      }\n\n      return returnValue;\n    }\n    /**\r\n     * Encodes a MathML with standard XML tags to a MMathML encoded with safe XML tags.\r\n     * We use these entities because IE doesn't support html entities on its attributes sometimes. Yes, sometimes.\r\n     * @param {string} input - input string to be encoded\r\n     * @returns {string} encoded string.\r\n     */\n\n  }, {\n    key: \"safeXmlEncode\",\n    value: function safeXmlEncode(input) {\n      input = input.split(_constants_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"].xmlCharacters.tagOpener).join(_constants_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"].safeXmlCharacters.tagOpener);\n      input = input.split(_constants_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"].xmlCharacters.tagCloser).join(_constants_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"].safeXmlCharacters.tagCloser);\n      input = input.split(_constants_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"].xmlCharacters.doubleQuote).join(_constants_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"].safeXmlCharacters.doubleQuote);\n      input = input.split(_constants_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"].xmlCharacters.ampersand).join(_constants_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"].safeXmlCharacters.ampersand);\n      input = input.split(_constants_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"].xmlCharacters.quote).join(_constants_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"].safeXmlCharacters.quote);\n      return input;\n    }\n    /**\r\n     * Converts special symbols (> 128) to entities and replaces all textual entities by its number entities.\r\n     * @param {string} mathml - MathML string containing - or not - special symbols\r\n     * @returns {string} MathML with all textual entities replaced.\r\n     */\n\n  }, {\n    key: \"mathMLEntities\",\n    value: function mathMLEntities(mathml) {\n      var toReturn = '';\n\n      for (var i = 0; i < mathml.length; ++i) {\n        var character = mathml.charAt(i); // Parsing > 128 characters.\n\n        if (mathml.codePointAt(i) > 128) {\n          toReturn += '&#' + mathml.codePointAt(i) + ';'; // For UTF-32 characters we need to move the index one position.\n\n          if (mathml.codePointAt(i) > 0xffff) {\n            i++;\n          }\n        } else if (character == '&') {\n          var end = mathml.indexOf(';', i + 1);\n\n          if (end >= 0) {\n            var container = document.createElement('span');\n            container.innerHTML = mathml.substring(i, end + 1);\n            toReturn += '&#' + _util_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"].fixedCharCodeAt(container.textContent || container.innerText, 0) + ';';\n            i = end;\n          } else {\n            toReturn += character;\n          }\n        } else {\n          toReturn += character;\n        }\n      }\n\n      return toReturn;\n    }\n    /**\r\n     * Add a custom editor name with the prefix wrs_ to a MathML class attribute.\r\n     * @param {string} mathml - a MathML string created with a custom editor, like chemistry.\r\n     * @param {string} customEditor - custom editor name.\r\n     * @returns {string} MathML string with his class containing the editor toolbar string.\r\n     */\n\n  }, {\n    key: \"addCustomEditorClassAttribute\",\n    value: function addCustomEditorClassAttribute(mathml, customEditor) {\n      var toReturn = '';\n      var start = mathml.indexOf('<math');\n\n      if (start == 0) {\n        var end = mathml.indexOf('>');\n\n        if (mathml.indexOf(\"class\") == -1) {\n          // Adding custom editor type.\n          toReturn = mathml.substr(start, end) + ' class=\"wrs_' + customEditor + '\">';\n          toReturn += mathml.substr(end + 1, mathml.length);\n          return toReturn;\n        }\n      }\n\n      return mathml;\n    }\n    /**\r\n     * Remove a custom editor name from the MathML class attribute.\r\n     * @param {string} mathml - a MathML string.\r\n     * @param {string} customEditor - custom editor name.\r\n     * @returns {string} The input MathML without customEditor name in his class.\r\n     */\n\n  }, {\n    key: \"removeCustomEditorClassAttribute\",\n    value: function removeCustomEditorClassAttribute(mathml, customEditor) {\n      // Discard MathML without the specified class.\n      if (mathml.indexOf('class') === -1 || mathml.indexOf('wrs_' + customEditor) === -1) {\n        return mathml;\n      } // Trivial case: class attribute value equal to editor name. Then\n      // class attribute is removed.\n\n\n      if (mathml.indexOf('class=\"wrs_' + customEditor + '\"') !== -1) {\n        return mathml.replace('class=\"wrs_' + customEditor + '\"', '');\n      } // Non Trivial case: class attribute contains editor name.\n\n\n      return mathml.replace('wrs_' + customEditor, '');\n    }\n    /**\r\n     * Adds annotation tag in MathML element.\r\n     * @param {String} mathml - valid MathML.\r\n     * @param {String} content - value to put inside annotation tag.\r\n     * @param {String} annotationEncoding - annotation encoding.\r\n     * @returns {String} - 'mathml' with an annotation that contains 'content' and encoding 'encoding'.\r\n     */\n\n  }, {\n    key: \"addAnnotation\",\n    value: function addAnnotation(mathml, content, annotationEncoding) {\n      // If contains annotation, also contains semantics tag.\n      var containsAnnotation = mathml.indexOf('<annotation');\n      var mathmlWithAnnotation = '';\n\n      if (containsAnnotation !== -1) {\n        var closeSemanticsIndex = mathml.indexOf('</semantics>');\n        mathmlWithAnnotation = mathml.substring(0, closeSemanticsIndex) + \"<annotation encoding=\\\"\".concat(annotationEncoding, \"\\\">\").concat(content, \"</annotation>\") + mathml.substring(closeSemanticsIndex);\n      } else if (MathML.isEmpty(mathml)) {\n        var endIndexInline = mathml.indexOf('/>');\n        var endIndexNonInline = mathml.indexOf('>');\n        var endIndex = endIndexNonInline === endIndexInline ? endIndexInline : endIndexNonInline;\n        mathmlWithAnnotation = mathml.substring(0, endIndex) + \"><semantics><annotation encoding=\\\"\".concat(annotationEncoding, \"\\\">\").concat(content, \"</annotation></semantics></math>\");\n      } else {\n        var beginMathMLContent = mathml.indexOf('>') + 1;\n        var endMathmlContent = mathml.lastIndexOf('</math>');\n        var mathmlContent = mathml.substring(beginMathMLContent, endMathmlContent);\n        mathmlWithAnnotation = mathml.substring(0, beginMathMLContent) + \"<semantics>\".concat(mathmlContent, \"<annotation encoding=\\\"\").concat(annotationEncoding, \"\\\">\").concat(content, \"</annotation></semantics></math>\");\n      }\n\n      return mathmlWithAnnotation;\n    }\n    /**\r\n     * Removes specific annotation tag in MathML element. In case of remove the unique annotation, also is removed semantics tag.\r\n     * @param {String} mathml - valid MathML.\r\n     * @param {String} annotationEncoding - annotation encoding to remove.\r\n     * @returns {String} - 'mathml' without the annotation encoding specified.\r\n     */\n\n  }, {\n    key: \"removeAnnotation\",\n    value: function removeAnnotation(mathml, annotationEncoding) {\n      var mathmlWithoutAnnotation = mathml;\n      var openAnnotationTag = \"<annotation encoding=\\\"\".concat(annotationEncoding, \"\\\">\");\n      var closeAnnotationTag = '</annotation>';\n      var startAnnotationIndex = mathml.indexOf(openAnnotationTag);\n\n      if (startAnnotationIndex !== -1) {\n        var differentAnnotationFound = false;\n        var differentAnnotationIndex = mathml.indexOf('<annotation');\n\n        while (differentAnnotationIndex !== -1) {\n          if (differentAnnotationIndex !== startAnnotationIndex) {\n            differentAnnotationFound = true;\n          }\n\n          differentAnnotationIndex = mathml.indexOf('<annotation', differentAnnotationIndex + 1);\n        }\n\n        if (differentAnnotationFound) {\n          var endAnnotationIndex = mathml.indexOf(closeAnnotationTag, startAnnotationIndex) + closeAnnotationTag.length;\n          mathmlWithoutAnnotation = mathml.substring(0, startAnnotationIndex) + mathml.substring(endAnnotationIndex);\n        } else {\n          mathmlWithoutAnnotation = MathML.removeSemantics(mathml);\n        }\n      }\n\n      return mathmlWithoutAnnotation;\n    }\n    /**\r\n     * Removes semantics tag to mathml.\r\n     * @param {string} mathml - MathML string.\r\n     * @returns {string} - 'mathml' without semantics tag.\r\n     */\n\n  }, {\n    key: \"removeSemantics\",\n    value: function removeSemantics(mathml) {\n      var mathTagEnd = '</math>';\n      var openSemantics = '<semantics>';\n      var openAnnotation = '<annotation';\n      var mathmlWithoutSemantics = mathml;\n      var startSemantics = mathml.indexOf(openSemantics);\n\n      if (startSemantics != -1) {\n        var startAnnotation = mathml.indexOf(openAnnotation, startSemantics + openSemantics.length);\n\n        if (startAnnotation != -1) {\n          mathmlWithoutSemantics = mathml.substring(0, startSemantics) + mathml.substring(startSemantics + openSemantics.length, startAnnotation) + mathTagEnd;\n        }\n      }\n\n      return mathmlWithoutSemantics;\n    }\n    /**\r\n     * Transforms all xml mathml ocurrences that contain semantics to the same\r\n     * xml mathml ocurrences without semantics.\r\n     * @param {string} text - string that can contain xml mathml ocurrences.\r\n     * @param {Constants} [characters] - Constant object containing xmlCharacters or safeXmlCharacters relation.\r\n     * xmlCharacters by default.\r\n     * @returns {string} - 'text' with all xml mathml ocurrences without annotation tag.\r\n     */\n\n  }, {\n    key: \"removeSemanticsOcurrences\",\n    value: function removeSemanticsOcurrences(text) {\n      var characters = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : _constants_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"].xmlCharacters;\n      var mathTagStart = characters.tagOpener + 'math';\n      var mathTagEnd = characters.tagOpener + '/math' + characters.tagCloser;\n      var mathTagEndline = '/' + characters.tagCloser;\n      var tagCloser = characters.tagCloser;\n      var semanticsTagStart = characters.tagOpener + 'semantics' + characters.tagCloser;\n      var annotationTagStart = characters.tagOpener + 'annotation encoding=';\n      var output = '';\n      var start = text.indexOf(mathTagStart);\n      var end = 0;\n\n      while (start !== -1) {\n        output += text.substring(end, start); // MathML can be written as '<math></math>' or '<math />'.\n\n        var mathTagEndIndex = text.indexOf(mathTagEnd, start);\n        var mathTagEndlineIndex = text.indexOf(mathTagEndline, start);\n        var firstTagCloser = text.indexOf(tagCloser, start);\n\n        if (mathTagEndIndex !== -1) {\n          end = mathTagEndIndex;\n        } else if (mathTagEndlineIndex === firstTagCloser - 1) {\n          end = mathTagEndlineIndex;\n        }\n\n        var semanticsIndex = text.indexOf(semanticsTagStart, start);\n\n        if (semanticsIndex !== -1) {\n          var mmlTagStart = text.substring(start, semanticsIndex);\n          var annotationIndex = text.indexOf(annotationTagStart, start);\n\n          if (annotationIndex !== -1) {\n            var mmlContent = text.substring(semanticsIndex + semanticsTagStart.length, annotationIndex);\n            output += mmlTagStart + mmlContent + mathTagEnd;\n            start = text.indexOf(mathTagStart, start + mathTagStart.length);\n            end += mathTagEnd.length;\n          } else {\n            end = start;\n            start = text.indexOf(mathTagStart, start + mathTagStart.length);\n          }\n        } else {\n          end = start;\n          start = text.indexOf(mathTagStart, start + mathTagStart.length);\n        }\n      }\n\n      output += text.substring(end, text.length);\n      return output;\n    }\n    /**\r\n     * Returns true if a MathML contains a certain class.\r\n     * @param {string} mathML - input MathML.\r\n     * @param {string} className - className.\r\n     * @returns {boolean} true if the input MathML contains the input class.\r\n     * false otherwise.\r\n     * @static\r\n     */\n\n  }, {\n    key: \"containClass\",\n    value: function containClass(mathML, className) {\n      var classIndex = mathML.indexOf('class');\n\n      if (classIndex == -1) {\n        return false;\n      } else {\n        var classTagEndIndex = mathML.indexOf('>', classIndex);\n        var classTag = mathML.substring(classIndex, classTagEndIndex);\n\n        if (classTag.indexOf(className) != -1) {\n          return true;\n        } else {\n          return false;\n        }\n      }\n    }\n    /**\r\n     * Returns true if mathml is empty. Otherwise, false.\r\n     * @param {string} mathml - valid MathML with standard XML tags.\r\n     * @returns {boolean} - true if mathml is empty. Otherwise, false.\r\n     */\n\n  }, {\n    key: \"isEmpty\",\n    value: function isEmpty(mathml) {\n      // MathML can have the shape <math></math> or '<math />'.\n      var closeTag = '>';\n      var closeTagInline = '/>';\n      var firstCloseTagIndex = mathml.indexOf(closeTag);\n      var firstCloseTagInlineIndex = mathml.indexOf(closeTagInline);\n      var empty = false; // MathML is always empty in the second shape.\n\n      if (firstCloseTagInlineIndex !== -1) {\n        if (firstCloseTagInlineIndex === firstCloseTagIndex - 1) {\n          empty = true;\n        }\n      } // MathML is always empty in the first shape when there aren't elements\n      // between math tags.\n\n\n      if (!empty) {\n        var mathTagEndRegex = new RegExp('</(.+:)?math>');\n        var mathTagEndArray = mathTagEndRegex.exec(mathml);\n\n        if (mathTagEndArray) {\n          empty = firstCloseTagIndex + 1 === mathTagEndArray.index;\n        }\n      }\n\n      return empty;\n    }\n  }]);\n\n  return MathML;\n}();\n\n\n\n//# sourceURL=webpack:///./core/src/mathml.js?");

/***/ }),

/***/ "./core/src/md5.js":
/*!*************************!*\
  !*** ./core/src/md5.js ***!
  \*************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\nfunction _typeof(obj) { if (typeof Symbol === \"function\" && typeof Symbol.iterator === \"symbol\") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === \"function\" && obj.constructor === Symbol && obj !== Symbol.prototype ? \"symbol\" : typeof obj; }; } return _typeof(obj); }\n\nvar md5;\n/* harmony default export */ __webpack_exports__[\"default\"] = (md5);\n\n(function () {\n  var HxOverrides = function HxOverrides() {};\n\n  HxOverrides.__name__ = true;\n\n  HxOverrides.dateStr = function (date) {\n    var m = date.getMonth() + 1;\n    var d = date.getDate();\n    var h = date.getHours();\n    var mi = date.getMinutes();\n    var s = date.getSeconds();\n    return date.getFullYear() + \"-\" + (m < 10 ? \"0\" + m : \"\" + m) + \"-\" + (d < 10 ? \"0\" + d : \"\" + d) + \" \" + (h < 10 ? \"0\" + h : \"\" + h) + \":\" + (mi < 10 ? \"0\" + mi : \"\" + mi) + \":\" + (s < 10 ? \"0\" + s : \"\" + s);\n  };\n\n  HxOverrides.strDate = function (s) {\n    switch (s.length) {\n      case 8:\n        var k = s.split(\":\");\n        var d = new Date();\n        d.setTime(0);\n        d.setUTCHours(k[0]);\n        d.setUTCMinutes(k[1]);\n        d.setUTCSeconds(k[2]);\n        return d;\n\n      case 10:\n        var k = s.split(\"-\");\n        return new Date(k[0], k[1] - 1, k[2], 0, 0, 0);\n\n      case 19:\n        var k = s.split(\" \");\n        var y = k[0].split(\"-\");\n        var t = k[1].split(\":\");\n        return new Date(y[0], y[1] - 1, y[2], t[0], t[1], t[2]);\n\n      default:\n        throw \"Invalid date format : \" + s;\n    }\n  };\n\n  HxOverrides.cca = function (s, index) {\n    var x = s.charCodeAt(index);\n    if (x != x) return undefined;\n    return x;\n  };\n\n  HxOverrides.substr = function (s, pos, len) {\n    if (pos != null && pos != 0 && len != null && len < 0) return \"\";\n    if (len == null) len = s.length;\n\n    if (pos < 0) {\n      pos = s.length + pos;\n      if (pos < 0) pos = 0;\n    } else if (len < 0) len = s.length + len - pos;\n\n    return s.substr(pos, len);\n  };\n\n  HxOverrides.remove = function (a, obj) {\n    var i = 0;\n    var l = a.length;\n\n    while (i < l) {\n      if (a[i] == obj) {\n        a.splice(i, 1);\n        return true;\n      }\n\n      i++;\n    }\n\n    return false;\n  };\n\n  HxOverrides.iter = function (a) {\n    return {\n      cur: 0,\n      arr: a,\n      hasNext: function hasNext() {\n        return this.cur < this.arr.length;\n      },\n      next: function next() {\n        return this.arr[this.cur++];\n      }\n    };\n  };\n\n  var IntIter = function IntIter(min, max) {\n    this.min = min;\n    this.max = max;\n  };\n\n  IntIter.__name__ = true;\n  IntIter.prototype = {\n    next: function next() {\n      return this.min++;\n    },\n    hasNext: function hasNext() {\n      return this.min < this.max;\n    },\n    __class__: IntIter\n  };\n\n  var Std = function Std() {};\n\n  Std.__name__ = true;\n\n  Std[\"is\"] = function (v, t) {\n    return js.Boot.__instanceof(v, t);\n  };\n\n  Std.string = function (s) {\n    return js.Boot.__string_rec(s, \"\");\n  };\n\n  Std[\"int\"] = function (x) {\n    return x | 0;\n  };\n\n  Std.parseInt = function (x) {\n    var v = parseInt(x, 10);\n    if (v == 0 && (HxOverrides.cca(x, 1) == 120 || HxOverrides.cca(x, 1) == 88)) v = parseInt(x);\n    if (isNaN(v)) return null;\n    return v;\n  };\n\n  Std.parseFloat = function (x) {\n    return parseFloat(x);\n  };\n\n  Std.random = function (x) {\n    return Math.floor(Math.random() * x);\n  };\n\n  var com = com || {};\n  if (!com.wiris) com.wiris = {};\n  if (!com.wiris.js) com.wiris.js = {};\n\n  com.wiris.js.JsPluginTools = function () {\n    this.tryReady();\n  };\n\n  com.wiris.js.JsPluginTools.__name__ = true;\n\n  com.wiris.js.JsPluginTools.main = function () {\n    var ev;\n    ev = com.wiris.js.JsPluginTools.getInstance();\n    haxe.Timer.delay($bind(ev, ev.tryReady), 100);\n  };\n\n  com.wiris.js.JsPluginTools.getInstance = function () {\n    if (com.wiris.js.JsPluginTools.instance == null) com.wiris.js.JsPluginTools.instance = new com.wiris.js.JsPluginTools();\n    return com.wiris.js.JsPluginTools.instance;\n  };\n\n  com.wiris.js.JsPluginTools.bypassEncapsulation = function () {\n    if (window.com == null) window.com = {};\n    if (window.com.wiris == null) window.com.wiris = {};\n    if (window.com.wiris.js == null) window.com.wiris.js = {};\n    if (window.com.wiris.js.JsPluginTools == null) window.com.wiris.js.JsPluginTools = com.wiris.js.JsPluginTools.getInstance();\n  };\n\n  com.wiris.js.JsPluginTools.prototype = {\n    md5encode: function md5encode(content) {\n      return haxe.Md5.encode(content);\n    },\n    doLoad: function doLoad() {\n      this.ready = true;\n      com.wiris.js.JsPluginTools.instance = this;\n      com.wiris.js.JsPluginTools.bypassEncapsulation();\n    },\n    tryReady: function tryReady() {\n      this.ready = false;\n\n      if (js.Lib.document.readyState) {\n        this.doLoad();\n        this.ready = true;\n      }\n\n      if (!this.ready) haxe.Timer.delay($bind(this, this.tryReady), 100);\n    },\n    __class__: com.wiris.js.JsPluginTools\n  };\n  var haxe = haxe || {};\n\n  haxe.Log = function () {};\n\n  haxe.Log.__name__ = true;\n\n  haxe.Log.trace = function (v, infos) {\n    js.Boot.__trace(v, infos);\n  };\n\n  haxe.Log.clear = function () {\n    js.Boot.__clear_trace();\n  };\n\n  haxe.Md5 = function () {};\n\n  haxe.Md5.__name__ = true;\n\n  haxe.Md5.encode = function (s) {\n    return new haxe.Md5().doEncode(s);\n  };\n\n  haxe.Md5.prototype = {\n    doEncode: function doEncode(str) {\n      var x = this.str2blks(str);\n      var a = 1732584193;\n      var b = -271733879;\n      var c = -1732584194;\n      var d = 271733878;\n      var step;\n      var i = 0;\n\n      while (i < x.length) {\n        var olda = a;\n        var oldb = b;\n        var oldc = c;\n        var oldd = d;\n        step = 0;\n        a = this.ff(a, b, c, d, x[i], 7, -680876936);\n        d = this.ff(d, a, b, c, x[i + 1], 12, -389564586);\n        c = this.ff(c, d, a, b, x[i + 2], 17, 606105819);\n        b = this.ff(b, c, d, a, x[i + 3], 22, -1044525330);\n        a = this.ff(a, b, c, d, x[i + 4], 7, -176418897);\n        d = this.ff(d, a, b, c, x[i + 5], 12, 1200080426);\n        c = this.ff(c, d, a, b, x[i + 6], 17, -1473231341);\n        b = this.ff(b, c, d, a, x[i + 7], 22, -45705983);\n        a = this.ff(a, b, c, d, x[i + 8], 7, 1770035416);\n        d = this.ff(d, a, b, c, x[i + 9], 12, -1958414417);\n        c = this.ff(c, d, a, b, x[i + 10], 17, -42063);\n        b = this.ff(b, c, d, a, x[i + 11], 22, -1990404162);\n        a = this.ff(a, b, c, d, x[i + 12], 7, 1804603682);\n        d = this.ff(d, a, b, c, x[i + 13], 12, -40341101);\n        c = this.ff(c, d, a, b, x[i + 14], 17, -1502002290);\n        b = this.ff(b, c, d, a, x[i + 15], 22, 1236535329);\n        a = this.gg(a, b, c, d, x[i + 1], 5, -165796510);\n        d = this.gg(d, a, b, c, x[i + 6], 9, -1069501632);\n        c = this.gg(c, d, a, b, x[i + 11], 14, 643717713);\n        b = this.gg(b, c, d, a, x[i], 20, -373897302);\n        a = this.gg(a, b, c, d, x[i + 5], 5, -701558691);\n        d = this.gg(d, a, b, c, x[i + 10], 9, 38016083);\n        c = this.gg(c, d, a, b, x[i + 15], 14, -660478335);\n        b = this.gg(b, c, d, a, x[i + 4], 20, -405537848);\n        a = this.gg(a, b, c, d, x[i + 9], 5, 568446438);\n        d = this.gg(d, a, b, c, x[i + 14], 9, -1019803690);\n        c = this.gg(c, d, a, b, x[i + 3], 14, -187363961);\n        b = this.gg(b, c, d, a, x[i + 8], 20, 1163531501);\n        a = this.gg(a, b, c, d, x[i + 13], 5, -1444681467);\n        d = this.gg(d, a, b, c, x[i + 2], 9, -51403784);\n        c = this.gg(c, d, a, b, x[i + 7], 14, 1735328473);\n        b = this.gg(b, c, d, a, x[i + 12], 20, -1926607734);\n        a = this.hh(a, b, c, d, x[i + 5], 4, -378558);\n        d = this.hh(d, a, b, c, x[i + 8], 11, -2022574463);\n        c = this.hh(c, d, a, b, x[i + 11], 16, 1839030562);\n        b = this.hh(b, c, d, a, x[i + 14], 23, -35309556);\n        a = this.hh(a, b, c, d, x[i + 1], 4, -1530992060);\n        d = this.hh(d, a, b, c, x[i + 4], 11, 1272893353);\n        c = this.hh(c, d, a, b, x[i + 7], 16, -155497632);\n        b = this.hh(b, c, d, a, x[i + 10], 23, -1094730640);\n        a = this.hh(a, b, c, d, x[i + 13], 4, 681279174);\n        d = this.hh(d, a, b, c, x[i], 11, -358537222);\n        c = this.hh(c, d, a, b, x[i + 3], 16, -722521979);\n        b = this.hh(b, c, d, a, x[i + 6], 23, 76029189);\n        a = this.hh(a, b, c, d, x[i + 9], 4, -640364487);\n        d = this.hh(d, a, b, c, x[i + 12], 11, -421815835);\n        c = this.hh(c, d, a, b, x[i + 15], 16, 530742520);\n        b = this.hh(b, c, d, a, x[i + 2], 23, -995338651);\n        a = this.ii(a, b, c, d, x[i], 6, -198630844);\n        d = this.ii(d, a, b, c, x[i + 7], 10, 1126891415);\n        c = this.ii(c, d, a, b, x[i + 14], 15, -1416354905);\n        b = this.ii(b, c, d, a, x[i + 5], 21, -57434055);\n        a = this.ii(a, b, c, d, x[i + 12], 6, 1700485571);\n        d = this.ii(d, a, b, c, x[i + 3], 10, -1894986606);\n        c = this.ii(c, d, a, b, x[i + 10], 15, -1051523);\n        b = this.ii(b, c, d, a, x[i + 1], 21, -2054922799);\n        a = this.ii(a, b, c, d, x[i + 8], 6, 1873313359);\n        d = this.ii(d, a, b, c, x[i + 15], 10, -30611744);\n        c = this.ii(c, d, a, b, x[i + 6], 15, -1560198380);\n        b = this.ii(b, c, d, a, x[i + 13], 21, 1309151649);\n        a = this.ii(a, b, c, d, x[i + 4], 6, -145523070);\n        d = this.ii(d, a, b, c, x[i + 11], 10, -1120210379);\n        c = this.ii(c, d, a, b, x[i + 2], 15, 718787259);\n        b = this.ii(b, c, d, a, x[i + 9], 21, -343485551);\n        a = this.addme(a, olda);\n        b = this.addme(b, oldb);\n        c = this.addme(c, oldc);\n        d = this.addme(d, oldd);\n        i += 16;\n      }\n\n      return this.rhex(a) + this.rhex(b) + this.rhex(c) + this.rhex(d);\n    },\n    ii: function ii(a, b, c, d, x, s, t) {\n      return this.cmn(this.bitXOR(c, this.bitOR(b, ~d)), a, b, x, s, t);\n    },\n    hh: function hh(a, b, c, d, x, s, t) {\n      return this.cmn(this.bitXOR(this.bitXOR(b, c), d), a, b, x, s, t);\n    },\n    gg: function gg(a, b, c, d, x, s, t) {\n      return this.cmn(this.bitOR(this.bitAND(b, d), this.bitAND(c, ~d)), a, b, x, s, t);\n    },\n    ff: function ff(a, b, c, d, x, s, t) {\n      return this.cmn(this.bitOR(this.bitAND(b, c), this.bitAND(~b, d)), a, b, x, s, t);\n    },\n    cmn: function cmn(q, a, b, x, s, t) {\n      return this.addme(this.rol(this.addme(this.addme(a, q), this.addme(x, t)), s), b);\n    },\n    rol: function rol(num, cnt) {\n      return num << cnt | num >>> 32 - cnt;\n    },\n    str2blks: function str2blks(str) {\n      var nblk = (str.length + 8 >> 6) + 1;\n      var blks = new Array();\n\n      var _g1 = 0,\n          _g = nblk * 16;\n\n      while (_g1 < _g) {\n        var i = _g1++;\n        blks[i] = 0;\n      }\n\n      var i = 0;\n\n      while (i < str.length) {\n        blks[i >> 2] |= HxOverrides.cca(str, i) << (str.length * 8 + i) % 4 * 8;\n        i++;\n      }\n\n      blks[i >> 2] |= 128 << (str.length * 8 + i) % 4 * 8;\n      var l = str.length * 8;\n      var k = nblk * 16 - 2;\n      blks[k] = l & 255;\n      blks[k] |= (l >>> 8 & 255) << 8;\n      blks[k] |= (l >>> 16 & 255) << 16;\n      blks[k] |= (l >>> 24 & 255) << 24;\n      return blks;\n    },\n    rhex: function rhex(num) {\n      var str = \"\";\n      var hex_chr = \"0123456789abcdef\";\n      var _g = 0;\n\n      while (_g < 4) {\n        var j = _g++;\n        str += hex_chr.charAt(num >> j * 8 + 4 & 15) + hex_chr.charAt(num >> j * 8 & 15);\n      }\n\n      return str;\n    },\n    addme: function addme(x, y) {\n      var lsw = (x & 65535) + (y & 65535);\n      var msw = (x >> 16) + (y >> 16) + (lsw >> 16);\n      return msw << 16 | lsw & 65535;\n    },\n    bitAND: function bitAND(a, b) {\n      var lsb = a & 1 & (b & 1);\n      var msb31 = a >>> 1 & b >>> 1;\n      return msb31 << 1 | lsb;\n    },\n    bitXOR: function bitXOR(a, b) {\n      var lsb = a & 1 ^ b & 1;\n      var msb31 = a >>> 1 ^ b >>> 1;\n      return msb31 << 1 | lsb;\n    },\n    bitOR: function bitOR(a, b) {\n      var lsb = a & 1 | b & 1;\n      var msb31 = a >>> 1 | b >>> 1;\n      return msb31 << 1 | lsb;\n    },\n    __class__: haxe.Md5\n  };\n\n  haxe.Timer = function (time_ms) {\n    var me = this;\n    this.id = window.setInterval(function () {\n      me.run();\n    }, time_ms);\n  };\n\n  haxe.Timer.__name__ = true;\n\n  haxe.Timer.delay = function (f, time_ms) {\n    var t = new haxe.Timer(time_ms);\n\n    t.run = function () {\n      t.stop();\n      f();\n    };\n\n    return t;\n  };\n\n  haxe.Timer.measure = function (f, pos) {\n    var t0 = haxe.Timer.stamp();\n    var r = f();\n    haxe.Log.trace(haxe.Timer.stamp() - t0 + \"s\", pos);\n    return r;\n  };\n\n  haxe.Timer.stamp = function () {\n    return new Date().getTime() / 1000;\n  };\n\n  haxe.Timer.prototype = {\n    run: function run() {},\n    stop: function stop() {\n      if (this.id == null) return;\n      window.clearInterval(this.id);\n      this.id = null;\n    },\n    __class__: haxe.Timer\n  };\n  var js = js || {};\n\n  js.Boot = function () {};\n\n  js.Boot.__name__ = true;\n\n  js.Boot.__unhtml = function (s) {\n    return s.split(\"&\").join(\"&amp;\").split(\"<\").join(\"&lt;\").split(\">\").join(\"&gt;\");\n  };\n\n  js.Boot.__trace = function (v, i) {\n    var msg = i != null ? i.fileName + \":\" + i.lineNumber + \": \" : \"\";\n    msg += js.Boot.__string_rec(v, \"\");\n    var d;\n    if (typeof document != \"undefined\" && (d = document.getElementById(\"haxe:trace\")) != null) d.innerHTML += js.Boot.__unhtml(msg) + \"<br/>\";else if (typeof console != \"undefined\" && console.log != null) console.log(msg);\n  };\n\n  js.Boot.__clear_trace = function () {\n    var d = document.getElementById(\"haxe:trace\");\n    if (d != null) d.innerHTML = \"\";\n  };\n\n  js.Boot.isClass = function (o) {\n    return o.__name__;\n  };\n\n  js.Boot.isEnum = function (e) {\n    return e.__ename__;\n  };\n\n  js.Boot.getClass = function (o) {\n    return o.__class__;\n  };\n\n  js.Boot.__string_rec = function (o, s) {\n    if (o == null) return \"null\";\n    if (s.length >= 5) return \"<...>\";\n\n    var t = _typeof(o);\n\n    if (t == \"function\" && (o.__name__ || o.__ename__)) t = \"object\";\n\n    switch (t) {\n      case \"object\":\n        if (o instanceof Array) {\n          if (o.__enum__) {\n            if (o.length == 2) return o[0];\n            var str = o[0] + \"(\";\n            s += \"\\t\";\n            var _g1 = 2,\n                _g = o.length;\n\n            while (_g1 < _g) {\n              var i = _g1++;\n              if (i != 2) str += \",\" + js.Boot.__string_rec(o[i], s);else str += js.Boot.__string_rec(o[i], s);\n            }\n\n            return str + \")\";\n          }\n\n          var l = o.length;\n          var i;\n          var str = \"[\";\n          s += \"\\t\";\n          var _g = 0;\n\n          while (_g < l) {\n            var i1 = _g++;\n            str += (i1 > 0 ? \",\" : \"\") + js.Boot.__string_rec(o[i1], s);\n          }\n\n          str += \"]\";\n          return str;\n        }\n\n        var tostr;\n\n        try {\n          tostr = o.toString;\n        } catch (e) {\n          return \"???\";\n        }\n\n        if (tostr != null && tostr != Object.toString) {\n          var s2 = o.toString();\n          if (s2 != \"[object Object]\") return s2;\n        }\n\n        var k = null;\n        var str = \"{\\n\";\n        s += \"\\t\";\n        var hasp = o.hasOwnProperty != null;\n\n        for (var k in o) {\n          ;\n\n          if (hasp && !o.hasOwnProperty(k)) {\n            continue;\n          }\n\n          if (k == \"prototype\" || k == \"__class__\" || k == \"__super__\" || k == \"__interfaces__\" || k == \"__properties__\") {\n            continue;\n          }\n\n          if (str.length != 2) str += \", \\n\";\n          str += s + k + \" : \" + js.Boot.__string_rec(o[k], s);\n        }\n\n        s = s.substring(1);\n        str += \"\\n\" + s + \"}\";\n        return str;\n\n      case \"function\":\n        return \"<function>\";\n\n      case \"string\":\n        return o;\n\n      default:\n        return String(o);\n    }\n  };\n\n  js.Boot.__interfLoop = function (cc, cl) {\n    if (cc == null) return false;\n    if (cc == cl) return true;\n    var intf = cc.__interfaces__;\n\n    if (intf != null) {\n      var _g1 = 0,\n          _g = intf.length;\n\n      while (_g1 < _g) {\n        var i = _g1++;\n        var i1 = intf[i];\n        if (i1 == cl || js.Boot.__interfLoop(i1, cl)) return true;\n      }\n    }\n\n    return js.Boot.__interfLoop(cc.__super__, cl);\n  };\n\n  js.Boot.__instanceof = function (o, cl) {\n    try {\n      if (o instanceof cl) {\n        if (cl == Array) return o.__enum__ == null;\n        return true;\n      }\n\n      if (js.Boot.__interfLoop(o.__class__, cl)) return true;\n    } catch (e) {\n      if (cl == null) return false;\n    }\n\n    switch (cl) {\n      case Int:\n        return Math.ceil(o % 2147483648.0) === o;\n\n      case Float:\n        return typeof o == \"number\";\n\n      case Bool:\n        return o === true || o === false;\n\n      case String:\n        return typeof o == \"string\";\n\n      case Dynamic:\n        return true;\n\n      default:\n        if (o == null) return false;\n        if (cl == Class && o.__name__ != null) return true;else null;\n        if (cl == Enum && o.__ename__ != null) return true;else null;\n        return o.__enum__ == cl;\n    }\n  };\n\n  js.Boot.__cast = function (o, t) {\n    if (js.Boot.__instanceof(o, t)) return o;else throw \"Cannot cast \" + Std.string(o) + \" to \" + Std.string(t);\n  };\n\n  js.Lib = function () {};\n\n  js.Lib.__name__ = true;\n\n  js.Lib.debug = function () {\n    debugger;\n  };\n\n  js.Lib.alert = function (v) {\n    alert(js.Boot.__string_rec(v, \"\"));\n  };\n\n  js.Lib.eval = function (code) {\n    return eval(code);\n  };\n\n  js.Lib.setErrorHandler = function (f) {\n    js.Lib.onerror = f;\n  };\n\n  var $_;\n\n  function $bind(o, m) {\n    var f = function f() {\n      return f.method.apply(f.scope, arguments);\n    };\n\n    f.scope = o;\n    f.method = m;\n    return f;\n  }\n\n  ;\n  if (Array.prototype.indexOf) HxOverrides.remove = function (a, o) {\n    var i = a.indexOf(o);\n    if (i == -1) return false;\n    a.splice(i, 1);\n    return true;\n  };else null;\n  Math.__name__ = [\"Math\"];\n  Math.NaN = Number.NaN;\n  Math.NEGATIVE_INFINITY = Number.NEGATIVE_INFINITY;\n  Math.POSITIVE_INFINITY = Number.POSITIVE_INFINITY;\n\n  Math.isFinite = function (i) {\n    return isFinite(i);\n  };\n\n  Math.isNaN = function (i) {\n    return isNaN(i);\n  };\n\n  String.prototype.__class__ = String;\n  String.__name__ = true;\n  Array.prototype.__class__ = Array;\n  Array.__name__ = true;\n  Date.prototype.__class__ = Date;\n  Date.__name__ = [\"Date\"];\n  var Int = {\n    __name__: [\"Int\"]\n  };\n  var Dynamic = {\n    __name__: [\"Dynamic\"]\n  };\n  var Float = Number;\n  Float.__name__ = [\"Float\"];\n  var Bool = Boolean;\n  Bool.__ename__ = [\"Bool\"];\n  var Class = {\n    __name__: [\"Class\"]\n  };\n  var Enum = {};\n  var Void = {\n    __ename__: [\"Void\"]\n  };\n  if (typeof document != \"undefined\") js.Lib.document = document;\n\n  if (typeof window != \"undefined\") {\n    js.Lib.window = window;\n\n    js.Lib.window.onerror = function (msg, url, line) {\n      var f = js.Lib.onerror;\n      if (f == null) return false;\n      return f(msg, [url + \":\" + line]);\n    };\n  }\n\n  com.wiris.js.JsPluginTools.main();\n  delete Array.prototype.__class__;\n})();\n\n(function () {\n  var HxOverrides = function HxOverrides() {};\n\n  HxOverrides.__name__ = true;\n\n  HxOverrides.dateStr = function (date) {\n    var m = date.getMonth() + 1;\n    var d = date.getDate();\n    var h = date.getHours();\n    var mi = date.getMinutes();\n    var s = date.getSeconds();\n    return date.getFullYear() + \"-\" + (m < 10 ? \"0\" + m : \"\" + m) + \"-\" + (d < 10 ? \"0\" + d : \"\" + d) + \" \" + (h < 10 ? \"0\" + h : \"\" + h) + \":\" + (mi < 10 ? \"0\" + mi : \"\" + mi) + \":\" + (s < 10 ? \"0\" + s : \"\" + s);\n  };\n\n  HxOverrides.strDate = function (s) {\n    switch (s.length) {\n      case 8:\n        var k = s.split(\":\");\n        var d = new Date();\n        d.setTime(0);\n        d.setUTCHours(k[0]);\n        d.setUTCMinutes(k[1]);\n        d.setUTCSeconds(k[2]);\n        return d;\n\n      case 10:\n        var k = s.split(\"-\");\n        return new Date(k[0], k[1] - 1, k[2], 0, 0, 0);\n\n      case 19:\n        var k = s.split(\" \");\n        var y = k[0].split(\"-\");\n        var t = k[1].split(\":\");\n        return new Date(y[0], y[1] - 1, y[2], t[0], t[1], t[2]);\n\n      default:\n        throw \"Invalid date format : \" + s;\n    }\n  };\n\n  HxOverrides.cca = function (s, index) {\n    var x = s.charCodeAt(index);\n    if (x != x) return undefined;\n    return x;\n  };\n\n  HxOverrides.substr = function (s, pos, len) {\n    if (pos != null && pos != 0 && len != null && len < 0) return \"\";\n    if (len == null) len = s.length;\n\n    if (pos < 0) {\n      pos = s.length + pos;\n      if (pos < 0) pos = 0;\n    } else if (len < 0) len = s.length + len - pos;\n\n    return s.substr(pos, len);\n  };\n\n  HxOverrides.remove = function (a, obj) {\n    var i = 0;\n    var l = a.length;\n\n    while (i < l) {\n      if (a[i] == obj) {\n        a.splice(i, 1);\n        return true;\n      }\n\n      i++;\n    }\n\n    return false;\n  };\n\n  HxOverrides.iter = function (a) {\n    return {\n      cur: 0,\n      arr: a,\n      hasNext: function hasNext() {\n        return this.cur < this.arr.length;\n      },\n      next: function next() {\n        return this.arr[this.cur++];\n      }\n    };\n  };\n\n  var IntIter = function IntIter(min, max) {\n    this.min = min;\n    this.max = max;\n  };\n\n  IntIter.__name__ = true;\n  IntIter.prototype = {\n    next: function next() {\n      return this.min++;\n    },\n    hasNext: function hasNext() {\n      return this.min < this.max;\n    },\n    __class__: IntIter\n  };\n\n  var Std = function Std() {};\n\n  Std.__name__ = true;\n\n  Std[\"is\"] = function (v, t) {\n    return js.Boot.__instanceof(v, t);\n  };\n\n  Std.string = function (s) {\n    return js.Boot.__string_rec(s, \"\");\n  };\n\n  Std[\"int\"] = function (x) {\n    return x | 0;\n  };\n\n  Std.parseInt = function (x) {\n    var v = parseInt(x, 10);\n    if (v == 0 && (HxOverrides.cca(x, 1) == 120 || HxOverrides.cca(x, 1) == 88)) v = parseInt(x);\n    if (isNaN(v)) return null;\n    return v;\n  };\n\n  Std.parseFloat = function (x) {\n    return parseFloat(x);\n  };\n\n  Std.random = function (x) {\n    return Math.floor(Math.random() * x);\n  };\n\n  var com = com || {};\n  if (!com.wiris) com.wiris = {};\n  if (!com.wiris.js) com.wiris.js = {};\n\n  com.wiris.js.JsPluginTools = function () {\n    this.tryReady();\n  };\n\n  com.wiris.js.JsPluginTools.__name__ = true;\n\n  com.wiris.js.JsPluginTools.main = function () {\n    var ev;\n    ev = com.wiris.js.JsPluginTools.getInstance();\n    haxe.Timer.delay($bind(ev, ev.tryReady), 100);\n  };\n\n  com.wiris.js.JsPluginTools.getInstance = function () {\n    if (com.wiris.js.JsPluginTools.instance == null) com.wiris.js.JsPluginTools.instance = new com.wiris.js.JsPluginTools();\n    return com.wiris.js.JsPluginTools.instance;\n  };\n\n  com.wiris.js.JsPluginTools.bypassEncapsulation = function () {\n    if (window.com == null) window.com = {};\n    if (window.com.wiris == null) window.com.wiris = {};\n    if (window.com.wiris.js == null) window.com.wiris.js = {};\n    if (window.com.wiris.js.JsPluginTools == null) window.com.wiris.js.JsPluginTools = com.wiris.js.JsPluginTools.getInstance();\n  };\n\n  com.wiris.js.JsPluginTools.prototype = {\n    md5encode: function md5encode(content) {\n      return haxe.Md5.encode(content);\n    },\n    doLoad: function doLoad() {\n      this.ready = true;\n      com.wiris.js.JsPluginTools.instance = this;\n      com.wiris.js.JsPluginTools.bypassEncapsulation();\n    },\n    tryReady: function tryReady() {\n      this.ready = false;\n\n      if (js.Lib.document.readyState) {\n        this.doLoad();\n        this.ready = true;\n      }\n\n      if (!this.ready) haxe.Timer.delay($bind(this, this.tryReady), 100);\n    },\n    __class__: com.wiris.js.JsPluginTools\n  };\n  var haxe = haxe || {};\n\n  haxe.Log = function () {};\n\n  haxe.Log.__name__ = true;\n\n  haxe.Log.trace = function (v, infos) {\n    js.Boot.__trace(v, infos);\n  };\n\n  haxe.Log.clear = function () {\n    js.Boot.__clear_trace();\n  };\n\n  haxe.Md5 = function () {};\n\n  haxe.Md5.__name__ = true;\n\n  haxe.Md5.encode = function (s) {\n    return new haxe.Md5().doEncode(s);\n  };\n\n  haxe.Md5.prototype = {\n    doEncode: function doEncode(str) {\n      var x = this.str2blks(str);\n      var a = 1732584193;\n      var b = -271733879;\n      var c = -1732584194;\n      var d = 271733878;\n      var step;\n      var i = 0;\n\n      while (i < x.length) {\n        var olda = a;\n        var oldb = b;\n        var oldc = c;\n        var oldd = d;\n        step = 0;\n        a = this.ff(a, b, c, d, x[i], 7, -680876936);\n        d = this.ff(d, a, b, c, x[i + 1], 12, -389564586);\n        c = this.ff(c, d, a, b, x[i + 2], 17, 606105819);\n        b = this.ff(b, c, d, a, x[i + 3], 22, -1044525330);\n        a = this.ff(a, b, c, d, x[i + 4], 7, -176418897);\n        d = this.ff(d, a, b, c, x[i + 5], 12, 1200080426);\n        c = this.ff(c, d, a, b, x[i + 6], 17, -1473231341);\n        b = this.ff(b, c, d, a, x[i + 7], 22, -45705983);\n        a = this.ff(a, b, c, d, x[i + 8], 7, 1770035416);\n        d = this.ff(d, a, b, c, x[i + 9], 12, -1958414417);\n        c = this.ff(c, d, a, b, x[i + 10], 17, -42063);\n        b = this.ff(b, c, d, a, x[i + 11], 22, -1990404162);\n        a = this.ff(a, b, c, d, x[i + 12], 7, 1804603682);\n        d = this.ff(d, a, b, c, x[i + 13], 12, -40341101);\n        c = this.ff(c, d, a, b, x[i + 14], 17, -1502002290);\n        b = this.ff(b, c, d, a, x[i + 15], 22, 1236535329);\n        a = this.gg(a, b, c, d, x[i + 1], 5, -165796510);\n        d = this.gg(d, a, b, c, x[i + 6], 9, -1069501632);\n        c = this.gg(c, d, a, b, x[i + 11], 14, 643717713);\n        b = this.gg(b, c, d, a, x[i], 20, -373897302);\n        a = this.gg(a, b, c, d, x[i + 5], 5, -701558691);\n        d = this.gg(d, a, b, c, x[i + 10], 9, 38016083);\n        c = this.gg(c, d, a, b, x[i + 15], 14, -660478335);\n        b = this.gg(b, c, d, a, x[i + 4], 20, -405537848);\n        a = this.gg(a, b, c, d, x[i + 9], 5, 568446438);\n        d = this.gg(d, a, b, c, x[i + 14], 9, -1019803690);\n        c = this.gg(c, d, a, b, x[i + 3], 14, -187363961);\n        b = this.gg(b, c, d, a, x[i + 8], 20, 1163531501);\n        a = this.gg(a, b, c, d, x[i + 13], 5, -1444681467);\n        d = this.gg(d, a, b, c, x[i + 2], 9, -51403784);\n        c = this.gg(c, d, a, b, x[i + 7], 14, 1735328473);\n        b = this.gg(b, c, d, a, x[i + 12], 20, -1926607734);\n        a = this.hh(a, b, c, d, x[i + 5], 4, -378558);\n        d = this.hh(d, a, b, c, x[i + 8], 11, -2022574463);\n        c = this.hh(c, d, a, b, x[i + 11], 16, 1839030562);\n        b = this.hh(b, c, d, a, x[i + 14], 23, -35309556);\n        a = this.hh(a, b, c, d, x[i + 1], 4, -1530992060);\n        d = this.hh(d, a, b, c, x[i + 4], 11, 1272893353);\n        c = this.hh(c, d, a, b, x[i + 7], 16, -155497632);\n        b = this.hh(b, c, d, a, x[i + 10], 23, -1094730640);\n        a = this.hh(a, b, c, d, x[i + 13], 4, 681279174);\n        d = this.hh(d, a, b, c, x[i], 11, -358537222);\n        c = this.hh(c, d, a, b, x[i + 3], 16, -722521979);\n        b = this.hh(b, c, d, a, x[i + 6], 23, 76029189);\n        a = this.hh(a, b, c, d, x[i + 9], 4, -640364487);\n        d = this.hh(d, a, b, c, x[i + 12], 11, -421815835);\n        c = this.hh(c, d, a, b, x[i + 15], 16, 530742520);\n        b = this.hh(b, c, d, a, x[i + 2], 23, -995338651);\n        a = this.ii(a, b, c, d, x[i], 6, -198630844);\n        d = this.ii(d, a, b, c, x[i + 7], 10, 1126891415);\n        c = this.ii(c, d, a, b, x[i + 14], 15, -1416354905);\n        b = this.ii(b, c, d, a, x[i + 5], 21, -57434055);\n        a = this.ii(a, b, c, d, x[i + 12], 6, 1700485571);\n        d = this.ii(d, a, b, c, x[i + 3], 10, -1894986606);\n        c = this.ii(c, d, a, b, x[i + 10], 15, -1051523);\n        b = this.ii(b, c, d, a, x[i + 1], 21, -2054922799);\n        a = this.ii(a, b, c, d, x[i + 8], 6, 1873313359);\n        d = this.ii(d, a, b, c, x[i + 15], 10, -30611744);\n        c = this.ii(c, d, a, b, x[i + 6], 15, -1560198380);\n        b = this.ii(b, c, d, a, x[i + 13], 21, 1309151649);\n        a = this.ii(a, b, c, d, x[i + 4], 6, -145523070);\n        d = this.ii(d, a, b, c, x[i + 11], 10, -1120210379);\n        c = this.ii(c, d, a, b, x[i + 2], 15, 718787259);\n        b = this.ii(b, c, d, a, x[i + 9], 21, -343485551);\n        a = this.addme(a, olda);\n        b = this.addme(b, oldb);\n        c = this.addme(c, oldc);\n        d = this.addme(d, oldd);\n        i += 16;\n      }\n\n      return this.rhex(a) + this.rhex(b) + this.rhex(c) + this.rhex(d);\n    },\n    ii: function ii(a, b, c, d, x, s, t) {\n      return this.cmn(this.bitXOR(c, this.bitOR(b, ~d)), a, b, x, s, t);\n    },\n    hh: function hh(a, b, c, d, x, s, t) {\n      return this.cmn(this.bitXOR(this.bitXOR(b, c), d), a, b, x, s, t);\n    },\n    gg: function gg(a, b, c, d, x, s, t) {\n      return this.cmn(this.bitOR(this.bitAND(b, d), this.bitAND(c, ~d)), a, b, x, s, t);\n    },\n    ff: function ff(a, b, c, d, x, s, t) {\n      return this.cmn(this.bitOR(this.bitAND(b, c), this.bitAND(~b, d)), a, b, x, s, t);\n    },\n    cmn: function cmn(q, a, b, x, s, t) {\n      return this.addme(this.rol(this.addme(this.addme(a, q), this.addme(x, t)), s), b);\n    },\n    rol: function rol(num, cnt) {\n      return num << cnt | num >>> 32 - cnt;\n    },\n    str2blks: function str2blks(str) {\n      var nblk = (str.length + 8 >> 6) + 1;\n      var blks = new Array();\n\n      var _g1 = 0,\n          _g = nblk * 16;\n\n      while (_g1 < _g) {\n        var i = _g1++;\n        blks[i] = 0;\n      }\n\n      var i = 0;\n\n      while (i < str.length) {\n        blks[i >> 2] |= HxOverrides.cca(str, i) << (str.length * 8 + i) % 4 * 8;\n        i++;\n      }\n\n      blks[i >> 2] |= 128 << (str.length * 8 + i) % 4 * 8;\n      var l = str.length * 8;\n      var k = nblk * 16 - 2;\n      blks[k] = l & 255;\n      blks[k] |= (l >>> 8 & 255) << 8;\n      blks[k] |= (l >>> 16 & 255) << 16;\n      blks[k] |= (l >>> 24 & 255) << 24;\n      return blks;\n    },\n    rhex: function rhex(num) {\n      var str = \"\";\n      var hex_chr = \"0123456789abcdef\";\n      var _g = 0;\n\n      while (_g < 4) {\n        var j = _g++;\n        str += hex_chr.charAt(num >> j * 8 + 4 & 15) + hex_chr.charAt(num >> j * 8 & 15);\n      }\n\n      return str;\n    },\n    addme: function addme(x, y) {\n      var lsw = (x & 65535) + (y & 65535);\n      var msw = (x >> 16) + (y >> 16) + (lsw >> 16);\n      return msw << 16 | lsw & 65535;\n    },\n    bitAND: function bitAND(a, b) {\n      var lsb = a & 1 & (b & 1);\n      var msb31 = a >>> 1 & b >>> 1;\n      return msb31 << 1 | lsb;\n    },\n    bitXOR: function bitXOR(a, b) {\n      var lsb = a & 1 ^ b & 1;\n      var msb31 = a >>> 1 ^ b >>> 1;\n      return msb31 << 1 | lsb;\n    },\n    bitOR: function bitOR(a, b) {\n      var lsb = a & 1 | b & 1;\n      var msb31 = a >>> 1 | b >>> 1;\n      return msb31 << 1 | lsb;\n    },\n    __class__: haxe.Md5\n  };\n\n  haxe.Timer = function (time_ms) {\n    var me = this;\n    this.id = window.setInterval(function () {\n      me.run();\n    }, time_ms);\n  };\n\n  haxe.Timer.__name__ = true;\n\n  haxe.Timer.delay = function (f, time_ms) {\n    var t = new haxe.Timer(time_ms);\n\n    t.run = function () {\n      t.stop();\n      f();\n    };\n\n    return t;\n  };\n\n  haxe.Timer.measure = function (f, pos) {\n    var t0 = haxe.Timer.stamp();\n    var r = f();\n    haxe.Log.trace(haxe.Timer.stamp() - t0 + \"s\", pos);\n    return r;\n  };\n\n  haxe.Timer.stamp = function () {\n    return new Date().getTime() / 1000;\n  };\n\n  haxe.Timer.prototype = {\n    run: function run() {},\n    stop: function stop() {\n      if (this.id == null) return;\n      window.clearInterval(this.id);\n      this.id = null;\n    },\n    __class__: haxe.Timer\n  };\n  var js = js || {};\n\n  js.Boot = function () {};\n\n  js.Boot.__name__ = true;\n\n  js.Boot.__unhtml = function (s) {\n    return s.split(\"&\").join(\"&amp;\").split(\"<\").join(\"&lt;\").split(\">\").join(\"&gt;\");\n  };\n\n  js.Boot.__trace = function (v, i) {\n    var msg = i != null ? i.fileName + \":\" + i.lineNumber + \": \" : \"\";\n    msg += js.Boot.__string_rec(v, \"\");\n    var d;\n    if (typeof document != \"undefined\" && (d = document.getElementById(\"haxe:trace\")) != null) d.innerHTML += js.Boot.__unhtml(msg) + \"<br/>\";else if (typeof console != \"undefined\" && console.log != null) console.log(msg);\n  };\n\n  js.Boot.__clear_trace = function () {\n    var d = document.getElementById(\"haxe:trace\");\n    if (d != null) d.innerHTML = \"\";\n  };\n\n  js.Boot.isClass = function (o) {\n    return o.__name__;\n  };\n\n  js.Boot.isEnum = function (e) {\n    return e.__ename__;\n  };\n\n  js.Boot.getClass = function (o) {\n    return o.__class__;\n  };\n\n  js.Boot.__string_rec = function (o, s) {\n    if (o == null) return \"null\";\n    if (s.length >= 5) return \"<...>\";\n\n    var t = _typeof(o);\n\n    if (t == \"function\" && (o.__name__ || o.__ename__)) t = \"object\";\n\n    switch (t) {\n      case \"object\":\n        if (o instanceof Array) {\n          if (o.__enum__) {\n            if (o.length == 2) return o[0];\n            var str = o[0] + \"(\";\n            s += \"\\t\";\n            var _g1 = 2,\n                _g = o.length;\n\n            while (_g1 < _g) {\n              var i = _g1++;\n              if (i != 2) str += \",\" + js.Boot.__string_rec(o[i], s);else str += js.Boot.__string_rec(o[i], s);\n            }\n\n            return str + \")\";\n          }\n\n          var l = o.length;\n          var i;\n          var str = \"[\";\n          s += \"\\t\";\n          var _g = 0;\n\n          while (_g < l) {\n            var i1 = _g++;\n            str += (i1 > 0 ? \",\" : \"\") + js.Boot.__string_rec(o[i1], s);\n          }\n\n          str += \"]\";\n          return str;\n        }\n\n        var tostr;\n\n        try {\n          tostr = o.toString;\n        } catch (e) {\n          return \"???\";\n        }\n\n        if (tostr != null && tostr != Object.toString) {\n          var s2 = o.toString();\n          if (s2 != \"[object Object]\") return s2;\n        }\n\n        var k = null;\n        var str = \"{\\n\";\n        s += \"\\t\";\n        var hasp = o.hasOwnProperty != null;\n\n        for (var k in o) {\n          ;\n\n          if (hasp && !o.hasOwnProperty(k)) {\n            continue;\n          }\n\n          if (k == \"prototype\" || k == \"__class__\" || k == \"__super__\" || k == \"__interfaces__\" || k == \"__properties__\") {\n            continue;\n          }\n\n          if (str.length != 2) str += \", \\n\";\n          str += s + k + \" : \" + js.Boot.__string_rec(o[k], s);\n        }\n\n        s = s.substring(1);\n        str += \"\\n\" + s + \"}\";\n        return str;\n\n      case \"function\":\n        return \"<function>\";\n\n      case \"string\":\n        return o;\n\n      default:\n        return String(o);\n    }\n  };\n\n  js.Boot.__interfLoop = function (cc, cl) {\n    if (cc == null) return false;\n    if (cc == cl) return true;\n    var intf = cc.__interfaces__;\n\n    if (intf != null) {\n      var _g1 = 0,\n          _g = intf.length;\n\n      while (_g1 < _g) {\n        var i = _g1++;\n        var i1 = intf[i];\n        if (i1 == cl || js.Boot.__interfLoop(i1, cl)) return true;\n      }\n    }\n\n    return js.Boot.__interfLoop(cc.__super__, cl);\n  };\n\n  js.Boot.__instanceof = function (o, cl) {\n    try {\n      if (o instanceof cl) {\n        if (cl == Array) return o.__enum__ == null;\n        return true;\n      }\n\n      if (js.Boot.__interfLoop(o.__class__, cl)) return true;\n    } catch (e) {\n      if (cl == null) return false;\n    }\n\n    switch (cl) {\n      case Int:\n        return Math.ceil(o % 2147483648.0) === o;\n\n      case Float:\n        return typeof o == \"number\";\n\n      case Bool:\n        return o === true || o === false;\n\n      case String:\n        return typeof o == \"string\";\n\n      case Dynamic:\n        return true;\n\n      default:\n        if (o == null) return false;\n        if (cl == Class && o.__name__ != null) return true;else null;\n        if (cl == Enum && o.__ename__ != null) return true;else null;\n        return o.__enum__ == cl;\n    }\n  };\n\n  js.Boot.__cast = function (o, t) {\n    if (js.Boot.__instanceof(o, t)) return o;else throw \"Cannot cast \" + Std.string(o) + \" to \" + Std.string(t);\n  };\n\n  js.Lib = function () {};\n\n  js.Lib.__name__ = true;\n\n  js.Lib.debug = function () {\n    debugger;\n  };\n\n  js.Lib.alert = function (v) {\n    alert(js.Boot.__string_rec(v, \"\"));\n  };\n\n  js.Lib.eval = function (code) {\n    return eval(code);\n  };\n\n  js.Lib.setErrorHandler = function (f) {\n    js.Lib.onerror = f;\n  };\n\n  var $_;\n\n  function $bind(o, m) {\n    var f = function f() {\n      return f.method.apply(f.scope, arguments);\n    };\n\n    f.scope = o;\n    f.method = m;\n    return f;\n  }\n\n  ;\n  if (Array.prototype.indexOf) HxOverrides.remove = function (a, o) {\n    var i = a.indexOf(o);\n    if (i == -1) return false;\n    a.splice(i, 1);\n    return true;\n  };else null;\n  Math.__name__ = [\"Math\"];\n  Math.NaN = Number.NaN;\n  Math.NEGATIVE_INFINITY = Number.NEGATIVE_INFINITY;\n  Math.POSITIVE_INFINITY = Number.POSITIVE_INFINITY;\n\n  Math.isFinite = function (i) {\n    return isFinite(i);\n  };\n\n  Math.isNaN = function (i) {\n    return isNaN(i);\n  };\n\n  String.prototype.__class__ = String;\n  String.__name__ = true;\n  Array.prototype.__class__ = Array;\n  Array.__name__ = true;\n  Date.prototype.__class__ = Date;\n  Date.__name__ = [\"Date\"];\n  var Int = {\n    __name__: [\"Int\"]\n  };\n  var Dynamic = {\n    __name__: [\"Dynamic\"]\n  };\n  var Float = Number;\n  Float.__name__ = [\"Float\"];\n  var Bool = Boolean;\n  Bool.__ename__ = [\"Bool\"];\n  var Class = {\n    __name__: [\"Class\"]\n  };\n  var Enum = {};\n  var Void = {\n    __ename__: [\"Void\"]\n  };\n  if (typeof document != \"undefined\") js.Lib.document = document;\n\n  if (typeof window != \"undefined\") {\n    js.Lib.window = window;\n\n    js.Lib.window.onerror = function (msg, url, line) {\n      var f = js.Lib.onerror;\n      if (f == null) return false;\n      return f(msg, [url + \":\" + line]);\n    };\n  }\n\n  com.wiris.js.JsPluginTools.main();\n})();\n\ndelete Array.prototype.__class__; // @codingStandardsIgnoreEnd\n\n//# sourceURL=webpack:///./core/src/md5.js?");

/***/ }),

/***/ "./core/src/modal.js":
/*!***************************!*\
  !*** ./core/src/modal.js ***!
  \***************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return ModalDialog; });\n/* harmony import */ var _popupmessage_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./popupmessage.js */ \"./core/src/popupmessage.js\");\n/* harmony import */ var _core_src_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./core.src.js */ \"./core/src/core.src.js\");\n/* harmony import */ var _util_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./util.js */ \"./core/src/util.js\");\n/* harmony import */ var _configuration_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./configuration.js */ \"./core/src/configuration.js\");\n/* harmony import */ var _listeners__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./listeners */ \"./core/src/listeners.js\");\n/* harmony import */ var _contentmanager_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./contentmanager.js */ \"./core/src/contentmanager.js\");\nfunction _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError(\"Cannot call a class as a function\"); } }\n\nfunction _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if (\"value\" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }\n\nfunction _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }\n\n\n\n\n\n\n\n/**\r\n * This class represents a modal dialog. The modal dialog admits a ContentManager instance in order\r\n * to manage the content of the dialog.\r\n */\n\nvar ModalDialog =\n/*#__PURE__*/\nfunction () {\n  /**\r\n   * Modal dialog constructor\r\n   * @param {Object} modalDialogAttributes  - An object containing all modal dialog attributes.\r\n   */\n  function ModalDialog(modalDialogAttributes) {\n    _classCallCheck(this, ModalDialog);\n\n    this.attributes = modalDialogAttributes; // Metrics\n\n    var ua = navigator.userAgent.toLowerCase();\n    var isAndroid = ua.indexOf(\"android\") > -1;\n    var isIOS = ua.indexOf(\"ipad\") > -1 || ua.indexOf(\"iphone\") > -1;\n    this.iosSoftkeyboardOpened = false;\n    this.iosMeasureUnit = ua.indexOf(\"crios\") == -1 ? \"%\" : \"vh\";\n    this.iosDivHeight = \"100\" + this.iosMeasureUnit;\n    var deviceWidth = window.outerWidth;\n    var deviceHeight = window.outerHeight;\n    var landscape = deviceWidth > deviceHeight;\n    var portrait = deviceWidth < deviceHeight; // TODO: Detect isMobile without using editor metrics.\n\n    var isMobile = landscape && this.attributes.height > deviceHeight || portrait && this.attributes.width > deviceWidth ? true : false; // Obtain number of current instance\n\n    this.instanceId = document.getElementsByClassName(\"wrs_modal_dialogContainer\").length; // Device object properties.\n\n    this.deviceProperties = {\n      orientation: landscape ? 'landscape' : 'portait',\n      isAndroid: isAndroid ? true : false,\n      isIOS: isIOS ? true : false,\n      isMobile: isMobile,\n      isDesktop: !isMobile && !isIOS && !isAndroid\n    };\n    this.properties = {\n      created: false,\n      state: '',\n      previousState: '',\n      position: {\n        bottom: 0,\n        right: 10\n      },\n      size: {\n        height: 338,\n        width: 580\n      }\n    };\n    /**\r\n     * Object to keep website's style before change it on lock scroll for mobile devices.\r\n     * @type {Object}\r\n     * @property {String} bodyStylePosition - previous body style postion.\r\n     * @property {String} bodyStyleOverflow - previous body style overflow.\r\n     * @property {String} htmlStyleOverflow - previous body style overflow.\r\n     * @property {String} windowScrollX - previous window's scroll Y.\r\n     * @property {String} windowScrollY - previous window's scroll X.\r\n     */\n\n    this.websiteBeforeLockParameters = null;\n    var attributes = {};\n    attributes.class = 'wrs_modal_overlay';\n    attributes.id = this.getElementId(attributes.class);\n    this.overlay = _util_js__WEBPACK_IMPORTED_MODULE_2__[\"default\"].createElement('div', attributes);\n    attributes = {};\n    attributes.class = 'wrs_modal_title_bar';\n    attributes.id = this.getElementId(attributes.class);\n    this.titleBar = _util_js__WEBPACK_IMPORTED_MODULE_2__[\"default\"].createElement('div', attributes);\n    attributes = {};\n    attributes.class = 'wrs_modal_title';\n    attributes.id = this.getElementId(attributes.class);\n    this.title = _util_js__WEBPACK_IMPORTED_MODULE_2__[\"default\"].createElement('div', attributes);\n    this.title.innerHTML = '';\n    attributes = {};\n    attributes.class = 'wrs_modal_close_button';\n    attributes.id = this.getElementId(attributes.class);\n    attributes.title = _core_src_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"].getStringManager().getString('close');\n    this.closeDiv = _util_js__WEBPACK_IMPORTED_MODULE_2__[\"default\"].createElement('a', attributes);\n    ;\n    this.closeDiv.setAttribute('role', 'button');\n    attributes = {};\n    attributes.class = 'wrs_modal_stack_button';\n    attributes.id = this.getElementId(attributes.class);\n    attributes.title = \"Exit full-screen\";\n    this.stackDiv = _util_js__WEBPACK_IMPORTED_MODULE_2__[\"default\"].createElement('a', attributes);\n    this.stackDiv.setAttribute('role', 'button');\n    attributes = {};\n    attributes.class = 'wrs_modal_maximize_button';\n    attributes.id = this.getElementId(attributes.class);\n    attributes.title = _core_src_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"].getStringManager().getString('fullscreen');\n    this.maximizeDiv = _util_js__WEBPACK_IMPORTED_MODULE_2__[\"default\"].createElement('a', attributes);\n    this.maximizeDiv.setAttribute('role', 'button');\n    attributes = {};\n    attributes.class = 'wrs_modal_minimize_button';\n    attributes.id = this.getElementId(attributes.class);\n    attributes.title = _core_src_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"].getStringManager().getString('minimise');\n    this.minimizeDiv = _util_js__WEBPACK_IMPORTED_MODULE_2__[\"default\"].createElement('a', attributes);\n    this.minimizeDiv.setAttribute('role', 'button');\n    attributes = {};\n    attributes.class = 'wrs_modal_dialogContainer';\n    attributes.id = this.getElementId(attributes.class);\n    this.container = _util_js__WEBPACK_IMPORTED_MODULE_2__[\"default\"].createElement('div', attributes);\n    attributes = {};\n    attributes.class = 'wrs_modal_wrapper';\n    attributes.id = this.getElementId(attributes.class);\n    this.wrapper = _util_js__WEBPACK_IMPORTED_MODULE_2__[\"default\"].createElement('div', attributes);\n    attributes = {};\n    attributes.class = 'wrs_content_container';\n    attributes.id = this.getElementId(attributes.class);\n    this.contentContainer = _util_js__WEBPACK_IMPORTED_MODULE_2__[\"default\"].createElement('div', attributes);\n    attributes = {};\n    attributes.class = 'wrs_modal_controls';\n    attributes.id = this.getElementId(attributes.class);\n    this.controls = _util_js__WEBPACK_IMPORTED_MODULE_2__[\"default\"].createElement('div', attributes);\n    attributes = {};\n    attributes.class = 'wrs_modal_buttons_container';\n    attributes.id = this.getElementId(attributes.class);\n    this.buttonContainer = _util_js__WEBPACK_IMPORTED_MODULE_2__[\"default\"].createElement('div', attributes); // Buttons: all button must be created using createSubmitButton method.\n\n    this.submitButton = this.createSubmitButton({\n      id: this.getElementId('wrs_modal_button_accept'),\n      class: 'wrs_modal_button_accept',\n      innerHTML: _core_src_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"].getStringManager().getString('accept')\n    }, this.submitAction.bind(this));\n    this.cancelButton = this.createSubmitButton({\n      id: this.getElementId('wrs_modal_button_cancel'),\n      class: 'wrs_modal_button_cancel',\n      innerHTML: _core_src_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"].getStringManager().getString('cancel')\n    }, this.cancelAction.bind(this));\n    this.contentManager = null; // Overlay popup.\n\n    var popupStrings = {\n      'cancelString': _core_src_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"].getStringManager().getString('cancel'),\n      'submitString': _core_src_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"].getStringManager().getString('close'),\n      'message': _core_src_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"].getStringManager().getString('close_modal_warning')\n    };\n    var callbacks = {\n      'closeCallback': function () {\n        this.close();\n      }.bind(this),\n      'cancelCallback': function () {\n        this.focus();\n      }.bind(this)\n    };\n    var popupupProperties = {\n      'overlayElement': this.container,\n      'callbacks': callbacks,\n      'strings': popupStrings\n    };\n    this.popup = new _popupmessage_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"](popupupProperties);\n    /**\r\n    * Indicates if directionality of the modal dialog is RTL. false by default.\r\n    * @type {boolean}\r\n    */\n\n    this.rtl = false;\n\n    if ('rtl' in this.attributes) {\n      this.rtl = this.attributes.rtl;\n    } // Event handlers need modal instance context.\n\n\n    this.handleOpenedIosSoftkeyboard = this.handleOpenedIosSoftkeyboard.bind(this);\n    this.handleClosedIosSoftkeyboard = this.handleClosedIosSoftkeyboard.bind(this);\n  }\n  /**\r\n   * This method sets an ContentManager instance to ModalDialog. ContentManager\r\n   * manages the logic of ModalDialog content: submit, update, close and changes.\r\n   * @param {ContentManager} contentManager - ContentManager instance.\r\n   */\n\n\n  _createClass(ModalDialog, [{\n    key: \"setContentManager\",\n    value: function setContentManager(contentManager) {\n      this.contentManager = contentManager;\n    }\n    /**\r\n     * Returns the modal contentElement object.\r\n     * @returns {ContentManager} the instance of the ContentManager class.\r\n    */\n\n  }, {\n    key: \"getContentManager\",\n    value: function getContentManager() {\n      return this.contentManager;\n    }\n    /**\r\n     * This method is called when the modal object has been submitted. Calls\r\n     * contentElement submitAction method - if exists - and closes the modal\r\n     * object. No logic about the content should be placed here,\r\n     * contentElement.submitAction is the responsible of the content logic.\r\n     */\n\n  }, {\n    key: \"submitAction\",\n    value: function submitAction() {\n      if (typeof this.contentManager.submitAction !== 'undefined') {\n        this.contentManager.submitAction();\n      }\n\n      this.close();\n    }\n    /**\r\n     * This method is called when the modal object has been cancelled. If\r\n     * contentElement has implemented hasChanges method, a confirm popup\r\n     * will be shown if hasChanges returns true.\r\n     */\n\n  }, {\n    key: \"cancelAction\",\n    value: function cancelAction() {\n      if (typeof this.contentManager.hasChanges === 'undefined') {\n        this.close();\n      } else if (!this.contentManager.hasChanges()) {\n        this.close();\n      } else {\n        this.showPopUpMessage();\n      }\n    }\n    /**\r\n     * Returns a button element.\r\n     * @param {Object} properties - input button properties.\r\n     * @param {string} properties.class - input button class.\r\n     * @param {string} properties.innerHTML - input button innerHTML.\r\n     * @param {Object} callback - callback function associated to click event.\r\n     * @returns {HTMLButtonElement} the button element.\r\n     *\r\n     */\n\n  }, {\n    key: \"createSubmitButton\",\n    value: function createSubmitButton(properties, callback) {\n      function SubmitButton(properties, callback) {\n        this.element = document.createElement('button');\n        this.element.id = properties.id;\n        this.element.className = properties.class;\n        this.element.innerHTML = properties.innerHTML;\n        _util_js__WEBPACK_IMPORTED_MODULE_2__[\"default\"].addEvent(this.element, 'click', callback);\n      }\n\n      SubmitButton.prototype.getElement = function () {\n        return this.element;\n      };\n\n      return new SubmitButton(properties, callback).getElement();\n    }\n    /**\r\n     * Creates the modal window object inserting a contentElement object.\r\n     */\n\n  }, {\n    key: \"create\",\n    value: function create() {\n      /*Modal Window Structure\r\n      _____________________________________________________________________________________\r\n      |wrs_modal_dialog_Container                                                         |\r\n      | _________________________________________________________________________________ |\r\n      | |title_bar                          minimize_button  stack_button  close_button | |\r\n      | |_______________________________________________________________________________| |\r\n      | |wrapper                                                                        | |\r\n      | | _____________________________________________________________________________ | |\r\n      | | |content                                                                    | | |\r\n      | | |                                                                           | | |\r\n      | | |                                                                           | | |\r\n      | | |___________________________________________________________________________| | |\r\n      | | _____________________________________________________________________________ | |\r\n      | | |controls                                                                   | | |\r\n      | | | ___________________________________                                       | | |\r\n      | | | |buttonContainer                  |                                       | | |\r\n      | | | | _______________________________ |                                       | | |\r\n      | | | | |button_accept | button_cancel| |                                       | | |\r\n      | | | |_|_____________ |______________|_|                                       | | |\r\n      | | |___________________________________________________________________________| | |\r\n      | |_______________________________________________________________________________| |\r\n      |___________________________________________________________________________________|*/\n      this.titleBar.appendChild(this.closeDiv);\n      this.titleBar.appendChild(this.stackDiv);\n      this.titleBar.appendChild(this.maximizeDiv);\n      this.titleBar.appendChild(this.minimizeDiv);\n      this.titleBar.appendChild(this.title);\n\n      if (this.deviceProperties['isDesktop']) {\n        this.container.appendChild(this.titleBar);\n      }\n\n      this.wrapper.appendChild(this.contentContainer);\n      this.wrapper.appendChild(this.controls);\n      this.controls.appendChild(this.buttonContainer);\n      this.buttonContainer.appendChild(this.submitButton);\n      this.buttonContainer.appendChild(this.cancelButton);\n      this.container.appendChild(this.wrapper); // Check if browser has scrollBar before modal has modified.\n\n      this.recalculateScrollBar();\n      document.body.appendChild(this.container);\n      document.body.appendChild(this.overlay);\n\n      if (this.deviceProperties['isDesktop']) {\n        // Desktop.\n        this.createModalWindowDesktop();\n        this.createResizeButtons();\n        this.addListeners(); // Maximize window only when the configuration is set and the device is not iOS or Android.\n\n        if (_configuration_js__WEBPACK_IMPORTED_MODULE_3__[\"default\"].get('modalWindowFullScreen')) {\n          this.maximize();\n        }\n      } else if (this.deviceProperties['isAndroid']) {\n        this.createModalWindowAndroid();\n      } else if (this.deviceProperties['isIOS'] && !this.deviceProperties['isMobile']) {\n        this.createModalWindowIos();\n      }\n\n      if (this.contentManager != null) {\n        this.contentManager.insert(this);\n      }\n\n      this.properties.open = true;\n      this.properties.created = true; // Checks language directionality.\n\n      if (this.isRTL()) {\n        this.container.style.right = window.innerWidth - this.scrollbarWidth - this.container.offsetWidth + 'px';\n        this.container.className += ' wrs_modal_rtl';\n      }\n    }\n    /**\r\n     * Creates a button in the modal object to resize it.\r\n     */\n\n  }, {\n    key: \"createResizeButtons\",\n    value: function createResizeButtons() {\n      // This is a definition of Resize Button Bottom-Right\n      this.resizerBR = document.createElement('div');\n      this.resizerBR.className = 'wrs_bottom_right_resizer';\n      this.resizerBR.innerHTML = '◢'; // This is a definition of Resize Button Top-Left\n\n      this.resizerTL = document.createElement('div');\n      this.resizerTL.className = 'wrs_bottom_left_resizer'; // Append resize buttons to modal\n\n      this.container.appendChild(this.resizerBR);\n      this.titleBar.appendChild(this.resizerTL); // Add events to resize on click and drag\n\n      _util_js__WEBPACK_IMPORTED_MODULE_2__[\"default\"].addEvent(this.resizerBR, 'mousedown', this.activateResizeStateBR.bind(this));\n      _util_js__WEBPACK_IMPORTED_MODULE_2__[\"default\"].addEvent(this.resizerTL, 'mousedown', this.activateResizeStateTL.bind(this));\n    }\n    /**\r\n     * Initialize variables for Bottom-Right resize button\r\n     * @param {MouseEvent} mouseEvent - mouse event.\r\n     */\n\n  }, {\n    key: \"activateResizeStateBR\",\n    value: function activateResizeStateBR(mouseEvent) {\n      this.initializeResizeProperties(mouseEvent, false);\n    }\n    /**\r\n     * Initialize variables for Top-Left resize button\r\n     * @param {MouseEvent} mouseEvent - mouse event.\r\n     */\n\n  }, {\n    key: \"activateResizeStateTL\",\n    value: function activateResizeStateTL(mouseEvent) {\n      this.initializeResizeProperties(mouseEvent, true);\n    }\n    /**\r\n     * Common method to initialize variables at resize\r\n     * @param {MouseEvent} mouseEvent - mouse event.\r\n     */\n\n  }, {\n    key: \"initializeResizeProperties\",\n    value: function initializeResizeProperties(mouseEvent, leftOption) {\n      // Apply class for disable involuntary select text when drag.\n      _util_js__WEBPACK_IMPORTED_MODULE_2__[\"default\"].addClass(document.body, 'wrs_noselect');\n      _util_js__WEBPACK_IMPORTED_MODULE_2__[\"default\"].addClass(this.overlay, 'wrs_overlay_active');\n      this.resizeDataObject = {\n        x: this.eventClient(mouseEvent).X,\n        y: this.eventClient(mouseEvent).Y\n      }; // Save Initial state of modal to compare on drag and obtain the difference.\n\n      this.initialWidth = parseInt(this.container.style.width);\n      this.initialHeight = parseInt(this.container.style.height);\n\n      if (!leftOption) {\n        this.initialRight = parseInt(this.container.style.right);\n        this.initialBottom = parseInt(this.container.style.bottom);\n      } else {\n        this.leftScale = true;\n      }\n\n      if (!this.initialRight) {\n        this.initialRight = 0;\n      }\n\n      if (!this.initialBottom) {\n        this.initialBottom = 0;\n      } // Disable mouse events on editor when we start to drag modal.\n\n\n      document.body.style['user-select'] = 'none';\n    }\n    /**\r\n     * This method opens the modal window, restoring the previous state, position and metrics,\r\n     * if exists. By default the modal object opens in stack mode.\r\n     */\n\n  }, {\n    key: \"open\",\n    value: function open() {\n      //Removing close class.\n      this.removeClass('wrs_closed'); // Hiding keyboard for mobile devices.\n\n      if (this.deviceProperties['isIOS'] || this.deviceProperties['isAndroid'] || this.deviceProperties['isMobile']) {\n        // Restore scale to 1\n        this.restoreWebsiteScale();\n        this.lockWebsiteScroll(); // Due to editor wait we need to wait until editor focus.\n\n        setTimeout(function () {\n          this.hideKeyboard();\n        }.bind(this), 400);\n      } // New modal window. He need to create the whole object.\n\n\n      if (!this.properties.created) {\n        this.create();\n      } else {\n        // Previous state closed. Open method can be called even the previous state is open,\n        // for example updating the content of the modal object.\n        if (!this.properties.open) {\n          this.properties.open = true; // Restoring the previous open state: if the modal object has been closed\n          // re-open it should preserve the state and the metrics.\n\n          if (!this.deviceProperties.isAndroid && !this.deviceProperties.isIOS) {\n            this.restoreState();\n          }\n        } // Maximize window only when the configuration is set and the device is not iOs or Android.\n\n\n        if (this.deviceProperties['isDesktop'] && _configuration_js__WEBPACK_IMPORTED_MODULE_3__[\"default\"].get('modalWindowFullScreen')) {\n          this.maximize();\n        } // In iOS we need to recalculate the size of the modal object because\n        // iOS keyboard is a float div which can overlay the modal object.\n\n\n        if (this.deviceProperties['isIOS']) {\n          this.iosSoftkeyboardOpened = false;\n          this.setContainerHeight(\"100\" + this.iosMeasureUnit);\n        }\n      }\n\n      if (this.contentManager.isEditorLoaded === false) {\n        var listener = _listeners__WEBPACK_IMPORTED_MODULE_4__[\"default\"].newListener('onLoad', function () {\n          this.contentManager.onOpen(this);\n        }.bind(this));\n        this.contentManager.addListener(listener);\n      } else {\n        this.contentManager.onOpen(this);\n      }\n    }\n    /**\r\n     * Closes modal window and restores viewport header.\r\n     */\n\n  }, {\n    key: \"close\",\n    value: function close() {\n      this.removeClass('wrs_maximized');\n      this.removeClass('wrs_minimized');\n      this.removeClass('wrs_stack');\n      this.addClass('wrs_closed');\n      this.saveModalProperties();\n      this.unlockWebsiteScroll();\n      this.properties.open = false;\n    }\n    /**\r\n     * Sets the website scale to one.\r\n     */\n\n  }, {\n    key: \"restoreWebsiteScale\",\n    value: function restoreWebsiteScale() {\n      var viewportmeta = document.querySelector('meta[name=viewport]'); // Let the equal symbols in order to search and make meta's final content.\n\n      var contentAttrsToUpdate = ['initial-scale=', 'minimum-scale=', 'maximum-scale='];\n      var contentAttrsValuesToUpdate = ['1.0', '1.0', '1.0'];\n\n      var setMetaAttrFunc = function setMetaAttrFunc(viewportelement, contentAttrsToUpdate) {\n        var contentAttr = viewportelement.getAttribute('content'); // If it exists, we need to maintain old values and put our values.\n\n        if (contentAttr) {\n          var attrArray = contentAttr.split(',');\n          var finalContentMeta = \"\";\n          var oldAttrs = [];\n\n          for (var i = 0; i < attrArray.length; i++) {\n            var isAttrToUpdate = false;\n            var j = 0;\n\n            while (!isAttrToUpdate && j < contentAttrsToUpdate.length) {\n              if (attrArray[i].indexOf(contentAttrsToUpdate[j])) {\n                isAttrToUpdate = true;\n              }\n\n              j++;\n            }\n\n            if (!isAttrToUpdate) {\n              oldAttrs.push(attrArray[i]);\n            }\n          }\n\n          for (var _i = 0; _i < contentAttrsToUpdate.length; _i++) {\n            var attr = contentAttrsToUpdate[_i] + contentAttrsValuesToUpdate[_i];\n            finalContentMeta += _i == 0 ? attr : ',' + attr;\n          }\n\n          for (var _i2 = 0; _i2 < oldAttrs.length; _i2++) {\n            finalContentMeta += ',' + oldAttrs[_i2];\n          }\n\n          viewportelement.setAttribute('content', finalContentMeta); // It needs to set to empty because setAttribute refresh only when attribute is different.\n\n          viewportelement.setAttribute('content', '');\n          viewportelement.setAttribute('content', contentAttr);\n        } else {\n          viewportelement.setAttribute('content', 'initial-scale=1.0, minimum-scale=1.0, maximum-scale=1.0');\n          viewportelement.removeAttribute('content');\n        }\n      };\n\n      if (!viewportmeta) {\n        viewportmeta = document.createElement('meta');\n        document.getElementsByTagName('head')[0].appendChild(viewportmeta);\n        setMetaAttrFunc(viewportmeta, contentAttrsToUpdate, contentAttrsValuesToUpdate);\n        viewportmeta.remove();\n      } else {\n        setMetaAttrFunc(viewportmeta, contentAttrsToUpdate, contentAttrsValuesToUpdate);\n      }\n    }\n    /**\r\n     * Locks website scroll for mobile devices.\r\n     */\n\n  }, {\n    key: \"lockWebsiteScroll\",\n    value: function lockWebsiteScroll() {\n      this.websiteBeforeLockParameters = {\n        bodyStylePosition: document.body.style.position ? document.body.style.position : '',\n        bodyStyleOverflow: document.body.style.overflow ? document.body.style.overflow : '',\n        htmlStyleOverflow: document.documentElement.style.overflow ? document.documentElement.style.overflow : '',\n        windowScrollX: window.scrollX,\n        windowScrollY: window.scrollY\n      };\n      document.body.style.position = 'fixed';\n      document.body.style.overflow = 'hidden';\n      document.documentElement.style.overflow = 'hidden';\n    }\n    /**\r\n     * Unlocks website scroll for mobile devices.\r\n     */\n\n  }, {\n    key: \"unlockWebsiteScroll\",\n    value: function unlockWebsiteScroll() {\n      if (this.websiteBeforeLockParameters) {\n        document.body.style.position = this.websiteBeforeLockParameters.bodyStylePosition;\n        document.body.style.overflow = this.websiteBeforeLockParameters.bodyStyleOverflow;\n        document.documentElement.style.overflow = this.websiteBeforeLockParameters.htmlStyleOverflow;\n        window.scrollTo(this.websiteBeforeLockParameters.windowScrollX, this.websiteBeforeLockParameters.windowScrollY);\n        this.websiteBeforeLockParameters = null;\n      }\n    }\n    /**\r\n     * Util function to known if browser is IE11.\r\n     * @returns {boolean} true if the browser is IE11. false otherwise.\r\n     */\n\n  }, {\n    key: \"isIE11\",\n    value: function isIE11() {\n      if (navigator.userAgent.search(\"Msie/\") >= 0 || navigator.userAgent.search(\"Trident/\") >= 0 || navigator.userAgent.search(\"Edge/\") >= 0) {\n        return true;\n      }\n\n      return false;\n    }\n    /**\r\n     * Returns if the current language type is RTL.\r\n     * @return {boolean} true if current language is RTL. false otherwise.\r\n     */\n\n  }, {\n    key: \"isRTL\",\n    value: function isRTL() {\n      if (this.attributes.language == 'ar' || this.attributes.language == 'he') {\n        return true;\n      } else {\n        return this.rtl;\n      }\n\n      ;\n    }\n    /**\r\n     * Adds a class to all modal ModalDialog DOM elements.\r\n     * @param {string} className - class name.\r\n     */\n\n  }, {\n    key: \"addClass\",\n    value: function addClass(className) {\n      _util_js__WEBPACK_IMPORTED_MODULE_2__[\"default\"].addClass(this.overlay, className);\n      _util_js__WEBPACK_IMPORTED_MODULE_2__[\"default\"].addClass(this.titleBar, className);\n      _util_js__WEBPACK_IMPORTED_MODULE_2__[\"default\"].addClass(this.overlay, className);\n      _util_js__WEBPACK_IMPORTED_MODULE_2__[\"default\"].addClass(this.container, className);\n      _util_js__WEBPACK_IMPORTED_MODULE_2__[\"default\"].addClass(this.contentContainer, className);\n      _util_js__WEBPACK_IMPORTED_MODULE_2__[\"default\"].addClass(this.stackDiv, className);\n      _util_js__WEBPACK_IMPORTED_MODULE_2__[\"default\"].addClass(this.minimizeDiv, className);\n      _util_js__WEBPACK_IMPORTED_MODULE_2__[\"default\"].addClass(this.maximizeDiv, className);\n      _util_js__WEBPACK_IMPORTED_MODULE_2__[\"default\"].addClass(this.wrapper, className);\n    }\n    /**\r\n     * Remove a class from all modal DOM elements.\r\n     * @param {string} className - class name.\r\n     */\n\n  }, {\n    key: \"removeClass\",\n    value: function removeClass(className) {\n      _util_js__WEBPACK_IMPORTED_MODULE_2__[\"default\"].removeClass(this.overlay, className);\n      _util_js__WEBPACK_IMPORTED_MODULE_2__[\"default\"].removeClass(this.titleBar, className);\n      _util_js__WEBPACK_IMPORTED_MODULE_2__[\"default\"].removeClass(this.overlay, className);\n      _util_js__WEBPACK_IMPORTED_MODULE_2__[\"default\"].removeClass(this.container, className);\n      _util_js__WEBPACK_IMPORTED_MODULE_2__[\"default\"].removeClass(this.contentContainer, className);\n      _util_js__WEBPACK_IMPORTED_MODULE_2__[\"default\"].removeClass(this.stackDiv, className);\n      _util_js__WEBPACK_IMPORTED_MODULE_2__[\"default\"].removeClass(this.minimizeDiv, className);\n      _util_js__WEBPACK_IMPORTED_MODULE_2__[\"default\"].removeClass(this.maximizeDiv, className);\n      _util_js__WEBPACK_IMPORTED_MODULE_2__[\"default\"].removeClass(this.wrapper, className);\n    }\n    /**\r\n     * Create modal dialog for desktop.\r\n     */\n\n  }, {\n    key: \"createModalWindowDesktop\",\n    value: function createModalWindowDesktop() {\n      this.addClass('wrs_modal_desktop');\n      this.stack();\n    }\n    /**\r\n     * Create modal dialog for non android devices.\r\n     */\n\n  }, {\n    key: \"createModalWindowAndroid\",\n    value: function createModalWindowAndroid() {\n      this.addClass('wrs_modal_android');\n      window.addEventListener('resize', this.orientationChangeAndroidSoftkeyboard.bind(this));\n    }\n    /**\r\n     * Create modal dialog for iOS devices.\r\n     */\n\n  }, {\n    key: \"createModalWindowIos\",\n    value: function createModalWindowIos() {\n      this.addClass('wrs_modal_ios'); // Refresh the size when the orientation is changed\n\n      window.addEventListener('resize', this.orientationChangeIosSoftkeyboard.bind(this));\n    }\n    /**\r\n     * Restore previous state, position and size of previous stacked modal dialog.\r\n     */\n\n  }, {\n    key: \"restoreState\",\n    value: function restoreState() {\n      if (this.properties.state == 'maximized') {\n        // Reset states for prevent return to stack state.\n        this.maximize();\n      } else if (this.properties.state == 'minimized') {\n        // Reset states for prevent return to stack state.\n        this.properties.state = this.properties.previousState;\n        this.properties.previousState = '';\n        this.minimize();\n      } else {\n        this.stack();\n      }\n    }\n    /**\r\n     * Stacks the modal object.\r\n     */\n\n  }, {\n    key: \"stack\",\n    value: function stack() {\n      this.properties.previousState = this.properties.state;\n      this.properties.state = 'stack';\n      this.removeClass('wrs_maximized');\n      this.minimizeDiv.title = \"Minimise\";\n      this.removeClass('wrs_minimized');\n      this.addClass('wrs_stack');\n      this.restoreModalProperties();\n\n      if (typeof this.resizerBR !== 'undefined' && typeof this.resizerTL !== 'undefined') {\n        this.setResizeButtonsVisibility();\n      } // Need recalculate position of actual modal because window can was changed in fullscreenmode\n\n\n      this.recalculateScrollBar();\n      this.recalculatePosition();\n      this.recalculateScale();\n      this.focus();\n    }\n    /**\r\n     * Minimizes the modal object\r\n     */\n\n  }, {\n    key: \"minimize\",\n    value: function minimize() {\n      // Saving width, height, top and bottom parameters to restore when open\n      this.saveModalProperties();\n\n      if (this.properties.state == 'minimized' && this.properties.previousState == 'stack') {\n        this.stack();\n      } else if (this.properties.state == 'minimized' && this.properties.previousState == 'maximized') {\n        this.maximize();\n      } else {\n        // Setting css to prevent important tag into css style\n        this.container.style.height = \"30px\";\n        this.container.style.width = \"250px\";\n        this.container.style.bottom = \"0px\";\n        this.container.style.right = \"10px\";\n        this.removeListeners();\n        this.properties.previousState = this.properties.state;\n        this.properties.state = \"minimized\";\n        this.setResizeButtonsVisibility();\n        this.minimizeDiv.title = \"Maximise\";\n\n        if (_util_js__WEBPACK_IMPORTED_MODULE_2__[\"default\"].containsClass(this.overlay, 'wrs_stack')) {\n          this.removeClass('wrs_stack');\n        } else {\n          this.removeClass('wrs_maximized');\n        }\n\n        this.addClass('wrs_minimized');\n      }\n    }\n    /**\r\n     * Maximizes the modal object.\r\n     */\n\n  }, {\n    key: \"maximize\",\n    value: function maximize() {\n      // Saving width, height, top and bottom parameters to restore when open\n      this.saveModalProperties();\n\n      if (this.properties.state != 'maximized') {\n        this.properties.previousState = this.properties.state;\n        this.properties.state = 'maximized';\n      } // Don't permit resize on maximize mode.\n\n\n      this.setResizeButtonsVisibility();\n\n      if (_util_js__WEBPACK_IMPORTED_MODULE_2__[\"default\"].containsClass(this.overlay, 'wrs_minimized')) {\n        this.minimizeDiv.title = \"Minimise\";\n        this.removeClass('wrs_minimized');\n      } else if (_util_js__WEBPACK_IMPORTED_MODULE_2__[\"default\"].containsClass(this.overlay, 'wrs_stack')) {\n        this.container.style.left = null;\n        this.container.style.top = null;\n        this.removeClass('wrs_stack');\n      }\n\n      this.addClass('wrs_maximized'); // Set size to 80% screen with a max size.\n\n      this.setSize(parseInt(window.innerHeight * 0.8), parseInt(window.innerWidth * 0.8));\n      var sizeModificated = false;\n\n      if (this.container.clientHeight > 700) {\n        this.container.style.height = '700px';\n        sizeModificated = true;\n      }\n\n      if (this.container.clientWidth > 1200) {\n        this.container.style.width = '1200px';\n        sizeModificated = true;\n      } // Setting modal position in center on screen.\n\n\n      this.setPosition(window.innerHeight / 2 - this.container.offsetHeight / 2, window.innerWidth / 2 - this.container.offsetWidth / 2);\n      this.recalculateScale();\n      this.recalculatePosition();\n      this.recalculateSize();\n      this.focus();\n    }\n    /**\r\n     * Sets modal size.\r\n     * @param {number} height - height of the ModalDialog\r\n     * @param {number} width - width of the ModalDialog.\r\n     */\n\n  }, {\n    key: \"setSize\",\n    value: function setSize(height, width) {\n      this.container.style.height = height + 'px';\n      this.container.style.width = width + 'px';\n      this.recalculateSize();\n    }\n    /**\r\n     * Sets modal position using bottom and right style attributes.\r\n     * @param  {number} bottom - bottom attribute.\r\n     * @param  {number} right - right attribute.\r\n     */\n\n  }, {\n    key: \"setPosition\",\n    value: function setPosition(bottom, right) {\n      this.container.style.bottom = bottom + 'px';\n      this.container.style.right = right + 'px';\n    }\n    /**\r\n     * Saves position and size parameters of and open ModalDialog. This attributes\r\n     * are needed to restore it on re-open.\r\n     */\n\n  }, {\n    key: \"saveModalProperties\",\n    value: function saveModalProperties() {\n      // Saving values of modal only when modal is in stack state.\n      if (this.properties.state == 'stack') {\n        this.properties.position.bottom = parseInt(this.container.style.bottom);\n        this.properties.position.right = parseInt(this.container.style.right);\n        this.properties.size.width = parseInt(this.container.style.width);\n        this.properties.size.height = parseInt(this.container.style.height);\n      }\n    }\n    /**\r\n     * Restore ModalDialog position and size parameters.\r\n     */\n\n  }, {\n    key: \"restoreModalProperties\",\n    value: function restoreModalProperties() {\n      if (this.properties.state == 'stack') {\n        // Restoring Bottom and Right values from last modal\n        this.setPosition(this.properties.position.bottom, this.properties.position.right); // Restoring Height and Left values from last modal\n\n        this.setSize(this.properties.size.height, this.properties.size.width);\n      }\n    }\n    /**\r\n     * Sets the modal dialog initial size.\r\n     */\n\n  }, {\n    key: \"recalculateSize\",\n    value: function recalculateSize() {\n      this.wrapper.style.width = this.container.clientWidth - 12 + 'px';\n      this.wrapper.style.height = this.container.clientHeight - 38 + 'px';\n      this.contentContainer.style.height = parseInt(this.wrapper.offsetHeight - 50) + 'px';\n    }\n    /**\r\n     * Enable or disable visibility of resize buttons in modal window depend on state.\r\n     */\n\n  }, {\n    key: \"setResizeButtonsVisibility\",\n    value: function setResizeButtonsVisibility() {\n      if (this.properties.state == 'stack') {\n        this.resizerTL.style.visibility = 'visible';\n        this.resizerBR.style.visibility = 'visible';\n      } else {\n        this.resizerTL.style.visibility = 'hidden';\n        this.resizerBR.style.visibility = 'hidden';\n      }\n    }\n    /**\r\n     * Makes an object draggable adding mouse and touch events.\r\n     */\n\n  }, {\n    key: \"addListeners\",\n    value: function addListeners() {\n      // Button events (maximize, minimize, stack and close).\n      this.maximizeDiv.addEventListener('click', this.maximize.bind(this), true);\n      this.stackDiv.addEventListener('click', this.stack.bind(this), true);\n      this.minimizeDiv.addEventListener('click', this.minimize.bind(this), true);\n      this.closeDiv.addEventListener('click', this.cancelAction.bind(this)); // Overlay events (close).\n\n      this.overlay.addEventListener('click', this.cancelAction.bind(this)); // Mouse events.\n\n      _util_js__WEBPACK_IMPORTED_MODULE_2__[\"default\"].addEvent(window, 'mousedown', this.startDrag.bind(this));\n      _util_js__WEBPACK_IMPORTED_MODULE_2__[\"default\"].addEvent(window, 'mouseup', this.stopDrag.bind(this));\n      _util_js__WEBPACK_IMPORTED_MODULE_2__[\"default\"].addEvent(window, 'mousemove', this.drag.bind(this));\n      _util_js__WEBPACK_IMPORTED_MODULE_2__[\"default\"].addEvent(window, 'resize', this.onWindowResize.bind(this)); // Key events.\n\n      _util_js__WEBPACK_IMPORTED_MODULE_2__[\"default\"].addEvent(window, 'keydown', this.onKeyDown.bind(this));\n    }\n    /**\r\n     * Removes draggable events from an object.\r\n     */\n\n  }, {\n    key: \"removeListeners\",\n    value: function removeListeners() {\n      // Mouse events.\n      _util_js__WEBPACK_IMPORTED_MODULE_2__[\"default\"].removeEvent(window, 'mousedown', this.startDrag);\n      _util_js__WEBPACK_IMPORTED_MODULE_2__[\"default\"].removeEvent(window, 'mouseup', this.stopDrag);\n      _util_js__WEBPACK_IMPORTED_MODULE_2__[\"default\"].removeEvent(window, 'mousemove', this.drag);\n      _util_js__WEBPACK_IMPORTED_MODULE_2__[\"default\"].removeEvent(window, 'resize', this.onWindowResize); // Key events\n\n      _util_js__WEBPACK_IMPORTED_MODULE_2__[\"default\"].removeEvent(window, 'keydown', this.onKeyDown);\n    }\n    /**\r\n     * Returns mouse or touch coordinates (on touch events ev.ClientX doesn't exists)\r\n     * @param {MouseEvent} mouseEvent - mouse event.\r\n     * @return {Object} with the X and Y coordinates.\r\n     */\n\n  }, {\n    key: \"eventClient\",\n    value: function eventClient(mouseEvent) {\n      if (typeof mouseEvent.clientX == 'undefined' && mouseEvent.changedTouches) {\n        var client = {\n          X: mouseEvent.changedTouches[0].clientX,\n          Y: mouseEvent.changedTouches[0].clientY\n        };\n        return client;\n      } else {\n        client = {\n          X: mouseEvent.clientX,\n          Y: mouseEvent.clientY\n        };\n        return client;\n      }\n    }\n    /**\r\n     * Start drag function: set the object dragDataObject with the draggable object offsets coordinates.\r\n     * when drag starts (on touchstart or mousedown events).\r\n     * @param {MouseEvent} mouseEvent - touchstart or mousedown event.\r\n     */\n\n  }, {\n    key: \"startDrag\",\n    value: function startDrag(mouseEvent) {\n      if (this.properties.state == 'minimized') {\n        return;\n      }\n\n      if (mouseEvent.target === this.title) {\n        if (typeof this.dragDataObject === 'undefined' || this.dragDataObject === null) {\n          mouseEvent = mouseEvent || event; // Save first click mouse point on screen\n\n          this.dragDataObject = {\n            x: this.eventClient(mouseEvent).X,\n            y: this.eventClient(mouseEvent).Y\n          }; // Reset last drag position when start drag\n\n          this.lastDrag = {\n            x: \"0px\",\n            y: \"0px\"\n          }; // Init right and bottom values for window modal if it isn't exist.\n\n          if (this.container.style.right == '') {\n            this.container.style.right = \"0px\";\n          }\n\n          if (this.container.style.bottom == '') {\n            this.container.style.bottom = \"0px\";\n          } // Needed for IE11 for apply disabled mouse events on editor because iexplorer need a dinamic object to apply this property.\n\n\n          if (this.isIE11()) {} // this.iframe.style['position'] = 'relative';\n          // Apply class for disable involuntary select text when drag.\n\n\n          _util_js__WEBPACK_IMPORTED_MODULE_2__[\"default\"].addClass(document.body, 'wrs_noselect');\n          _util_js__WEBPACK_IMPORTED_MODULE_2__[\"default\"].addClass(this.overlay, 'wrs_overlay_active'); // Obtain screen limits for prevent overflow.\n\n          this.limitWindow = this.getLimitWindow();\n        }\n      }\n    }\n    /**\r\n     * Updates dragDataObject with the draggable object coordinates when the draggable object is being moved.\r\n     * @param {MouseEvent} mouseEvent - the mouse event.\r\n     */\n\n  }, {\n    key: \"drag\",\n    value: function drag(mouseEvent) {\n      if (this.dragDataObject) {\n        mouseEvent.preventDefault();\n        mouseEvent = mouseEvent || event; // Calculate max and min between actual mouse position and limit of screeen. It restric the movement of modal into window.\n\n        var limitY = Math.min(this.eventClient(mouseEvent).Y, this.limitWindow.minPointer.y);\n        limitY = Math.max(this.limitWindow.maxPointer.y, limitY);\n        var limitX = Math.min(this.eventClient(mouseEvent).X, this.limitWindow.minPointer.x);\n        limitX = Math.max(this.limitWindow.maxPointer.x, limitX); // Substract limit with first position to obtain relative pixels increment to the anchor point.\n\n        var dragX = limitX - this.dragDataObject.x + \"px\";\n        var dragY = limitY - this.dragDataObject.y + \"px\"; // Save last valid position of modal before window overflow.\n\n        this.lastDrag = {\n          x: dragX,\n          y: dragY\n        }; // This move modal with hadware acceleration.\n\n        this.container.style.transform = \"translate3d(\" + dragX + \",\" + dragY + \",0)\";\n      }\n\n      if (this.resizeDataObject) {\n        var limitX = Math.min(this.eventClient(mouseEvent).X, window.innerWidth - this.scrollbarWidth - 7);\n        var limitY = Math.min(this.eventClient(mouseEvent).Y, window.innerHeight - 7);\n\n        if (limitX < 0) {\n          limitX = 0;\n        }\n\n        if (limitY < 0) {\n          limitY = 0;\n        }\n\n        var scaleMultiplier;\n\n        if (this.leftScale) {\n          scaleMultiplier = -1;\n        } else {\n          scaleMultiplier = 1;\n        }\n\n        this.container.style.width = this.initialWidth + scaleMultiplier * (limitX - this.resizeDataObject.x) + 'px';\n        this.container.style.height = this.initialHeight + scaleMultiplier * (limitY - this.resizeDataObject.y) + 'px';\n\n        if (!this.leftScale) {\n          if (this.resizeDataObject.x - limitX - this.initialWidth < -580) {\n            this.container.style.right = this.initialRight - (limitX - this.resizeDataObject.x) + 'px';\n          } else {\n            this.container.style.right = this.initialRight + this.initialWidth - 580 + \"px\";\n            this.container.style.width = \"580px\";\n          }\n\n          if (this.resizeDataObject.y - limitY < this.initialHeight - 338) {\n            this.container.style.bottom = this.initialBottom - (limitY - this.resizeDataObject.y) + 'px';\n          } else {\n            this.container.style.bottom = this.initialBottom + this.initialHeight - 338 + \"px\";\n            this.container.style.height = \"338px\";\n          }\n        }\n\n        this.recalculateScale();\n        this.recalculatePosition();\n      }\n    }\n    /**\r\n     * Returns the boundaries of actual window to limit modal movement.\r\n     * @return {Object} Object containing mouseX and mouseY coordinates of actual mouse on screen.\r\n     */\n\n  }, {\n    key: \"getLimitWindow\",\n    value: function getLimitWindow() {\n      // Obtain dimensions of window page.\n      var maxWidth = window.innerWidth;\n      var maxHeight = window.innerHeight; // Calculate relative position of mouse point into window.\n\n      var offSetToolbarY = this.container.offsetHeight + parseInt(this.container.style.bottom) - (maxHeight - (this.dragDataObject.y - window.pageXOffset));\n      var offSetToolbarX = maxWidth - this.scrollbarWidth - (this.dragDataObject.x - window.pageXOffset) - parseInt(this.container.style.right); // Calculate limits with sizes of window, modal and mouse position.\n\n      var minPointerY = maxHeight - this.container.offsetHeight + offSetToolbarY;\n      var maxPointerY = this.title.offsetHeight - (this.title.offsetHeight - offSetToolbarY);\n      var minPointerX = maxWidth - offSetToolbarX - this.scrollbarWidth;\n      var maxPointerX = this.container.offsetWidth - offSetToolbarX;\n      var minPointer = {\n        x: minPointerX,\n        y: minPointerY\n      };\n      var maxPointer = {\n        x: maxPointerX,\n        y: maxPointerY\n      };\n      return {\n        minPointer: minPointer,\n        maxPointer: maxPointer\n      };\n    }\n    /**\r\n     * Returns the scrollbar width size of browser\r\n     * @returns {number} the scrollbar width.\r\n     */\n\n  }, {\n    key: \"getScrollBarWidth\",\n    value: function getScrollBarWidth() {\n      // Create a paragraph with full width of page.\n      var inner = document.createElement('p');\n      inner.style.width = \"100%\";\n      inner.style.height = \"200px\"; // Create a hidden div to compare sizes.\n\n      var outer = document.createElement('div');\n      outer.style.position = \"absolute\";\n      outer.style.top = \"0px\";\n      outer.style.left = \"0px\";\n      outer.style.visibility = \"hidden\";\n      outer.style.width = \"200px\";\n      outer.style.height = \"150px\";\n      outer.style.overflow = \"hidden\";\n      outer.appendChild(inner);\n      document.body.appendChild(outer);\n      var widthOuter = inner.offsetWidth; // Change type overflow of paragraph for measure scrollbar.\n\n      outer.style.overflow = 'scroll';\n      var widthInner = inner.offsetWidth; // If measure is the same, we compare with internal div.\n\n      if (widthOuter == widthInner) {\n        widthInner = outer.clientWidth;\n      }\n\n      document.body.removeChild(outer);\n      return widthOuter - widthInner;\n    }\n    /**\r\n     * Set the dragDataObject to null.\r\n     */\n\n  }, {\n    key: \"stopDrag\",\n    value: function stopDrag() {\n      // Due to we have multiple events that call this function, we need only to execute the next modifiers one time,\n      // when the user stops to drag and dragDataObject is not null (the object to drag is attached).\n      if (this.dragDataObject || this.resizeDataObject) {\n        // If modal doesn't change, it's not necessary to set position with interpolation\n        this.container.style.transform = '';\n\n        if (this.dragDataObject) {\n          this.container.style.right = parseInt(this.container.style.right) - parseInt(this.lastDrag.x) + \"px\";\n          this.container.style.bottom = parseInt(this.container.style.bottom) - parseInt(this.lastDrag.y) + \"px\";\n        } // We make focus on editor after drag modal windows to prevent lose focus.\n\n\n        this.focus(); // Restore mouse events on iframe\n        // this.iframe.style['pointer-events'] = 'auto';\n\n        document.body.style['user-select'] = ''; // Restore static state of iframe if we use Internet Explorer.\n\n        if (this.isIE11()) {} // this.iframe.style['position'] = null;\n        // Active text select event\n\n\n        _util_js__WEBPACK_IMPORTED_MODULE_2__[\"default\"].removeClass(document.body, 'wrs_noselect');\n        _util_js__WEBPACK_IMPORTED_MODULE_2__[\"default\"].removeClass(this.overlay, 'wrs_overlay_active');\n      }\n\n      this.dragDataObject = null;\n      this.resizeDataObject = null;\n      this.initialWidth = null;\n      this.leftScale = null;\n    }\n    /**\r\n     * Recalculates scale for modal when resize browser window.\r\n     */\n\n  }, {\n    key: \"onWindowResize\",\n    value: function onWindowResize() {\n      this.recalculateScrollBar();\n      this.recalculatePosition();\n      this.recalculateScale();\n    }\n    /**\r\n     * Triggers keyboard events:\r\n     * - Tab key tab to go to submit button.\r\n     * - Esc key to close the modal dialog.\r\n     * @param {KeyboardEvent} keyboardEvent - the keyboard event.\r\n     */\n\n  }, {\n    key: \"onKeyDown\",\n    value: function onKeyDown(keyboardEvent) {\n      if (keyboardEvent.key !== undefined && keyboardEvent.repeat === false) {\n        // Code for detect Esc event\n        if (keyboardEvent.key === \"Escape\" || keyboardEvent.key === 'Esc') {\n          if (this.properties.open) {\n            this.cancelAction();\n          }\n        } // Code for detect Tab event\n\n\n        if (keyboardEvent.key === \"Tab\") {\n          this.submitButton.focus();\n          keyboardEvent.preventDefault();\n        }\n      }\n    }\n    /**\r\n     * Recalculating position for modal dialog when the browser is resized.\r\n     */\n\n  }, {\n    key: \"recalculatePosition\",\n    value: function recalculatePosition() {\n      this.container.style.right = Math.min(parseInt(this.container.style.right), window.innerWidth - this.scrollbarWidth - this.container.offsetWidth) + \"px\";\n\n      if (parseInt(this.container.style.right) < 0) {\n        this.container.style.right = \"0px\";\n      }\n\n      this.container.style.bottom = Math.min(parseInt(this.container.style.bottom), window.innerHeight - this.container.offsetHeight) + \"px\";\n\n      if (parseInt(this.container.style.bottom) < 0) {\n        this.container.style.bottom = \"0px\";\n      }\n    }\n    /**\r\n     * Recalculating scale for modal when the browser is resized.\r\n     */\n\n  }, {\n    key: \"recalculateScale\",\n    value: function recalculateScale() {\n      var sizeModificated = false;\n\n      if (parseInt(this.container.style.width) > 580) {\n        this.container.style.width = Math.min(parseInt(this.container.style.width), window.innerWidth - this.scrollbarWidth) + \"px\";\n        sizeModificated = true;\n      } else {\n        this.container.style.width = \"580px\";\n        sizeModificated = true;\n      }\n\n      if (parseInt(this.container.style.height) > 338) {\n        this.container.style.height = Math.min(parseInt(this.container.style.height), window.innerHeight) + \"px\";\n        sizeModificated = true;\n      } else {\n        this.container.style.height = \"338px\";\n        sizeModificated = true;\n      }\n\n      if (sizeModificated) {\n        this.recalculateSize();\n      }\n    }\n    /**\r\n     * Recalculating width of browser scroll bar.\r\n     */\n\n  }, {\n    key: \"recalculateScrollBar\",\n    value: function recalculateScrollBar() {\n      this.hasScrollBar = window.innerWidth > document.documentElement.clientWidth;\n\n      if (this.hasScrollBar) {\n        this.scrollbarWidth = this.getScrollBarWidth();\n      } else {\n        this.scrollbarWidth = 0;\n      }\n    }\n    /**\r\n     * Hide soft keyboards on iOS devices.\r\n     */\n\n  }, {\n    key: \"hideKeyboard\",\n    value: function hideKeyboard() {\n      document.activeElement.blur();\n    }\n    /**\r\n     * Focus to contentManager object.\r\n     */\n\n  }, {\n    key: \"focus\",\n    value: function focus() {\n      if (this.contentManager != null && typeof this.contentManager.onFocus !== 'undefined') {\n        this.contentManager.onFocus();\n      }\n    }\n    /**\r\n     * Returns true when the device is on portrait mode.\r\n     */\n\n  }, {\n    key: \"portraitMode\",\n    value: function portraitMode() {\n      return window.innerHeight > window.innerWidth;\n    }\n    /**\r\n     * Event handler that change container size when IOS softkeyboard is opened.\r\n     */\n\n  }, {\n    key: \"handleOpenedIosSoftkeyboard\",\n    value: function handleOpenedIosSoftkeyboard() {\n      if (!this.iosSoftkeyboardOpened && this.iosDivHeight != null && this.iosDivHeight == \"100\" + this.iosMeasureUnit) {\n        if (this.portraitMode()) {\n          this.setContainerHeight(\"63\" + this.iosMeasureUnit);\n        } else {\n          this.setContainerHeight(\"40\" + this.iosMeasureUnit);\n        }\n      }\n\n      this.iosSoftkeyboardOpened = true;\n    }\n    /**\r\n     * Event handler that change container size when IOS softkeyboard is closed.\r\n     */\n\n  }, {\n    key: \"handleClosedIosSoftkeyboard\",\n    value: function handleClosedIosSoftkeyboard() {\n      this.iosSoftkeyboardOpened = false;\n      this.setContainerHeight(\"100\" + this.iosMeasureUnit);\n    }\n    /**\r\n     * Change container sizes when orientation is changed on iOS.\r\n     */\n\n  }, {\n    key: \"orientationChangeIosSoftkeyboard\",\n    value: function orientationChangeIosSoftkeyboard() {\n      if (this.iosSoftkeyboardOpened) {\n        if (this.portraitMode()) {\n          this.setContainerHeight(\"63\" + this.iosMeasureUnit);\n        } else {\n          this.setContainerHeight(\"40\" + this.iosMeasureUnit);\n        }\n      } else {\n        this.setContainerHeight(\"100\" + this.iosMeasureUnit);\n      }\n    }\n    /**\r\n     * Change container sizes when orientation is changed on Android.\r\n     */\n\n  }, {\n    key: \"orientationChangeAndroidSoftkeyboard\",\n    value: function orientationChangeAndroidSoftkeyboard() {\n      this.setContainerHeight(\"100%\");\n    }\n    /**\r\n     * Set iframe container height.\r\n     * @param {number} height - new height.\r\n     */\n\n  }, {\n    key: \"setContainerHeight\",\n    value: function setContainerHeight(height) {\n      this.iosDivHeight = height;\n      this.wrapper.style.height = height;\n    }\n    /**\r\n     * Check content of editor before close action.\r\n     */\n\n  }, {\n    key: \"showPopUpMessage\",\n    value: function showPopUpMessage() {\n      if (this.properties.state == 'minimized') {\n        this.stack();\n      }\n\n      this.popup.show();\n    }\n    /**\r\n     * Sets the tithle of the modal dialog.\r\n     * @param {string} title - modal dialog title.\r\n     */\n\n  }, {\n    key: \"setTitle\",\n    value: function setTitle(title) {\n      this.title.innerHTML = title;\n    }\n    /**\r\n     * Returns the id of an element, adding the instance number to\r\n     * the element class name:\r\n     * className --> className[idNumber]\r\n     * @param {string} className - the element class name.\r\n     * @returns {string} a string appending the instance id to the className.\r\n     */\n\n  }, {\n    key: \"getElementId\",\n    value: function getElementId(className) {\n      return className + \"[\" + this.instanceId + \"]\";\n    }\n  }]);\n\n  return ModalDialog;\n}();\n\n\n\n//# sourceURL=webpack:///./core/src/modal.js?");

/***/ }),

/***/ "./core/src/parser.js":
/*!****************************!*\
  !*** ./core/src/parser.js ***!
  \****************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return Parser; });\n/* harmony import */ var _util__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./util */ \"./core/src/util.js\");\n/* harmony import */ var _core_src__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./core.src */ \"./core/src/core.src.js\");\n/* harmony import */ var _latex__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./latex */ \"./core/src/latex.js\");\n/* harmony import */ var _mathml__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./mathml */ \"./core/src/mathml.js\");\n/* harmony import */ var _image__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./image */ \"./core/src/image.js\");\n/* harmony import */ var _accessibility__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./accessibility */ \"./core/src/accessibility.js\");\n/* harmony import */ var _serviceprovider__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./serviceprovider */ \"./core/src/serviceprovider.js\");\n/* harmony import */ var _configuration__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./configuration */ \"./core/src/configuration.js\");\n/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./constants */ \"./core/src/constants.js\");\n/* harmony import */ var _md5__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./md5 */ \"./core/src/md5.js\");\nfunction _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError(\"Cannot call a class as a function\"); } }\n\nfunction _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if (\"value\" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }\n\nfunction _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }\n\n\n\n\n\n\n\n\n\n\n\n/**\r\n * This class represent a MahML parser. Converts MathML into formulas depending on the\r\n * image format (SVG, PNG, base64) and the save mode (XML, safeXML, Image) configured in the backend.\r\n */\n\nvar Parser =\n/*#__PURE__*/\nfunction () {\n  function Parser() {\n    _classCallCheck(this, Parser);\n  }\n\n  _createClass(Parser, null, [{\n    key: \"mathmlToImgObject\",\n\n    /**\r\n     * Converts a MathML string to an img element.\r\n     * @param {Document} creator - Document object to call createElement method.\r\n     * @param {string} mathml - MathML code\r\n     * @param {Object[]} wirisProperties - object containing WIRIS custom properties\r\n     * @param {language} language - custom language for accessibility.\r\n     * @returns {HTMLImageElement} the formula image corresponding to initial MathML string.\r\n     * @static\r\n     */\n    value: function mathmlToImgObject(creator, mathml, wirisProperties, language) {\n      var width;\n      var height;\n      var baseline;\n      var imgObject = creator.createElement('img');\n      imgObject.align = 'middle';\n      imgObject.style.maxWidth = 'none';\n      var data = wirisProperties ? wirisProperties : {};\n      data['mml'] = mathml;\n      data['lang'] = language; // Request metrics of the generated image.\n\n      data['metrics'] = 'true';\n      data['centerbaseline'] = 'false'; // Full base64 method (edit & save).\n\n      if (_configuration__WEBPACK_IMPORTED_MODULE_7__[\"default\"].get('saveMode') == 'base64' && _configuration__WEBPACK_IMPORTED_MODULE_7__[\"default\"].get('editMode') == 'default') {\n        data['base64'] = true;\n      } // Render js params: _wrs_int_wirisProperties contains some js render params. Since mathml can support render params, js params should be send only to editor, not to render.\n\n\n      imgObject.className = _configuration__WEBPACK_IMPORTED_MODULE_7__[\"default\"].get('imageClassName');\n\n      if (mathml.indexOf('class=\"') != -1) {\n        // We check here if the MathML has been created from a customEditor (such chemistry)\n        // to add data-custom-editor attribute to img object (if necessary).\n        var mathmlSubstring = mathml.substring(mathml.indexOf('class=\"') + 'class=\"'.length, mathml.length);\n        mathmlSubstring = mathmlSubstring.substring(0, mathmlSubstring.indexOf('\"'));\n        mathmlSubstring = mathmlSubstring.substring(4, mathmlSubstring.length);\n        imgObject.setAttribute('data-custom-editor', mathmlSubstring);\n      } // Performance enabled.\n\n\n      if (_configuration__WEBPACK_IMPORTED_MODULE_7__[\"default\"].get('wirisPluginPerformance') && (_configuration__WEBPACK_IMPORTED_MODULE_7__[\"default\"].get('saveMode') == 'xml' || _configuration__WEBPACK_IMPORTED_MODULE_7__[\"default\"].get('saveMode') == 'safeXml')) {\n        var result = JSON.parse(Parser.createShowImageSrc(data, language));\n\n        if (result[\"status\"] == 'warning') {\n          // POST call.\n          // if the mathml is malformed, this function will throw an exception.\n          try {\n            result = JSON.parse(_serviceprovider__WEBPACK_IMPORTED_MODULE_6__[\"default\"].getService('showimage', data));\n          } catch (e) {\n            return;\n          }\n        }\n\n        result = result.result;\n\n        if (result['format'] == 'png') {\n          imgObject.src = 'data:image/png;base64,' + result['content'];\n        } else {\n          imgObject.src = 'data:image/svg+xml;charset=utf8,' + _util__WEBPACK_IMPORTED_MODULE_0__[\"default\"].urlEncode(result['content']);\n        }\n\n        imgObject.setAttribute(_configuration__WEBPACK_IMPORTED_MODULE_7__[\"default\"].get('imageMathmlAttribute'), _mathml__WEBPACK_IMPORTED_MODULE_3__[\"default\"].safeXmlEncode(mathml));\n        _image__WEBPACK_IMPORTED_MODULE_4__[\"default\"].setImgSize(imgObject, result['content'], true);\n\n        if (_configuration__WEBPACK_IMPORTED_MODULE_7__[\"default\"].get('enableAccessibility')) {\n          if (typeof result.alt == 'undefined') {\n            imgObject.alt = _accessibility__WEBPACK_IMPORTED_MODULE_5__[\"default\"].mathMLToAccessible(mathml, language, data);\n          } else {\n            imgObject.alt = result.alt;\n          }\n        }\n      } else {\n        var result = Parser.createImageSrc(mathml, data);\n        imgObject.setAttribute(_configuration__WEBPACK_IMPORTED_MODULE_7__[\"default\"].get('imageMathmlAttribute'), _mathml__WEBPACK_IMPORTED_MODULE_3__[\"default\"].safeXmlEncode(mathml));\n        imgObject.src = result;\n        _image__WEBPACK_IMPORTED_MODULE_4__[\"default\"].setImgSize(imgObject, result, _configuration__WEBPACK_IMPORTED_MODULE_7__[\"default\"].get('saveMode') == 'base64' && _configuration__WEBPACK_IMPORTED_MODULE_7__[\"default\"].get('editMode') == 'default' ? true : false);\n\n        if (_configuration__WEBPACK_IMPORTED_MODULE_7__[\"default\"].get('enableAccessibility')) {\n          imgObject.alt = _accessibility__WEBPACK_IMPORTED_MODULE_5__[\"default\"].mathMLToAccessible(mathml, language, data);\n        }\n      }\n\n      if (typeof Parser.observer != 'undefined') {\n        Parser.observer.observe(imgObject);\n      } // Role math https://www.w3.org/TR/wai-aria/roles#math.\n\n\n      imgObject.setAttribute('role', 'math');\n      return imgObject;\n    }\n    /**\r\n     * Returns the source to showimage service by calling createimage service. The\r\n     * output of the createimage service is a URL path pointing to showimage service.\r\n     * This method is called when performance is disabled.\r\n     * @param {string} mathml - MathML code.\r\n     * @param {Object[]} data - data object containing service parameters.\r\n     * @returns {string} the showimage path.\r\n     */\n\n  }, {\n    key: \"createImageSrc\",\n    value: function createImageSrc(mathml, data) {\n      // Full base64 method (edit & save).\n      if (_configuration__WEBPACK_IMPORTED_MODULE_7__[\"default\"].get('saveMode') == 'base64' && _configuration__WEBPACK_IMPORTED_MODULE_7__[\"default\"].get('editMode') == 'default') {\n        data['base64'] = true;\n      }\n\n      var result = _serviceprovider__WEBPACK_IMPORTED_MODULE_6__[\"default\"].getService('createimage', data);\n\n      if (result.indexOf('@BASE@') != -1) {\n        // Replacing '@BASE@' with the base URL of createimage.\n        var baseParts = _core_src__WEBPACK_IMPORTED_MODULE_1__[\"default\"].getServiceProvider().getServicePath('createimage').split('/');\n        baseParts.pop();\n        result = result.split('@BASE@').join(baseParts.join('/'));\n      }\n\n      return result;\n    }\n    /**\r\n     * Parses initial HTML code. If the HTML contains data generated by WIRIS, this data would be converted as following:\r\n     * <pre>\r\n     * MathML code: Image containing the corresponding MathML formulas.\r\n     * MathML code with LaTeX annotation : LaTeX string.\r\n     * </pre>\r\n     * @param {string} code - HTML code containing MathML data.\r\n     * @param {string} language - language to create image alt text.\r\n     * @returns {string} HTML code with the original MathML converted into LaTeX and images.\r\n     */\n\n  }, {\n    key: \"initParse\",\n    value: function initParse(code, language) {\n      /* Note: The code inside this function has been inverted.\r\n      If you invert again the code then you cannot use correctly LaTeX\r\n      in Moodle.\r\n      */\n      code = Parser.initParseSaveMode(code, language);\n      return Parser.initParseEditMode(code);\n    }\n    /**\r\n     * Parses initial HTML code depending on the save mode. Transforms all MathML\r\n     * occurrences for it's correspondent image or LaTeX.\r\n     * @param {string} code - HTML code to be parsed\r\n     * @param {string} language - language to create image alt text.\r\n     * @returns {string} HTML code parsed.\r\n     */\n\n  }, {\n    key: \"initParseSaveMode\",\n    value: function initParseSaveMode(code, language) {\n      if (_configuration__WEBPACK_IMPORTED_MODULE_7__[\"default\"].get('saveMode')) {\n        // Converting XML to tags.\n        code = _latex__WEBPACK_IMPORTED_MODULE_2__[\"default\"].parseMathmlToLatex(code, _constants__WEBPACK_IMPORTED_MODULE_8__[\"default\"].safeXmlCharacters);\n        code = _latex__WEBPACK_IMPORTED_MODULE_2__[\"default\"].parseMathmlToLatex(code, _constants__WEBPACK_IMPORTED_MODULE_8__[\"default\"].xmlCharacters); // Safe XML and XML must be parsed regardeless of save mode.\n        // Order is important here, safeXml must be parsed first in order to avoid conflicts with data-mathml img attribute.\n\n        code = Parser.parseSafeAppletsToObjects(code);\n        code = Parser.parseMathmlToImg(code, _constants__WEBPACK_IMPORTED_MODULE_8__[\"default\"].safeXmlCharacters, language);\n        code = Parser.parseMathmlToImg(code, _constants__WEBPACK_IMPORTED_MODULE_8__[\"default\"].xmlCharacters, language);\n\n        if (_configuration__WEBPACK_IMPORTED_MODULE_7__[\"default\"].get('saveMode') == 'base64' && _configuration__WEBPACK_IMPORTED_MODULE_7__[\"default\"].get('editMode') == 'image') {\n          code = Parser.codeImgTransform(code, 'base642showimage');\n        }\n      }\n\n      var appletList = _util__WEBPACK_IMPORTED_MODULE_0__[\"default\"].getElementsByNameFromString(code, 'applet', false);\n      var carry = 0; // While replacing applets with images, the indexes of the found applets changes respecting the original code, so this carry is needed.\n\n      for (var i = 0; i < appletList.length; ++i) {\n        var appletCode = code.substring(appletList[i].start + carry, appletList[i].end + carry); // The second control in the if is used to find WIRIS applet which don't have Wiriscas class (as it was in old CAS applets).\n\n        if (appletCode.indexOf(' class=\"' + _configuration__WEBPACK_IMPORTED_MODULE_7__[\"default\"].get('CASClassName') + '\"') != -1 || appletCode.toUpperCase().indexOf('WIRIS') != -1) {\n          if (appletCode.indexOf(' src=\"') != -1) {\n            var srcStart = appletCode.indexOf(' src=\"') + ' src=\"'.length;\n            var srcEnd = appletCode.indexOf('\"', srcStart);\n            var src = appletCode.substring(srcStart, srcEnd);\n          } else {\n            // This should happen only with old CAS imported from Moodle 1 to Moodle 2.\n            if (typeof _wrs_conf_pluginBasePath != 'undefined') {\n              var src = _wrs_conf_pluginBasePath + '/integration/showcasimage.php?formula=noimage';\n            } else {\n              var src = '';\n            }\n\n            if (appletCode.indexOf(' class=\"' + _configuration__WEBPACK_IMPORTED_MODULE_7__[\"default\"].get('CASClassName') + '\"') == -1) {\n              var closeSymbol = appletCode.indexOf('>');\n              var appletTag = appletCode.substring(0, closeSymbol);\n              var newAppletTag = appletTag.split(' width=').join(' class=\"Wiriscas\" width=');\n              appletCode = appletCode.split(appletTag).join(newAppletTag);\n              appletCode = appletCode.split('\\'').join('\"');\n            }\n          } // Double click to edit has been removed here.\n\n\n          var imgCode = '<img align=\"middle\" class=\"' + _configuration__WEBPACK_IMPORTED_MODULE_7__[\"default\"].get('CASClassName') + '\" ' + _configuration__WEBPACK_IMPORTED_MODULE_7__[\"default\"].get('CASMathmlAttribute') + '=\"' + _mathml__WEBPACK_IMPORTED_MODULE_3__[\"default\"].safeXmlEncode(appletCode) + '\" src=\"' + src + '\" />';\n          code = code.substring(0, appletList[i].start + carry) + imgCode + code.substring(appletList[i].end + carry);\n          carry += imgCode.length - (appletList[i].end - appletList[i].start);\n        }\n      }\n\n      return code;\n    }\n    /**\r\n     * Parses initial HTML code depending on the edit mode.\r\n     * If 'latex' parseMode is enabled all MathML containing an annotation with encoding='LaTeX' will\r\n     * be converted into a LaTeX string instead of an image.\r\n     * @param {string} code - HTML code containing MathML.\r\n     * @returns {string} parsed HTML code.\r\n     */\n\n  }, {\n    key: \"initParseEditMode\",\n    value: function initParseEditMode(code) {\n      if (_configuration__WEBPACK_IMPORTED_MODULE_7__[\"default\"].get('parseModes').indexOf('latex') != -1) {\n        var imgList = _util__WEBPACK_IMPORTED_MODULE_0__[\"default\"].getElementsByNameFromString(code, 'img', true);\n        var token = 'encoding=\"LaTeX\">';\n        var carry = 0;\n        4; // While replacing images with latex, the indexes of the found images changes respecting the original code, so this carry is needed.\n\n        for (var i = 0; i < imgList.length; ++i) {\n          var imgCode = code.substring(imgList[i].start + carry, imgList[i].end + carry);\n\n          if (imgCode.indexOf(' class=\"' + _configuration__WEBPACK_IMPORTED_MODULE_7__[\"default\"].get('imageClassName') + '\"') != -1) {\n            var mathmlStartToken = ' ' + _configuration__WEBPACK_IMPORTED_MODULE_7__[\"default\"].get('imageMathmlAttribute') + '=\"';\n            var mathmlStart = imgCode.indexOf(mathmlStartToken);\n\n            if (mathmlStart == -1) {\n              mathmlStartToken = ' alt=\"';\n              mathmlStart = imgCode.indexOf(mathmlStartToken);\n            }\n\n            if (mathmlStart != -1) {\n              mathmlStart += mathmlStartToken.length;\n              var mathmlEnd = imgCode.indexOf('\"', mathmlStart);\n              var mathml = _mathml__WEBPACK_IMPORTED_MODULE_3__[\"default\"].safeXmlDecode(imgCode.substring(mathmlStart, mathmlEnd));\n              var latexStartPosition = mathml.indexOf(token);\n\n              if (latexStartPosition != -1) {\n                latexStartPosition += token.length;\n                var latexEndPosition = mathml.indexOf('</annotation>', latexStartPosition);\n                var latex = mathml.substring(latexStartPosition, latexEndPosition);\n                var replaceText = '$$' + _util__WEBPACK_IMPORTED_MODULE_0__[\"default\"].htmlEntitiesDecode(latex) + '$$';\n                code = code.substring(0, imgList[i].start + carry) + replaceText + code.substring(imgList[i].end + carry);\n                carry += replaceText.length - (imgList[i].end - imgList[i].start);\n              }\n            }\n          }\n        }\n      }\n\n      return code;\n    }\n    /**\r\n     * Parses end HTML code. The end HTML code is HTML code with embedded images or LaTeX formulas created with MathType. <br>\r\n     * By default this method converts the formula images and LaTeX strings in MathML. <br>\r\n     * If image mode is enabled the images will not be converted into MathML. For further information see {@link http://www.wiris.com/plugins/docs/full-mathml-mode}.\r\n     * @param {string} code - HTML to be parsed\r\n     * @returns {string} the HTML code parsed.\r\n     */\n\n  }, {\n    key: \"endParse\",\n    value: function endParse(code) {\n      // Transform LaTeX ocurrences to MathML elements.\n      var codeEndParsedEditMode = Parser.endParseEditMode(code); // Transform img elements to MathML elements.\n\n      var codeEndParseSaveMode = Parser.endParseSaveMode(codeEndParsedEditMode);\n      return codeEndParseSaveMode;\n    }\n    /**\r\n     * Parses end HTML code depending on the edit mode.\r\n     * - LaTeX is an enabled parse mode, all LaTeX occurrences will be converted into MathML.\r\n     * @param {string} code - HTML code to be parsed.\r\n     * @returns {string} HTML code parsed.\r\n     */\n\n  }, {\n    key: \"endParseEditMode\",\n    value: function endParseEditMode(code) {\n      // Converting LaTeX to images.\n      if (_configuration__WEBPACK_IMPORTED_MODULE_7__[\"default\"].get('parseModes').indexOf('latex') != -1) {\n        var output = '';\n        var endPosition = 0;\n        var startPosition = code.indexOf('$$');\n\n        while (startPosition != -1) {\n          output += code.substring(endPosition, startPosition);\n          endPosition = code.indexOf('$$', startPosition + 2);\n\n          if (endPosition != -1) {\n            // Before, it was a condition here to execute the next codelines 'latex.indexOf('<') == -1'.\n            // We don't know why it was used, but seems to have a conflict with latex formulas that contains '<'.\n            var latex = code.substring(startPosition + 2, endPosition);\n            var decodedLatex = _util__WEBPACK_IMPORTED_MODULE_0__[\"default\"].htmlEntitiesDecode(latex);\n            var mathml = _latex__WEBPACK_IMPORTED_MODULE_2__[\"default\"].getMathMLFromLatex(decodedLatex, true);\n\n            if (!_configuration__WEBPACK_IMPORTED_MODULE_7__[\"default\"].get('saveHandTraces')) {\n              // Remove hand traces.\n              mathml = _mathml__WEBPACK_IMPORTED_MODULE_3__[\"default\"].removeAnnotation(mathml, 'application/json');\n            }\n\n            output += mathml;\n            endPosition += 2;\n          } else {\n            output += '$$';\n            endPosition = startPosition + 2;\n          }\n\n          startPosition = code.indexOf('$$', endPosition);\n        }\n\n        output += code.substring(endPosition, code.length);\n        code = output;\n      }\n\n      return code;\n    }\n    /**\r\n     * Parses end HTML code depending on the save mode. Converts all\r\n     * images into the element determined by the save mode:\r\n     * - xml: Parses images formulas into MathML.\r\n     * - safeXml: Parses images formulas into safeMAthML\r\n     * - base64: Parses images into base64 images.\r\n     * - image: Parse images into images (no parsing)\r\n     * @param {string} code - HTML code to be parsed\r\n     * @returns {string} HTML code parsed.\r\n     */\n\n  }, {\n    key: \"endParseSaveMode\",\n    value: function endParseSaveMode(code) {\n      if (_configuration__WEBPACK_IMPORTED_MODULE_7__[\"default\"].get('saveMode')) {\n        if (_configuration__WEBPACK_IMPORTED_MODULE_7__[\"default\"].get('saveMode') == 'safeXml') {\n          code = Parser.codeImgTransform(code, 'img2mathml');\n        } else if (_configuration__WEBPACK_IMPORTED_MODULE_7__[\"default\"].get('saveMode') == 'xml') {\n          code = Parser.codeImgTransform(code, 'img2mathml');\n        } else if (_configuration__WEBPACK_IMPORTED_MODULE_7__[\"default\"].get('saveMode') == 'base64' && _configuration__WEBPACK_IMPORTED_MODULE_7__[\"default\"].get('editMode') == 'image') {\n          code = Parser.codeImgTransform(code, 'img264');\n        }\n      }\n\n      return code;\n    }\n    /**\r\n     * Returns the result to call showimage service with the formula md5 as parameter.\r\n     *  The result could be:\r\n     * - {'status' : warning'} : The image associated to the MathML md5 is not in cache.\r\n     * - {'status' : 'ok' ...} : The image associated to the MathML md5 is in cache.\r\n     * @param {Object[]} data - object containing showimage service parameters.\r\n     * @param {string} language - string containing the language of the formula.\r\n     * @returns {Object} JSON object containing showimage response.\r\n     */\n\n  }, {\n    key: \"createShowImageSrc\",\n    value: function createShowImageSrc(data, language) {\n      var dataMd5 = [];\n      var renderParams = 'mml,color,centerbaseline,zoom,dpi,fontSize,fontFamily,defaultStretchy,backgroundColor,format';\n      var renderParamsArray = renderParams.split(',');\n\n      for (var key in renderParamsArray) {\n        var param = renderParamsArray[key];\n\n        if (typeof data[param] != 'undefined') {\n          dataMd5[param] = data[param];\n        }\n      } // Data variables to get.\n\n\n      var dataObject = {};\n\n      for (var key in data) {\n        // We don't need mathml in this request we try to get cached so we only need the formula md5 calculated before.\n        if (key != 'mml') {\n          dataObject[key] = data[key];\n        }\n      }\n\n      dataObject.formula = com.wiris.js.JsPluginTools.md5encode(_util__WEBPACK_IMPORTED_MODULE_0__[\"default\"].propertiesToString(dataMd5));\n      dataObject.lang = typeof language == 'undefined' ? 'en' : language;\n      dataObject.version = _configuration__WEBPACK_IMPORTED_MODULE_7__[\"default\"].get('version');\n      var result = _serviceprovider__WEBPACK_IMPORTED_MODULE_6__[\"default\"].getService('showimage', _util__WEBPACK_IMPORTED_MODULE_0__[\"default\"].httpBuildQuery(dataObject), true);\n      return result;\n    }\n    /**\r\n     * Transform html img tags inside a html code to mathml, base64 img tags (i.e with base64 on src) or showimage img tags (i.e with showimage.php on src)\r\n     * @param  {string} code - HTML code\r\n     * @param  {string} mode - base642showimage or img2mathml or img264 transform.\r\n     * @returns {string} html - code transformed.\r\n     */\n\n  }, {\n    key: \"codeImgTransform\",\n    value: function codeImgTransform(code, mode) {\n      var output = '';\n      var endPosition = 0;\n      var pattern = /<img/gi;\n      var patternLength = pattern.source.length;\n\n      while (pattern.test(code)) {\n        var startPosition = pattern.lastIndex - patternLength;\n        output += code.substring(endPosition, startPosition);\n        var i = startPosition + 1;\n\n        while (i < code.length && endPosition <= startPosition) {\n          var character = code.charAt(i);\n\n          if (character == '\"' || character == '\\'') {\n            var characterNextPosition = code.indexOf(character, i + 1);\n\n            if (characterNextPosition == -1) {\n              i = code.length; // End while.\n            } else {\n              i = characterNextPosition;\n            }\n          } else if (character == '>') {\n            endPosition = i + 1;\n          }\n\n          ++i;\n        }\n\n        if (endPosition < startPosition) {\n          // The img tag is stripped.\n          output += code.substring(startPosition, code.length);\n          return output;\n        }\n\n        var imgCode = code.substring(startPosition, endPosition);\n        var imgObject = _util__WEBPACK_IMPORTED_MODULE_0__[\"default\"].createObject(imgCode);\n        var xmlCode = imgObject.getAttribute(_configuration__WEBPACK_IMPORTED_MODULE_7__[\"default\"].get('imageMathmlAttribute'));\n        var convertToXml;\n        var convertToSafeXml;\n\n        if (mode == 'base642showimage') {\n          if (xmlCode == null) {\n            xmlCode = imgObject.getAttribute('alt');\n          }\n\n          xmlCode = _mathml__WEBPACK_IMPORTED_MODULE_3__[\"default\"].safeXmlDecode(xmlCode);\n          imgCode = Parser.mathmlToImgObject(document, xmlCode, null, null);\n          output += _util__WEBPACK_IMPORTED_MODULE_0__[\"default\"].createObjectCode(imgCode);\n        } else if (mode == 'img2mathml') {\n          if (_configuration__WEBPACK_IMPORTED_MODULE_7__[\"default\"].get('saveMode')) {\n            if (_configuration__WEBPACK_IMPORTED_MODULE_7__[\"default\"].get('saveMode') == 'safeXml') {\n              convertToXml = true;\n              convertToSafeXml = true;\n            } else if (_configuration__WEBPACK_IMPORTED_MODULE_7__[\"default\"].get('saveMode') == 'xml') {\n              convertToXml = true;\n              convertToSafeXml = false;\n            }\n          }\n\n          output += _util__WEBPACK_IMPORTED_MODULE_0__[\"default\"].getWIRISImageOutput(imgCode, convertToXml, convertToSafeXml);\n        } else if (mode == 'img264') {\n          if (xmlCode == null) {\n            xmlCode = imgObject.getAttribute('alt');\n          }\n\n          xmlCode = _mathml__WEBPACK_IMPORTED_MODULE_3__[\"default\"].safeXmlDecode(xmlCode);\n          var properties = {};\n          properties['base64'] = 'true';\n          imgCode = Parser.mathmlToImgObject(document, xmlCode, properties, null); // Metrics.\n\n          _image__WEBPACK_IMPORTED_MODULE_4__[\"default\"].setImgSize(imgCode, imgCode.src, true);\n          output += _util__WEBPACK_IMPORTED_MODULE_0__[\"default\"].createObjectCode(imgCode);\n        }\n      }\n\n      output += code.substring(endPosition, code.length);\n      return output;\n    }\n    /**\r\n     * Converts all occurrences of safe applet code to the corresponding code.\r\n     * @param {string} content - String containing valid applet code <APPLET>...</APPLET>\r\n     * @returns {string} content with all the applet code converted to safe tags.\r\n     */\n\n  }, {\n    key: \"parseSafeAppletsToObjects\",\n    value: function parseSafeAppletsToObjects(content) {\n      var output = '';\n      var appletTagBegin = _constants__WEBPACK_IMPORTED_MODULE_8__[\"default\"].safeXmlCharacters.tagOpener + 'APPLET';\n      var appletTagEnd = _constants__WEBPACK_IMPORTED_MODULE_8__[\"default\"].safeXmlCharacters.tagOpener + '/APPLET' + _constants__WEBPACK_IMPORTED_MODULE_8__[\"default\"].safeXmlCharacters.tagCloser;\n      var upperCaseContent = content.toUpperCase();\n      var start = upperCaseContent.indexOf(appletTagBegin);\n      var end = 0;\n      var applet;\n\n      while (start != -1) {\n        output += content.substring(end, start);\n        end = upperCaseContent.indexOf(appletTagEnd, start);\n\n        if (end == -1) {\n          end = content.length - 1;\n        } else {\n          end += appletTagEnd.length;\n        }\n\n        applet = _util__WEBPACK_IMPORTED_MODULE_0__[\"default\"].convertOldXmlinitialtextAttribute(content.substring(start, end));\n        output += _mathml__WEBPACK_IMPORTED_MODULE_3__[\"default\"].safeXmlDecode(applet);\n        start = upperCaseContent.indexOf(appletTagBegin, end);\n      }\n\n      output += content.substring(end, content.length);\n      return output;\n    }\n    /**\r\n     * Converts all occurrences of MathML to the corresponding image.\r\n     * @param {string} content - string with valid MathML code. The MathML code doesn't contain semantics.\r\n     * @param {Constants} characters - Constant object containing xmlCharacters or safeXmlCharacters relation.\r\n     * @param {string} language - a valid language code in order to generate formula accessibility.\r\n     * @returns {string} The input string with all the MathML occurrences replaced by the corresponding image.\r\n     */\n\n  }, {\n    key: \"parseMathmlToImg\",\n    value: function parseMathmlToImg(content, characters, language) {\n      var output = '';\n      var mathTagBegin = characters.tagOpener + 'math';\n      var mathTagEnd = characters.tagOpener + '/math' + characters.tagCloser;\n      var start = content.indexOf(mathTagBegin);\n      var end = 0;\n\n      while (start != -1) {\n        output += content.substring(end, start); // Avoid WIRIS images to be parsed.\n\n        var imageMathmlAtrribute = content.indexOf(_configuration__WEBPACK_IMPORTED_MODULE_7__[\"default\"].get('imageMathmlAttribute'));\n        end = content.indexOf(mathTagEnd, start);\n\n        if (end == -1) {\n          end = content.length - 1;\n        } else if (imageMathmlAtrribute != -1) {\n          // First close tag of img attribute\n          // If a mathmlAttribute exists should be inside a img tag.\n          end += content.indexOf(\"/>\", start);\n        } else {\n          end += mathTagEnd.length;\n        }\n\n        if (!_mathml__WEBPACK_IMPORTED_MODULE_3__[\"default\"].isMathmlInAttribute(content, start) && imageMathmlAtrribute == -1) {\n          var mathml = content.substring(start, end);\n          mathml = characters == _constants__WEBPACK_IMPORTED_MODULE_8__[\"default\"].safeXmlCharacters ? _mathml__WEBPACK_IMPORTED_MODULE_3__[\"default\"].safeXmlDecode(mathml) : _mathml__WEBPACK_IMPORTED_MODULE_3__[\"default\"].mathMLEntities(mathml);\n          output += _util__WEBPACK_IMPORTED_MODULE_0__[\"default\"].createObjectCode(Parser.mathmlToImgObject(document, mathml, null, language));\n        } else {\n          output += content.substring(start, end);\n        }\n\n        start = content.indexOf(mathTagBegin, end);\n      }\n\n      output += content.substring(end, content.length);\n      return output;\n    }\n  }]);\n\n  return Parser;\n}(); // Mutation observers to avoid wiris image formulas class be removed.\n\n\n\n\nif (typeof MutationObserver !== 'undefined') {\n  var mutationObserver = new MutationObserver(function (mutations) {\n    mutations.forEach(function (mutation) {\n      if (mutation.oldValue === _configuration__WEBPACK_IMPORTED_MODULE_7__[\"default\"].get('imageClassName') && mutation.attributeName === 'class' && mutation.target.className.indexOf(_configuration__WEBPACK_IMPORTED_MODULE_7__[\"default\"].get('imageClassName')) == -1) {\n        mutation.target.className = _configuration__WEBPACK_IMPORTED_MODULE_7__[\"default\"].get('imageClassName');\n      }\n    });\n  });\n  Parser.observer = Object.create(mutationObserver);\n  Parser.observer.Config = {\n    attributes: true,\n    attributeOldValue: true\n  }; // We use own default config.\n\n  Parser.observer.observe = function name(target) {\n    this.__proto__.observe(target, this.Config);\n  };\n}\n\n//# sourceURL=webpack:///./core/src/parser.js?");

/***/ }),

/***/ "./core/src/polyfills.js":
/*!*******************************!*\
  !*** ./core/src/polyfills.js ***!
  \*******************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\nvar polyfills;\n/* harmony default export */ __webpack_exports__[\"default\"] = (polyfills); // Polyfills.\n\n/*! http://mths.be/codepointat v0.1.0 by @mathias */\n\nif (!String.prototype.codePointAt) {\n  (function () {\n    'use strict'; // needed to support `apply`/`call` with `undefined`/`null`\n\n    var codePointAt = function codePointAt(position) {\n      if (this == null) {\n        throw TypeError();\n      }\n\n      var string = String(this);\n      var size = string.length; // `ToInteger`\n\n      var index = position ? Number(position) : 0;\n\n      if (index != index) {\n        // better `isNaN`\n        index = 0;\n      } // Account for out-of-bounds indices:\n\n\n      if (index < 0 || index >= size) {\n        return undefined;\n      } // Get the first code unit\n\n\n      var first = string.charCodeAt(index);\n      var second;\n\n      if ( // check if it’s the start of a surrogate pair\n      first >= 0xD800 && first <= 0xDBFF && // high surrogate\n      size > index + 1 // there is a next code unit\n      ) {\n          second = string.charCodeAt(index + 1);\n\n          if (second >= 0xDC00 && second <= 0xDFFF) {\n            // low surrogate\n            // http://mathiasbynens.be/notes/javascript-encoding#surrogate-formulae\n            return (first - 0xD800) * 0x400 + second - 0xDC00 + 0x10000;\n          }\n        }\n\n      return first;\n    };\n\n    if (Object.defineProperty) {\n      Object.defineProperty(String.prototype, 'codePointAt', {\n        'value': codePointAt,\n        'configurable': true,\n        'writable': true\n      });\n    } else {\n      String.prototype.codePointAt = codePointAt;\n    }\n  })();\n} // Object.assign polyfill.\n\n\nif (typeof Object.assign != 'function') {\n  // Must be writable: true, enumerable: false, configurable: true\n  Object.defineProperty(Object, \"assign\", {\n    value: function assign(target, varArgs) {\n      // .length of function is 2\n      'use strict';\n\n      if (target == null) {\n        // TypeError if undefined or null\n        throw new TypeError('Cannot convert undefined or null to object');\n      }\n\n      var to = Object(target);\n\n      for (var index = 1; index < arguments.length; index++) {\n        var nextSource = arguments[index];\n\n        if (nextSource != null) {\n          // Skip over if undefined or null\n          for (var nextKey in nextSource) {\n            // Avoid bugs when hasOwnProperty is shadowed\n            if (Object.prototype.hasOwnProperty.call(nextSource, nextKey)) {\n              to[nextKey] = nextSource[nextKey];\n            }\n          }\n        }\n      }\n\n      return to;\n    },\n    writable: true,\n    configurable: true\n  });\n}\n\n//# sourceURL=webpack:///./core/src/polyfills.js?");

/***/ }),

/***/ "./core/src/popupmessage.js":
/*!**********************************!*\
  !*** ./core/src/popupmessage.js ***!
  \**********************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return PopUpMessage; });\nfunction _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError(\"Cannot call a class as a function\"); } }\n\nfunction _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if (\"value\" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }\n\nfunction _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }\n\n/**\r\n * This class represents a dialog message overlaying a DOM element in order to\r\n * accept / cancel discard changes. The dialog can be closed i.e the overlay disappears\r\n * o canceled. In this last case a callback function should be called.\r\n */\nvar PopUpMessage =\n/*#__PURE__*/\nfunction () {\n  /**\r\n   *\r\n   * @param {Object} popupMessageAttributes - Object containing popup properties.\r\n   * @param {HTMLElement} popupMessageAttributes.overlayElement - Element to overlay.\r\n   * @param {Object} popupMessageAttributes.callbacks - contains callback methods for close and cancel actions.\r\n   * @param {Object} popupMessageAttributes.strings - contains all the strings needed.\r\n   */\n  function PopUpMessage(popupMessageAttributes) {\n    _classCallCheck(this, PopUpMessage);\n\n    /**\r\n     * Element to be overlaid when the popup appears.\r\n     */\n    this.overlayElement = popupMessageAttributes.overlayElement;\n    this.callbacks = popupMessageAttributes.callbacks;\n    /**\r\n     * HTMLElement element to wrap all HTML elements inside the popupMessage.\r\n     */\n\n    this.overlayWrapper = this.overlayElement.appendChild(document.createElement(\"div\"));\n    this.overlayWrapper.setAttribute(\"class\", \"wrs_popupmessage_overlay_envolture\");\n    /**\r\n     * HTMLElement to display the popup message, close button and cancel button.\r\n     */\n\n    this.message = this.overlayWrapper.appendChild(document.createElement(\"div\"));\n    this.message.id = \"wrs_popupmessage\";\n    this.message.setAttribute(\"class\", \"wrs_popupmessage_panel\");\n    this.message.innerHTML = popupMessageAttributes.strings.message;\n    /**\r\n     * HTML element overlaying the overlayElement.\r\n     */\n\n    var overlay = this.overlayWrapper.appendChild(document.createElement(\"div\"));\n    overlay.setAttribute(\"class\", \"wrs_popupmessage_overlay\"); // We create a overlay that close popup message on click in there\n\n    overlay.addEventListener(\"click\", this.cancelAction.bind(this));\n    /**\r\n     * HTML element containing cancel and close buttons.\r\n     */\n\n    this.buttonArea = this.message.appendChild(document.createElement('div'));\n    this.buttonArea.setAttribute(\"class\", \"wrs_popupmessage_button_area\");\n    this.buttonArea.id = 'wrs_popup_button_area'; // Close button arguments.\n\n    var buttonSubmitArguments = {\n      class: \"wrs_button_accept\",\n      innerHTML: popupMessageAttributes.strings.submitString,\n      id: 'wrs_popup_accept_button'\n    };\n    /**\r\n     * Close button arguments.\r\n     */\n\n    this.closeButton = this.createButton(buttonSubmitArguments, this.closeAction.bind(this));\n    this.buttonArea.appendChild(this.closeButton); // Cancel button arguments.\n\n    var buttonCancelArguments = {\n      class: \"wrs_button_cancel\",\n      innerHTML: popupMessageAttributes.strings.cancelString,\n      id: 'wrs_popup_cancel_button'\n    };\n    /**\r\n     * Cancel button.\r\n     */\n\n    this.cancelButton = this.createButton(buttonCancelArguments, this.cancelAction.bind(this));\n    this.buttonArea.appendChild(this.cancelButton);\n  }\n  /**\r\n   * This method create a button with arguments and return button dom object\r\n   * @param {Object} parameters - An object containing id, class and innerHTML button text.\r\n   * @param {string} parameters.id - button id.\r\n   * @param {string} parameters.class - button class name.\r\n   * @param {string} parameters.innerHTML - button innerHTML text.\r\n   * @param {object} callback- callback method to call on click event.\r\n   * @returns {HTMLElement} HTML button.\r\n   */\n\n\n  _createClass(PopUpMessage, [{\n    key: \"createButton\",\n    value: function createButton(parameters, callback) {\n      var element = {};\n      element = document.createElement(\"button\");\n      element.setAttribute(\"id\", parameters.id);\n      element.setAttribute(\"class\", parameters.class);\n      element.innerHTML = parameters.innerHTML;\n      element.addEventListener(\"click\", callback);\n      return element;\n    }\n    /**\r\n     * Shows the popupmessage containing a message, and two buttons\r\n     * to cancel the action or close the modal dialog.\r\n     */\n\n  }, {\n    key: \"show\",\n    value: function show() {\n      if (this.overlayWrapper.style.display != 'block') {\n        // Clear focus with blur for prevent press any key.\n        document.activeElement.blur(); // For works with Safari\n\n        window.focus();\n        this.overlayWrapper.style.display = 'block';\n      } else {\n        this.overlayWrapper.style.display = 'none';\n\n        _wrs_modalWindow.focus();\n      }\n    }\n    /**\r\n     * This method cancels the popupMessage: the dialog disappears revealing the overlaid element.\r\n     * A callback method is called (if defined). For example a method to focus the overlaid element.\r\n     */\n\n  }, {\n    key: \"cancelAction\",\n    value: function cancelAction() {\n      this.overlayWrapper.style.display = 'none';\n\n      if (typeof this.callbacks.cancelCallback !== 'undefined') {\n        this.callbacks.cancelCallback();\n      }\n    }\n    /**\r\n     * This method closes the popupMessage: the dialog disappears and the close callback is called.\r\n     * For example to close the overlaid element.\r\n     */\n\n  }, {\n    key: \"closeAction\",\n    value: function closeAction() {\n      this.cancelAction();\n\n      if (typeof this.callbacks.closeCallback !== 'undefined') {\n        this.callbacks.closeCallback();\n      }\n    }\n  }]);\n\n  return PopUpMessage;\n}();\n\n\n\n//# sourceURL=webpack:///./core/src/popupmessage.js?");

/***/ }),

/***/ "./core/src/serviceprovider.js":
/*!*************************************!*\
  !*** ./core/src/serviceprovider.js ***!
  \*************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return ServiceProvider; });\n/* harmony import */ var _util_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./util.js */ \"./core/src/util.js\");\nfunction _typeof(obj) { if (typeof Symbol === \"function\" && typeof Symbol.iterator === \"symbol\") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === \"function\" && obj.constructor === Symbol && obj !== Symbol.prototype ? \"symbol\" : typeof obj; }; } return _typeof(obj); }\n\nfunction _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError(\"Cannot call a class as a function\"); } }\n\nfunction _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if (\"value\" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }\n\nfunction _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }\n\n\n/**\r\n * Class representing a serviceProvider. A serviceProvider is a class containing\r\n * an arbitrary number of services with the correspondent path.\r\n */\n\nvar ServiceProvider =\n/*#__PURE__*/\nfunction () {\n  function ServiceProvider() {\n    _classCallCheck(this, ServiceProvider);\n  }\n\n  _createClass(ServiceProvider, null, [{\n    key: \"setServicePath\",\n\n    /**\r\n     * Adds a new service to the ServiceProvider.\r\n     * @param {string} service - service name.\r\n     * @param {string} path - service path.\r\n     * @static\r\n     */\n    value: function setServicePath(service, path) {\n      ServiceProvider.serVicePaths[service] = path;\n    }\n    /**\r\n     * Returns the service path for a certain service.\r\n     * @param {string} serviceName - service name\r\n     * @returns {string} the service path.\r\n     * @static\r\n     */\n\n  }, {\n    key: \"getServicePath\",\n    value: function getServicePath(serviceName) {\n      return ServiceProvider.serVicePaths[serviceName];\n    }\n    /**\r\n     * Gets the content from an URL.\r\n     * @param {string} url - target URL.\r\n     * @param {Object} postVariables - object containing post variables. null if a GET query should be done.\r\n     * @returns {string} content of the target URL.\r\n     * @static\r\n     */\n\n  }, {\n    key: \"getUrl\",\n    value: function getUrl(url, postVariables) {\n      var currentPath = window.location.toString().substr(0, window.location.toString().lastIndexOf('/') + 1);\n      var httpRequest = _util_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"].createHttpRequest();\n\n      if (httpRequest) {\n        if (_typeof(postVariables) === undefined || typeof postVariables == 'undefined') {\n          httpRequest.open('GET', url, false);\n        } else if (url.substr(0, 1) == '/' || url.substr(0, 7) == 'http://' || url.substr(0, 8) == 'https://') {\n          httpRequest.open('POST', url, false);\n        } else {\n          httpRequest.open('POST', currentPath + url, false);\n        }\n\n        if (postVariables !== undefined) {\n          httpRequest.setRequestHeader('Content-type', 'application/x-www-form-urlencoded; charset=UTF-8');\n          httpRequest.send(_util_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"].httpBuildQuery(postVariables));\n        } else {\n          httpRequest.send(null);\n        }\n\n        return httpRequest.responseText;\n      }\n\n      alert(Core.getStringManager().getString('browser_no_compatible'));\n      return '';\n    }\n    /**\r\n     * Returns the response text of a certain service.\r\n     * @param {string} service - service name.\r\n     * @param {string} postVariables - `post variables.\r\n     * @param {boolean} get - true if the request is GET instead of POST. false otherwise.\r\n     * @returns {string} service response text.\r\n     */\n\n  }, {\n    key: \"getService\",\n    value: function getService(service, postVariables, get) {\n      if (get === true) {\n        var serviceUrl = ServiceProvider.getServicePath(service) + '?' + postVariables;\n        var response = ServiceProvider.getUrl(serviceUrl);\n      } else {\n        var serviceUrl = ServiceProvider.getServicePath(service);\n        var response = ServiceProvider.getUrl(serviceUrl, postVariables);\n      }\n\n      return response;\n    }\n  }]);\n\n  return ServiceProvider;\n}();\n/**\r\n * @property {string} service - The service name\r\n * @property {string} path - The service path\r\n * @static\r\n */\n\n\n\nServiceProvider.serVicePaths = {};\n\n//# sourceURL=webpack:///./core/src/serviceprovider.js?");

/***/ }),

/***/ "./core/src/stringmanager.js":
/*!***********************************!*\
  !*** ./core/src/stringmanager.js ***!
  \***********************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return StringManager; });\n/* harmony import */ var _listeners__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./listeners */ \"./core/src/listeners.js\");\nfunction _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError(\"Cannot call a class as a function\"); } }\n\nfunction _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if (\"value\" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }\n\nfunction _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }\n\n\n/**\r\n * This class represents a string manager. It's used to load localized strings.\r\n */\n\nvar StringManager =\n/*#__PURE__*/\nfunction () {\n  function StringManager() {\n    _classCallCheck(this, StringManager);\n\n    /**\r\n     * key/value object containing the key of each string an it's translation.\r\n     */\n    this.strings = {};\n    /**\r\n     * Indicates if all strings are loaded.\r\n     */\n\n    this.stringsLoaded = false;\n    /**\r\n     * StringManager listeners.\r\n     */\n\n    this.listeners = new _listeners__WEBPACK_IMPORTED_MODULE_0__[\"default\"]();\n  }\n  /**\r\n   * Adds a listener object.\r\n   * @param {Object} listener - listener object.\r\n   */\n\n\n  _createClass(StringManager, [{\n    key: \"addListener\",\n    value: function addListener(listener) {\n      this.listeners.add(listener);\n    }\n    /**\r\n     * Returns the associated value of certain string key. If the associated value\r\n     * doesn't exits returns the original key.\r\n     * @param {string} key - string key\r\n     * @returns {string} correspondent value. If doesn't exists original key.\r\n     */\n\n  }, {\n    key: \"getString\",\n    value: function getString(key) {\n      // Wait 200ms and recall this method if strings aren't load.\n      if (!this.stringsLoaded) {\n        setTimeout(this.getString.bind(this, key), 100);\n        return;\n      }\n\n      if (key in this.strings) {\n        return this.strings[key];\n      }\n\n      return key;\n    }\n    /**\r\n     * Loads all strings to the manager and unset it for prevent bad usage.\r\n     * @param {Object[]} langStrings - array of key/value pairs of strings.\r\n     */\n\n  }, {\n    key: \"loadStrings\",\n    value: function loadStrings(langStrings) {\n      if (!this.stringsLoaded) {\n        this.strings = langStrings; // Activate variable to unlock getStrings\n\n        this.stringsLoaded = true; // Once the strings are loaded fire 'onLoad' event.\n\n        this.listeners.fire('onLoad', {});\n      }\n    }\n  }]);\n\n  return StringManager;\n}();\n\n\n\n//# sourceURL=webpack:///./core/src/stringmanager.js?");

/***/ }),

/***/ "./core/src/util.js":
/*!**************************!*\
  !*** ./core/src/util.js ***!
  \**************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return Util; });\n/* harmony import */ var _mathml__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./mathml */ \"./core/src/mathml.js\");\n/* harmony import */ var _configuration__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./configuration */ \"./core/src/configuration.js\");\n/* harmony import */ var _latex__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./latex */ \"./core/src/latex.js\");\n/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./constants */ \"./core/src/constants.js\");\nfunction _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError(\"Cannot call a class as a function\"); } }\n\nfunction _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if (\"value\" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }\n\nfunction _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }\n\n\n\n\n\n/**\r\n * This class represents an utility class.\r\n */\n\nvar Util =\n/*#__PURE__*/\nfunction () {\n  function Util() {\n    _classCallCheck(this, Util);\n  }\n\n  _createClass(Util, null, [{\n    key: \"fireEvent\",\n\n    /**\r\n     * Fires an event in a target.\r\n     * @param {EventTarget} eventTarget - target where event should be fired.\r\n     * @param {string} eventName event to fire.\r\n     * @static\r\n     */\n    value: function fireEvent(eventTarget, eventName) {\n      if (document.createEvent) {\n        var eventObject = document.createEvent('HTMLEvents');\n        eventObject.initEvent(eventName, true, true);\n        return !eventTarget.dispatchEvent(eventObject);\n      }\n\n      var eventObject = document.createEventObject();\n      return eventTarget.fireEvent('on' + eventName, eventObject);\n    }\n    /**\r\n     * Cross-browser addEventListener/attachEvent function.\r\n     * @param {EventTarget} eventTarget - target to add the event.\r\n     * @param {string} eventName - specifies the type of event.\r\n     * @param {Function} callBackFunction - callback function.\r\n     * @static\r\n     */\n\n  }, {\n    key: \"addEvent\",\n    value: function addEvent(eventTarget, eventName, callBackFunction) {\n      if (eventTarget.addEventListener) {\n        eventTarget.addEventListener(eventName, callBackFunction, true);\n      } else if (eventTarget.attachEvent) {\n        // Backwards compatibility.\n        eventTarget.attachEvent('on' + eventName, callBackFunction);\n      }\n    }\n    /**\r\n     * Cross-browser removeEventListener/detachEvent function.\r\n     * @param {EventTarget} eventTarget - target to add the event.\r\n     * @param {string} eventName - specifies the type of event.\r\n     * @param {Function} callBackFunction - function to remove from the event target.\r\n     * @static\r\n     */\n\n  }, {\n    key: \"removeEvent\",\n    value: function removeEvent(eventTarget, eventName, callBackFunction) {\n      if (eventTarget.removeEventListener) {\n        eventTarget.removeEventListener(eventName, callBackFunction, true);\n      } else if (eventTarget.detachEvent) {\n        eventTarget.detachEvent('on' + eventName, callBackFunction);\n      }\n    }\n    /**\r\n     * Adds the a callback function, for a certain event target, to the following event types:\r\n     * - dblclick\r\n     * - mousedown\r\n     * - mouseup\r\n     * @param {EventTarget} eventTarget - event target.\r\n     * @param {Function} doubleClickHandler - function to run when on dblclick event.\r\n     * @param {Function} mousedownHandler - function to run when on mousedown event.\r\n     * @param {Function} mouseupHandler - function to run when on mouseup event.\r\n     * @static\r\n     */\n\n  }, {\n    key: \"addElementEvents\",\n    value: function addElementEvents(eventTarget, doubleClickHandler, mousedownHandler, mouseupHandler) {\n      if (doubleClickHandler) {\n        Util.addEvent(eventTarget, 'dblclick', function (event) {\n          var realEvent = event ? event : window.event;\n          var element = realEvent.srcElement ? realEvent.srcElement : realEvent.target;\n          doubleClickHandler(element, realEvent);\n        });\n      }\n\n      if (mousedownHandler) {\n        Util.addEvent(eventTarget, 'mousedown', function (event) {\n          var realEvent = event ? event : window.event;\n          var element = realEvent.srcElement ? realEvent.srcElement : realEvent.target;\n          mousedownHandler(element, realEvent);\n        });\n      }\n\n      if (mouseupHandler) {\n        Util.addEvent(eventTarget, 'mouseup', function (event) {\n          var realEvent = event ? event : window.event;\n          var element = realEvent.srcElement ? realEvent.srcElement : realEvent.target;\n          mouseupHandler(element, realEvent);\n        });\n      }\n    }\n    /**\r\n     * Adds a class name to a HTMLElement.\r\n     * @param {HTMLElement} element - the HTML element.\r\n     * @param {string} className - the class name.\r\n     * @static\r\n     */\n\n  }, {\n    key: \"addClass\",\n    value: function addClass(element, className) {\n      if (!Util.containsClass(element, className)) {\n        element.className += \" \" + className;\n      }\n    }\n    /**\r\n     * Checks if a HTMLElement contains a certain class.\r\n     * @param {HTMLElement} element - the HTML element.\r\n     * @param {string} className - the className.\r\n     * @returns {boolean} true if the HTMLElement contains the class name. false otherwise.\r\n     * @static\r\n     */\n\n  }, {\n    key: \"containsClass\",\n    value: function containsClass(element, className) {\n      if (element == null || !('className' in element)) {\n        return false;\n      }\n\n      var currentClasses = element.className.split(' ');\n\n      for (var i = currentClasses.length - 1; i >= 0; --i) {\n        if (currentClasses[i] == className) {\n          return true;\n        }\n      }\n\n      return false;\n    }\n    /**\r\n     * Remove a certain class for a HTMLElement.\r\n     * @param {HTMLElement} element - the HTML element.\r\n     * @param {string} className - the class name.\r\n     * @static\r\n     */\n\n  }, {\n    key: \"removeClass\",\n    value: function removeClass(element, className) {\n      var newClassName = '';\n      var classes = element.className.split(\" \");\n\n      for (var i = 0; i < classes.length; i++) {\n        if (classes[i] != className) {\n          newClassName += classes[i] + \" \";\n        }\n      }\n\n      element.className = newClassName.trim();\n    }\n    /**\r\n     * Converts old xml initial text attribute (with «») to the correct one(with §lt;§gt;). It's\r\n     * used to parse old applets.\r\n     * @param {string} text - string containing safeXml characters\r\n     * @returns {string} a string with safeXml characters parsed.\r\n     * @static\r\n     */\n\n  }, {\n    key: \"convertOldXmlinitialtextAttribute\",\n    value: function convertOldXmlinitialtextAttribute(text) {\n      // Used to fix a bug with Cas imported from Moodle 1.9 to Moodle 2.x.\n      // This could be removed in future.\n      var val = 'value=';\n      var xitpos = text.indexOf('xmlinitialtext');\n      var valpos = text.indexOf(val, xitpos);\n      var quote = text.charAt(valpos + val.length);\n      var startquote = valpos + val.length + 1;\n      var endquote = text.indexOf(quote, startquote);\n      var value = text.substring(startquote, endquote);\n      var newvalue = value.split('«').join('§lt;');\n      newvalue = newvalue.split('»').join('§gt;');\n      newvalue = newvalue.split('&').join('§');\n      newvalue = newvalue.split('¨').join('§quot;');\n      text = text.split(value).join(newvalue);\n      return text;\n    }\n    /**\r\n     * Cross-browser solution for creating new elements.\r\n     * @param {string} tagName - tag name of the wished element.\r\n     * @param {Object} attributes - an object where each key is a wished attribute name and each value is its value.\r\n     * @param {Object} [creator] - if supplied, this function will use the \"createElement\" method from this param. Otherwise\r\n     * document will be used as creator.\r\n     * @returns {Element} The DOM element with the specified attributes assigned.\r\n     * @static\r\n     */\n\n  }, {\n    key: \"createElement\",\n    value: function createElement(tagName, attributes, creator) {\n      if (attributes === undefined) {\n        attributes = {};\n      }\n\n      if (creator === undefined) {\n        creator = document;\n      }\n\n      var element;\n      /*\r\n      * Internet Explorer fix:\r\n      * If you create a new object dynamically, you can't set a non-standard attribute.\r\n      * For example, you can't set the \"src\" attribute on an \"applet\" object.\r\n      * Other browsers will throw an exception and will run the standard code.\r\n      */\n\n      try {\n        var html = '<' + tagName;\n\n        for (var attributeName in attributes) {\n          html += ' ' + attributeName + '=\"' + Util.htmlEntities(attributes[attributeName]) + '\"';\n        }\n\n        html += '>';\n        element = creator.createElement(html);\n      } catch (e) {\n        element = creator.createElement(tagName);\n\n        for (var attributeName in attributes) {\n          element.setAttribute(attributeName, attributes[attributeName]);\n        }\n      }\n\n      return element;\n    }\n    /**\r\n     * Creates new HTML from it's HTML code as string.\r\n     * @param {string} objectCode - html code\r\n     * @returns {Element} the HTML element.\r\n     * @static\r\n     */\n\n  }, {\n    key: \"createObject\",\n    value: function createObject(objectCode, creator) {\n      if (creator === undefined) {\n        creator = document;\n      } // Internet Explorer can't include \"param\" tag when is setting an innerHTML property.\n\n\n      objectCode = objectCode.split('<applet ').join('<span wirisObject=\"WirisApplet\" ').split('<APPLET ').join('<span wirisObject=\"WirisApplet\" '); // It is a 'span' because 'span' objects can contain 'br' nodes.\n\n      objectCode = objectCode.split('</applet>').join('</span>').split('</APPLET>').join('</span>');\n      objectCode = objectCode.split('<param ').join('<br wirisObject=\"WirisParam\" ').split('<PARAM ').join('<br wirisObject=\"WirisParam\" '); // It is a 'br' because 'br' can't contain nodes.\n\n      objectCode = objectCode.split('</param>').join('</br>').split('</PARAM>').join('</br>');\n      var container = Util.createElement('div', {}, creator);\n      container.innerHTML = objectCode;\n\n      function recursiveParamsFix(object) {\n        if (object.getAttribute && object.getAttribute('wirisObject') == 'WirisParam') {\n          var attributesParsed = {};\n\n          for (var i = 0; i < object.attributes.length; ++i) {\n            if (object.attributes[i].nodeValue !== null) {\n              attributesParsed[object.attributes[i].nodeName] = object.attributes[i].nodeValue;\n            }\n          }\n\n          var param = Util.createElement('param', attributesParsed, creator); // IE fix.\n\n          if (param.NAME) {\n            param.name = param.NAME;\n            param.value = param.VALUE;\n          }\n\n          param.removeAttribute('wirisObject');\n          object.parentNode.replaceChild(param, object);\n        } else if (object.getAttribute && object.getAttribute('wirisObject') == 'WirisApplet') {\n          var attributesParsed = {};\n\n          for (var i = 0; i < object.attributes.length; ++i) {\n            if (object.attributes[i].nodeValue !== null) {\n              attributesParsed[object.attributes[i].nodeName] = object.attributes[i].nodeValue;\n            }\n          }\n\n          var applet = Util.createElement('applet', attributesParsed, creator);\n          applet.removeAttribute('wirisObject');\n\n          for (var i = 0; i < object.childNodes.length; ++i) {\n            recursiveParamsFix(object.childNodes[i]);\n\n            if (object.childNodes[i].nodeName.toLowerCase() == 'param') {\n              applet.appendChild(object.childNodes[i]);\n              --i; // When we insert the object child into the applet, object loses one child.\n            }\n          }\n\n          object.parentNode.replaceChild(applet, object);\n        } else {\n          for (var i = 0; i < object.childNodes.length; ++i) {\n            recursiveParamsFix(object.childNodes[i]);\n          }\n        }\n      }\n\n      recursiveParamsFix(container);\n      return container.firstChild;\n    }\n    /**\r\n     * Converts an Element to its HTML code.\r\n     * @param {Element} element - entry element.\r\n     * @return {string} the HTML code of the input element.\r\n     * @static\r\n     */\n\n  }, {\n    key: \"createObjectCode\",\n    value: function createObjectCode(element) {\n      // In case that the image was not created, the object can be null or undefined.\n      if (typeof element == 'undefined' || element == null) {\n        return;\n      }\n\n      if (element.nodeType == 1) {\n        // ELEMENT_NODE.\n        var output = '<' + element.tagName;\n\n        for (var i = 0; i < element.attributes.length; ++i) {\n          if (element.attributes[i].specified) {\n            output += ' ' + element.attributes[i].name + '=\"' + Util.htmlEntities(element.attributes[i].value) + '\"';\n          }\n        }\n\n        if (element.childNodes.length > 0) {\n          output += '>';\n\n          for (var i = 0; i < element.childNodes.length; ++i) {\n            output += Util.createObject(element.childNodes[i]);\n          }\n\n          output += '</' + element.tagName + '>';\n        } else if (element.nodeName == 'DIV' || element.nodeName == 'SCRIPT') {\n          output += '></' + element.tagName + '>';\n        } else {\n          output += '/>';\n        }\n\n        return output;\n      }\n\n      if (element.nodeType == 3) {\n        // TEXT_NODE.\n        return Util.htmlEntities(element.nodeValue);\n      }\n\n      return '';\n    }\n    /**\r\n     * Concatenates two URL paths.\r\n     * @param {string} path1 - first URL path\r\n     * @param {string} path2 - second URL path\r\n     * @returns {string} new URL.\r\n     */\n\n  }, {\n    key: \"concatenateUrl\",\n    value: function concatenateUrl(path1, path2) {\n      var separator = \"\";\n\n      if (path1.indexOf(\"/\") != path1.length && path2.indexOf(\"/\") != 0) {\n        separator = \"/\";\n      }\n\n      return (path1 + separator + path2).replace(/([^:]\\/)\\/+/g, \"$1\");\n    }\n    /**\r\n     * Parses a text and replaces all HTML special characters by their correspondent entities.\r\n     * @param {string} input - text to be parsed.\r\n     * @returns {string} the input text with all their special characters replaced by their entities.\r\n     * @static\r\n     */\n\n  }, {\n    key: \"htmlEntities\",\n    value: function htmlEntities(input) {\n      return input.split('&').join('&amp;').split('<').join('&lt;').split('>').join('&gt;').split('\"').join('&quot;');\n    }\n    /**\r\n     * Parses a text and replaces all the HTML entities by their characters.\r\n     * @param {string} input - text to be parsed\r\n     * @returns {string} the input text with all their entities replaced by characters.\r\n     * @static\r\n     */\n\n  }, {\n    key: \"htmlEntitiesDecode\",\n    value: function htmlEntitiesDecode(input) {\n      return input.split('&quot;').join('\"').split('&gt;').join('>').split('&lt;').join('<').split('&amp;').join('&');\n    }\n    /**\r\n     * Returns a cross-browser http request.\r\n     * @return {object} httpRequest request object.\r\n     * @returns {XMLHttpRequest|ActiveXObject} the proper request object.\r\n     */\n\n  }, {\n    key: \"createHttpRequest\",\n    value: function createHttpRequest() {\n      var currentPath = window.location.toString().substr(0, window.location.toString().lastIndexOf('/') + 1);\n\n      if (currentPath.substr(0, 7) == 'file://') {\n        throw Core.getStringManager().getString('exception_cross_site');\n      }\n\n      if (typeof XMLHttpRequest != 'undefined') {\n        return new XMLHttpRequest();\n      }\n\n      try {\n        return new ActiveXObject('Msxml2.XMLHTTP');\n      } catch (e) {\n        try {\n          return new ActiveXObject('Microsoft.XMLHTTP');\n        } catch (oc) {}\n      }\n\n      return false;\n    }\n    /**\r\n     * Converts a hash to a HTTP query.\r\n     * @param {Object[]} properties - a key/value object.\r\n     * @returns {string} a HTTP query containing all the key value pairs with all the special characters replaced by their entities.\r\n     * @static\r\n     */\n\n  }, {\n    key: \"httpBuildQuery\",\n    value: function httpBuildQuery(properties) {\n      var result = '';\n\n      for (var i in properties) {\n        if (properties[i] != null) {\n          result += Util.urlEncode(i) + '=' + Util.urlEncode(properties[i]) + '&';\n        }\n      } // Deleting last '&' empty character.\n\n\n      if (result.substring(result.length - 1) == '&') {\n        result = result.substring(0, result.length - 1);\n      }\n\n      return result;\n    }\n    /**\r\n     * Convert a hash to string sorting keys to get a deterministic output\r\n     * @param {Object[]} hash - a key/value object.\r\n     * @returns {string} a string with the form key1=value1...keyn=valuen\r\n     * @static\r\n     */\n\n  }, {\n    key: \"propertiesToString\",\n    value: function propertiesToString(hash) {\n      // 1. Sort keys. We sort the keys because we want a deterministic output.\n      var keys = [];\n\n      for (var key in hash) {\n        if (hash.hasOwnProperty(key)) {\n          keys.push(key);\n        }\n      }\n\n      var n = keys.length;\n\n      for (var i = 0; i < n; i++) {\n        for (var j = i + 1; j < n; j++) {\n          var s1 = keys[i];\n          var s2 = keys[j];\n\n          if (Util.compareStrings(s1, s2) > 0) {\n            // Swap.\n            keys[i] = s2;\n            keys[j] = s1;\n          }\n        }\n      } // 2. Generate output.\n\n\n      var output = '';\n\n      for (var i = 0; i < n; i++) {\n        var key = keys[i];\n        output += key;\n        output += \"=\";\n        var value = hash[key];\n        value = value.replace(\"\\\\\", \"\\\\\\\\\");\n        value = value.replace(\"\\n\", \"\\\\n\");\n        value = value.replace(\"\\r\", \"\\\\r\");\n        value = value.replace(\"\\t\", \"\\\\t\");\n        output += value;\n        output += \"\\n\";\n      }\n\n      return output;\n    }\n    /**\r\n     * Compare two strings using charCodeAt method\r\n     * @param {string} a - first string to compare.\r\n     * @param {string} b - second string to compare.\r\n     * @returns {number} the difference between a and b\r\n     * @static\r\n     */\n\n  }, {\n    key: \"compareStrings\",\n    value: function compareStrings(a, b) {\n      var i;\n      var an = a.length;\n      var bn = b.length;\n      var n = an > bn ? bn : an;\n\n      for (i = 0; i < n; i++) {\n        var c = Util.fixedCharCodeAt(a, i) - Util.fixedCharCodeAt(b, i);\n\n        if (c != 0) {\n          return c;\n        }\n      }\n\n      return a.length - b.length;\n    }\n    /**\r\n     * Fix charCodeAt() JavaScript function to handle non-Basic-Multilingual-Plane characters.\r\n     * @param {string} string - input string\r\n     * @param {number} idx - an integer greater than or equal to 0 and less than the length of the string\r\n     * @returns {number} an integer representing the UTF-16 code of the string at the given index.\r\n     * @static\r\n     */\n\n  }, {\n    key: \"fixedCharCodeAt\",\n    value: function fixedCharCodeAt(string, idx) {\n      idx = idx || 0;\n      var code = string.charCodeAt(idx);\n      var hi, low;\n      /* High surrogate (could change last hex to 0xDB7F to treat high\r\n      private surrogates as single characters) */\n\n      if (0xD800 <= code && code <= 0xDBFF) {\n        hi = code;\n        low = string.charCodeAt(idx + 1);\n\n        if (isNaN(low)) {\n          throw Core.getStringManager().getString('exception_high_surrogate');\n        }\n\n        return (hi - 0xD800) * 0x400 + (low - 0xDC00) + 0x10000;\n      }\n\n      if (0xDC00 <= code && code <= 0xDFFF) {\n        // Low surrogate.\n\n        /* We return false to allow loops to skip this iteration since should have\r\n        already handled high surrogate above in the previous iteration. */\n        return false;\n      }\n\n      return code;\n    }\n    /**\r\n     * Returns an URL with it's query params converted into array.\r\n     * @param {string} url - input URL.\r\n     * @returns {Object[]} an array containing all URL query params.\r\n     * @static\r\n     */\n\n  }, {\n    key: \"urlToAssArray\",\n    value: function urlToAssArray(url) {\n      var i;\n      i = url.indexOf(\"?\");\n\n      if (i > 0) {\n        var query = url.substring(i + 1);\n        var ss = query.split(\"&\");\n        var h = new Object();\n\n        for (i = 0; i < ss.length; i++) {\n          var s = ss[i];\n          var kv = s.split(\"=\");\n\n          if (kv.length > 1) {\n            h[kv[0]] = decodeURIComponent(kv[1].replace(/\\+/g, ' '));\n          }\n        }\n\n        return h;\n      } else {\n        return new Object();\n      }\n    }\n    /**\r\n     * Returns an encoded URL by replacing each instance of certain characters by\r\n     * one, two, three or four escape sequences using encodeURIComponent method.\r\n     * !'()* . will not be encoded.\r\n     *\r\n     * @param {string} clearString - URL string to be encoded\r\n     * @returns {string} URL with it's special characters replaced.\r\n     * @static\r\n     */\n\n  }, {\n    key: \"urlEncode\",\n    value: function urlEncode(clearString) {\n      var output = ''; // Method encodeURIComponent doesn't encode !'()*~ .\n\n      output = encodeURIComponent(clearString);\n      return output;\n    } // TODO: To parser?\n\n    /**\r\n     * Converts the HTML of a image into the output code that WIRIS must return.\r\n     * By default returns the MathML stored on data-mahml attribute (if imgCode is a formula)\r\n     * or the Wiriscas attribute of a WIRIS applet.\r\n     * @param {string} imgCode - the html code from a formula or a CAS image.\r\n     * @param {boolean} convertToXml - true if the image should be converted to XML.\r\n     * @param {boolean} convertToSafeXml - true if the image should be converted to safeXML.\r\n     * @returns {string} the XML or safeXML of a WIRIS image.\r\n     * @static\r\n     */\n\n  }, {\n    key: \"getWIRISImageOutput\",\n    value: function getWIRISImageOutput(imgCode, convertToXml, convertToSafeXml) {\n      var imgObject = Util.createObject(imgCode);\n\n      if (imgObject) {\n        if (imgObject.className == _configuration__WEBPACK_IMPORTED_MODULE_1__[\"default\"].get('imageClassName') || imgObject.getAttribute(_configuration__WEBPACK_IMPORTED_MODULE_1__[\"default\"].get('imageMathmlAttribute'))) {\n          if (!convertToXml) {\n            return imgCode;\n          }\n\n          var xmlCode = imgObject.getAttribute(_configuration__WEBPACK_IMPORTED_MODULE_1__[\"default\"].get('imageMathmlAttribute'));\n\n          if (!_configuration__WEBPACK_IMPORTED_MODULE_1__[\"default\"].get('saveHandTraces')) {\n            xmlCode = _mathml__WEBPACK_IMPORTED_MODULE_0__[\"default\"].removeSemanticsOcurrences(xmlCode, _constants__WEBPACK_IMPORTED_MODULE_3__[\"default\"].safeXmlCharacters);\n          }\n\n          if (xmlCode == null) {\n            xmlCode = imgObject.getAttribute('alt');\n          }\n\n          if (!convertToSafeXml) {\n            xmlCode = _mathml__WEBPACK_IMPORTED_MODULE_0__[\"default\"].safeXmlDecode(xmlCode);\n          }\n\n          return xmlCode;\n        } else if (imgObject.className == _configuration__WEBPACK_IMPORTED_MODULE_1__[\"default\"].get('CASClassName')) {\n          var appletCode = imgObject.getAttribute(_configuration__WEBPACK_IMPORTED_MODULE_1__[\"default\"].get('CASMathmlAttribute'));\n          appletCode = _mathml__WEBPACK_IMPORTED_MODULE_0__[\"default\"].safeXmlDecode(appletCode);\n          var appletObject = Util.createObject(appletCode);\n          appletObject.setAttribute('src', imgObject.src);\n          var object = appletObject;\n          var appletCodeToBeInserted = Util.createObjectCode(appletObject);\n\n          if (convertToSafeXml) {\n            appletCodeToBeInserted = _mathml__WEBPACK_IMPORTED_MODULE_0__[\"default\"].safeXmlEncode(appletCodeToBeInserted);\n          }\n\n          return appletCodeToBeInserted;\n        }\n      }\n\n      return imgCode;\n    }\n    /**\r\n     * Gets the node length in characters.\r\n     * @param {Node} node - HTML node.\r\n     * @returns {number} node length.\r\n     * @static\r\n     */\n\n  }, {\n    key: \"getNodeLength\",\n    value: function (_getNodeLength) {\n      function getNodeLength(_x) {\n        return _getNodeLength.apply(this, arguments);\n      }\n\n      getNodeLength.toString = function () {\n        return _getNodeLength.toString();\n      };\n\n      return getNodeLength;\n    }(function (node) {\n      var staticNodeLengths = {\n        'IMG': 1,\n        'BR': 1\n      };\n\n      if (node.nodeType == 3) {\n        // TEXT_NODE.\n        return node.nodeValue.length;\n      }\n\n      if (node.nodeType == 1) {\n        // ELEMENT_NODE.\n        var length = staticNodeLengths[node.nodeName.toUpperCase()];\n\n        if (length === undefined) {\n          length = 0;\n        }\n\n        for (var i = 0; i < node.childNodes.length; ++i) {\n          length += getNodeLength(node.childNodes[i]);\n        }\n\n        return length;\n      }\n\n      return 0;\n    })\n    /**\r\n     * Gets a selected node or text from an editable HTMLElement.\r\n     * If the caret is on a text node, concatenates it with all the previous and next text nodes.\r\n     * @param {HTMLElement} target - the editable HTMLElement.\r\n     * @param {boolean} isIframe  - specifies if the target is an iframe or not\r\n     * @param {boolean} forceGetSelection - if true, ignores IE system to get the current selection and uses window.getSelection()\r\n     * @returns {object} an object with the 'node' key set if the item is an element or the keys 'node' and 'caretPosition' if the element is text.\r\n     * @static\r\n     */\n\n  }, {\n    key: \"getSelectedItem\",\n    value: function getSelectedItem(target, isIframe, forceGetSelection) {\n      var windowTarget;\n\n      if (isIframe) {\n        windowTarget = target.contentWindow;\n        windowTarget.focus();\n      } else {\n        windowTarget = window;\n        target.focus();\n      }\n\n      if (document.selection && !forceGetSelection) {\n        var range = windowTarget.document.selection.createRange();\n\n        if (range.parentElement) {\n          if (range.htmlText.length > 0) {\n            if (range.text.length == 0) {\n              return Util.getSelectedItem(target, isIframe, true);\n            }\n\n            return null;\n          }\n\n          windowTarget.document.execCommand('InsertImage', false, '#');\n          var temporalObject = range.parentElement();\n\n          if (temporalObject.nodeName.toUpperCase() != 'IMG') {\n            // IE9 fix: parentElement() does not return the IMG node, returns the parent DIV node. In IE < 9, pasteHTML does not work well.\n            range.pasteHTML('<span id=\"wrs_openEditorWindow_temporalObject\"></span>');\n            temporalObject = windowTarget.document.getElementById('wrs_openEditorWindow_temporalObject');\n          }\n\n          var node;\n          var caretPosition;\n\n          if (temporalObject.nextSibling && temporalObject.nextSibling.nodeType == 3) {\n            // TEXT_NODE.\n            node = temporalObject.nextSibling;\n            caretPosition = 0;\n          } else if (temporalObject.previousSibling && temporalObject.previousSibling.nodeType == 3) {\n            // TEXT_NODE.\n            node = temporalObject.previousSibling;\n            caretPosition = node.nodeValue.length;\n          } else {\n            node = windowTarget.document.createTextNode('');\n            temporalObject.parentNode.insertBefore(node, temporalObject);\n            caretPosition = 0;\n          }\n\n          temporalObject.parentNode.removeChild(temporalObject);\n          return {\n            'node': node,\n            'caretPosition': caretPosition\n          };\n        }\n\n        if (range.length > 1) {\n          return null;\n        }\n\n        return {\n          'node': range.item(0)\n        };\n      }\n\n      if (windowTarget.getSelection) {\n        var selection = windowTarget.getSelection();\n\n        try {\n          var range = selection.getRangeAt(0);\n        } catch (e) {\n          var range = windowTarget.document.createRange();\n        }\n\n        var node = range.startContainer;\n\n        if (node.nodeType == 3) {\n          // TEXT_NODE.\n          return {\n            'node': node,\n            'caretPosition': range.startOffset\n          };\n        }\n\n        if (node != range.endContainer) {\n          return null;\n        }\n\n        if (node.nodeType == 1) {\n          // ELEMENT_NODE.\n          var position = range.startOffset;\n\n          if (node.childNodes[position]) {\n            return {\n              'node': node.childNodes[position]\n            };\n          }\n        }\n      }\n\n      return null;\n    }\n    /**\r\n     * Returns null if there isn't any item or if it is malformed.\r\n     * Otherwise returns an object containing the node with the MathML image\r\n     * and the cursor position inside the textarea.\r\n     * @param {HTMLTextAreaElement} textarea - textarea element.\r\n     * @returns {Object} An object containing the node, the index of the\r\n     * beginning  of the selected text, caret position and the start and end position of the\r\n     * text node.\r\n     * @static\r\n     */\n\n  }, {\n    key: \"getSelectedItemOnTextarea\",\n    value: function getSelectedItemOnTextarea(textarea) {\n      var textNode = document.createTextNode(textarea.value);\n      var textNodeValues = _latex__WEBPACK_IMPORTED_MODULE_2__[\"default\"].getLatexFromTextNode(textNode, textarea.selectionStart);\n\n      if (textNodeValues === null) {\n        return null;\n      }\n\n      ;\n      return {\n        'node': textNode,\n        'caretPosition': textarea.selectionStart,\n        'startPosition': textNodeValues.startPosition,\n        'endPosition': textNodeValues.endPosition\n      };\n    }\n    /**\r\n     * Looks for elements that match the given name in a HTML code string.\r\n     * Important: this function is very concrete for WIRIS code. It takes as preconditions lots of behaviors that are not the general case.\r\n     * @param {string} code -  HTML code.\r\n     * @param {string} name - element name.\r\n     * @param {boolean} autoClosed - true if the elements are autoClosed.\r\n     * @return {Object[]} an object containing all HTML elements of code matching the name argument.\r\n     * @static\r\n     */\n\n  }, {\n    key: \"getElementsByNameFromString\",\n    value: function getElementsByNameFromString(code, name, autoClosed) {\n      var elements = [];\n      var code = code.toLowerCase();\n      name = name.toLowerCase();\n      var start = code.indexOf('<' + name + ' ');\n\n      while (start != -1) {\n        // Look for nodes.\n        var endString;\n\n        if (autoClosed) {\n          endString = '>';\n        } else {\n          endString = '</' + name + '>';\n        }\n\n        var end = code.indexOf(endString, start);\n\n        if (end != -1) {\n          end += endString.length;\n          elements.push({\n            'start': start,\n            'end': end\n          });\n        } else {\n          end = start + 1;\n        }\n\n        start = code.indexOf('<' + name + ' ', end);\n      }\n\n      return elements;\n    }\n    /**\r\n     * Returns the numeric value of a base64 character.\r\n     * @param  {string} character - base64 character.\r\n     * @returns {number} base64 character numeric value.\r\n     * @static\r\n     */\n\n  }, {\n    key: \"decode64\",\n    value: function decode64(character) {\n      var PLUS = '+'.charCodeAt(0);\n      var SLASH = '/'.charCodeAt(0);\n      var NUMBER = '0'.charCodeAt(0);\n      var LOWER = 'a'.charCodeAt(0);\n      var UPPER = 'A'.charCodeAt(0);\n      var PLUS_URL_SAFE = '-'.charCodeAt(0);\n      var SLASH_URL_SAFE = '_'.charCodeAt(0);\n      var code = character.charCodeAt(0);\n\n      if (code === PLUS || code === PLUS_URL_SAFE) {\n        return 62; // Char '+'.\n      }\n\n      if (code === SLASH || code === SLASH_URL_SAFE) {\n        return 63; // Char '/'.\n      }\n\n      if (code < NUMBER) {\n        return -1; // No match.\n      }\n\n      if (code < NUMBER + 10) {\n        return code - NUMBER + 26 + 26;\n      }\n\n      if (code < UPPER + 26) {\n        return code - UPPER;\n      }\n\n      if (code < LOWER + 26) {\n        return code - LOWER + 26;\n      }\n    }\n    /**\r\n     * Converts a base64 string to a array of bytes.\r\n     * @param {string} b64String - base64 string.\r\n     * @param {number} length - dimension of byte array (by default whole string).\r\n     * @return {Object[]} the resultant byte array.\r\n     * @static\r\n     */\n\n  }, {\n    key: \"b64ToByteArray\",\n    value: function b64ToByteArray(b64String, length) {\n      var tmp;\n\n      if (b64String.length % 4 > 0) {\n        throw new Error('Invalid string. Length must be a multiple of 4'); // Tipped base64. Length is fixed.\n      }\n\n      var arr = new Array();\n\n      if (!length) {\n        // All b64String string.\n        var placeHolders = b64String.charAt(b64String.length - 2) === '=' ? 2 : b64String.charAt(b64String.length - 1) === '=' ? 1 : 0;\n        var l = placeHolders > 0 ? b64String.length - 4 : b64String.length;\n      } else {\n        var l = length;\n      }\n\n      for (var i = 0; i < l; i += 4) {\n        // Ignoring code checker standards (bitewise operators).\n        // See https://tracker.moodle.org/browse/CONTRIB-5862 for further information.\n        // @codingStandardsIgnoreStart\n        tmp = Util.decode64(b64String.charAt(i)) << 18 | Util.decode64(b64String.charAt(i + 1)) << 12 | Util.decode64(b64String.charAt(i + 2)) << 6 | Util.decode64(b64String.charAt(i + 3));\n        arr.push(tmp >> 16 & 0xFF);\n        arr.push(tmp >> 8 & 0xFF);\n        arr.push(tmp & 0xFF); // @codingStandardsIgnoreEnd\n      }\n\n      if (placeHolders) {\n        if (placeHolders === 2) {\n          // Ignoring code checker standards (bitewise operators).\n          // @codingStandardsIgnoreStart\n          tmp = Util.decode64(b64String.charAt(i)) << 2 | Util.decode64(b64String.charAt(i + 1)) >> 4;\n          arr.push(tmp & 0xFF);\n        } else if (placeHolders === 1) {\n          tmp = Util.decode64(b64String.charAt(i)) << 10 | Util.decode64(b64String.charAt(i + 1)) << 4 | Util.decode64(b64String.charAt(i + 2)) >> 2;\n          arr.push(tmp >> 8 & 0xFF);\n          arr.push(tmp & 0xFF); // @codingStandardsIgnoreEnd\n        }\n      }\n\n      return arr;\n    }\n    /**\r\n     * Returns the first 32-bit signed integer from a byte array.\r\n     * @param {Object[]} bytes - array of bytes.\r\n     * @returns {number} the 32-bit signed integer.\r\n     * @static\r\n     */\n\n  }, {\n    key: \"readInt32\",\n    value: function readInt32(bytes) {\n      if (bytes.length < 4) {\n        return false;\n      }\n\n      var int32 = bytes.splice(0, 4); // @codingStandardsIgnoreStart\n\n      return int32[0] << 24 | int32[1] << 16 | int32[2] << 8 | int32[3] << 0; // @codingStandardsIgnoreEnd\n    }\n    /**\r\n     * Read the first byte from a byte array.\r\n     * @param {Object} bytes - input byte array.\r\n     * @returns {number} first byte of the byte array.\r\n     * @static\r\n     */\n\n  }, {\n    key: \"readByte\",\n    value: function readByte(bytes) {\n      // @codingStandardsIgnoreStart\n      return bytes.shift() << 0; // @codingStandardsIgnoreEnd\n    }\n    /**\r\n     * Read an arbitrary number of bytes, from a fixed position on a byte array.\r\n     * @param  {Object[]} bytes - byte array.\r\n     * @param  {number} pos - start position.\r\n     * @param  {number} len - number of bytes to read.\r\n     * @returns {Object[]} the byte array.\r\n     * @static\r\n     */\n\n  }, {\n    key: \"readBytes\",\n    value: function readBytes(bytes, pos, len) {\n      return bytes.splice(pos, len);\n    }\n    /**\r\n     * Inserts or modifies formulas or CAS on a textarea.\r\n     * @param {HTMLTextAreaElement} textarea - textarea target.\r\n     * @param {string} text - text to add in the textarea. For example, to add the link to the image,\r\n     * call this function as (textarea, Parser.createImageSrc(mathml));\r\n     * @static\r\n     */\n\n  }, {\n    key: \"updateTextArea\",\n    value: function updateTextArea(textarea, text) {\n      if (textarea && text) {\n        textarea.focus();\n\n        if (textarea.selectionStart != null) {\n          var selectionEnd = textarea.selectionEnd;\n          textarea.value = textarea.value.substring(0, textarea.selectionStart) + text + textarea.value.substring(textarea.selectionEnd, textarea.value.length);\n          textarea.selectionEnd = selectionEnd + text.length;\n        } else {\n          var selection = document.selection.createRange();\n          selection.text = text;\n        }\n      }\n    }\n    /**\r\n     * Modifies existing formula on a textarea.\r\n     * @param {HTMLTextAreaElement} textarea - text area target.\r\n     * @param {string} text - text to add in the textarea. For example, if you want to add the link to the image, you can call this function as Util.updateTextarea(textarea, Parser.createImageSrc(mathml));\r\n     * @param {number} start - beginning index from textarea where it needs to be replaced by text.\r\n     * @param {number} end - ending index from textarea where it needs to be replaced by text\r\n     * @static\r\n     */\n\n  }, {\n    key: \"updateExistingTextOnTextarea\",\n    value: function updateExistingTextOnTextarea(textarea, text, start, end) {\n      textarea.focus();\n      textarea.value = textarea.value.substring(0, start) + text + textarea.value.substring(end, textarea.value.length);\n      textarea.selectionEnd = start + text.length;\n    }\n    /**\r\n     * Add a parameter with it's correspondent value to an URL (GET).\r\n     * @param {string} path - URL path\r\n     * @param {string} parameter - parameter\r\n     * @param {string} value - value\r\n     * @static\r\n     */\n\n  }, {\n    key: \"addArgument\",\n    value: function addArgument(path, parameter, value) {\n      var sep;\n\n      if (path.indexOf(\"?\") > 0) {\n        sep = \"&\";\n      } else {\n        sep = \"?\";\n      }\n\n      return path + sep + parameter + \"=\" + value;\n    }\n  }]);\n\n  return Util;\n}();\n\n\n\n//# sourceURL=webpack:///./core/src/util.js?");

/***/ }),

/***/ "./core/styles.src.css":
/*!*****************************!*\
  !*** ./core/styles.src.css ***!
  \*****************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

eval("\nvar content = __webpack_require__(/*! !../node_modules/mini-css-extract-plugin/dist/loader.js!../node_modules/css-loader!./styles.src.css */ \"./node_modules/mini-css-extract-plugin/dist/loader.js!./node_modules/css-loader/index.js!./core/styles.src.css\");\n\nif(typeof content === 'string') content = [[module.i, content, '']];\n\nvar transform;\nvar insertInto;\n\n\n\nvar options = {\"hmr\":true}\n\noptions.transform = transform\noptions.insertInto = undefined;\n\nvar update = __webpack_require__(/*! ../node_modules/style-loader/lib/addStyles.js */ \"./node_modules/style-loader/lib/addStyles.js\")(content, options);\n\nif(content.locals) module.exports = content.locals;\n\nif(false) {}\n\n//# sourceURL=webpack:///./core/styles.src.css?");

/***/ }),

/***/ "./editor_plugin.src.js":
/*!******************************!*\
  !*** ./editor_plugin.src.js ***!
  \******************************/
/*! exports provided: TinyMceIntegration, instances, currentInstance */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"TinyMceIntegration\", function() { return TinyMceIntegration; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"instances\", function() { return instances; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"currentInstance\", function() { return currentInstance; });\n/* harmony import */ var _core_src_integrationmodel_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./core/src/integrationmodel.js */ \"./core/src/integrationmodel.js\");\n/* harmony import */ var _core_src_configuration_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./core/src/configuration.js */ \"./core/src/configuration.js\");\n/* harmony import */ var _core_src_parser_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./core/src/parser.js */ \"./core/src/parser.js\");\n/* harmony import */ var _core_src_util__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./core/src/util */ \"./core/src/util.js\");\n/* harmony import */ var _core_src_listeners__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./core/src/listeners */ \"./core/src/listeners.js\");\nfunction _typeof(obj) { if (typeof Symbol === \"function\" && typeof Symbol.iterator === \"symbol\") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === \"function\" && obj.constructor === Symbol && obj !== Symbol.prototype ? \"symbol\" : typeof obj; }; } return _typeof(obj); }\n\nfunction _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError(\"Cannot call a class as a function\"); } }\n\nfunction _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if (\"value\" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }\n\nfunction _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }\n\nfunction _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === \"object\" || typeof call === \"function\")) { return call; } return _assertThisInitialized(self); }\n\nfunction _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError(\"this hasn't been initialised - super() hasn't been called\"); } return self; }\n\nfunction _get(target, property, receiver) { if (typeof Reflect !== \"undefined\" && Reflect.get) { _get = Reflect.get; } else { _get = function _get(target, property, receiver) { var base = _superPropBase(target, property); if (!base) return; var desc = Object.getOwnPropertyDescriptor(base, property); if (desc.get) { return desc.get.call(receiver); } return desc.value; }; } return _get(target, property, receiver || target); }\n\nfunction _superPropBase(object, property) { while (!Object.prototype.hasOwnProperty.call(object, property)) { object = _getPrototypeOf(object); if (object === null) break; } return object; }\n\nfunction _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }\n\nfunction _inherits(subClass, superClass) { if (typeof superClass !== \"function\" && superClass !== null) { throw new TypeError(\"Super expression must either be null or a function\"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }\n\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\n\n\n\n\n\n\n/**\n * TinyMCE integration class. This class extends IntegrationModel class.\n */\n\nvar TinyMceIntegration =\n/*#__PURE__*/\nfunction (_IntegrationModel) {\n  _inherits(TinyMceIntegration, _IntegrationModel);\n\n  function TinyMceIntegration(integrationModelProperties) {\n    var _this;\n\n    _classCallCheck(this, TinyMceIntegration);\n\n    _this = _possibleConstructorReturn(this, _getPrototypeOf(TinyMceIntegration).call(this, integrationModelProperties));\n    /**\n     * Indicates if the content of the TinyMCe editor has\n     * been parsed.\n     * @type {Boolean}\n     */\n\n    _this.initParsed = integrationModelProperties.initParsed;\n    /**\n     * Indicates if the TinyMCE is integrated in Moodle.\n     * @type {Boolean}\n     */\n\n    _this.isMoodle = integrationModelProperties.isMoodle;\n    /**\n     * Indicates if the plugin is loaded as an external plugin by TinyMCE.\n     * @type {Boolean}\n     */\n\n    _this.isExternal = integrationModelProperties.isExternal;\n    return _this;\n  }\n  /**\n   * Returns the absolute path of the integration script. Depends on\n   * TinyMCE integration (Moodle or standard).\n   * @returns {Boolean} - Absolute path for the integration script.\n   */\n\n\n  _createClass(TinyMceIntegration, [{\n    key: \"getPath\",\n    value: function getPath() {\n      if (this.isMoodle) {\n        var search = 'lib/editor/tinymce';\n        var pos = tinymce.baseURL.indexOf(search);\n        var baseURL = tinymce.baseURL.substr(0, pos + search.length);\n        return baseURL + '/plugins/tiny_mce_wiris/tinymce/';\n      } else if (this.isExternal) {\n        var externalUrl = this.editorObject.getParam('external_plugins')['tiny_mce_wiris'];\n        return externalUrl.substring(0, externalUrl.lastIndexOf('/') + 1);\n      } else {\n        return tinymce.baseURL + '/plugins/tiny_mce_wiris/';\n      }\n    }\n    /**\n     * Returns the absolute path of plugin icons. A set of different\n     * icons is needed for TinyMCE and Moodle 2.5-\n     * @returns {String} - Absolute path of the icons folder.\n     */\n\n  }, {\n    key: \"getIconsPath\",\n    value: function getIconsPath() {\n      if (this.isMoodle && _core_src_configuration_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"].get('versionPlatform') < 2013111800) {\n        return this.getPath() + 'icons/tinymce3/';\n      } else {\n        return this.getPath() + 'icons/';\n      }\n    }\n    /**\n     * Returns the integration language. TinyMCE language is inherited.\n     * When no language is set, TinyMCE sets the toolbar to english.\n     * @returns {String} - Integration language.\n     */\n\n  }, {\n    key: \"getLanguage\",\n    value: function getLanguage() {\n      if (this.editorObject.settings['wirisformulaeditorlang']) {\n        return editor.settings['wirisformulaeditorlang'];\n      }\n\n      var langParam = this.editorObject.getParam('language');\n      return langParam ? langParam : 'en';\n    }\n    /**\n     * Callback function called before 'onTargetLoad' is fired. All the logic here is to\n     * avoid TinyMCE change MathType formulas.\n     */\n\n  }, {\n    key: \"callbackFunction\",\n    value: function callbackFunction() {\n      var dataImgFiltered = [];\n\n      _get(_getPrototypeOf(TinyMceIntegration.prototype), \"callbackFunction\", this).call(this); // Avoid to change class of image formulas.\n\n\n      var imageClassName = _core_src_configuration_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"].get('imageClassName');\n\n      if (this.isIframe) {\n        // Attaching observers to wiris images.\n        if (typeof _core_src_parser_js__WEBPACK_IMPORTED_MODULE_2__[\"default\"].observer != 'undefined') {\n          Array.prototype.forEach.call(this.target.contentDocument.getElementsByClassName(imageClassName), function (wirisImages) {\n            _core_src_parser_js__WEBPACK_IMPORTED_MODULE_2__[\"default\"].observer.observe(wirisImages);\n          });\n        }\n      } else {\n        // Inline.\n        // Attaching observers to wiris images.\n        Array.prototype.forEach.call(document.getElementsByClassName(imageClassName), function (wirisImages) {\n          _core_src_parser_js__WEBPACK_IMPORTED_MODULE_2__[\"default\"].observer.observe(wirisImages);\n        });\n      } // When a formula is updated TinyMCE 'Change' event must be fired.\n      // See https://www.tiny.cloud/docs/advanced/events/#change for further information.\n\n\n      var listener = _core_src_listeners__WEBPACK_IMPORTED_MODULE_4__[\"default\"].newListener('onAfterFormulaInsertion', function () {\n        if (typeof this.editorObject.fire != 'undefined') {\n          this.editorObject.fire('Change');\n        }\n      }.bind(this));\n      this.getCore().addListener(listener); // Avoid filter formulas with performance enabled.\n\n      dataImgFiltered[this.editorObject.id] = this.editorObject.settings.images_dataimg_filter;\n\n      this.editorObject.settings.images_dataimg_filter = function (img) {\n        if (img.hasAttribute('class') && img.getAttribute('class').indexOf(_core_src_configuration_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"].get('imageClassName')) != -1) {\n          return img.hasAttribute('internal-blob');\n        } else {\n          // If the client put an image data filter, run. Otherwise default behaviour (put blob).\n          if (typeof dataImgFiltered[this.editorObject.id] != 'undefined') {\n            return dataImgFiltered[this.editorObject.id](img);\n          }\n\n          return true;\n        }\n      };\n    }\n  }]);\n\n  return TinyMceIntegration;\n}(_core_src_integrationmodel_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"]);\n/**\n * Object containing all TinyMCE integration instances. One for each TinyMCE editor.\n * @type {Object}\n */\n\nvar instances = {};\n/**\n * TinyMCE integration current instance. The current instance\n * is the instance related with the focused editor.\n * @type {TinyMceIntegration}\n */\n\nvar currentInstance = null;\n/* Plugin integration */\n\n(function () {\n  tinymce.create('tinymce.plugins.tiny_mce_wiris', {\n    init: function init(editor, url) {\n      // Array with MathML valid alements.\n      var validMathML = ['math[*]', 'maction[*]]', 'malignmark[*]', 'maligngroup[*]', 'menclose[*]', 'merror[*]', 'mfenced[*]', 'mfrac[*]', 'mglyph[*]', 'mi[*]', 'mlabeledtr[*]', 'mlongdiv[*]', 'mmultiscripts[*]', 'mn[*]', 'mo[*]', 'mover[*]', 'mpadded[*]', 'mphantom[*]', 'mprescripts[*]', 'mroot[*]', 'mrow[*]', 'ms[*]', 'mscarries[*]', 'mscarry[*]', 'msgroup[*]', 'msline[*]', 'mspace[*]', 'msqrt[*]', 'msrow[*]', 'mstack[*]', 'mstyle[*]', 'msub[*]', 'msubsup[*]', 'msup[*]', 'mtable[*]', 'mtd[*]', 'mtext[*]', 'mtr[*]', 'munder[*]', 'munderover[*]', 'semantics[*]', 'annotation[*]'];\n      editor.settings.extended_valid_elements += ',' + validMathML.join();\n      var callbackMethodArguments = {};\n      /**\n       * Integration model properties\n       * @type {Object}\n       * @property {Object} target - Integration DOM target.\n       * @property {String} configurationService - Configuration integration service.\n       * @property {String} version - Plugin version.\n       * @property {String} scriptName - Integration script name.\n       * @property {Object} environment - Integration environment properties.\n       * @property {String} editor - Editor name.\n       */\n\n      var integrationModelProperties = {};\n      integrationModelProperties.configurationService = 'integration/configurationjs.php';\n      integrationModelProperties.version = '7.9.0.1399';\n      integrationModelProperties.isMoodle = false;\n\n      if (typeof editor.getParam('wiriscontextpath') !== 'undefined') {\n        integrationModelProperties.configurationService = _core_src_util__WEBPACK_IMPORTED_MODULE_3__[\"default\"].concatenateUrl(editor.getParam('wiriscontextpath'), integrationModelProperties.configurationService);\n        editor.getParam('wiriscontextpath') + '/' + integrationModelProperties.configurationService;\n      }\n\n      integrationModelProperties.scriptName = \"plugin.min.js\";\n      integrationModelProperties.environment = {};\n      var editorVersion = '4';\n\n      if (tinyMCE.majorVersion === '5') {\n        editorVersion = '5';\n      }\n\n      integrationModelProperties.environment.editor = 'TinyMCE ' + editorVersion + '.x';\n      integrationModelProperties.callbackMethodArguments = callbackMethodArguments;\n      integrationModelProperties.editorObject = editor;\n      integrationModelProperties.initParsed = false; // We need to create the instance before TinyMce initialization in order to register commands.\n      // However, as TinyMCE is not initialized at this point the HTML target is not created.\n      // Here we create the target as null and onInit object the target is updated.\n\n      integrationModelProperties.target = null;\n      var isExternalPlugin = typeof editor.getParam('external_plugins') !== 'undefined' && 'tiny_mce_wiris' in editor.getParam('external_plugins');\n      integrationModelProperties.isExternal = isExternalPlugin;\n      integrationModelProperties.rtl = editor.getParam('directionality') === 'rtl'; // GenericIntegration instance.\n\n      var tinyMceIntegrationInstance = new TinyMceIntegration(integrationModelProperties);\n      tinyMceIntegrationInstance.init();\n      WirisPlugin.instances[tinyMceIntegrationInstance.editorObject.id] = tinyMceIntegrationInstance;\n      WirisPlugin.currentInstance = tinyMceIntegrationInstance;\n\n      var onInit = function onInit(editor) {\n        var integrationInstance = WirisPlugin.instances[tinyMceIntegrationInstance.editorObject.id];\n\n        if (!editor.inline) {\n          integrationInstance.setTarget(editor.getContentAreaContainer().firstChild);\n        } else {\n          integrationInstance.setTarget(editor.getElement());\n        }\n\n        integrationInstance.setEditorObject(editor);\n        integrationInstance.listeners.fire('onTargetReady', {});\n\n        if ('wiriseditorparameters' in editor.settings) {\n          _core_src_configuration_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"].update('_wrs_conf_editorParameters', editor.settings.wiriseditorparameters);\n        }\n\n        var content = editor.getContent(); // Bug fix: In Moodle2.x when TinyMCE is set to full screen\n        // the content doesn't need to be filtered.\n\n        if (!editor.getParam('fullscreen_is_enabled') && content !== \"\") {\n          // We set content in html because other tiny plugins need data-mce\n          // and this is not posibil with raw format.\n          editor.setContent(_core_src_parser_js__WEBPACK_IMPORTED_MODULE_2__[\"default\"].initParse(content, editor.getParam('language')), {\n            format: \"html\"\n          }); // This clean undoQueue for prevent onChange and Dirty state.\n\n          editor.undoManager.clear();\n        } // Init parsing OK. If a setContent method is called\n        // wrs_initParse is called again.\n        // Now if source code is edited the returned code is parsed.\n        // PLUGINS-1070: We set this variable out of condition to parse content after.\n\n\n        WirisPlugin.instances[editor.id].initParsed = true;\n      };\n\n      if ('onInit' in editor) {\n        editor.onInit.add(onInit);\n      } else {\n        editor.on('init', function () {\n          onInit(editor);\n        });\n      }\n\n      if ('onActivate' in editor) {\n        editor.onActivate.add(function (editor) {\n          WirisPlugin.currentInstance = WirisPlugin.instances[tinymce.activeEditor.id];\n        });\n      } else {\n        editor.on('focus', function (event) {\n          WirisPlugin.currentInstance = WirisPlugin.instances[tinymce.activeEditor.id];\n        });\n      }\n\n      var onSave = function onSave(editor, params) {\n        params.content = _core_src_parser_js__WEBPACK_IMPORTED_MODULE_2__[\"default\"].endParse(params.content, editor.getParam('language'));\n      };\n\n      if ('onSaveContent' in editor) {\n        editor.onSaveContent.add(onSave);\n      } else {\n        editor.on('saveContent', function (params) {\n          onSave(editor, params);\n        });\n      }\n\n      if ('onGetContent' in editor) {\n        editor.onGetContent.add(onSave);\n      } else {\n        editor.on('getContent', function (params) {\n          onSave(editor, params);\n        });\n      }\n\n      if ('onBeforeSetContent' in editor) {\n        editor.onBeforeSetContent.add(function (e, params) {\n          if (WirisPlugin.instances[editor.id].initParsed) {\n            params.content = _core_src_parser_js__WEBPACK_IMPORTED_MODULE_2__[\"default\"].initParse(params.content, editor.getParam('language'));\n          }\n        });\n      } else {\n        editor.on('beforeSetContent', function (params) {\n          if (WirisPlugin.instances[editor.id].initParsed) {\n            params.content = _core_src_parser_js__WEBPACK_IMPORTED_MODULE_2__[\"default\"].initParse(params.content, editor.getParam('language'));\n          }\n        });\n      } // We use a mutation to observe iframe of tiny and filter to remove data-mce.\n\n\n      var observerConfig = {\n        attributes: true,\n        childList: true,\n        characterData: true,\n        subtree: true\n      };\n\n      function onMutations(mutations) {\n        Array.prototype.forEach.call(mutations, function (mutation) {\n          Array.prototype.forEach.call(mutation.addedNodes, function (node) {\n            // We search only in element nodes.\n            if (node.nodeType == 1) {\n              Array.prototype.forEach.call(node.getElementsByClassName(WirisPlugin.Configuration.get('imageMathmlAttribute')), function (image) {\n                image.removeAttribute('data-mce-src');\n                image.removeAttribute('data-mce-style');\n              });\n            }\n          });\n        });\n      }\n\n      var mutationInstance = new MutationObserver(onMutations); // We wait for iframe definition for observe this.\n\n      function waitForIframeBody() {\n        if (typeof editor.contentDocument != 'undefined') {\n          mutationInstance.observe(editor.getBody(), observerConfig);\n        } else {\n          setTimeout(waitForIframeBody, 50);\n        }\n      }\n\n      waitForIframeBody();\n\n      function openFormulaEditorFunction() {\n        var tinyMceIntegrationInstance = WirisPlugin.instances[editor.id]; // Disable previous custom editors.\n\n        tinyMceIntegrationInstance.core.getCustomEditors().disable();\n        tinyMceIntegrationInstance.openNewFormulaEditor();\n      }\n\n      var commonEditor;\n\n      if (tinyMCE.majorVersion === '5') {\n        commonEditor = editor.ui.registry;\n      } else {\n        commonEditor = editor;\n        commonEditor.addCommand('tiny_mce_wiris_openFormulaEditor', openFormulaEditorFunction);\n      }\n\n      var mathTypeIcon = '<svg width=\"16\" height=\"16\" version=\"1.1\" xmlns=\"http://www.w3.org/2000/svg\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" x=\"0px\" y=\"0px\"viewBox=\"0 0 300 261.7\" style=\"enable-background:new 0 0 300 261.7;\" xml:space=\"preserve\"><g id=icon-wirisformula stroke=\"none\" stroke-width=\"1\" fill-rule=\"evenodd\"><g><path class=\"st1\" d=\"M90.2,257.7c-11.4,0-21.9-6.4-27-16.7l-60-119.9c-7.5-14.9-1.4-33.1,13.5-40.5c14.9-7.5,33.1-1.4,40.5,13.5l27.3,54.7L121.1,39c5.3-15.8,22.4-24.4,38.2-19.1c15.8,5.3,24.4,22.4,19.1,38.2l-59.6,179c-3.9,11.6-14.3,19.7-26.5,20.6C91.6,257.7,90.9,257.7,90.2,257.7\"/></g></g><g><g><path class=\"st2\" d=\"M300,32.8c0-16.4-13.4-29.7-29.9-29.7c-2.9,0-7.2,0.8-7.2,0.8c-37.9,9.1-71.3,14-112,14c-0.3,0-0.6,0-1,0c-16.5,0-29.9,13.3-29.9,29.7c0,16.4,13.4,29.7,29.9,29.7l0,0c45.3,0,83.1-5.3,125.3-15.3h0C289.3,59.5,300,47.4,300,32.8\"/></g></g></svg>'; // MathType button.\n      // Cmd Parameter is needed in TinyMCE4 and onAction parameter is needed in TinyMCE5.\n      // For more details see TinyMCE migration page: https://www.tiny.cloud/docs-preview/migration-from-4.x/\n\n      commonEditor.addButton('tiny_mce_wiris_formulaEditor', {\n        tooltip: 'Insert a math equation - MathType',\n        //TinyMCE3\n        title: 'Insert a math equation - MathType',\n        cmd: 'tiny_mce_wiris_openFormulaEditor',\n        image: WirisPlugin.instances[editor.id].getIconsPath() + 'formula.png',\n        onAction: openFormulaEditorFunction,\n        icon: mathTypeIcon\n      });\n      var chemTypeIcon = '<svg width=\"16\" height=\"16\" version=\"1.1\" xmlns=\"http://www.w3.org/2000/svg\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" x=\"0px\" y=\"0px\" width=\"16px\" height=\"16px\" viewBox=\"0 0 16 16\" enable-background=\"new 0 0 16 16\" xml:space=\"preserve\">  <image id=\"image0\" width=\"16\" height=\"16\" x=\"0\" y=\"0\"href=\"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAQAAAC1+jfqAAAABGdBTUEAALGPC/xhBQAAACBjSFJNAAB6JgAAgIQAAPoAAACA6AAAdTAAAOpgAAA6mAAAF3CculE8AAAAAmJLR0QA/4ePzL8AAAAHdElNRQfiChwSIwERK9BGAAABfklEQVQoz12RvUtbcRiFn/uRXKNJNCJSokFFqoKDIjHEqKA4WRAc/AsUKl2Ck5ODIKKDm4v+BbqIEr8WQ+hgQSgOElGJgkPTih+3tUabeL3353A1CX3Hcx7OC+dIAIL3CwXEmJU6XBHWuyIVgIjrOcoUblCTrolE/D+gc0QsUJePEtrGh+jajzcg1GQu0W87ldl7zZQAtPP9Dh5lADNm25rx+Xb7ZdWMCAARyHXhVQD8iwAD+qLV61B++U4Hb5pKS9Tx3w05Umr+K3Mlsk6SfY7x9oX7OvDiwlEEoLPLNkdc4yRJG9WkuCoCxBV7JMhg8cgRl7h44m9xwhM3PLyVYnBni3LBX64p4MHGYLSzOV9UWDd8AO608iW+2eP5NyVN4JR/7rRU2T0MzVRmATI197FIInsmTeIErcwTxqcAxHPDFdLHE4cJmPV4AAKZ+XStyrkCMC00K8Qnj+6+kAFKjfE/sw6/zAXf7bFUqmill+5v7es+vzVqlhukOWCLr6/ZMH/PRaOKYwAAACV0RVh0ZGF0ZTpjcmVhdGUAMjAxOC0xMC0yOVQwMTozNTowMS0wNzowMOC+eEAAAAAldEVYdGRhdGU6bW9kaWZ5ADIwMTgtMTAtMjlUMDE6MzU6MDEtMDc6MDCR48D8AAAAAElFTkSuQmCC\" /></svg>'; // Dynamic customEditors buttons.\n\n      var customEditors = WirisPlugin.instances[editor.id].getCore().getCustomEditors();\n\n      for (var customEditor in customEditors.editors) {\n        if (customEditors.editors[customEditor].confVariable) {\n          var commandFunction = function commandFunction() {\n            customEditors.enable(customEditor);\n            WirisPlugin.instances[editor.id].openNewFormulaEditor();\n          };\n\n          var cmd = 'tiny_mce_wiris_openFormulaEditor' + customEditors.editors[customEditor].name;\n          ;\n          editor.addCommand(cmd, commandFunction); // Cmd Parameter is needed in TinyMCE4 and onAction parameter is needed in TinyMCE5.\n          // For more details see TinyMCE migration page: https://www.tiny.cloud/docs-preview/migration-from-4.x/\n\n          commonEditor.addButton('tiny_mce_wiris_formulaEditor' + customEditors.editors[customEditor].name, {\n            title: customEditors.editors[customEditor].tooltip,\n            // TinyMCE3\n            tooltip: customEditors.editors[customEditor].tooltip,\n            onAction: commandFunction,\n            cmd: cmd,\n            icon: chemTypeIcon,\n            // At the moment only chemTypeIcon because of the provisional solution for TinyMCE5.\n            image: WirisPlugin.instances[editor.id].getIconsPath() + customEditors.editors[customEditor].icon\n          });\n        }\n      }\n    },\n    // All versions.\n    getInfo: function getInfo() {\n      return {\n        longname: 'tiny_mce_wiris',\n        author: 'Maths for More',\n        authorurl: 'http://www.wiris.com',\n        infourl: 'http://www.wiris.com',\n        version: '7.9.0.1399'\n      };\n    }\n  });\n  tinymce.PluginManager.add('tiny_mce_wiris', tinymce.plugins.tiny_mce_wiris);\n})();\n\n//# sourceURL=webpack:///./editor_plugin.src.js?");

/***/ }),

/***/ "./global.js":
/*!*******************!*\
  !*** ./global.js ***!
  \*******************/
/*! no exports provided */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _core_src_core_src_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./core/src/core.src.js */ \"./core/src/core.src.js\");\n/* harmony import */ var _core_src_parser_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./core/src/parser.js */ \"./core/src/parser.js\");\n/* harmony import */ var _core_src_util_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./core/src/util.js */ \"./core/src/util.js\");\n/* harmony import */ var _core_src_image_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./core/src/image.js */ \"./core/src/image.js\");\n/* harmony import */ var _core_src_configuration_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./core/src/configuration.js */ \"./core/src/configuration.js\");\n/* harmony import */ var _core_src_listeners__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./core/src/listeners */ \"./core/src/listeners.js\");\n/* harmony import */ var _core_src_backwardslib_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./core/src/backwardslib.js */ \"./core/src/backwardslib.js\");\n/* harmony import */ var _core_src_polyfills_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./core/src/polyfills.js */ \"./core/src/polyfills.js\");\n/* harmony import */ var _core_src_integrationmodel_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./core/src/integrationmodel.js */ \"./core/src/integrationmodel.js\");\n/* harmony import */ var _editor_plugin_src_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./editor_plugin.src.js */ \"./editor_plugin.src.js\");\n/* harmony import */ var _core_src_latex__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./core/src/latex */ \"./core/src/latex.js\");\n/* harmony import */ var _core_styles_src_css__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./core/styles.src.css */ \"./core/styles.src.css\");\n/* harmony import */ var _core_styles_src_css__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(_core_styles_src_css__WEBPACK_IMPORTED_MODULE_11__);\n\n\n\n\n\n\n\n\n\n\n\n // Expose WirisPlugin variable to the window.\n\nwindow.WirisPlugin = {\n  Core: _core_src_core_src_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"],\n  Parser: _core_src_parser_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"],\n  Image: _core_src_image_js__WEBPACK_IMPORTED_MODULE_3__[\"default\"],\n  Util: _core_src_util_js__WEBPACK_IMPORTED_MODULE_2__[\"default\"],\n  Configuration: _core_src_configuration_js__WEBPACK_IMPORTED_MODULE_4__[\"default\"],\n  Listeners: _core_src_listeners__WEBPACK_IMPORTED_MODULE_5__[\"default\"],\n  IntegrationModel: _core_src_integrationmodel_js__WEBPACK_IMPORTED_MODULE_8__[\"default\"],\n  currentInstance: _editor_plugin_src_js__WEBPACK_IMPORTED_MODULE_9__[\"currentInstance\"],\n  instances: _editor_plugin_src_js__WEBPACK_IMPORTED_MODULE_9__[\"instances\"],\n  TinyMceIntegration: _editor_plugin_src_js__WEBPACK_IMPORTED_MODULE_9__[\"TinyMceIntegration\"],\n  Latex: _core_src_latex__WEBPACK_IMPORTED_MODULE_10__[\"default\"]\n};\n\n//# sourceURL=webpack:///./global.js?");

/***/ }),

/***/ "./node_modules/mini-css-extract-plugin/dist/loader.js!./node_modules/css-loader/index.js!./core/styles.src.css":
/*!*************************************************************************************************************!*\
  !*** ./node_modules/mini-css-extract-plugin/dist/loader.js!./node_modules/css-loader!./core/styles.src.css ***!
  \*************************************************************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

eval("// extracted by mini-css-extract-plugin\n\n//# sourceURL=webpack:///./core/styles.src.css?./node_modules/mini-css-extract-plugin/dist/loader.js!./node_modules/css-loader");

/***/ }),

/***/ "./node_modules/style-loader/lib/addStyles.js":
/*!****************************************************!*\
  !*** ./node_modules/style-loader/lib/addStyles.js ***!
  \****************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

eval("/*\n\tMIT License http://www.opensource.org/licenses/mit-license.php\n\tAuthor Tobias Koppers @sokra\n*/\n\nvar stylesInDom = {};\n\nvar\tmemoize = function (fn) {\n\tvar memo;\n\n\treturn function () {\n\t\tif (typeof memo === \"undefined\") memo = fn.apply(this, arguments);\n\t\treturn memo;\n\t};\n};\n\nvar isOldIE = memoize(function () {\n\t// Test for IE <= 9 as proposed by Browserhacks\n\t// @see http://browserhacks.com/#hack-e71d8692f65334173fee715c222cb805\n\t// Tests for existence of standard globals is to allow style-loader\n\t// to operate correctly into non-standard environments\n\t// @see https://github.com/webpack-contrib/style-loader/issues/177\n\treturn window && document && document.all && !window.atob;\n});\n\nvar getTarget = function (target, parent) {\n  if (parent){\n    return parent.querySelector(target);\n  }\n  return document.querySelector(target);\n};\n\nvar getElement = (function (fn) {\n\tvar memo = {};\n\n\treturn function(target, parent) {\n                // If passing function in options, then use it for resolve \"head\" element.\n                // Useful for Shadow Root style i.e\n                // {\n                //   insertInto: function () { return document.querySelector(\"#foo\").shadowRoot }\n                // }\n                if (typeof target === 'function') {\n                        return target();\n                }\n                if (typeof memo[target] === \"undefined\") {\n\t\t\tvar styleTarget = getTarget.call(this, target, parent);\n\t\t\t// Special case to return head of iframe instead of iframe itself\n\t\t\tif (window.HTMLIFrameElement && styleTarget instanceof window.HTMLIFrameElement) {\n\t\t\t\ttry {\n\t\t\t\t\t// This will throw an exception if access to iframe is blocked\n\t\t\t\t\t// due to cross-origin restrictions\n\t\t\t\t\tstyleTarget = styleTarget.contentDocument.head;\n\t\t\t\t} catch(e) {\n\t\t\t\t\tstyleTarget = null;\n\t\t\t\t}\n\t\t\t}\n\t\t\tmemo[target] = styleTarget;\n\t\t}\n\t\treturn memo[target]\n\t};\n})();\n\nvar singleton = null;\nvar\tsingletonCounter = 0;\nvar\tstylesInsertedAtTop = [];\n\nvar\tfixUrls = __webpack_require__(/*! ./urls */ \"./node_modules/style-loader/lib/urls.js\");\n\nmodule.exports = function(list, options) {\n\tif (typeof DEBUG !== \"undefined\" && DEBUG) {\n\t\tif (typeof document !== \"object\") throw new Error(\"The style-loader cannot be used in a non-browser environment\");\n\t}\n\n\toptions = options || {};\n\n\toptions.attrs = typeof options.attrs === \"object\" ? options.attrs : {};\n\n\t// Force single-tag solution on IE6-9, which has a hard limit on the # of <style>\n\t// tags it will allow on a page\n\tif (!options.singleton && typeof options.singleton !== \"boolean\") options.singleton = isOldIE();\n\n\t// By default, add <style> tags to the <head> element\n        if (!options.insertInto) options.insertInto = \"head\";\n\n\t// By default, add <style> tags to the bottom of the target\n\tif (!options.insertAt) options.insertAt = \"bottom\";\n\n\tvar styles = listToStyles(list, options);\n\n\taddStylesToDom(styles, options);\n\n\treturn function update (newList) {\n\t\tvar mayRemove = [];\n\n\t\tfor (var i = 0; i < styles.length; i++) {\n\t\t\tvar item = styles[i];\n\t\t\tvar domStyle = stylesInDom[item.id];\n\n\t\t\tdomStyle.refs--;\n\t\t\tmayRemove.push(domStyle);\n\t\t}\n\n\t\tif(newList) {\n\t\t\tvar newStyles = listToStyles(newList, options);\n\t\t\taddStylesToDom(newStyles, options);\n\t\t}\n\n\t\tfor (var i = 0; i < mayRemove.length; i++) {\n\t\t\tvar domStyle = mayRemove[i];\n\n\t\t\tif(domStyle.refs === 0) {\n\t\t\t\tfor (var j = 0; j < domStyle.parts.length; j++) domStyle.parts[j]();\n\n\t\t\t\tdelete stylesInDom[domStyle.id];\n\t\t\t}\n\t\t}\n\t};\n};\n\nfunction addStylesToDom (styles, options) {\n\tfor (var i = 0; i < styles.length; i++) {\n\t\tvar item = styles[i];\n\t\tvar domStyle = stylesInDom[item.id];\n\n\t\tif(domStyle) {\n\t\t\tdomStyle.refs++;\n\n\t\t\tfor(var j = 0; j < domStyle.parts.length; j++) {\n\t\t\t\tdomStyle.parts[j](item.parts[j]);\n\t\t\t}\n\n\t\t\tfor(; j < item.parts.length; j++) {\n\t\t\t\tdomStyle.parts.push(addStyle(item.parts[j], options));\n\t\t\t}\n\t\t} else {\n\t\t\tvar parts = [];\n\n\t\t\tfor(var j = 0; j < item.parts.length; j++) {\n\t\t\t\tparts.push(addStyle(item.parts[j], options));\n\t\t\t}\n\n\t\t\tstylesInDom[item.id] = {id: item.id, refs: 1, parts: parts};\n\t\t}\n\t}\n}\n\nfunction listToStyles (list, options) {\n\tvar styles = [];\n\tvar newStyles = {};\n\n\tfor (var i = 0; i < list.length; i++) {\n\t\tvar item = list[i];\n\t\tvar id = options.base ? item[0] + options.base : item[0];\n\t\tvar css = item[1];\n\t\tvar media = item[2];\n\t\tvar sourceMap = item[3];\n\t\tvar part = {css: css, media: media, sourceMap: sourceMap};\n\n\t\tif(!newStyles[id]) styles.push(newStyles[id] = {id: id, parts: [part]});\n\t\telse newStyles[id].parts.push(part);\n\t}\n\n\treturn styles;\n}\n\nfunction insertStyleElement (options, style) {\n\tvar target = getElement(options.insertInto)\n\n\tif (!target) {\n\t\tthrow new Error(\"Couldn't find a style target. This probably means that the value for the 'insertInto' parameter is invalid.\");\n\t}\n\n\tvar lastStyleElementInsertedAtTop = stylesInsertedAtTop[stylesInsertedAtTop.length - 1];\n\n\tif (options.insertAt === \"top\") {\n\t\tif (!lastStyleElementInsertedAtTop) {\n\t\t\ttarget.insertBefore(style, target.firstChild);\n\t\t} else if (lastStyleElementInsertedAtTop.nextSibling) {\n\t\t\ttarget.insertBefore(style, lastStyleElementInsertedAtTop.nextSibling);\n\t\t} else {\n\t\t\ttarget.appendChild(style);\n\t\t}\n\t\tstylesInsertedAtTop.push(style);\n\t} else if (options.insertAt === \"bottom\") {\n\t\ttarget.appendChild(style);\n\t} else if (typeof options.insertAt === \"object\" && options.insertAt.before) {\n\t\tvar nextSibling = getElement(options.insertAt.before, target);\n\t\ttarget.insertBefore(style, nextSibling);\n\t} else {\n\t\tthrow new Error(\"[Style Loader]\\n\\n Invalid value for parameter 'insertAt' ('options.insertAt') found.\\n Must be 'top', 'bottom', or Object.\\n (https://github.com/webpack-contrib/style-loader#insertat)\\n\");\n\t}\n}\n\nfunction removeStyleElement (style) {\n\tif (style.parentNode === null) return false;\n\tstyle.parentNode.removeChild(style);\n\n\tvar idx = stylesInsertedAtTop.indexOf(style);\n\tif(idx >= 0) {\n\t\tstylesInsertedAtTop.splice(idx, 1);\n\t}\n}\n\nfunction createStyleElement (options) {\n\tvar style = document.createElement(\"style\");\n\n\tif(options.attrs.type === undefined) {\n\t\toptions.attrs.type = \"text/css\";\n\t}\n\n\tif(options.attrs.nonce === undefined) {\n\t\tvar nonce = getNonce();\n\t\tif (nonce) {\n\t\t\toptions.attrs.nonce = nonce;\n\t\t}\n\t}\n\n\taddAttrs(style, options.attrs);\n\tinsertStyleElement(options, style);\n\n\treturn style;\n}\n\nfunction createLinkElement (options) {\n\tvar link = document.createElement(\"link\");\n\n\tif(options.attrs.type === undefined) {\n\t\toptions.attrs.type = \"text/css\";\n\t}\n\toptions.attrs.rel = \"stylesheet\";\n\n\taddAttrs(link, options.attrs);\n\tinsertStyleElement(options, link);\n\n\treturn link;\n}\n\nfunction addAttrs (el, attrs) {\n\tObject.keys(attrs).forEach(function (key) {\n\t\tel.setAttribute(key, attrs[key]);\n\t});\n}\n\nfunction getNonce() {\n\tif (false) {}\n\n\treturn __webpack_require__.nc;\n}\n\nfunction addStyle (obj, options) {\n\tvar style, update, remove, result;\n\n\t// If a transform function was defined, run it on the css\n\tif (options.transform && obj.css) {\n\t    result = typeof options.transform === 'function'\n\t\t ? options.transform(obj.css) \n\t\t : options.transform.default(obj.css);\n\n\t    if (result) {\n\t    \t// If transform returns a value, use that instead of the original css.\n\t    \t// This allows running runtime transformations on the css.\n\t    \tobj.css = result;\n\t    } else {\n\t    \t// If the transform function returns a falsy value, don't add this css.\n\t    \t// This allows conditional loading of css\n\t    \treturn function() {\n\t    \t\t// noop\n\t    \t};\n\t    }\n\t}\n\n\tif (options.singleton) {\n\t\tvar styleIndex = singletonCounter++;\n\n\t\tstyle = singleton || (singleton = createStyleElement(options));\n\n\t\tupdate = applyToSingletonTag.bind(null, style, styleIndex, false);\n\t\tremove = applyToSingletonTag.bind(null, style, styleIndex, true);\n\n\t} else if (\n\t\tobj.sourceMap &&\n\t\ttypeof URL === \"function\" &&\n\t\ttypeof URL.createObjectURL === \"function\" &&\n\t\ttypeof URL.revokeObjectURL === \"function\" &&\n\t\ttypeof Blob === \"function\" &&\n\t\ttypeof btoa === \"function\"\n\t) {\n\t\tstyle = createLinkElement(options);\n\t\tupdate = updateLink.bind(null, style, options);\n\t\tremove = function () {\n\t\t\tremoveStyleElement(style);\n\n\t\t\tif(style.href) URL.revokeObjectURL(style.href);\n\t\t};\n\t} else {\n\t\tstyle = createStyleElement(options);\n\t\tupdate = applyToTag.bind(null, style);\n\t\tremove = function () {\n\t\t\tremoveStyleElement(style);\n\t\t};\n\t}\n\n\tupdate(obj);\n\n\treturn function updateStyle (newObj) {\n\t\tif (newObj) {\n\t\t\tif (\n\t\t\t\tnewObj.css === obj.css &&\n\t\t\t\tnewObj.media === obj.media &&\n\t\t\t\tnewObj.sourceMap === obj.sourceMap\n\t\t\t) {\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\tupdate(obj = newObj);\n\t\t} else {\n\t\t\tremove();\n\t\t}\n\t};\n}\n\nvar replaceText = (function () {\n\tvar textStore = [];\n\n\treturn function (index, replacement) {\n\t\ttextStore[index] = replacement;\n\n\t\treturn textStore.filter(Boolean).join('\\n');\n\t};\n})();\n\nfunction applyToSingletonTag (style, index, remove, obj) {\n\tvar css = remove ? \"\" : obj.css;\n\n\tif (style.styleSheet) {\n\t\tstyle.styleSheet.cssText = replaceText(index, css);\n\t} else {\n\t\tvar cssNode = document.createTextNode(css);\n\t\tvar childNodes = style.childNodes;\n\n\t\tif (childNodes[index]) style.removeChild(childNodes[index]);\n\n\t\tif (childNodes.length) {\n\t\t\tstyle.insertBefore(cssNode, childNodes[index]);\n\t\t} else {\n\t\t\tstyle.appendChild(cssNode);\n\t\t}\n\t}\n}\n\nfunction applyToTag (style, obj) {\n\tvar css = obj.css;\n\tvar media = obj.media;\n\n\tif(media) {\n\t\tstyle.setAttribute(\"media\", media)\n\t}\n\n\tif(style.styleSheet) {\n\t\tstyle.styleSheet.cssText = css;\n\t} else {\n\t\twhile(style.firstChild) {\n\t\t\tstyle.removeChild(style.firstChild);\n\t\t}\n\n\t\tstyle.appendChild(document.createTextNode(css));\n\t}\n}\n\nfunction updateLink (link, options, obj) {\n\tvar css = obj.css;\n\tvar sourceMap = obj.sourceMap;\n\n\t/*\n\t\tIf convertToAbsoluteUrls isn't defined, but sourcemaps are enabled\n\t\tand there is no publicPath defined then lets turn convertToAbsoluteUrls\n\t\ton by default.  Otherwise default to the convertToAbsoluteUrls option\n\t\tdirectly\n\t*/\n\tvar autoFixUrls = options.convertToAbsoluteUrls === undefined && sourceMap;\n\n\tif (options.convertToAbsoluteUrls || autoFixUrls) {\n\t\tcss = fixUrls(css);\n\t}\n\n\tif (sourceMap) {\n\t\t// http://stackoverflow.com/a/26603875\n\t\tcss += \"\\n/*# sourceMappingURL=data:application/json;base64,\" + btoa(unescape(encodeURIComponent(JSON.stringify(sourceMap)))) + \" */\";\n\t}\n\n\tvar blob = new Blob([css], { type: \"text/css\" });\n\n\tvar oldSrc = link.href;\n\n\tlink.href = URL.createObjectURL(blob);\n\n\tif(oldSrc) URL.revokeObjectURL(oldSrc);\n}\n\n\n//# sourceURL=webpack:///./node_modules/style-loader/lib/addStyles.js?");

/***/ }),

/***/ "./node_modules/style-loader/lib/urls.js":
/*!***********************************************!*\
  !*** ./node_modules/style-loader/lib/urls.js ***!
  \***********************************************/
/*! no static exports found */
/***/ (function(module, exports) {

eval("\n/**\n * When source maps are enabled, `style-loader` uses a link element with a data-uri to\n * embed the css on the page. This breaks all relative urls because now they are relative to a\n * bundle instead of the current page.\n *\n * One solution is to only use full urls, but that may be impossible.\n *\n * Instead, this function \"fixes\" the relative urls to be absolute according to the current page location.\n *\n * A rudimentary test suite is located at `test/fixUrls.js` and can be run via the `npm test` command.\n *\n */\n\nmodule.exports = function (css) {\n  // get current location\n  var location = typeof window !== \"undefined\" && window.location;\n\n  if (!location) {\n    throw new Error(\"fixUrls requires window.location\");\n  }\n\n\t// blank or null?\n\tif (!css || typeof css !== \"string\") {\n\t  return css;\n  }\n\n  var baseUrl = location.protocol + \"//\" + location.host;\n  var currentDir = baseUrl + location.pathname.replace(/\\/[^\\/]*$/, \"/\");\n\n\t// convert each url(...)\n\t/*\n\tThis regular expression is just a way to recursively match brackets within\n\ta string.\n\n\t /url\\s*\\(  = Match on the word \"url\" with any whitespace after it and then a parens\n\t   (  = Start a capturing group\n\t     (?:  = Start a non-capturing group\n\t         [^)(]  = Match anything that isn't a parentheses\n\t         |  = OR\n\t         \\(  = Match a start parentheses\n\t             (?:  = Start another non-capturing groups\n\t                 [^)(]+  = Match anything that isn't a parentheses\n\t                 |  = OR\n\t                 \\(  = Match a start parentheses\n\t                     [^)(]*  = Match anything that isn't a parentheses\n\t                 \\)  = Match a end parentheses\n\t             )  = End Group\n              *\\) = Match anything and then a close parens\n          )  = Close non-capturing group\n          *  = Match anything\n       )  = Close capturing group\n\t \\)  = Match a close parens\n\n\t /gi  = Get all matches, not the first.  Be case insensitive.\n\t */\n\tvar fixedCss = css.replace(/url\\s*\\(((?:[^)(]|\\((?:[^)(]+|\\([^)(]*\\))*\\))*)\\)/gi, function(fullMatch, origUrl) {\n\t\t// strip quotes (if they exist)\n\t\tvar unquotedOrigUrl = origUrl\n\t\t\t.trim()\n\t\t\t.replace(/^\"(.*)\"$/, function(o, $1){ return $1; })\n\t\t\t.replace(/^'(.*)'$/, function(o, $1){ return $1; });\n\n\t\t// already a full url? no change\n\t\tif (/^(#|data:|http:\\/\\/|https:\\/\\/|file:\\/\\/\\/|\\s*$)/i.test(unquotedOrigUrl)) {\n\t\t  return fullMatch;\n\t\t}\n\n\t\t// convert the url to a full url\n\t\tvar newUrl;\n\n\t\tif (unquotedOrigUrl.indexOf(\"//\") === 0) {\n\t\t  \t//TODO: should we add protocol?\n\t\t\tnewUrl = unquotedOrigUrl;\n\t\t} else if (unquotedOrigUrl.indexOf(\"/\") === 0) {\n\t\t\t// path should be relative to the base url\n\t\t\tnewUrl = baseUrl + unquotedOrigUrl; // already starts with '/'\n\t\t} else {\n\t\t\t// path should be relative to current directory\n\t\t\tnewUrl = currentDir + unquotedOrigUrl.replace(/^\\.\\//, \"\"); // Strip leading './'\n\t\t}\n\n\t\t// send back the fixed url(...)\n\t\treturn \"url(\" + JSON.stringify(newUrl) + \")\";\n\t});\n\n\t// send back the fixed css\n\treturn fixedCss;\n};\n\n\n//# sourceURL=webpack:///./node_modules/style-loader/lib/urls.js?");

/***/ })

/******/ });