
MathType for TinyMCE4 [![Tweet](https://img.shields.io/twitter/url/http/shields.io.svg?style=social)](https://twitter.com/wirismath)
===================================

MathType is a WYSIWYG editor to edit math equations and chemistry formulas. This package allows integrating MathType into TinyMCE4.

![MathType for Froala screenshot](http://www.wiris.com/system/files/attachments/1202/TinyMCE_editor_plugin.png)

# Table of Contents
- [Install instructions](#install-instructions)
- [Services](#services)
- [Documentation](#documentation)

## Installation
If you want to use MathType in TinyMCE4, please follow the steps below:

1. Install the npm module
    ```
    npm install @wiris/mathtype-tinymce4
    ```
2. Add the plugin to TinyMCE4 configuration as an external plugin:
    ```js
    tinymce.init({
        external_plugins: {
              'tiny_mce_wiris' : 'http://localhost/project/npm-tinymce4/node_modules/@wiris/mathtype-tinymce4/plugin.min.js'
        }
     });
    ```
    The external_plugin parameter needs an absolute URL due to a TinyMCE4 issue. See [TinyMCE4 tracker](https://github.com/tinymce/tinymce/issues/3056) for further information.
3. Add the MathType buttons to TinyMCE4 toolbar
    ```js
    tinymce.init({
        toolbar: 'tiny_mce_wiris_formulaEditor,tiny_mce_wiris_formulaEditorChemistry',
     });
    ```
    Notice that the example is assuming that you have the following directory structure and the plugin path may be ajusted.
    ```
    project
    └───node_modules
        └───@wiris/mathtype-tinymce4
    ```
## Services

This npm module uses services remotely hosted to render MathML data. However is strongly recommended to install this services in your backend. This will allow you, among other things, to customize the backend service and store locally the images generated by MathType.

The services are available for the following technologies: Java, PHP, .NET and Ruby on Rails. If you use any of this technologies, please download the plugin for your backend technology from [here](http://www.wiris.com/en/plugins3/tinymce/download).

In order to install the plugin along with the correspondent services, please follow the [TinyMCE4 install instructions](http://docs.wiris.com/en/mathtype/mathtype_web/integrations/html/tinymce).

## Documentation
To find out more information about MathType, please go to the following documentation:

* [Install instructions](http://docs.wiris.com/en/mathtype/mathtype_web/integrations/html/tinymce)
* [MathType documentation](http://docs.wiris.com/en/mathtype/mathtype_web/start)
* [Introductory tutorials](http://docs.wiris.com/en/mathtype/mathtype_web/intro_tutorials)
* [Service customization](http://docs.wiris.com/en/mathtype/mathtype_web/integrations/config-table)
* [Testing](http://docs.wiris.com/en/mathtype/mathtype_web/integrations/html/plugins-test)