<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Finger extends CI_Controller {

	public function __construct()
	{
		parent::__construct();
		$this->load->model('finger_model','finger');
		$this->load->helper('url');
		if ($this->session->userdata('username')=='') {
            redirect('login');
        }
	}

	public function index()
	{
		$this->template->display('admin/finger');
	}
	public function balikin($str){
		$search = array ("'xpsijix'");
		$replace = array ("'");
		$str = preg_replace($search,$replace,$str);
		return $str;
	}
	public function ajax_list()
	{
		$list = $this->finger->get_datatables();
		$data = array();
		$no = $_POST['start'];
		foreach ($list as $finger) {
			$no++;
			$row = array();
			$row[] = $no;
			$row[] = '<a class="btn btn-white btn-primary btn-sm" href="javascript:void(0)" title="Edit Finger" onclick="edit_finger('."'".$finger->id."'".')"><i class="glyphicon glyphicon-pencil"></i></a>
				  <a class="btn btn-white btn-danger btn-sm" href="javascript:void(0)" title="Hapus" onclick="delete_log('."'".$finger->id."'".')"><i class="glyphicon glyphicon-trash"></i></a>';
			$row[] = $finger->ip;
			$row[] = $finger->desk;
			$row[] = $finger->publish;
			$Connect = @fsockopen('192.168.19.200', 80);
			exec("ping -c 4 " . $finger->ip, $output, $result);

			if ($result != 0) {
				$row[] ='<button class="btn btn-danger">Mati</button>';
			} else {
				$row[] ='<button class="btn btn-success">Terkoneksi</button>';
			}
			$data[] = $row;
		}

			$output = array(
						"draw" => $_POST['draw'],
						"recordsTotal" => $this->finger->count_all(),
						"recordsFiltered" => $this->finger->count_filtered(),
						"data" => $data,
				);

		echo json_encode($output);
	}


	public function ajax_edit($id)
	{
		$data = $this->finger->get_by_id($id);
		echo json_encode($data);
	}
	public function ajax_add()
	{
		$this->_validate();
		$data = array(
				'ip' => $this->input->post('ip'),
				'desk' => $this->input->post('desk'),
				'publish' => $this->input->post('publish'),
			);

		$insert = $this->finger->save($data);

		echo json_encode(array("status" => TRUE));
	}
	public function ajax_update()
	{
		$this->_validate();
		$data = array(
				'ip' => $this->input->post('ip'),
				'desk' => $this->input->post('desk'),
				'publish' => $this->input->post('publish'),
			);

		$this->finger->update(array('id' => $this->input->post('id')), $data);
		echo json_encode(array("status" => TRUE));
	}
	public function ajax_delete($id)
	{
		$finger = $this->finger->get_by_id($id);
		$this->finger->delete_by_id($id);
		echo json_encode(array("status" => TRUE));
	}
	private function _validate()
	{
		$data = array();
		$data['error_string'] = array();
		$data['inputerror'] = array();
		$data['status'] = TRUE;

		if($this->input->post('ip') == '')
		{
			$data['inputerror'][] = 'ip';
			$data['error_string'][] = 'IP wajib di isi';
			$data['status'] = FALSE;
		}
		if($data['status'] === FALSE)
		{
			echo json_encode($data);
			exit();
		}
	}

}
