<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Laporan extends CI_Controller {

	public function __construct()
	{
		parent::__construct();
		$this->load->model('siswa_model','siswa');
		$this->load->helper('url');
		$this->load->helper('nama');
		if ($this->session->userdata('username')=='') {
            redirect('login');
        }
	}

	public function index()
	{
		$this->template->display('admin/laporan');
	}
	public function harian()
	{

		$this->load->view('admin/cetakhadir');
	}
	public function bulanan()
	{

		$this->load->view('admin/cetakbulanan');
	}
	public function semester()
	{

		$this->load->view('admin/cetakrekapsemester');
	}
	public function individu()
	{

		$this->load->view('admin/cetakrekap');
	}
	public function perindividu()
	{

		$this->load->view('admin/cetakrekapin');
	}

	public function balikin($str){
		$search = array ("'xpsijix'");
		$replace = array ("'");
		$str = preg_replace($search,$replace,$str);
		return $str;
	}
	public function ajax_list()
	{
		$list = $this->siswa->get_datatables();
		$data = array();
		$no = $_POST['start'];

		foreach ($list as $siswa) {
			$no++;
			$row = array();
			$row[] = $no;
			$row[] = '<a class="btn btn-white btn-primary btn-sm" href="javascript:void(0)" title="Edit Individu" onclick="edit_siswa('."'".$siswa->NIP."'".')"><i class="glyphicon glyphicon-pencil"></i></a>
				  <a class="btn btn-white btn-danger btn-sm" href="javascript:void(0)" title="Hapus" onclick="delete_siswa('."'".$siswa->NIP."'".')"><i class="glyphicon glyphicon-trash"></i></a>';
			$row[] = $siswa->absen;
			$row[] = $siswa->NM_PEGAWAI;
			$row[] = $siswa->NOMOR_INDUK_BARU;
			$cekkelas=$this->db->query("SELECT * FROM web_kelas WHERE kode='".$siswa->KD_JENIS_KETENAGAAN."'");
			foreach ($cekkelas->result() as $baris) {
				$namakelas=$baris->nama;
			}
			$row[] =$namakelas;
			$data[] = $row;
		}

			$output = array(
						"draw" => $_POST['draw'],
						"recordsTotal" => $this->siswa->count_all(),
						"recordsFiltered" => $this->siswa->count_filtered(),
						"data" => $data,
				);

		echo json_encode($output);
	}
	public function cetakku()
	{
		$this->load->view('admin/cetakharian');

	}
	public function export()
	{
		header("Content-type: application/vnd-ms-excel");
		header("Content-Disposition: attachment; filename=DataSiswa.xls");
		?>
		<table border="1">
					<thead>
					<tr>
						<th width="3%"><div align="center" >No</div></th>
						<th width="9%"><div align="center" >No Daftar</div></th>
						<th width="15%"><div align="center" >No Daftar Ulang</div></th>
						<th width="10%"><div align="center" >Nama</div></th>
						<th width="10%"><div align="center" >Tempat, Tanggal Lahir</div></th>
						<th width="2%"><div align="center" >JK</div></th>
						<th width="39%"><div align="center" >Alamat</div></th>
						<th width="10%"><div align="center" >No HP</div></th>
						<th width="10%"><div align="center" >NISN</div></th>
						<th width="10%"><div align="center" >NIK</div></th>
						<th width="20%"><div align="center" >Asal Sekolah</div></th>
						<th width="2%"><div align="center" >Jurusan</div></th>
						<th width="2%"><div align="center" >Gelombang</div></th>
					</tr>
					</thead>
		<tbody>
		<?php
		$dua=$this->db->query("SELECT * FROM `biodata_siswa`");
		$no=1;
		foreach ($dua->result() as $row) {
						$id=$row->absen;
						$nodaftar=$row->nodaftar;
						$nodaftarulang=$row->nodaftarulang;
						$nama=balikin($row->nama);
						$tem_lahir=$row->tem_lahir;
						$jurusan1=$row->jurusan1;
						$tgl=$row->tgl;
						$bln=$row->bln;
						$tahun=$row->tahun;
						$alamat=$row->alamat;
						$hp=$row->hp;
						$nisn=$row->nisn;
						$nik=$row->nik;
						$asal_sek=$row->asal_sek;
						$jkel=$row->jkel;
						$gelombang=$row->gelombang;
						?>
						  <tr >
						  <td class="ttl" align="center"><?php echo $no;?></td>
							<td class="ul" align="center"><?php echo "19/NU/".$nodaftar;?></td>
							<td class="ul" align="center"><?php echo "'".$nodaftarulang;?></td>
							<td class="ul"><?php echo $nama;?></td>
							<td class="ul"><?php echo $tem_lahir.", ".$tgl."-".$bln."-".$tahun;?></td>
							<td class="ul"><?php echo $jkel;?></td>
							<td class="ul"><?php echo $alamat;?></td>
							<td class="ul"><?php echo "'".$hp;?></td>
							<td class="ul"><?php echo "'".$nisn;?></td>
							<td class="ul"><?php echo "'".$nik;?></td>
							<td class="ul"><?php echo $asal_sek;?></td>
							<td class="ul"><?php echo $jurusan1;?></td>
							<td align="center" class="ul"><strong><?php echo $gelombang;?></strong></td>
						  </tr>
						  <?php $no++;}?>
					</tbody>
		</table>
	<?php
	}
	public function ajax_edit($id)
	{
		$data = $this->siswa->get_by_id($id);
		echo json_encode($data);
	}

	public function ajax_add()
	{
		$this->_validate();
		$hariini = date("Y-m-d");
		$data = array(
				'absen' => $this->input->post('absen'),
				'NM_PEGAWAI' => $this->input->post('nama'),
				'ALAMAT' => $this->input->post('alamat'),
				'NO_HP' => $this->input->post('nohp'),
				'KD_JENIS_KETENAGAAN' => $this->input->post('kd_jenis'),
				'SEN' => $this->input->post('senin'),
				'SEL' => $this->input->post('selasa'),
				'RAB' => $this->input->post('rabu'),
				'KAM' => $this->input->post('kamis'),
				'JUM' => $this->input->post('jumat'),
				'SAB' => $this->input->post('sabtu'),
				'MIN' => $this->input->post('minggu'),
			);

		$insert = $this->siswa->save($data);

		echo json_encode(array("status" => TRUE));
	}

	public function ajax_update()
	{
		$this->_validate();
		$data = array(
				'absen' => $this->input->post('absen'),
				'NM_PEGAWAI' => $this->input->post('nama'),
				'ALAMAT' => $this->input->post('alamat'),
				'NO_HP' => $this->input->post('nohp'),
				'KD_JENIS_KETENAGAAN' => $this->input->post('kd_jenis'),
				'SEN' => $this->input->post('senin'),
				'SEL' => $this->input->post('selasa'),
				'RAB' => $this->input->post('rabu'),
				'KAM' => $this->input->post('kamis'),
				'JUM' => $this->input->post('jumat'),
				'SAB' => $this->input->post('sabtu'),
				'MIN' => $this->input->post('minggu'),
			);

		$this->siswa->update(array('NIP' => $this->input->post('id')), $data);
		echo json_encode(array("status" => TRUE));
	}
	public function du_update()
	{
		$data = array(
				'nodaftarulang' => $this->input->post('nodaftarulang'),
			);

		$this->siswa->update(array('id' => $this->input->post('id')), $data);
		echo json_encode(array("status" => TRUE,"iki id ".$this->input->post('id')." iki no du = ".$this->input->post('nodaftarulang')));
	}
	public function ajax_delete($id)
	{
		$siswa = $this->siswa->get_by_id($id);
		$this->siswa->delete_by_id($id);
		echo json_encode(array("status" => TRUE));
	}


	public function ajax_bulk_delete()
    {
        $list_id = $this->input->post('id');
        foreach ($list_id as $id) {
            $this->siswa->delete_by_id($id);
        }
        echo json_encode(array("status" => TRUE));
    }
	private function _validate()
	{
		$data = array();
		$data['error_string'] = array();
		$data['inputerror'] = array();
		$data['status'] = TRUE;

		if($this->input->post('absen') == '')
		{
			$data['inputerror'][] = 'absen';
			$data['error_string'][] = 'Kode Absen wajib diisi';
			$data['status'] = FALSE;
		} else {
			$cek1=$this->db->query("SELECT absen FROM web_siswa WHERE absen='".$this->input->post('absen')."'");
			$hasilcek1=$cek1->num_rows();
			if ($hasilcek1 <> 0) {
				$data['inputerror'][] = 'absen';
				$data['error_string'][] = 'Absen sudah ada';
				$data['status'] = FALSE;
			}
		}

		if($this->input->post('nama') == '')
		{
			$data['inputerror'][] = 'nama';
			$data['error_string'][] = 'Nama wajib diisi';
			$data['status'] = FALSE;
		}
		if($this->input->post('kd_jenis') == '')
		{
			$data['inputerror'][] = 'kd_jenis';
			$data['error_string'][] = 'Kelompok wajib dipilih';
			$data['status'] = FALSE;
		}
		if($data['status'] === FALSE)
		{
			echo json_encode($data);
			exit();
		}
	}

}
