<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class User extends CI_Controller {

	public function __construct()
	{
		parent::__construct();
		$this->load->model('user_model','user');
		$this->load->helper('url');
		if ($this->session->userdata('username')=='') {
            redirect('login');
        } 
	}

	public function index()
	{
		$this->template->display('admin/user');
	}
	public function balikin($str){
		$search = array ("'xpsijix'");
		$replace = array ("'");
		$str = preg_replace($search,$replace,$str);
		return $str;
	}
	public function ajax_list()
	{
		$list = $this->user->get_datatables();
		$data = array();
		$no = $_POST['start'];
		foreach ($list as $user) {
			$no++;
			$row = array();
			$row[] = $no;
			$row[] = '<a class="btn btn-white btn-primary btn-sm" href="javascript:void(0)" title="Edit user" onclick="edit_user('."'".$user->id."'".')"><i class="glyphicon glyphicon-pencil"></i></a>
				  <a class="btn btn-white btn-danger btn-sm" href="javascript:void(0)" title="Hapus" onclick="delete_log('."'".$user->id."'".')"><i class="glyphicon glyphicon-trash"></i></a>';
			$row[] = $user->nama;
			$row[] = $user->user;
			$row[] = $user->email;
			$row[] = $user->publish;
			$data[] = $row;
		}

			$output = array(
						"draw" => $_POST['draw'],
						"recordsTotal" => $this->user->count_all(),
						"recordsFiltered" => $this->user->count_filtered(),
						"data" => $data,
				);
		
		echo json_encode($output);
	}
	
	
	public function ajax_edit($id)
	{
		$data = $this->user->get_by_id($id);
		echo json_encode($data);
	}
	public function ajax_add()
	{
		$this->_validate();
		$data = array(
				'nama' => $this->input->post('nama'),
				'user' => $this->input->post('user'),
				'pass' => md5($this->input->post('pass1')),
				'email' => $this->input->post('email'),
			);

		$insert = $this->user->save($data);

		echo json_encode(array("status" => TRUE));
	}
	public function ajax_update()
	{
		$this->_validate();
		$data = array(
				'nama' => $this->input->post('nama'),
				'user' => $this->input->post('user'),
				'pass' => md5($this->input->post('pass1')),
				'email' => $this->input->post('email'),
			);

		$this->user->update(array('id' => $this->input->post('id')), $data);
		echo json_encode(array("status" => TRUE));
	}
	public function ajax_delete($id)
	{
		$user = $this->user->get_by_id($id);
		$this->user->delete_by_id($id);
		echo json_encode(array("status" => TRUE));
	}
	private function _validate()
	{
		$data = array();
		$data['error_string'] = array();
		$data['inputerror'] = array();
		$data['status'] = TRUE;

		if($this->input->post('nama') == '')
		{
			$data['inputerror'][] = 'nama';
			$data['error_string'][] = 'Nama wajib di isi';
			$data['status'] = FALSE;
		}
		if($this->input->post('user') == '')
		{
			$data['inputerror'][] = 'user';
			$data['error_string'][] = 'Usernam wajib di isi';
			$data['status'] = FALSE;
		}
		if($this->input->post('pass1') <> $this->input->post('pass2'))
		{
			$data['inputerror'][] = 'pass2';
			$data['error_string'][] = 'Password tidak sama';
			$data['status'] = FALSE;
		}
		if($data['status'] === FALSE)
		{
			echo json_encode($data);
			exit();
		}
	}

}
