	<section class="content-header">
        <h1>
            Daftar Calon Siswa (Tes Agama)
        </h1>
        <ol class="breadcrumb">
            <li><a href="#"><i class="fa fa-dashboard"></i> Home</a></li>
            <li class="active">Agama</li>
        </ol>
    </section>
	<section class="content">
		<div class="row">
        <div class="col-md-12">
            <div class="box box-primary">
					<!-- /.box-header -->
					<div class="box-body table-responsive">
					<table id="table" class="table table-bordered table-striped">
						<thead>
							<tr>
								<th>No</th>
								<th>Action</th>
								<th>No Daftar</th>
								<th>Daftar Ulang</th>
								<th>Nama Calon Siswa</th>
								<th>Asal Sekolah</th>
								<th>Jurusan</th>
								<th>Baca Al Qur'an</th>
								<th>Bacaan Sholat</th>
								<th>Hafalan</th>
							</tr>
						</thead>
						<tbody>
						</tbody>

						<tfoot>
						<tr>
							<th>No</th>
							<th>Action</th>
							<th>No Daftar</th>
							<th>Daftar Ulang</th>
							<th>Nama Calon Siswa</th>
							<th>Asal Sekolah</th>
							<th>Jurusan</th>
							<th>Baca Al Qur'an</th>
							<th>Bacaan Sholat</th>
							<th>Hafalan</th>
							
						</tr>
						</tfoot>
					</table>
				</div><!-- /.box-body -->
            </div><!-- /.box -->
        </div>
    </div>
<div class="modal fade" id="modal_form" role="dialog">
	<div class="modal-dialog">
		<div class="modal-content">
			<div class="modal-header">
				<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
				<h3 class="modal-title">Tes Agama Calon Siswa</h3>
			</div>
			<div class="modal-body form">
				<form action="#" id="form" class="form-horizontal">
					<input type="hidden" value="" name="id"/> 
					<div class="form-body">
						<div class="container col-md-12">
							<div class="form-group form-group-sm">
								<div class="form-group">
									<label class="control-label col-md-2">No Daftar</label>
									<div class="col-md-10">
										<input name="nodaftar" placeholder="Masukan No Pendaftaran" class="form-control" type="text" disabled>
										<span class="help-block"></span>
									</div>
								</div>
								<div class="form-group">
									<label class="control-label col-md-2">Nama Siswa</label>
									<div class="col-md-10">
										<input name="nama" placeholder="Masukan Nama Calon Siswa" class="form-control" type="text" disabled>
										<span class="help-block"></span>
									</div>
								</div>
								
								<div class="form-group">
									<label class="control-label col-md-2">Baca Al Qur'an</label>
									<div class="col-md-10">
										<select name="bacaal" class="form-control">
											<option value="">--Select Baca Al Qur'an--</option>
											<option value="Bisa">Lancar</option>
											<option value="Sedang">Sedang</option>
											<option value="Tidak Bisa">Tidak Bisa</option>
										</select>
										<span class="help-block"></span>
									</div>
								</div>
								<div class="form-group">
									<label class="control-label col-md-2">Bacaan Sholat</label>
									<div class="col-md-10">
										<select name="bacasholat" class="form-control">
											<option value="">--Select Bacaan Sholat--</option>
											<option value="Bisa">Lancar</option>
											<option value="Sedang">Sedang</option>
											<option value="Tidak Bisa">Tidak Bisa</option>
										</select>
										<span class="help-block"></span>
									</div>
								</div>
								<div class="form-group">
									<label class="control-label col-md-2">Hafalan</label>
									<div class="col-md-10">
										<input name="hafal" placeholder="Masukan Jumlah hafalan" class="form-control" type="text">
										<span class="help-block"></span>
									</div>
								</div>
								<div class="form-group">
									<label class="control-label col-md-2">Status Tes Agama</label>
									<div class="col-md-10">
										<select name="tesagama" class="form-control">
											<option value="">--Select Status Tes Agama--</option>
											<option value="Sudah">Sudah Tes</option>
											<option value="Belum">Belum Tes</option>
										</select>
										<span class="help-block"></span>
									</div>
								</div>
							</div>
						</div>							
					</div>
				</form>
			</div>
			<div class="modal-footer">
				<button type="button" id="btnSave" onclick="save()" class="btn btn-primary">Simpan</button>
				<button type="button" class="btn btn-danger" data-dismiss="modal">Batal</button>
			</div>
		</div><!-- /.modal-content -->
	</div><!-- /.modal-dialog -->
</div><!-- /.modal -->
			<script type="text/javascript">

			var save_method; //for save method string
			var table;
			var base_url = '<?php echo base_url();?>';

			$(document).ready(function() {
				
				//datepicker
				$('.datepicker').datepicker({
					autoclose: true,
					format: "yyyy-mm-dd",
					todayHighlight: true,
					orientation: "top auto",
					todayBtn: true,
					todayHighlight: true,  
				});

				//set input/textarea/select event when change value, remove class error and remove text help block 
				$("input").change(function(){
					$(this).parent().parent().removeClass('has-error');
					$(this).next().empty();
				});
				$("textarea").change(function(){
					$(this).parent().parent().removeClass('has-error');
					$(this).next().empty();
				});
				$("select").change(function(){
					$(this).parent().parent().removeClass('has-error');
					$(this).next().empty();
				});
				 //check all
				$("#check-all").click(function () {
					$(".data-check").prop('checked', $(this).prop('checked'));
				});
			});

			$(function () {
				table = $('#table').DataTable({ 

					"processing": true, //Feature control the processing indicator.
					"serverSide": true, //Feature control DataTables' server-side processing mode.
					"order": [], //Initial no order.

					// Load data for the table's content from an Ajax source
					"ajax": {
						"url": "<?php echo site_url('agama/ajax_list')?>",
						"type": "POST"
					},

					//Set column definition initialisation properties.
					"columnDefs": [
						{ 
							"targets": [ 0 ], //first column
							"orderable": false, //set not orderable
						},
						{ 
							"targets": [ -1 ], //last column
							"orderable": false, //set not orderable
						},
			 
					],

				});
			});

		
			function edit_agama(id)
			{
				save_method = 'update';
				$('#form')[0].reset(); // reset form on modals
				$('.form-group').removeClass('has-error'); // clear error class
				$('.help-block').empty(); // clear error string


				//Ajax Load data from ajax
				$.ajax({
					url : "<?php echo site_url('agama/ajax_edit')?>/" + id,
					type: "GET",
					dataType: "JSON",
					success: function(data)
					{

						$('[name="id"]').val(data.id);
						$('[name="nodaftar"]').val(data.nodaftar);
						$('[name="nama"]').val(data.nama);
						$('[name="bacaal"]').val(data.bacaal);
						$('[name="bacasholat"]').val(data.bacasholat);
						$('[name="hafal"]').val(data.hafal);
						$('[name="tesagama"]').val(data.tesagama);
						$('#modal_form').modal('show'); // show bootstrap modal when complete loaded
						$('.modal-title').text('Edit agama'); // Set title to Bootstrap modal title

					},
					error: function (jqXHR, textStatus, errorThrown)
					{
						alert('Error get data from ajax');
					}
				});
			}

			function reload_table()
			{
				table.ajax.reload(null,false); //reload datatable ajax 
			}

			
			function save()
			{
				$('#btnSave').text('saving...'); //change button text
				$('#btnSave').attr('disabled',true); //set button disable 
				var url;
					url = "<?php echo site_url('agama/ajax_update')?>";
				var formData = new FormData($('#form')[0]);
				$.ajax({
					url : url,
					type: "POST",
					data: formData,
					contentType: false,
					processData: false,
					dataType: "JSON",
					success: function(data)
					{

						if(data.status) //if success close modal and reload ajax table
						{
							$('#modal_form').modal('hide');
							reload_table();
						}
						else
						{
							for (var i = 0; i < data.inputerror.length; i++) 
							{
								$('[name="'+data.inputerror[i]+'"]').parent().parent().addClass('has-error'); //select parent twice to select div form-group class and add has-error class
								$('[name="'+data.inputerror[i]+'"]').next().text(data.error_string[i]); //select span help-block class set text error string
							}
						}
						$('#btnSave').text('Simpan'); //change button text
						$('#btnSave').attr('disabled',false); //set button enable 


					},
					error: function (jqXHR, textStatus, errorThrown)
					{
						alert('Error adding / update data');
						$('#btnSave').text('Simpan'); //change button text
						$('#btnSave').attr('disabled',false); //set button enable 

					}
				});
			}
			
			 
			</script>
  </section>
