<section class="content-header">
      <h1>
          Daftar Jam
      </h1>
      <ol class="breadcrumb">
          <li><a href="#"><i class="fa fa-dashboard"></i> Home</a></li>
          <li class="active">Jam</li>
      </ol>
  </section>
<section class="content">
  <div class="row">
      <div class="col-md-12">
          <div class="box box-primary">
      <div class='box-header with-border'>
        <button class="btn btn-success" onclick="add_jam()"><i class="glyphicon glyphicon-plus"></i> Tambah jam</button>
        <button class="btn btn-default" onclick="reload_table()"><i class="glyphicon glyphicon-refresh"></i> Reload</button>
      </div>
        <!-- /.box-header -->
        <div class="box-body table-responsive">
        <table id="table" class="table table-bordered table-striped">
          <thead>
            <tr>
              <th>No</th>
              <th>Action</th>
              <th>Kode</th>
              <th>Nama</th>
              <th>Awal Masuk</th>
              <th>Jam Masuk</th>
              <th>Akhir Masuk</th>
              <th>Jam Pulang</th>
              <th>Akhir Pulang</th>
            </tr>
          </thead>
          <tbody>
          </tbody>

          <tfoot>
          <tr>
            <th>No</th>
            <th>Action</th>
            <th>Kode</th>
            <th>Nama</th>
            <th>Awal Masuk</th>
            <th>Jam Masuk</th>
            <th>Akhir Masuk</th>
            <th>Jam Pulang</th>
            <th>Akhir Pulang</th>
          </tr>
          </tfoot>
        </table>
      </div><!-- /.box-body -->
          </div><!-- /.box -->
      </div>
  </div>
<div class="modal fade" id="modal_form" role="dialog">
<div class="modal-dialog">
  <div class="modal-content">
    <div class="modal-header">
      <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
      <h3 class="modal-title">Tambah jam</h3>
    </div>
    <div class="modal-body form">
      <form action="#" id="form" class="form-horizontal">
        <input type="hidden" value="" name="id"/>
        <div class="form-body">
          <div class="container col-md-12">
            <div class="form-group form-group-sm">
              <div class="form-group">
                <label class="control-label col-md-3">Kode</label>
                <div class="col-md-9">
                  <input name="kode" placeholder="Masukan Kode" class="form-control" type="text">
                  <span class="help-block"></span>
                </div>
              </div>
              <div class="form-group">
                <label class="control-label col-md-3">Nama</label>
                <div class="col-md-9">
                  <input name="nama" placeholder="Masukan Nama" class="form-control" type="text">
                  <span class="help-block"></span>
                </div>
              </div>
              <div class="form-group">
                <label class="control-label col-md-3">Awal Masuk</label>
                <div class="col-md-9">
                  <input name="awal_masuk" placeholder="05:00:00" class="form-control" type="text" value="00:00:00">
                  <span class="help-block"></span>
                </div>
              </div>
              <div class="form-group">
                <label class="control-label col-md-3">Jam Masuk</label>
                <div class="col-md-9">
                  <input name="jam_masuk" placeholder="05:00:00" class="form-control" type="text" value="00:00:00">
                  <span class="help-block"></span>
                </div>
              </div>
              <div class="form-group">
                <label class="control-label col-md-3">Akhir Masuk</label>
                <div class="col-md-9">
                  <input name="akhir_masuk" placeholder="05:00:00" class="form-control" type="text" value="00:00:00">
                  <span class="help-block"></span>
                </div>
              </div>
              <div class="form-group">
                <label class="control-label col-md-3">Jam Pulang</label>
                <div class="col-md-9">
                  <input name="jam_pulang" placeholder="05:00:00" class="form-control" type="text" value="00:00:00">
                  <span class="help-block"></span>
                </div>
              </div>
              <div class="form-group">
                <label class="control-label col-md-3">Akhir Pulang</label>
                <div class="col-md-9">
                  <input name="akhir_pulang" placeholder="05:00:00" class="form-control" type="text" value="00:00:00">
                  <span class="help-block"></span>
                </div>
              </div>
            </div>
          </div>
        </div>
      </form>
    </div>
    <div class="modal-footer">
      <button type="button" id="btnSave" onclick="save()" class="btn btn-primary">Simpan</button>
      <button type="button" class="btn btn-danger" data-dismiss="modal">Batal</button>
    </div>
  </div><!-- /.modal-content -->
</div><!-- /.modal-dialog -->
</div><!-- /.modal -->
    <script type="text/javascript">

    var save_method; //for save method string
    var table;
    var base_url = '<?php echo base_url();?>';

    $(document).ready(function() {

      //datepicker
      $('.datepicker').datepicker({
        autoclose: true,
        format: "yyyy-mm-dd",
        todayHighlight: true,
        orientation: "top auto",
        todayBtn: true,
        todayHighlight: true,
      });

      //set input/textarea/select event when change value, remove class error and remove text help block
      $("input").change(function(){
        $(this).parent().parent().removeClass('has-error');
        $(this).next().empty();
      });
      $("textarea").change(function(){
        $(this).parent().parent().removeClass('has-error');
        $(this).next().empty();
      });
      $("select").change(function(){
        $(this).parent().parent().removeClass('has-error');
        $(this).next().empty();
      });
       //check all
      $("#check-all").click(function () {
        $(".data-check").prop('checked', $(this).prop('checked'));
      });
    });

    $(function () {
      table = $('#table').DataTable({

        "processing": true, //Feature control the processing indicator.
        "serverSide": true, //Feature control DataTables' server-side processing mode.
        "order": [], //Initial no order.

        // Load data for the table's content from an Ajax source
        "ajax": {
          "url": "<?php echo site_url('jam/ajax_list')?>",
          "type": "POST"
        },

        //Set column definition initialisation properties.
        "columnDefs": [
          {
            "targets": [ 0 ], //first column
            "orderable": false, //set not orderable
          },
          {
            "targets": [ -1 ], //last column
            "orderable": false, //set not orderable
          },

        ],

      });
    });


    function edit_jam(id)
    {
      save_method = 'update';
      $('#form')[0].reset(); // reset form on modals
      $('.form-group').removeClass('has-error'); // clear error class
      $('.help-block').empty(); // clear error string


      //Ajax Load data from ajax
      $.ajax({
        url : "<?php echo site_url('jam/ajax_edit')?>/" + id,
        type: "GET",
        dataType: "JSON",
        success: function(data)
        {

          $('[name="id"]').val(data.id);
          $('[name="kode"]').val(data.kode);
          $('[name="nama"]').val(data.nama);
          $('[name="awal_masuk"]').val(data.awal_masuk);
          $('[name="jam_masuk"]').val(data.jam_masuk);
          $('[name="akhir_masuk"]').val(data.akhir_masuk);
          $('[name="jam_pulang"]').val(data.jam_pulang);
          $('[name="akhir_pulang"]').val(data.akhir_pulang);
          $('#modal_form').modal('show'); // show bootstrap modal when complete loaded
          $('.modal-title').text('Edit Jam'); // Set title to Bootstrap modal title

        },
        error: function (jqXHR, textStatus, errorThrown)
        {
          alert('Error get data from ajax');
        }
      });
    }

    function reload_table()
    {
      table.ajax.reload(null,false); //reload datatable ajax
    }

    function add_jam()
    {
      save_method = 'add';
      $('#form')[0].reset(); // reset form on modals
      $('.form-group').removeClass('has-error'); // clear error class
      $('.help-block').empty(); // clear error string
      $('#modal_form').modal('show'); // show bootstrap modal
      $('.modal-title').text('Tambah Jam'); // Set Title to Bootstrap modal title
    }
    function save()
    {
      $('#btnSave').text('saving...'); //change button text
      $('#btnSave').attr('disabled',true); //set button disable
      var url;
      if(save_method == 'add') {
        url = "<?php echo site_url('jam/ajax_add')?>";
      } else {
        url = "<?php echo site_url('jam/ajax_update')?>";
      }
      var formData = new FormData($('#form')[0]);
      $.ajax({
        url : url,
        type: "POST",
        data: formData,
        contentType: false,
        processData: false,
        dataType: "JSON",
        success: function(data)
        {

          if(data.status) //if success close modal and reload ajax table
          {
            $('#modal_form').modal('hide');
            reload_table();
          }
          else
          {
            for (var i = 0; i < data.inputerror.length; i++)
            {
              $('[name="'+data.inputerror[i]+'"]').parent().parent().addClass('has-error'); //select parent twice to select div form-group class and add has-error class
              $('[name="'+data.inputerror[i]+'"]').next().text(data.error_string[i]); //select span help-block class set text error string
            }
          }
          $('#btnSave').text('Simpan'); //change button text
          $('#btnSave').attr('disabled',false); //set button enable


        },
        error: function (jqXHR, textStatus, errorThrown)
        {
          alert('Error adding / update data');
          $('#btnSave').text('Simpan'); //change button text
          $('#btnSave').attr('disabled',false); //set button enable

        }
      });
    }
    function delete_log(id)
    {
      if(confirm('Are you sure delete this data?'))
      {
        // ajax delete data to database
        $.ajax({
          url : "<?php echo site_url('jam/ajax_delete')?>/"+id,
          type: "POST",
          dataType: "JSON",
          success: function(data)
          {
            //if success reload ajax table
            $('#modal_form').modal('hide');
            reload_table();
          },
          error: function (jqXHR, textStatus, errorThrown)
          {
            alert('Error deleting data');
          }
        });

      }
    }

    </script>
</section>
