	<section class="content-header">
        <h1>
            Daftar Log Absen
        </h1>
        <ol class="breadcrumb">
            <li><a href="#"><i class="fa fa-dashboard"></i> Home</a></li>
            <li class="active">Log Absen</li>
        </ol>
    </section>
	<section class="content">
		<div class="row">
        <div class="col-md-12">
            <div class="box box-primary">
				<div class='box-header with-border'>
					<button class="btn btn-success" onclick="add_absen()"><i class="glyphicon glyphicon-plus"></i> Tambah Absen</button>
					<button class="btn btn-default" onclick="reload_table()"><i class="glyphicon glyphicon-refresh"></i> Reload</button>
					<!--<button class="btn btn-success" onclick="tarik_absen()"><i class="glyphicon glyphicon-plus"></i> Tarik Absensi dari Fingerprint</button>
					<button class="btn btn-danger" onclick="hapus_absen()"><i class="glyphicon glyphicon-remove"></i> Hapus Absensi dari Fingerprint</button>-->
				</div>
					<!-- /.box-header -->
					<div class="box-body table-responsive">
					<table id="table" class="table table-bordered table-striped">
						<thead>
							<tr>
								<th>No</th>
								<th>Action</th>
								<th>Tanggal</th>
								<th>Jam</th>
								<th>Foto Profil</th>
								<th>Nama Individu</th>
								<th>Kelompok</th>
								<th>IP</th>
								<th>Tipe Absen</th>
								<th>Foto Absen</th>
								<th>Keterangan</th>
							</tr>
						</thead>
						<tbody>
						</tbody>

						<tfoot>
						<tr>
							<th>No</th>
							<th>Action</th>
							<th>Tanggal</th>
							<th>Jam</th>
							<th>Foto Profil</th>
							<th>Nama Individu</th>
							<th>Kelompok</th>
							<th>IP</th>
							<th>Tipe Absen</th>
							<th>Foto Absen</th>
							<th>Keterangan</th>

						</tr>
						</tfoot>
					</table>
				</div><!-- /.box-body -->
            </div><!-- /.box -->
        </div>
    </div>
<div class="modal fade" id="modal_form" role="dialog">
	<div class="modal-dialog">
		<div class="modal-content">
			<div class="modal-header">
				<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
				<h3 class="modal-title">Tambah Log Absen</h3>
			</div>
			<div class="modal-body form">
				<form action="#" id="form" class="form-horizontal">
					<input type="hidden" value="" name="id"/>
					<div class="form-body">
						<div class="container col-md-12">
							<div class="form-group form-group-sm">
								<div class="form-group">

									<label class="control-label col-md-3">Kelompok</label>
									<div class="col-md-9">
										<select name="kd_jenis" id="kd_jenis" class="form-control">
										<option value="">Pilih</option>

										<?php
										foreach($pelajaran as $data){ // Lakukan looping pada variabel siswa dari controller
											echo "<option value='".$data->kode."'>".$data->nama."</option>";
										}
										?>
									</select>

										<span class="help-block"></span>
									</div>
								</div>
								<div class="form-group">

									<label class="control-label col-md-3">Nama Individu</label>
									<div class="col-md-9">
										<select class="select2 form-control" name="kikd" id="kikd">

										</select>

										<span class="help-block"></span>
									</div>
								</div>
								<div class="form-group">

									<label class="control-label col-md-3">Jenis Absen</label>
									<div class="col-md-9">
										<select name="status" id="status" class="form-control">
										<option value="">--Select Jenis Absen--</option>
										<?php
										$mapil=$this->db->query("SELECT * FROM web_status");
										foreach ($mapil->result() as $row1) {
											$kode_mapel=$row1->kd_jenis;
											$nama_mapel=$row1->status;
											echo "<option value=".$kode_mapel.">".$nama_mapel."</option>";
										}
										?>
										</select>

										<span class="help-block"></span>
									</div>
								</div>
								<div class="form-group">
											<label class="control-label col-md-3">Keterangan</label>
											<div class="col-md-9">
												<input name="ket" placeholder="Masukan Keterangan" class="form-control" type="text">
												<span class="help-block"></span>
											</div>
										</div>
							</div>
						</div>
					</div>
				</form>
			</div>
			<div class="modal-footer">
				<button type="button" id="btnSave" onclick="save()" class="btn btn-primary">Simpan</button>
				<button type="button" class="btn btn-danger" data-dismiss="modal">Batal</button>
			</div>
		</div><!-- /.modal-content -->
	</div><!-- /.modal-dialog -->
</div><!-- /.modal -->
			<script type="text/javascript">

			var save_method; //for save method string
			var table;
			var base_url = '<?php echo base_url();?>';

			$(document).ready(function() {
				$("#kd_jenis").change(function(){ // Ketika user mengganti atau memilih data pelajaran
					$("#kikd").hide(); // Sembunyikan dulu combobox kikd nya

					$.ajax({
						type: "POST",
						url: "<?php echo base_url("log/listsiswa"); ?>", // Isi dengan url/path file php yang dituju
						data: {kd_jenis : $("#kd_jenis").val()}, // data yang akan dikirim ke file yang dituju
						dataType: "json",
						beforeSend: function(e) {
							if(e && e.overrideMimeType) {
								e.overrideMimeType("application/json;charset=UTF-8");
							}
						},
						success: function(response){ // Ketika proses pengiriman berhasil
							$("#kikd").html(response.list_kelas).show();
						},
						error: function (xhr, ajaxOptions, thrownError) { // Ketika ada error
							alert(xhr.status + "\n" + xhr.responseText + "\n" + thrownError); // Munculkan alert error
						}
					});
				});
				//datepicker
				$('.datepicker').datepicker({
					autoclose: true,
					format: "yyyy-mm-dd",
					todayHighlight: true,
					orientation: "top auto",
					todayBtn: true,
					todayHighlight: true,
				});

				//set input/textarea/select event when change value, remove class error and remove text help block
				$("input").change(function(){
					$(this).parent().parent().removeClass('has-error');
					$(this).next().empty();
				});
				$("textarea").change(function(){
					$(this).parent().parent().removeClass('has-error');
					$(this).next().empty();
				});
				$("select").change(function(){
					$(this).parent().parent().removeClass('has-error');
					$(this).next().empty();
				});
				 //check all
				$("#check-all").click(function () {
					$(".data-check").prop('checked', $(this).prop('checked'));
				});
			});

			$(function () {
				table = $('#table').DataTable({

					"processing": true, //Feature control the processing indicator.
					"serverSide": true, //Feature control DataTables' server-side processing mode.
					"order": [], //Initial no order.

					// Load data for the table's content from an Ajax source
					"ajax": {
						"url": "<?php echo site_url('log/ajax_list')?>",
						"type": "POST"
					},

					//Set column definition initialisation properties.
					"columnDefs": [
						{
							"targets": [ 0 ], //first column
							"orderable": false, //set not orderable
						},
						{
							"targets": [ -1 ], //last column
							"orderable": false, //set not orderable
						},

					],

				});
			});


			function edit_log(id)
			{
				save_method = 'update';
				$('#form')[0].reset(); // reset form on modals
				$('.form-group').removeClass('has-error'); // clear error class
				$('.help-block').empty(); // clear error string


				//Ajax Load data from ajax
				$.ajax({
					url : "<?php echo site_url('log/ajax_edit')?>/" + id,
					type: "GET",
					dataType: "JSON",
					success: function(data)
					{

						$('[name="id"]').val(data.id);
						$('[name="kikd"]').val(data.nip);
						$('[name="status"]').val(data.status);
						$('[name="ket"]').val(data.ket);
						$('#modal_form').modal('show'); // show bootstrap modal when complete loaded
						$('.modal-title').text('Edit sehat'); // Set title to Bootstrap modal title

					},
					error: function (jqXHR, textStatus, errorThrown)
					{
						alert('Error get data from ajax');
					}
				});
			}

			function reload_table()
			{
				table.ajax.reload(null,false); //reload datatable ajax
			}

			function add_absen()
			{
				save_method = 'add';
				$('#form')[0].reset(); // reset form on modals
				$('.form-group').removeClass('has-error'); // clear error class
				$('.help-block').empty(); // clear error string
				$('#modal_form').modal('show'); // show bootstrap modal
				$('.modal-title').text('Tambah Log Absen'); // Set Title to Bootstrap modal title
			}
			function save()
			{
				$('#btnSave').text('saving...'); //change button text
				$('#btnSave').attr('disabled',true); //set button disable
				var url;
				if(save_method == 'add') {
					url = "<?php echo site_url('log/ajax_add')?>";
				} else {
					url = "<?php echo site_url('log/ajax_update')?>";
				}
				var formData = new FormData($('#form')[0]);
				$.ajax({
					url : url,
					type: "POST",
					data: formData,
					contentType: false,
					processData: false,
					dataType: "JSON",
					success: function(data)
					{

						if(data.status) //if success close modal and reload ajax table
						{
							$('#modal_form').modal('hide');
							reload_table();
						}
						else
						{
							for (var i = 0; i < data.inputerror.length; i++)
							{
								$('[name="'+data.inputerror[i]+'"]').parent().parent().addClass('has-error'); //select parent twice to select div form-group class and add has-error class
								$('[name="'+data.inputerror[i]+'"]').next().text(data.error_string[i]); //select span help-block class set text error string
							}
						}
						$('#btnSave').text('Simpan'); //change button text
						$('#btnSave').attr('disabled',false); //set button enable


					},
					error: function (jqXHR, textStatus, errorThrown)
					{
						alert('Error adding / update data');
						$('#btnSave').text('Simpan'); //change button text
						$('#btnSave').attr('disabled',false); //set button enable

					}
				});
			}
			function delete_log(id)
			{
				if(confirm('Are you sure delete this data?'))
				{
					// ajax delete data to database
					$.ajax({
						url : "<?php echo site_url('log/ajax_delete')?>/"+id,
						type: "POST",
						dataType: "JSON",
						success: function(data)
						{
							//if success reload ajax table
							$('#modal_form').modal('hide');
							reload_table();
						},
						error: function (jqXHR, textStatus, errorThrown)
						{
							alert('Error deleting data');
						}
					});

				}
			}
			function tarik_absen()
			{
				if(confirm('Apakan akan menarik data absen?'))
				{
					// ajax delete data to database
					$.ajax({
						url : "<?php echo site_url('log/tarik_data')?>",
						type: "POST",
						dataType: "JSON",
						success: function(data)
						{
							alert('Berhasil tarik data');
							reload_table();
						},
						error: function (jqXHR, textStatus, errorThrown)
						{
							alert('Error deleting data');
						}
					});

				}
			}
			 function hapus_absen()
			{
				if(confirm('Apakan akan menghapus data absen di fingerprint?'))
				{
					// ajax delete data to database
					$.ajax({
						url : "<?php echo site_url('log/hapus_data')?>",
						type: "POST",
						dataType: "JSON",
						success: function(data)
						{
							alert('Berhasil hapus data');
							reload_table();
						},
						error: function (jqXHR, textStatus, errorThrown)
						{
							alert('Error deleting data');
						}
					});

				}
			}
			</script>
  </section>
