<?php
	class Siswa extends CI_Controller{

	/* # Begin:Default # */
		function __construct(){
			parent:: __construct();
			$this->load->model("operator_model");
			$this->load->model("superuser_model");
			$this->load->library(array('pagination'));
			
			if ($this->session->userdata("login_username") != TRUE) {
				redirect();
			}
		}

		function alert($alert, $alert_type, $url=NULL){
			$this->session->set_userdata('alert_error', $alert);
			$this->session->set_userdata('alert_error_type', $alert_type);		
			if(!empty($url)){redirect($url);};
		}
	/* # End:Default # */
	
	/* # Begin:Dashboard Page # */
		function index(){
			$this->dashboard();
		}

		function dashboard(){
			$data["content"] 	= "siswa_dashboard";
			$this->load->view("siswa", $data);
		}
	/* # End:Dashboard Page # */
		
	

		function spp($peserta_id=NULL){
			if($peserta_id != NULL){
				$cekIDPserta = $this->superuser_model->getAkun($peserta_id);
				if($cekIDPserta->num_rows() > 0){
					$data["peserta"] = $cekIDPserta->row_array();
					$data["tagihan"] = $this->superuser_model->getTagihanPeserta($cekIDPserta->row()->peserta_id);
					$data["transaksi"] = $this->superuser_model->getTransaksiPeserta($cekIDPserta->row()->peserta_id);
					$data["content"] = "siswa_pembayaran_detail";
					$this->load->view("siswa", $data);
				}else{
					show_404();
				}
			}else{
				show_404();
			}
		}
		function bayar(){

					$data["content"] = "siswa_bayar";
					$this->load->view("siswa", $data);
				
		}
		function bayarspp(){
			$peserta_id = $this->input->post("peserta_id");
			$tagihan_id = $this->input->post("tagihan_id");
			$tagihan_peserta_id = $this->input->post("tagihan_peserta_id");
			$pembayaran = $this->input->post("pembayaran");
			$tipe = $this->input->post("tagihan_tipe");
			$namafile=$peserta_id.$tagihan_peserta_id.$tagihan_id.$tipe;
			$file_name = str_replace('.','',$namafile);
			$config['upload_path']          = FCPATH.'/_uploads/bukti/';
			$config['allowed_types']        = 'gif|jpg|jpeg|png';
			$config['file_name']            = $file_name;
			$config['overwrite']            = true;
			//$config['max_size']             = 1024; // 1MB
			//$config['max_width']            = 1080;
			//$config['max_height']           = 1080;
			$this->load->library('upload', $config);
			if (!$this->upload->do_upload('bukti')) {
				$data['error'] = $this->upload->display_errors();
			} else {
				$uploaded_data = $this->upload->data();
				if ($this->input->post("peserta_submit")){
					$this->db->trans_start();

					$entri_transaksi = [
						"peserta_id" => $peserta_id,
					];
					$this->db->set('waktu_entri', 'NOW()', FALSE);
					$this->db->insert('transaksi', $entri_transaksi);
					$transaksi_id = $this->db->insert_id();

					$entri_angsur = [
						"transaksi_id" => $transaksi_id,
						"peserta_id" => $peserta_id,
						"tagihan_id" => $tagihan_id,
						"tagihan_peserta_id" => $tagihan_peserta_id,
						"tipe_transaksi" => 'tunai',
						"nominal_bayar" => toNumberFormat($pembayaran),
						"status" => '0',
					];
					$this->db->set('waktu_entri', 'NOW()', FALSE);
					$this->db->insert('rincian', $entri_angsur);
					$this->db->trans_complete();
					$data["content"] 	= "siswa_dashboard";
					$this->load->view("siswa", $data);
					if ($this->db->trans_status() === FALSE) {
						$this->db->trans_rollback();
						$this->alert('<strong>Data gagal disimpan,</strong><br>Silahkan coba lagi.', 'alert-danger','siswa/spp/'.$peserta_id);
					}

				}else{
					show_404();
				}
			}
		}
		function bayar2($peserta_id=NULL){
			if($peserta_id != NULL){
				$cekIDPserta = $this->superuser_model->getAkun($peserta_id);
				if($cekIDPserta->num_rows() > 0){
					$data["peserta"] = $cekIDPserta->row_array();
					$data["tagihan"] = $this->superuser_model->getTagihanPeserta($cekIDPserta->row()->peserta_id);
					$data["transaksi"] = $this->superuser_model->getTransaksiPeserta($cekIDPserta->row()->peserta_id);
					$data["content"] = "siswa_bayar";
					$this->load->view("siswa", $data);
				}else{
					show_404();
				}
			}else{
				show_404();
			}
		}
	}